/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.lang.reflect.Array;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;

public class ParameterChecker {
    public static void assertMandatoryParameter(int parameterNumber, String parameterName, Object parameter, LogTraceHelper pLTH) throws MissingParameterException {
        if (parameter == null) {
            throw DiskMessageHelper.getMissingParameterException(parameterNumber, "HWN020002E", parameterName, pLTH);
        }
        if (parameter.getClass().isArray() && Array.getLength(parameter) == 0) {
            throw DiskMessageHelper.getMissingParameterException(parameterNumber, "HWN020002E", parameterName, pLTH);
        }
    }

    public static void assertValidPrimitiveParameterArray(int parameterNumber, String parameterName, Object parameter, LogTraceHelper pLTH) throws InvalidParameterException {
        if (parameter.getClass().isArray() && Array.getLength(parameter) > 0 && parameter instanceof long[]) {
            long[] parameterT = (long[])parameter;
            for (int idx = 0; idx < parameterT.length; ++idx) {
                ParameterChecker.assertValidPrimitiveParameterLong(parameterNumber, parameterName, parameterT[idx], pLTH);
            }
        }
    }

    public static void assertValidPrimitiveParameterLong(int parameterNumber, String parameterName, long parameter, LogTraceHelper pLTH) throws InvalidParameterException {
        if (parameter < 0L) {
            throw DiskMessageHelper.getInvalidParameterException(parameterNumber, "HWN020003E", parameterName, pLTH);
        }
    }

    public static void assertValidPrimitiveParameterInt_BitMask(int pParameterNumber, String pParameterName, int pParameter, int pValidMask, LogTraceHelper pLTH) throws InvalidParameterException {
        if (pParameter < 0) {
            throw DiskMessageHelper.getMissingParameterException(pParameterNumber, "HWN020003E", pParameterName, pLTH);
        }
    }

    public static void assertMandatoryParameterInRange(int pParameterNumber, String pParameterName, int pParameter, int minValue, int maxValue, LogTraceHelper pLTH) throws InvalidParameterException {
        if (pParameter < minValue || pParameter > maxValue) {
            throw DiskMessageHelper.getInvalidParameterException(pParameterNumber, "HWN020003E", pParameterName, pLTH);
        }
    }

    public static void assertOptionalParameterInRange(int pParameterNumber, String pParameterName, int pParameter, int minValue, int maxValue, LogTraceHelper pLTH) throws InvalidParameterException {
        if (pParameter != -1) {
            ParameterChecker.assertMandatoryParameterInRange(pParameterNumber, pParameterName, pParameter, minValue, maxValue, pLTH);
        }
    }

    public static void assertExclusiveMandatoryParameter(int parameterNumber, String parameterName, Object parameter1, Object parameter2, String parameter1Name, String parameter2Name, LogTraceHelper pLTH) throws MissingParameterException {
        if (parameter1 == null && parameter2 == null) {
            throw DiskMessageHelper.getMissingParameterException(parameterNumber, "HWN020002E", parameterName, pLTH);
        }
        if (parameter1 != null && parameter1.getClass().isArray() && Array.getLength(parameter1) == 0) {
            throw DiskMessageHelper.getMissingParameterException(parameterNumber, "HWN020002E", parameter1Name, pLTH);
        }
        if (parameter2 != null && parameter2.getClass().isArray() && Array.getLength(parameter2) == 0) {
            throw DiskMessageHelper.getMissingParameterException(parameterNumber, "HWN020002E", parameter2Name, pLTH);
        }
    }

    public static void assertMandatoryParameterArraySizes(int parameterNumber, String parameterNames, Object parameter1, Object parameter2, LogTraceHelper pLTH) throws InvalidParameterException {
        if (parameter1.getClass().isArray() && parameter1.getClass().isArray() && Array.getLength(parameter1) != Array.getLength(parameter2)) {
            throw DiskMessageHelper.getInvalidParameterException(parameterNumber, "HWN021524E", parameterNames, pLTH);
        }
    }

    public static void assertOptionalParameterArraySizes(int parameterNumber, String parameterNames, Object mandatoryParameter, Object optionalParameter, LogTraceHelper pLTH) throws InvalidParameterException {
        if (optionalParameter != null && mandatoryParameter.getClass().isArray() && optionalParameter.getClass().isArray() && Array.getLength(mandatoryParameter) != Array.getLength(optionalParameter)) {
            throw DiskMessageHelper.getInvalidParameterException(parameterNumber, "HWN021524E", parameterNames, pLTH);
        }
    }

    public static void assertVitualizationType(int parameterNumber, String parameterName, int virtualizationType, LogTraceHelper pLTH) throws InvalidParameterException {
        if (virtualizationType < 0 || virtualizationType > 2) {
            throw DiskMessageHelper.getInvalidParameterException(parameterNumber, "HWN020003E", parameterName, pLTH);
        }
    }

    public static void assertMDisksForVitualizationType(int pParameterNumber, int virtualizationType, String[] pMDiskIDs, String[] pMDiskGrps, LogTraceHelper pLTH) {
        if (virtualizationType != 0) {
            ParameterChecker.assertMandatoryParameter(pParameterNumber, "SVCMDiskIDs", pMDiskIDs, pLTH);
            if (pMDiskIDs.length != 1) {
                ParameterChecker.assertMandatoryParameterArraySizes(pParameterNumber, "SVCMDiskGroupIDs, SVCMDiskIDs", pMDiskGrps, pMDiskIDs, pLTH);
            }
        }
    }
}

