/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.InstancePool;
import org.eclipse.aperi.disk.common.util.thread.DiskMgrThread;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;

public final class DiskThreadPool
extends InstancePool {
    public DiskThreadPool() {
        super(DiskManagerConfigSvc.getIntConfigValue("DiskThread.PoolSize", 50));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskMgrThread getThread(DiskThreadManager pMgr) {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "getThread", new Object[]{pMgr});
        DiskMgrThread mReturn = null;
        try {
            mReturn = (DiskMgrThread)this.getClearInstance();
            if (mReturn != null) {
                mLTH.traceHigh("Returning thread from pool.");
                DiskMgrThread diskMgrThread = mReturn;
                return diskMgrThread;
            }
            mReturn = new DiskMgrThread(pMgr);
            mReturn.start();
            mLTH.traceHigh("Returning new thread.");
            DiskMgrThread diskMgrThread = mReturn;
            return diskMgrThread;
        }
        finally {
            mLTH.exit(mReturn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnThread(DiskMgrThread pThread) {
        LogTraceHelper mLTH = LogTraceHelper.entry(this, "returnThread", new Object[]{pThread});
        try {
            if (!pThread.cIsExecutionComplete()) {
                mLTH.traceWarning("Thread execution of " + pThread.getName() + " is not yet complete. Thread will be taken out of the thread management");
                pThread.releaseThread();
                pThread.interrupt();
                this.removeInst(pThread);
                return;
            }
            if (!this.returnInst(pThread)) {
                mLTH.traceHigh("Thread " + pThread.getName() + " returned to pool");
                pThread.releaseThread();
            }
        }
        finally {
            mLTH.exit("void");
        }
    }
}

