/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.control.util;

import java.util.ArrayList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.control.util.OutputHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.sblim.wbem.cim.CIMObjectPath;

public class ConfigurationParameter {
    protected StorageSubsystem[] cStorageSubsystemsForSorting;
    protected StorageSubsystem cStorageSubsystem;
    protected CIMObjectPath cStorageSubsystemCIMOP;
    protected String cStorageSubsystemID;
    protected CapabilityData cCapability;
    protected CIMOM cCimom;
    protected CIMClientWrapper cCIMClientWrapper;
    protected CIMObjectPath[] cVolumeCOPs = new CIMObjectPath[0];
    protected StorageVolume[] cVolumes = new StorageVolume[0];
    protected String[] cVolumeIDs = new String[0];
    protected String[] cVolumeNames = new String[0];
    protected AsyncResult cAsyncResult;
    protected String cAPIMethodName = "";
    protected Token cToken;

    public String getStorageSubsystemID() {
        return this.cStorageSubsystemID;
    }

    public void setStorageSubsystemID(String pStorageSubsystemID) {
        this.cStorageSubsystemID = pStorageSubsystemID;
    }

    public ConfigurationParameter() {
    }

    public ConfigurationParameter(StorageSubsystem pStorageSubSystem, CIMObjectPath pStorageSubSystemCIMOP) {
        this.cStorageSubsystem = pStorageSubSystem;
        this.cStorageSubsystemCIMOP = pStorageSubSystemCIMOP;
    }

    public ConfigurationParameter(StorageSubsystem pStorageSubSystem) {
        this.cStorageSubsystem = pStorageSubSystem;
    }

    public CapabilityData getCapability() {
        return this.cCapability;
    }

    public StorageSubsystem getStorageSubsystem() {
        return this.cStorageSubsystem;
    }

    public CIMObjectPath getStorageSubsystemCIMOP() {
        return this.cStorageSubsystemCIMOP;
    }

    public void setCapability(CapabilityData data) {
        this.cCapability = data;
    }

    public void setStorageSubsystem(StorageSubsystem subsystem) {
        this.cStorageSubsystem = subsystem;
    }

    public void setStorageSubsystemCOP(CIMObjectPath path) {
        this.cStorageSubsystemCIMOP = path;
    }

    public AsyncResult getAsyncResult() {
        return this.cAsyncResult;
    }

    public void setAsyncResult(AsyncResult pAsyncResult) {
        this.cAsyncResult = pAsyncResult;
    }

    public CIMClientWrapper getCIMClientWrapper() {
        return this.cCIMClientWrapper;
    }

    public void setCIMClientWrapper(CIMClientWrapper pClientWrapper) {
        this.cCIMClientWrapper = pClientWrapper;
    }

    public String getAPIMethodName() {
        return this.cAPIMethodName;
    }

    public void setAPIMethodName(String pMethodName) {
        this.cAPIMethodName = pMethodName;
    }

    public Token getToken() {
        return this.cToken;
    }

    public void setToken(Token pJobId) {
        this.cToken = pJobId;
    }

    public CIMOM getCimom() {
        return this.cCimom;
    }

    public void setCimom(CIMOM cimom) {
        this.cCimom = cimom;
    }

    public StorageSubsystem[] getStorageSubsystemsForSorting() {
        return this.cStorageSubsystemsForSorting;
    }

    public void setStorageSubsystemsForSorting(StorageSubsystem[] pStorageSubsystemsForSorting) {
        this.cStorageSubsystemsForSorting = pStorageSubsystemsForSorting;
    }

    public CIMObjectPath[] getVolumeCOPs() {
        return this.cVolumeCOPs;
    }

    public void setVolumeCOPs(CIMObjectPath[] volumes) {
        this.cVolumeCOPs = volumes;
    }

    public String[] getVolumeNames() {
        return this.cVolumeNames;
    }

    public void setVolumeNames(String[] pVolumeNames) {
        this.cVolumeNames = pVolumeNames;
    }

    public StorageVolume[] getVolumes() {
        return this.cVolumes;
    }

    public void setVolumes(StorageVolume[] pVolumes) {
        this.cVolumes = pVolumes;
    }

    public String[] getVolumeIDs() {
        return this.cVolumeIDs;
    }

    public void setVolumeIDs(String[] pVolumeIDs) {
        this.cVolumeIDs = pVolumeIDs;
    }

    public void addParameters(ConfigurationParameter pConfigurationParameter, int pIndex) {
        this.cVolumes = (StorageVolume[])this.addParameter(this.cVolumes, pConfigurationParameter.getVolumes()[pIndex]);
        this.cVolumeIDs = (String[])this.addParameter(this.cVolumeIDs, pConfigurationParameter.getVolumeIDs()[pIndex]);
        this.cVolumeNames = (String[])this.addParameter(this.cVolumeNames, pConfigurationParameter.getVolumeNames()[pIndex]);
    }

    public Object[] addParameter(Object[] pParameters, Object pParameter) {
        Object[] mNewParameter = null;
        if (pParameter instanceof String) {
            mNewParameter = new String[pParameters.length + 1];
        }
        if (pParameter instanceof CIMObjectPath) {
            mNewParameter = new CIMObjectPath[pParameters.length + 1];
        }
        if (pParameter instanceof StorageVolume) {
            mNewParameter = new StorageVolume[pParameters.length + 1];
        }
        if (mNewParameter == null) {
            throw new RuntimeException("Parameter is not of any expected class. Parameter: " + pParameter.toString() + ", Class: " + pParameter.getClass().getName());
        }
        if (pParameters.length != 0) {
            System.arraycopy(pParameters, 0, mNewParameter, 0, pParameters.length);
        }
        mNewParameter[pParameters.length] = pParameter;
        return mNewParameter;
    }

    public int getIDOfVolume(String pVolumeID) {
        for (int j = 0; j < this.cVolumes.length; ++j) {
            if (!pVolumeID.equals(this.cVolumeIDs[j])) continue;
            return this.cVolumes[j].getSvid();
        }
        return -1;
    }

    public CIMObjectPath getVolumeCOPForID(String pVolumeID) {
        for (int j = 0; j < this.cVolumeCOPs.length; ++j) {
            if (!pVolumeID.equals(this.cVolumeIDs[j])) continue;
            return this.cVolumeCOPs[j];
        }
        return null;
    }

    public String[] getVolumeIDsForCOPs(CIMObjectPath[] pVolumeCOPs) {
        ArrayList<String> mVolumeIDs = new ArrayList<String>();
        for (int i = 0; i < pVolumeCOPs.length; ++i) {
            for (int j = 0; j < this.cVolumeCOPs.length; ++j) {
                if (!pVolumeCOPs[i].equals((Object)this.cVolumeCOPs[j])) continue;
                mVolumeIDs.add(this.cVolumeIDs[j]);
            }
        }
        String[] mVolIDs = new String[mVolumeIDs.size()];
        for (int i = 0; i < mVolumeIDs.size(); ++i) {
            mVolIDs[i] = (String)mVolumeIDs.get(i);
        }
        return mVolIDs;
    }

    public String[] getVolumeNamesForCOPs(CIMObjectPath[] pVolumeCOPs) {
        ArrayList<String> mVolumeNames = new ArrayList<String>();
        for (int i = 0; i < pVolumeCOPs.length; ++i) {
            for (int j = 0; j < this.cVolumeCOPs.length; ++j) {
                if (!pVolumeCOPs[i].equals((Object)this.cVolumeCOPs[j])) continue;
                mVolumeNames.add(this.cVolumeNames[j]);
            }
        }
        return mVolumeNames.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(OutputHelper.toStringHeader(this.getClass()));
        sb.append(this.prepareToString());
        sb.append(OutputHelper.toStringFooter(this.getClass()));
        return sb.toString();
    }

    String prepareToStringNoVolumes() {
        StringBuffer sb = new StringBuffer();
        sb.append("CIMOM: ");
        if (this.cCIMClientWrapper != null) {
            sb.append(this.cCIMClientWrapper.toString());
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    String prepareToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.prepareToStringNoVolumes());
        sb.append("; Storage Volume IDs: {");
        sb.append(OutputHelper.arrayToCS(this.cVolumeIDs));
        sb.append("}");
        return sb.toString();
    }
}

