/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.sql.SQLException;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.discovery.RetryDeleteParameters;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.tables.TResChunkCllctnTable;
import org.eclipse.aperi.infrastructure.database.tables.TResChunkTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResDataPathTable;
import org.eclipse.aperi.infrastructure.database.tables.TResMaskingInfoTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPhysicalvolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResVolume2extentTable;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskHistTable;
import org.eclipse.aperi.infrastructure.database.tables.TStatDiskTable;

public class SubsystemDBHelper {
    private static final int DEL_VOLUMES = 0;
    private static final int DEL_POOLS = 1;
    private static final int DEL_PHYVOLS = 2;
    private static final int DEL_PORTS = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteStorageVolumes(int[] pVolumeAutoIDs) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry(SubsystemDBHelper.class, "deleteStorageVolumes", new Object[]{pVolumeAutoIDs});
        Boolean mResult = new Boolean(false);
        try {
            mResult = SubsystemDBHelper.deadlockSafeSubentityDeletion(pVolumeAutoIDs, mLTH, 0);
            boolean bl = mResult;
            return bl;
        }
        finally {
            mLTH.exit(mResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteStoragePools(int[] pPoolAutoIDs) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry(SubsystemDBHelper.class, "deleteStoragePools", new Object[]{pPoolAutoIDs});
        Boolean mResult = new Boolean(false);
        try {
            mResult = SubsystemDBHelper.deadlockSafeSubentityDeletion(pPoolAutoIDs, mLTH, 1);
            boolean bl = mResult;
            return bl;
        }
        finally {
            mLTH.exit(mResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deletePorts(int[] pPortAutoIDs) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry(SubsystemDBHelper.class, "deletePorts", new Object[]{pPortAutoIDs});
        Boolean mResult = new Boolean(false);
        try {
            mResult = SubsystemDBHelper.deadlockSafeSubentityDeletion(pPortAutoIDs, mLTH, 3);
            boolean bl = mResult;
            return bl;
        }
        finally {
            mLTH.exit(mResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deletePhysicalVolumes(int[] pPhyVolumeAutoIDs) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry(SubsystemDBHelper.class, "deletePhysicalVolumes", new Object[]{pPhyVolumeAutoIDs});
        Boolean mResult = new Boolean(false);
        try {
            mResult = SubsystemDBHelper.deadlockSafeSubentityDeletion(pPhyVolumeAutoIDs, mLTH, 2);
            boolean bl = mResult;
            return bl;
        }
        finally {
            mLTH.exit(mResult);
        }
    }

    public static boolean handleDeadlock(DBConnection pConn, LogTraceHelper pLTH, RetryDeleteParameters pRetryParms, Exception pEx, Result pResult, String pExtSubsystemID) {
        pLTH.traceInfo("Deadlock ..... rollback!");
        try {
            pConn.rollback();
        }
        catch (SQLException pEx2) {
            pLTH.traceInfo("Exception in rollback  " + pEx2.getMessage());
            pRetryParms.setToRetry(false);
            throw DiskMessageHelper.getServerException("HWN021503E", pEx.getMessage(), pLTH);
        }
        pRetryParms.setNumRetries(pRetryParms.getNumRetries() + 1);
        if (pRetryParms.getNumRetries() > pRetryParms.getAllowed_Retries()) {
            pRetryParms.setToRetry(false);
            if (pResult != null && pExtSubsystemID != null) {
                pResult.setSRMMessage("HWN021672E", new String[]{pExtSubsystemID});
            }
            return false;
        }
        pLTH.traceInfo("Retry " + pRetryParms.getNumRetries() + " after deadlock");
        pRetryParms.setToRetry(true);
        pRetryParms.setMsWaitPeriod((long)((double)pRetryParms.getMult_Retry_Interval() * RetryDeleteParameters.getRandGen().nextDouble() * (double)pRetryParms.getNumRetries()));
        if (pRetryParms.getMsWaitPeriod() < pRetryParms.getMin_Retry_Internal()) {
            pRetryParms.setMsWaitPeriod(pRetryParms.getMin_Retry_Internal());
        }
        try {
            Thread.sleep(pRetryParms.getMsWaitPeriod());
        }
        catch (InterruptedException pEx3) {
            pLTH.traceInfo("InterruptedException " + pEx.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Boolean deadlockSafeSubentityDeletion(int[] pIDs, LogTraceHelper pLTH, int pType) throws SQLException {
        Boolean mResult = new Boolean(false);
        DBConnection mConn = null;
        RetryDeleteParameters mRetryParms = new RetryDeleteParameters();
        mRetryParms.init(pLTH);
        try {
            if (pIDs == null || pIDs.length == 0) return mResult;
            String mINPredicate = "(" + ParameterHelper.intArrayToString(pIDs) + ")";
            while (mRetryParms.isToRetry()) {
                try {
                    mConn = ServiceUtils.getConnection();
                    mConn.setAutoCommit(false);
                    switch (pType) {
                        case 0: {
                            mResult = new Boolean(SubsystemDBHelper.performVolDelete(mConn, mINPredicate, pIDs));
                            break;
                        }
                        case 2: {
                            mResult = new Boolean(SubsystemDBHelper.performPhyVolDelete(mConn, mINPredicate, pIDs));
                            break;
                        }
                        case 3: {
                            mResult = new Boolean(SubsystemDBHelper.performPortDelete(mConn, mINPredicate, pIDs));
                            break;
                        }
                        case 1: {
                            mResult = new Boolean(SubsystemDBHelper.performPoolDelete(mConn, mINPredicate, pIDs));
                        }
                    }
                    mConn.commit();
                    mRetryParms.setToRetry(false);
                }
                catch (SQLException pEx) {
                    if (!SQLExceptionHelper.isDeadlock(mConn, pEx)) throw pEx;
                    if (!SubsystemDBHelper.handleDeadlock(mConn, pLTH, mRetryParms, pEx, null, null)) continue;
                    continue;
                    return mResult;
                }
            }
        }
        finally {
            try {
                if (mConn != null) {
                    mConn.close();
                }
            }
            catch (RuntimeException mEx) {
                pLTH.traceError("Error during commit or close of DBConnection", mEx);
                pLTH.exit(new Boolean(false));
                throw mEx;
            }
            catch (SQLException mEx) {
                pLTH.traceError("Error during commit or close of DBConnection", mEx);
                pLTH.exit(new Boolean(false));
                throw mEx;
            }
        }
    }

    private static int execDelete(String pTable, String pColumn, String pINPredicate, DBConnection pConn) throws SQLException {
        String mSQL = "DELETE FROM " + pTable + " WHERE " + pColumn + " IN " + pINPredicate;
        return ComplexQuery.sqlUpdate(pConn, mSQL, null);
    }

    private static boolean performPoolDelete(DBConnection pConn, String pINPredicate, int[] pPoolAutoIDs) throws SQLException {
        SubsystemDBHelper.execDelete(TResStorageExtentTable.getTablename(), "POOL_ID", pINPredicate, pConn);
        return SubsystemDBHelper.execDelete(TResStoragePoolTable.getTablename(), "POOL_ID", pINPredicate, pConn) == pPoolAutoIDs.length;
    }

    private static boolean performPortDelete(DBConnection pConn, String pINPredicate, int[] pPortAutoIDs) throws SQLException {
        String mInnerSQL = "SELECT MASKING_INFO_ID FROM " + TResDataPathTable.getTablename() + " WHERE " + "TARGET_PORT_ID" + " IN " + pINPredicate;
        String mSQL = "DELETE FROM " + TResMaskingInfoTable.getTablename() + " WHERE " + "MASKING_INFO_ID" + " IN (" + mInnerSQL + ")";
        ComplexQuery.sqlUpdate(pConn, mSQL, null);
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "TARGET_PORT_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "INITIATOR_PORT_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TResCimkeyPortTable.getTablename(), "CIMKEY_PORT_ID", pINPredicate, pConn);
        return SubsystemDBHelper.execDelete(TResPortTable.getTablename(), "PORT_ID", pINPredicate, pConn) == pPortAutoIDs.length;
    }

    private static boolean performPhyVolDelete(DBConnection pConn, String pINPredicate, int[] pPhyVolumeAutoIDs) throws SQLException {
        SubsystemDBHelper.execDelete(TStatDiskTable.getTablename(), "DISK_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TStatDiskHistTable.getTablename(), "DISK_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TResPhysicalvolume2extentTable.getTablename(), "PHYSICAL_VOLUME_ID", pINPredicate, pConn);
        return SubsystemDBHelper.execDelete(TResPhysicalVolumeTable.getTablename(), "PHYSICAL_VOLUME_ID", pINPredicate, pConn) == pPhyVolumeAutoIDs.length;
    }

    private static boolean performVolDelete(DBConnection pConn, String pINPredicate, int[] pVolumeAutoIDs) throws SQLException {
        SubsystemDBHelper.execDelete(TResDataPathTable.getTablename(), "DEVICE_LUN_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TResChunkTable.getTablename(), "LOGICAL_DISK_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TResChunkCllctnTable.getTablename(), "LOGICAL_DISK_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TResVolume2extentTable.getTablename(), "VOLUME_ID", pINPredicate, pConn);
        SubsystemDBHelper.execDelete(TResCimkeyVolumeTable.getTablename(), "VOLUME_ID", pINPredicate, pConn);
        return SubsystemDBHelper.execDelete(TResStorageVolumeTable.getTablename(), "SVID", pINPredicate, pConn) == pVolumeAutoIDs.length;
    }
}

