/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import com.tivoli.tec.event_delivery.TECEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AlertEmailEditor;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.ScriptDefinitionDialog;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.TextUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertEmail;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class AbstractAlertEditor
extends JPanel
implements ActionListener,
GuiRequestor {
    private static final int LOGINID_LENGTH = 32;
    private static final int DEFAULT_LOG_FACILITY = 0;
    private static final int DEFAULT_LOG_LEVEL = 0;
    protected static final int MAX_VALUE_LENGTH = 7;
    protected static final int MAX_PERCENT_LENGTH = 2;
    protected static final int MAX_MB_LENGTH = 6;
    protected static final int MAX_GB_LENGTH = 3;
    protected static final int VERTICAL_INSET = 4;
    protected AlertDefinition alert;
    protected NameList computers;
    private Component alertEditPanel;
    private boolean doDbmsType = false;
    protected JComboBox conditionList;
    protected JComboBox thresholdUnits;
    protected JComboBox dbmsList;
    protected TTextField thresholdValue;
    protected JLabel lConditions;
    protected JLabel lUnits;
    protected JLabel lValue;
    protected JLabel lDbmsType;
    protected SizeLimitedDocument valueDocument;
    protected IntToString[] conditions;
    protected JCheckBox snmpTrap;
    protected JCheckBox tecTrap;
    protected JCheckBox loginNotification;
    protected JLabel lLoginID;
    protected TTextField loginID;
    protected JCheckBox osLog;
    protected JComboBox logLevel;
    protected JComboBox logFacility;
    protected JLabel lLogLevel;
    protected JLabel lLogFacility;
    protected JCheckBox runScript;
    protected JButton scriptSettings;
    protected JCheckBox email;
    protected EditableList emailRecipientList;
    protected JCheckBox emailQuotaViolator;
    protected JRadioButton directoryName;
    protected JRadioButton directoryOwner;
    protected JButton editEmail;
    protected String emailSubject;
    protected String emailText;
    protected IntToString[] emailParms = new IntToString[0];
    private int emailCond = -1;
    private IntToString logError = new IntToString(3, "GUI0230L");
    private IntToString logWarning = new IntToString(2, "GUI0229L");
    protected String changeText;
    protected String defineText;
    private IntToString[] winLogLevels = new IntToString[]{this.logWarning, this.logError};
    private IntToString[] unixLogLevels = new IntToString[]{new IntToString(0, "GUI0227L"), new IntToString(1, "GUI0228L"), this.logWarning, this.logError, new IntToString(4, "GUI0231L"), new IntToString(5, "GUI0232L"), new IntToString(6, "GUI0233L")};
    private IntToString[] unixLogFacilitys = new IntToString[]{new IntToString(8, "GUI0242L"), new IntToString(0, "GUI0234L"), new IntToString(1, "GUI0235L"), new IntToString(2, "GUI0236L"), new IntToString(3, "GUI0237L"), new IntToString(4, "GUI0238L"), new IntToString(5, "GUI0239L"), new IntToString(6, "GUI0240L"), new IntToString(7, "GUI0241L")};

    public AbstractAlertEditor() {
        this.alert = new AlertDefinition();
        this.initAlert();
    }

    public AbstractAlertEditor(boolean doDbmsType) {
        this();
        this.doDbmsType = doDbmsType;
    }

    public AbstractAlertEditor(AlertDefinition alert) {
        this.alert = alert;
    }

    public AbstractAlertEditor(AlertDefinition alert, boolean doDbmsType) {
        this(alert);
        this.doDbmsType = doDbmsType;
    }

    public Component getComponent() {
        if (this.alertEditPanel != null) {
            return this.alertEditPanel;
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildConditionPanel());
        this.add(this.buildActionPanel());
        this.add(Box.createVerticalGlue());
        this.setConditionData();
        this.setActionData();
        this.conditionList.addActionListener(this);
        this.thresholdUnits.addActionListener(this);
        this.loginNotification.addActionListener(this);
        this.osLog.addActionListener(this);
        this.runScript.addActionListener(this);
        this.scriptSettings.addActionListener(this);
        this.email.addActionListener(this);
        this.editEmail.addActionListener(this);
        if (this.thresholdUnits.isEnabled()) {
            this.thresholdUnitChange();
        }
        this.alertEditPanel = this;
        return this.alertEditPanel;
    }

    public AlertDefinition getData() {
        if (this.alertEditPanel != null) {
            this.getActionData();
            this.getConditionData();
        }
        return this.alert;
    }

    public void validateData() throws GeneralException {
        if (this.alertEditPanel == null) {
            return;
        }
        this.validateConditionData();
        if (this.alert.aldEmail && !this.haveRecipient()) {
            this.throwException("GUI0246M");
        }
        if (this.alert.aldNotifyOnLogin != null && this.alert.aldNotifyOnLogin.equals("")) {
            this.throwException("GUI0244M");
        }
        if (this.runScript.isSelected() && !this.scriptDefined()) {
            this.throwException("GUI2076E");
        }
        this.validateAlertSpecificActionData();
    }

    protected void throwException(String msgID) throws GeneralException {
        throw new GeneralException(MessageLog.getMessageNoTS(msgID, null));
    }

    protected boolean haveRecipient() {
        return !TextUtil.isNull(this.alert.aldEmailDef.aleRecipients);
    }

    protected void validateConditionData() throws GeneralException {
        if (this.thresholdValue.isEnabled() && this.alert.aldThresholdValue == -1) {
            this.throwException("STG4020E");
        }
    }

    protected void validateAlertSpecificActionData() throws GeneralException {
    }

    protected void initAlert() {
        this.alert.aldCreator = GuiUtil.getUserName();
        this.alert.aldEnabled = true;
        this.alert.aldThresholdType = 0;
        this.alert.aldThresholdValue = 0;
        this.alert.aldScriptComputerID = -1;
    }

    protected JPanel buildConditionPanel() {
        String labelText = MessageLog.getMessageNoID("GUI0205T");
        JPanel conditionPanel = GuiUtil.getTitledBorderedPanel(labelText);
        labelText = MessageLog.getMessageNoID("GUI0206L");
        this.lConditions = new JLabel(labelText);
        labelText = MessageLog.getMessageNoID("GUI0207L");
        this.lUnits = new JLabel(labelText);
        labelText = MessageLog.getMessageNoID("GUI0208L");
        this.lValue = new JLabel(labelText);
        this.conditionList = new TComboBox();
        this.conditionList.setPreferredSize(new Dimension(425, 20));
        this.thresholdUnits = new TComboBox();
        this.thresholdUnits.setPreferredSize(new Dimension(190, 20));
        this.thresholdValue = TTextField.newTTextField(9, 7, true);
        this.valueDocument = (SizeLimitedDocument)this.thresholdValue.getDocument();
        GuiUtil.setAccessibleLabel(this.lConditions, this.conditionList, "MNEMONIC_CONDITION", MessageLog.getMessageNoID("GUI0206L"), "DESCRIPTION_CONDITION");
        GuiUtil.setAccessibleLabel(this.lValue, this.thresholdValue, "MNEMONIC_VALUE", MessageLog.getMessageNoID("GUI0207L"), "DESCRIPTION_VALUE");
        GuiUtil.setAccessibleLabel(this.lUnits, this.thresholdUnits, "MNEMONIC_UNITS", MessageLog.getMessageNoID("GUI0208L"), "DESCRIPTION_UNITS");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 0, 16);
        constraints.anchor = 17;
        if (this.doDbmsType) {
            this.lDbmsType = new JLabel(MessageLog.getMessageNoID("DBG0578L"));
            this.dbmsList = new TComboBox();
            GuiUtil.setAccessibleLabel(this.lDbmsType, this.dbmsList, "MNEMONIC_TYPE", MessageLog.getMessageNoID("DBG0578L"), MessageLog.getMessageNoID("DBG0578L"));
            constraints.gridwidth = 0;
            conditionPanel.add((Component)this.lDbmsType, constraints);
            conditionPanel.add((Component)this.dbmsList, constraints);
        }
        constraints.gridwidth = 2;
        conditionPanel.add((Component)this.lConditions, constraints);
        constraints.gridwidth = 1;
        conditionPanel.add((Component)this.lValue, constraints);
        constraints.gridwidth = 0;
        conditionPanel.add((Component)this.lUnits, constraints);
        constraints.gridwidth = 2;
        conditionPanel.add((Component)this.conditionList, constraints);
        constraints.gridwidth = 1;
        conditionPanel.add((Component)this.thresholdValue, constraints);
        constraints.gridwidth = 0;
        conditionPanel.add((Component)this.thresholdUnits, constraints);
        GuiUtil.completePanel(conditionPanel);
        this.setPanelSize(conditionPanel);
        return conditionPanel;
    }

    protected void setPanelSize(JPanel panel) {
        int maxWidth = (int)panel.getMaximumSize().getWidth();
        int minHeight = (int)panel.getMinimumSize().getHeight();
        panel.setMaximumSize(new Dimension(maxWidth, minHeight));
    }

    private boolean scriptDefined() {
        return this.alert.aldScriptComputerID >= 0 && !Util.isEmpty(this.alert.aldScriptName);
    }

    private JPanel buildActionPanel() {
        Insets insets;
        boolean winEventLog;
        String labelText = MessageLog.getMessageNoID("GUI0209T");
        JPanel actionPanel = GuiUtil.getTitledBorderedPanel(labelText);
        labelText = MessageLog.getMessageNoID("GUI0210L");
        this.snmpTrap = new JCheckBox(labelText);
        GuiUtil.setAccessibleDescription(this.snmpTrap, labelText);
        labelText = Util.getString("LABEL_TEC_TRAP");
        this.tecTrap = new JCheckBox(labelText);
        GuiUtil.setAccessibleDescription(this.tecTrap, labelText);
        labelText = MessageLog.getMessageNoID("GUI0211L");
        this.loginNotification = new JCheckBox(labelText);
        GuiUtil.setAccessible(this.loginNotification, labelText, "DESCRIPTION_LOGINNOTIFICATIONDESCRIPTION_LOGINNOTIFICATION");
        labelText = MessageLog.getMessageNoID("GUI0212L");
        this.lLoginID = new JLabel(labelText);
        this.loginID = TTextField.newTTextField(24, 32, false);
        GuiUtil.setAccessibleLabel(this.lLoginID, this.loginID, "MNEMONIC_lOGINID", labelText, "DESCRIPTION_LOGINID");
        if (Constants.isWindows(GuiClient.serverStatusResp.osType)) {
            winEventLog = true;
            labelText = MessageLog.getMessageNoID("GUI0213L");
            this.osLog = new JCheckBox(labelText);
            GuiUtil.setAccessibleDescription(this.osLog, labelText);
            labelText = MessageLog.getMessageNoID("GUI0214L");
            this.lLogLevel = new JLabel(labelText);
            IntToString.resolveNames(this.winLogLevels);
            this.logLevel = new TComboBox(this.winLogLevels);
            GuiUtil.setAccessibleLabel(this.lLogLevel, this.logLevel, "MNEMONIC_EVENTTYPE", labelText, "DESCRIPTION_EVENTTYPE");
        } else {
            winEventLog = false;
            labelText = MessageLog.getMessageNoID("GUI0215L");
            this.osLog = new JCheckBox(labelText);
            labelText = MessageLog.getMessageNoID("GUI0216L");
            this.lLogLevel = new JLabel(labelText);
            IntToString.resolveNames(this.unixLogLevels);
            this.logLevel = new TComboBox(this.unixLogLevels);
            GuiUtil.setAccessibleLabel(this.lLogLevel, this.logLevel, "MNEMONIC_EVENTTYPE", labelText, "DESCRIPTION_EVENTTYPE");
            labelText = MessageLog.getMessageNoID("GUI0217L");
            this.lLogFacility = new JLabel(labelText);
            IntToString.resolveNames(this.unixLogFacilitys);
            this.logFacility = new TComboBox(this.unixLogFacilitys);
            GuiUtil.setAccessibleLabel(this.lLogFacility, this.logFacility, "MNEMONIC_EVENTTYPE", labelText, "DESCRIPTION_EVENTTYPE");
        }
        labelText = MessageLog.getMessageNoID("GUI2071L");
        this.runScript = new JCheckBox(labelText);
        GuiUtil.setAccessible(this.runScript, labelText, labelText);
        if (this.changeText == null) {
            this.changeText = MessageLog.getMessageNoID("GUI2072L");
            this.defineText = MessageLog.getMessageNoID("GUI2073L");
        }
        labelText = this.scriptDefined() ? this.changeText : this.defineText;
        this.scriptSettings = new JButton(labelText);
        GuiUtil.setAccessible(this.scriptSettings, labelText, labelText);
        JPanel emailPanel = this.buildEmailPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = insets = new Insets(0, 0, 4, 5);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        actionPanel.add((Component)this.snmpTrap, constraints);
        if (this.realEvdJarInstalled()) {
            actionPanel.add((Component)this.tecTrap, constraints);
        }
        constraints.gridwidth = 1;
        actionPanel.add((Component)this.loginNotification, constraints);
        actionPanel.add((Component)this.lLoginID, constraints);
        constraints.gridwidth = 3;
        constraints.gridwidth = 0;
        actionPanel.add((Component)this.loginID, constraints);
        constraints.gridwidth = 1;
        actionPanel.add((Component)this.osLog, constraints);
        if (!winEventLog) {
            actionPanel.add((Component)this.lLogFacility, constraints);
            actionPanel.add((Component)this.logFacility, constraints);
        }
        actionPanel.add((Component)this.lLogLevel, constraints);
        constraints.gridwidth = 0;
        actionPanel.add((Component)this.logLevel, constraints);
        constraints.gridwidth = 1;
        actionPanel.add((Component)this.runScript, constraints);
        constraints.gridwidth = 0;
        actionPanel.add((Component)this.scriptSettings, constraints);
        Component[] otherControls = this.buildAlertSpecificActionControls();
        if (otherControls != null) {
            constraints.gridwidth = 1;
            int lastControl = otherControls.length - 1;
            for (int i = 0; i <= lastControl; ++i) {
                if (i == lastControl) {
                    constraints.gridwidth = 0;
                }
                actionPanel.add(otherControls[i], constraints);
            }
        }
        actionPanel.add((Component)emailPanel, constraints);
        GuiUtil.completePanel(actionPanel);
        this.setPanelSize(actionPanel);
        return actionPanel;
    }

    private JPanel buildEmailPanel() {
        JPanel emailPanel = new JPanel();
        emailPanel.setLayout(new GridBagLayout());
        String labelText = MessageLog.getMessageNoID("GUI0220L");
        this.email = new JCheckBox(labelText);
        GuiUtil.setAccessible(this.email, labelText, labelText);
        labelText = MessageLog.getMessageNoID("GUI0221L");
        this.emailRecipientList = new EditableList(labelText, null, 5);
        JPanel emailButtonPanel = this.buildEmailButtonPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        emailPanel.add((Component)this.email, constraints);
        constraints.gridwidth = 3;
        constraints.insets = new Insets(4, 16, 0, 5);
        constraints.gridheight = 5;
        emailPanel.add((Component)this.emailRecipientList, constraints);
        constraints.gridwidth = 0;
        constraints.insets = new Insets(2, 20, 0, 0);
        constraints.fill = 1;
        constraints.anchor = 13;
        emailPanel.add((Component)emailButtonPanel, constraints);
        return emailPanel;
    }

    protected JPanel buildEmailButtonPanel() {
        String labelText = MessageLog.getMessageNoID("GUI0226L");
        this.editEmail = new JButton(labelText);
        GuiUtil.setAccessible(this.editEmail, labelText, labelText);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.editEmail);
        return buttonPanel;
    }

    protected Component[] buildAlertSpecificActionControls() {
        return null;
    }

    protected abstract void setConditionData();

    protected void setThresholdValue() {
        if (this.alert.aldThresholdValue != -1) {
            int value = this.alert.aldThresholdValue;
            if (this.alert.aldThresholdType == 4) {
                value /= 1024;
            } else if (this.alert.aldThresholdType == 5) {
                value /= 0x100000;
            }
            this.thresholdValue.setText(String.valueOf(value));
        }
    }

    protected void setActionData() {
        this.snmpTrap.setSelected(this.alert.aldSnmpTrap);
        this.tecTrap.setSelected(this.alert.aldTecEvent);
        this.loginNotification.setSelected(this.alert.aldNotifyOnLogin != null && !this.alert.aldNotifyOnLogin.equals(" "));
        TextUtil.setText(this.loginID, this.alert.aldNotifyOnLogin);
        this.loginNotificationChange();
        this.osLog.setSelected(this.alert.aldOsLog);
        if (this.alert.aldOsLog) {
            this.setComboBoxSelection(this.logLevel, this.alert.aldOsLogSeverity);
            if (this.logFacility != null) {
                this.setComboBoxSelection(this.logFacility, this.alert.aldSyslogFacility);
            }
        }
        this.osLogChange();
        boolean selected = this.scriptDefined();
        this.runScript.setSelected(selected);
        this.scriptSettings.setEnabled(selected);
        this.setAlertSpecificActionData();
        this.setEmailData();
    }

    protected void setAlertSpecificActionData() {
    }

    protected void setEmailData() {
        this.email.setSelected(this.alert.aldEmail);
        if (this.alert.aldEmail && this.alert.aldEmailDef != null) {
            this.emailRecipientList.removeAllObjects();
            ArrayList recipients = this.alert.aldEmailDef.parseRecipients();
            for (int i = 0; i < recipients.size(); ++i) {
                String recipient = (String)recipients.get(i);
                this.emailRecipientList.addObject(recipient);
            }
            this.emailSubject = this.alert.aldEmailDef.aleSubject;
            this.emailText = this.alert.aldEmailDef.aleText;
            this.emailCond = this.alert.aldCondition;
        }
        this.emailChange();
    }

    protected void getConditionData() {
        IntToString selectedItem = (IntToString)this.conditionList.getSelectedItem();
        this.alert.aldCondition = (short)selectedItem.value;
        selectedItem = (IntToString)this.thresholdUnits.getSelectedItem();
        this.alert.aldThresholdType = selectedItem == null ? (byte)0 : (byte)selectedItem.value;
        String value = this.thresholdValue.getText();
        if (TextUtil.isNull(value)) {
            this.alert.aldThresholdValue = -1;
        } else {
            this.alert.aldThresholdValue = Integer.parseInt(value);
            if (this.alert.aldThresholdType == 4) {
                this.alert.aldThresholdValue *= 1024;
            } else if (this.alert.aldThresholdType == 5) {
                this.alert.aldThresholdValue *= 0x100000;
            }
        }
    }

    protected void getActionData() {
        this.alert.aldSnmpTrap = this.snmpTrap.isSelected();
        this.alert.aldTecEvent = this.tecTrap.isSelected();
        this.alert.aldNotifyOnLogin = this.loginNotification.isSelected() ? TextUtil.getTrimmedText(this.loginID) : null;
        this.alert.aldOsLog = this.osLog.isSelected();
        if (this.alert.aldOsLog) {
            IntToString selectedItem = (IntToString)this.logLevel.getSelectedItem();
            this.alert.aldOsLogSeverity = (byte)selectedItem.value;
            if (this.logFacility != null) {
                selectedItem = (IntToString)this.logFacility.getSelectedItem();
                this.alert.aldSyslogFacility = (byte)selectedItem.value;
            }
        }
        this.getAlertSpecificActionData();
        this.getEmailData();
    }

    protected void getAlertSpecificActionData() {
    }

    protected void getEmailData() {
        this.alert.aldEmail = this.email.isSelected();
        if (this.alert.aldEmail) {
            if (this.alert.aldEmailDef == null) {
                this.alert.aldEmailDef = new AlertEmail();
            }
            Object[] recipients = this.emailRecipientList.getElements();
            this.alert.aldEmailDef.setRecipients(recipients);
            this.alert.aldEmailDef.aleSubject = this.emailSubject;
            this.alert.aldEmailDef.aleText = this.emailText;
        } else {
            this.alert.aldEmailDef = null;
        }
    }

    protected Dialog makeScriptDialog() {
        return new ScriptDefinitionDialog(this.alert, this.computers);
    }

    private void showDialog() {
        this.getConditionData();
        if (Util.isEmpty(this.alert.aldScriptName)) {
            this.alert.aldScriptName = "";
        }
        Dialog dlg = this.makeScriptDialog();
        dlg.show();
        if (this.scriptDefined()) {
            this.scriptSettings.setText(this.changeText);
        }
    }

    private void submitRequest() {
        Request request = new Request();
        ServerRequest.guiInfo(request, 2, -2);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        TreeMap<String, NameList> sorter = new TreeMap<String, NameList>();
        NameList element = this.computers = (NameList)response.responseData;
        while (element != null) {
            GComputer gc = GuiUtil.getComputer(element.nlID);
            element.nlName = gc.gcTSName;
            sorter.put(element.nlName, element);
            element = element.nlNext;
        }
        Iterator iterator = sorter.values().iterator();
        this.computers = null;
        NameList prev = null;
        while (iterator.hasNext()) {
            element = (NameList)iterator.next();
            element.nlNext = null;
            if (prev != null) {
                prev.nlNext = element;
            } else {
                this.computers = element;
            }
            prev = element;
        }
        sorter = null;
        iterator = null;
        this.showDialog();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.loginNotification) {
            this.loginNotificationChange();
        } else if (source == this.osLog) {
            this.osLogChange();
        } else if (source == this.runScript) {
            boolean selected = this.runScript.isSelected();
            this.scriptSettings.setEnabled(selected);
            if (!selected) {
                this.alert.aldScriptComputerID = -1;
                this.scriptSettings.setText(this.defineText);
            }
        } else if (source == this.scriptSettings) {
            if (this.computers != null) {
                this.showDialog();
            } else {
                this.submitRequest();
            }
        } else if (source == this.email) {
            this.emailChange();
        } else if (source == this.editEmail) {
            this.updateEmail();
        } else if (source == this.dbmsList) {
            this.dbmsChange();
        } else if (source == this.conditionList) {
            this.conditionChange();
            IntToString selection = (IntToString)this.conditionList.getSelectedItem();
            int condition = selection.value;
            if (condition != this.emailCond) {
                if (condition == this.alert.aldCondition) {
                    this.setEmailData();
                } else {
                    this.emailSubject = null;
                    this.emailText = null;
                    this.emailCond = condition;
                }
            }
        } else if (source == this.thresholdUnits) {
            this.thresholdUnitChange();
        }
    }

    private void loginNotificationChange() {
        boolean selected = this.loginNotification.isSelected();
        this.lLoginID.setEnabled(selected);
        this.loginID.setEnabled(selected);
        if (!selected) {
            this.loginID.setText(null);
        }
    }

    private void osLogChange() {
        boolean selected = this.osLog.isSelected();
        this.lLogLevel.setEnabled(selected);
        this.logLevel.setEnabled(selected);
        if (!selected) {
            this.logLevel.setSelectedIndex(0);
        }
        if (this.lLogFacility != null) {
            this.lLogFacility.setEnabled(selected);
            this.logFacility.setEnabled(selected);
            if (!selected) {
                this.logFacility.setSelectedIndex(0);
            }
        }
    }

    protected void emailChange() {
        boolean selected = this.email.isSelected();
        this.editEmail.setEnabled(selected);
        this.emailRecipientList.setEnabled(selected);
    }

    protected void dbmsChange() {
        IntToString selection = (IntToString)this.dbmsList.getSelectedItem();
        if (selection == null) {
            return;
        }
        this.alert.aldDbmsType = (byte)selection.value;
        this.conditionList.removeActionListener(this);
        this.setConditionData();
        this.conditionList.addActionListener(this);
    }

    protected void conditionChange() {
    }

    protected void thresholdUnitChange() {
        IntToString selection = (IntToString)this.thresholdUnits.getSelectedItem();
        if (selection == null) {
            return;
        }
        int condition = selection.value;
        switch (condition) {
            case 1: {
                this.valueDocument.setMaxSize(7);
                break;
            }
            case 2: {
                this.valueDocument.setMaxSize(2);
                break;
            }
            case 3: {
                this.valueDocument.setMaxSize(7);
                break;
            }
            case 4: {
                this.valueDocument.setMaxSize(6);
                break;
            }
            case 5: {
                this.valueDocument.setMaxSize(3);
            }
        }
    }

    protected void updateEmail() {
        short saveCondition = this.alert.aldCondition;
        IntToString sel = (IntToString)this.conditionList.getSelectedItem();
        this.alert.aldCondition = (short)sel.value;
        AlertEmailEditor email = new AlertEmailEditor();
        email.edit(this.emailSubject, this.emailText, this.alert);
        this.emailSubject = email.subject;
        this.emailText = email.text;
        email = null;
        this.alert.aldCondition = saveCondition;
    }

    protected void initComboBox(JComboBox comboBox, IntToString[] valueList, int defaultValue) {
        IntToString.resolveNames(valueList);
        this.setComboBoxChoices(comboBox, valueList, defaultValue);
    }

    protected void setComboBoxChoices(JComboBox comboBox, IntToString[] valueList, int defaultValue) {
        comboBox.removeAllItems();
        for (int i = 0; i < valueList.length; ++i) {
            comboBox.addItem(valueList[i]);
        }
        this.setComboBoxSelection(comboBox, defaultValue);
    }

    protected void setComboBoxSelection(JComboBox comboBox, int value) {
        for (int i = comboBox.getItemCount() - 1; i >= 0; --i) {
            IntToString element = (IntToString)comboBox.getItemAt(i);
            if (element.value != value) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    protected void setConditions(IntToString[] conditions) {
        this.conditions = conditions;
    }

    protected void setValueEnabled(boolean state) {
        this.thresholdValue.setEnabled(state);
        this.lValue.setEnabled(state);
    }

    protected void setUnitEnabled(boolean state) {
        this.thresholdUnits.setEnabled(state);
        this.lUnits.setEnabled(state);
        if (!state) {
            this.thresholdUnits.removeAllItems();
        }
    }

    public AlertHeader getAlertHeader() {
        return null;
    }

    private boolean realEvdJarInstalled() {
        boolean ret = false;
        Method[] methods = new TECEvent().getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("normalizeEvEnd")) continue;
            ret = true;
        }
        return ret;
    }
}

