/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.AlertLogDetailPanel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogDetailDDI
extends DataDisplayInfo
implements GuiRequestor {
    private ExtAlertLog record;
    private boolean textFetched;

    public AlertLogDetailDDI(ExtAlertLog pRecord) {
        this.record = pRecord;
        this.textFetched = false;
        String s = AlertConditionManager.getConditionMessageId(this.record.alAlertCondition);
        s = s != null ? MessageLog.getMessageNoID(s) : "?";
        Object[] args = new Object[]{s};
        this.setDescription(MessageLog.getMessageNoID("GUI2030L", args));
    }

    private void create() {
        this.panel = new AlertLogDetailPanel(this.record);
        this.show();
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        this.textFetched = true;
        this.record.alMessage = (String)((Object)response.responseData);
        this.create();
    }

    private void submitRequest() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.AlertLogIDHndlr.Message";
        request.flags = (byte)4;
        request.requestData = this.record;
        GuiClient.doRequest(this, request);
    }

    public void reDisplay() {
        if (this.panel != null) {
            this.show();
        } else if (this.textFetched) {
            this.create();
        } else {
            this.submitRequest();
        }
    }
}

