/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.Alertable;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class AlertableTreeNode
extends Alertable {
    protected int ID;
    public JPopupMenu menu;

    public AlertableTreeNode(int pID) {
        this.ID = pID;
        if (this.ID > 0) {
            AlertManager.register(this.ID, (Alertable)this);
        }
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.render(renderer, tree, selected, expanded, leaf, row, hasFocus);
        renderer.setFont(BaseTree.plainFont);
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.menu;
    }

    public void showPopupMenu(MouseEvent event) {
        this.menu = this.getPopupMenu();
        if (this.ID > 0) {
            String s = MessageLog.getMessageNoID("GUI0059L");
            JMenuItem item = new JMenuItem(s);
            this.menu.add(item);
            item.addActionListener(new Listener());
            item.setName(s);
        }
        if (event != null) {
            this.showPopupMenu(this.menu, event);
        }
    }

    protected abstract NameList getNameList();

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent event) {
            byte subProduct;
            short product;
            NameList element = AlertableTreeNode.this.getNameList();
            if (element instanceof AlertNameList) {
                AlertNameList extended = (AlertNameList)element;
                product = extended.nlProductID;
                subProduct = extended.nlSubProductID;
            } else {
                product = 0;
                subProduct = 0;
            }
            AlertLogDDI DDI = new AlertLogDDI(element, product, subProduct);
            ((DataDisplayInfo)DDI).reDisplay();
        }
    }
}

