/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Toolkit;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DecimalDocument
extends PlainDocument {
    private int maxLength;

    public DecimalDocument(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setMaxSize(int maxLength) {
        this.maxLength = maxLength;
        int length = this.getLength();
        if (length > maxLength) {
            try {
                this.remove(0, length);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
        if (s != null && s.length() > 0) {
            if (offset == 0 && s.charAt(0) == ' ' || s.length() + this.getLength() > this.maxLength) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            for (int i = s.length() - 1; i >= 0; --i) {
                if (Character.isDigit(s.charAt(i))) continue;
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                if (s.charAt(i) == symbols.getDecimalSeparator()) {
                    String c = this.getText(0, this.getLength());
                    for (int j = c.length() - 1; j >= 0; --j) {
                        if (c.charAt(j) != symbols.getDecimalSeparator()) continue;
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        super.insertString(offset, s, attributeSet);
    }
}

