/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.ListElementEditor;
import org.eclipse.aperi.gui.SizeLimitedDocument;

public class DefaultListEditor
extends JTextField
implements ListElementEditor,
DocumentListener,
ActionListener {
    private EditableList list;

    public DefaultListEditor(int maxSize, EditableList pList) {
        this.list = pList;
        SizeLimitedDocument document = new SizeLimitedDocument(maxSize, false);
        this.setDocument(document);
        document.addDocumentListener(this);
        this.addActionListener(this);
    }

    public DefaultListEditor(int maxSize) {
        this(maxSize, null);
    }

    public void setList(EditableList pList) {
        this.list = pList;
    }

    public Object getObject() {
        String o = this.getText();
        this.setText("");
        return o;
    }

    public void setObject(Object o) {
        this.setText(o.toString());
        this.requestFocus();
    }

    public void objectRemoved(Object listElement) {
    }

    public Component getComponent() {
        return this;
    }

    public void insertUpdate(DocumentEvent e) {
        this.list.setAddEnabled(true);
    }

    public void removeUpdate(DocumentEvent e) {
        String value = this.getText();
        if (value == null || value.length() == 0) {
            this.list.setAddEnabled(false);
        }
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String s = (String)this.getObject();
        if (s != null && s.length() > 0) {
            this.list.addObject(s);
        }
    }
}

