/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.FilterResultsViewer;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;

public class FilterPanel
extends GridBagPanel
implements ListSelectionListener,
ActionListener {
    private Vector filterVec;
    private JList filterList;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private DefaultListModel listModel;
    private short resourceType;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public FilterPanel(Vector inFilterVec, Insets insets, short resType) {
        super(new Insets(0, insets.left, 0, insets.right));
        String resLabelString;
        this.filterVec = inFilterVec;
        this.resourceType = resType;
        this.filterVec.trimToSize();
        this.filterList = new JList(this.filterVec);
        this.filterList.setSelectionMode(0);
        this.filterList.setSelectedIndex(0);
        this.filterList.setVisibleRowCount(3);
        switch (resType) {
            case 89: {
                resLabelString = Util.getString("LABEL_COMPUTER_FILTERS");
                break;
            }
            case 93: {
                resLabelString = Util.getString("LABEL_DA_FILTERS");
                break;
            }
            case 90: {
                resLabelString = Util.getString("LABEL_FS_FILTERS");
                break;
            }
            default: {
                resLabelString = "";
            }
        }
        this.add((JComponent)new JLabel(resLabelString), new Insets(2, 0, 0, 0));
        this.newRow();
        JScrollPane sp = new JScrollPane(this.filterList);
        this.add(sp, 3, 1, 2, new Insets(0, 0, 0, 0));
        this.newRow();
        this.addButton = new JButton(Util.getString("NAME_ADD"));
        this.editButton = new JButton(Util.getString("LABEL_EDIT"));
        this.removeButton = new JButton(Util.getString("LABEL_DELETE"));
        this.add((JComponent)this.addButton, 22, 0, new Insets(2, 4, 0, 0));
        this.add((JComponent)this.editButton, 22, 0, new Insets(2, 4, 0, insets.right));
        this.add((JComponent)this.removeButton, 22, 0, new Insets(2, 4, 0, insets.right));
        if (inFilterVec.size() == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.filterList.addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.editButton.addActionListener(this);
        this.removeButton.addActionListener(this);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.filterList.isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addButton || source == this.editButton) {
            FilterResultsViewer frv = source == this.addButton ? new FilterResultsViewer(this.guiMain.getFrame(), FilterResultsViewer.ADD, this, 0, null, this.resourceType, Util.getString("TITLE_ADD_FILTER")) : new FilterResultsViewer(this.guiMain.getFrame(), FilterResultsViewer.EDIT, this, this.filterList.getSelectedIndex(), this.filterList.getSelectedValue(), this.resourceType, Util.getString("TITLE_EDIT_FILTER"));
            GuiUtil.centerDialog(frv);
            frv.displayDialog();
        } else if (source == this.removeButton) {
            this.removeSelectedFilter();
        }
    }

    public boolean addFilter(String filter) {
        return this.addFilter(filter, this.filterList.getModel().getSize());
    }

    public boolean addFilter(String filter, int row) {
        if (this.filterVec.contains(filter)) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI1620E"), "GUI1620E", 0);
            return false;
        }
        int saveIx = this.filterList.getSelectedIndex();
        this.filterVec.add(row, filter);
        this.filterList.setListData(this.filterVec);
        this.filterList.setSelectedIndex(saveIx);
        return true;
    }

    public void removeSelectedFilter() {
        int ix = this.filterList.getSelectedIndex();
        this.filterVec.remove(ix);
        this.filterVec.trimToSize();
        this.filterList.setListData(this.filterVec);
        int size = this.filterVec.size();
        if (size == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            if (ix == size) {
                --ix;
            }
            this.filterList.setSelectedIndex(ix);
        }
    }

    public boolean updateFilter(String newFilter) {
        if (this.filterVec.contains(newFilter)) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI1620E"), "GUI1620E", 0);
            return false;
        }
        int saveSelected = this.filterList.getSelectedIndex();
        this.removeSelectedFilter();
        this.addFilter(newFilter, saveSelected);
        return true;
    }
}

