/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.eclipse.aperi.gui.DoubleLineBorder;
import org.eclipse.aperi.gui.GuiUtil;

public class GridBagPanel
extends JPanel {
    public static final int HORZ = 2;
    public static final int VERT = 3;
    public static final int BOTH = 1;
    public static final int NONE = 0;
    public static final int CENTER = 10;
    public static final int WEST = 21;
    public static final int EAST = 22;
    public static final int NW = 23;
    public static final int NE = 24;
    public static final int SW = 25;
    public static final int SE = 26;
    public static final int NORTH = 19;
    public static final int SOUTH = 20;
    public static final Color TEXT_COLOR = new Color(72, 102, 150);
    private int WIDTH = 1;
    private int HEIGHT = 1;
    public static final Dimension TEXTFIELDSIZE = new Dimension(165, 25);
    public static final Dimension TEXTAREASIZE;
    public static final Dimension TABLESIZE;
    private GridBagConstraints gbc;
    private Insets m_insets;
    private Insets titleInsets = new Insets(10, 5, 2, 8);
    private Insets subtitleInsets = new Insets(10, 10, 2, 8);
    private Insets descriptionInsets = new Insets(4, 12, 12, 8);
    private int m_anchor = 23;
    private int m_column = 0;
    private int m_fill = 0;
    private int m_row = 0;
    private JLabel topLabel = new JLabel();
    private JLabel descriptionLabel;

    public GridBagPanel() {
        this(new Insets(4, 12, 4, 8));
    }

    public GridBagPanel(Insets ins) {
        super(new GridBagLayout());
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = this.m_anchor;
        this.gbc.insets = this.m_insets = ins;
        this.gbc.fill = this.m_fill;
    }

    public void setDefaultAnchor(int anchor) {
        this.gbc.anchor = this.m_anchor = anchor;
    }

    public void setDefaultInsets(Insets ins) {
        this.gbc.insets = this.m_insets = ins;
    }

    public void setTitle(String text) {
        this.topLabel = new JLabel(text);
        Font font = this.topLabel.getFont();
        this.topLabel.setFont(font.deriveFont(1, (float)font.getSize() + 4.0f));
        this.topLabel.setBorder(new DoubleLineBorder(this.topLabel.getForeground(), this.topLabel.getForeground()));
        this.add(this.topLabel, 0, 1, 2, this.titleInsets);
        this.newRow();
    }

    public void changeTitle(String text) {
        this.topLabel.setText(text);
    }

    public void setDescription(String text) {
        JTextArea descriptionLabel = new JTextArea(){

            public boolean isFocusable() {
                return false;
            }
        };
        Font font = descriptionLabel.getFont();
        descriptionLabel.setFont(font.deriveFont(0, font.getSize()));
        descriptionLabel.setEditable(false);
        descriptionLabel.setLineWrap(true);
        descriptionLabel.setWrapStyleWord(GuiUtil.wrapAtWords());
        descriptionLabel.setText(text);
        descriptionLabel.setForeground(this.topLabel.getForeground());
        descriptionLabel.setBackground(this.getBackground());
        this.add(descriptionLabel, 0, 1, 2, this.descriptionInsets);
        this.newRow();
    }

    public void changeDescription(String text) {
        this.descriptionLabel.setText(text);
    }

    public void setSubtitle(String text) {
        JLabel subLabel = new JLabel(text);
        Font font = subLabel.getFont();
        subLabel.setFont(font.deriveFont(1, (float)font.getSize() + 1.0f));
        subLabel.setBorder(new DoubleLineBorder(subLabel.getForeground(), null));
        this.add(subLabel, 0, 1, 2, this.subtitleInsets);
        this.newRow();
        this.gbc.insets = this.m_insets = new Insets(this.m_insets.top, this.subtitleInsets.left, this.m_insets.bottom, this.m_insets.right);
    }

    public void setSubtitleDescription(String text) {
        JTextArea descriptionLabel = new JTextArea(){

            public boolean isFocusable() {
                return false;
            }
        };
        Font font = descriptionLabel.getFont();
        this.topLabel.setFont(font.deriveFont(0, font.getSize()));
        descriptionLabel.setEditable(false);
        descriptionLabel.setLineWrap(true);
        descriptionLabel.setWrapStyleWord(GuiUtil.wrapAtWords());
        descriptionLabel.setText(text);
        descriptionLabel.setBackground(this.getBackground());
        this.add(descriptionLabel, 0, 1, 2, new Insets(4, 18, 2, 8));
        this.newRow();
    }

    public void newRow() {
        ++this.m_row;
        this.m_column = 0;
    }

    public void skipColumn() {
        ++this.m_column;
    }

    public void add(JComponent component) {
        this.addComponent(component, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, this.m_fill);
    }

    public void add(JComponent component, int fill) {
        this.addComponent(component, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, fill);
    }

    public void add(JComponent component, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, this.m_fill);
    }

    public void add(JComponent component, int anchor, int fill) {
        this.addComponent(component, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, anchor, fill);
    }

    public void add(JComponent component, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, fill);
    }

    public void add(JComponent component, int anchor, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, anchor, fill);
    }

    public void add(JComponent component, int width, int height, int fill) {
        this.addComponent(component, this.m_row, this.m_column, width, height, this.m_anchor, fill);
    }

    public void add(JComponent component, int width, int height, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, this.m_row, this.m_column, width, height, this.m_anchor, fill);
    }

    public void add(JComponent component, int row, int col, int width, int height, int anchor, int fill, Insets spacing) {
        this.gbc.insets = spacing;
        this.addComponent(component, row, col, width, height, anchor, fill);
    }

    public void createBox() {
        JPanel panel = new JPanel();
        panel.setBackground(this.getBackground());
        this.addComponent(panel, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, 0);
    }

    public void createStretchBox() {
        JPanel sbox = new JPanel();
        sbox.setBackground(this.getBackground());
        this.addComponent(sbox, this.m_row, this.m_column, this.WIDTH, this.HEIGHT, this.m_anchor, 1);
    }

    public void addComponent(JComponent component, int row, int col, int width, int height, int anchor, int fill) {
        this.gbc.gridx = col;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.anchor = anchor;
        switch (fill) {
            case 2: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 0.0;
                break;
            }
            case 3: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 1: {
                this.gbc.weightx = 1.0;
                this.gbc.weighty = 1.0;
                break;
            }
            case 0: {
                this.gbc.weightx = 0.0;
                this.gbc.weighty = 0.0;
                break;
            }
        }
        this.gbc.fill = fill;
        super.add((Component)component, this.gbc);
        this.gbc.insets = this.m_insets;
        this.gbc.anchor = this.m_anchor;
        this.m_column = col + width;
        this.m_row = row + height - 1;
    }

    static {
        TABLESIZE = TEXTAREASIZE = new Dimension(165, 100);
    }
}

