/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.dashboard.DashInitialize;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiConnect
extends JDialog
implements ActionListener {
    private static GridBagLayout gridBag = new GridBagLayout();
    private static GridBagConstraints gbcLabel = new GridBagConstraints();
    private static GridBagConstraints gbcLast = new GridBagConstraints();
    private JPanel entryPanel = new JPanel(gridBag);
    private static JLabel idL = new JLabel(MessageLog.getMessageNoID("GUI0014L"));
    private static JLabel pwdL = new JLabel(MessageLog.getMessageNoID("GUI0015L"));
    private static JLabel serverL = new JLabel(MessageLog.getMessageNoID("GUI0001L"));
    private JTextField idF = TTextField.newTTextField(null, 8, 64, false);
    private JPasswordField pwdF = new JPasswordField(8);
    private JComboBox server;
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton(MessageLog.getMessageNoID("GUI0113L"));
    private JButton cancelButton = new JButton(MessageLog.getMessageNoID("GUI0114L"));
    private static final String ERROR_TITLE = MessageLog.getMessageNoID("GUI0017M");
    private static final String SERV_FORMAT_ERROR = MessageLog.getMessageNoID("GUI0035M") + " ";
    private static ArrayList servers = new ArrayList();
    private static String serverHost;
    private static int serverPort;

    public GuiConnect() {
        super((Frame)GuiMain.pGuiMain, true);
        this.server = new JComboBox<Object>(servers.toArray());
        if (GuiMain.DEMO_MODE) {
            this.idF.setText("demo");
            this.pwdF.setText("demo");
            ActionEvent event = new ActionEvent(this, 1001, "OK");
            this.actionPerformed(event);
            return;
        }
        this.idF.setToolTipText(MessageLog.getMessageNoID("GUI0139T"));
        this.pwdF.setToolTipText(MessageLog.getMessageNoID("GUI0140T"));
        this.pwdF.addActionListener(this);
        this.server.setToolTipText(MessageLog.getMessageNoID("GUI0141T"));
        GuiUtil.setAccessible(this.idF, MessageLog.getMessageNoID("GUI0139T"), MessageLog.getMessageNoID("GUI0139T"));
        GuiUtil.setAccessible(this.pwdF, pwdL.getText(), MessageLog.getMessageNoID("GUI0140T"));
        GuiUtil.setAccessible(this.server, MessageLog.getMessageNoID("GUI0141T"), MessageLog.getMessageNoID("GUI0141T"));
        this.server.setEditable(true);
        Dimension screenSize = this.getToolkit().getScreenSize();
        int x = (screenSize.width - 400) / 2;
        int y = (screenSize.height - 200) / 2;
        this.setBounds(x, y, 400, 200);
        this.setModal(true);
        this.setTitle(MessageLog.getMessageNoID("GUI0013T"));
        GuiUtil.setAccessibleDescription(this, MessageLog.getMessageNoID("GUI0013T"));
        this.idF.setText(GuiUtil.getUserName());
        this.idF.selectAll();
        this.getContentPane().add((Component)this.entryPanel, "Center");
        GuiConnect.gbcLabel.anchor = 17;
        GuiConnect.gbcLast.anchor = 17;
        GuiConnect.gbcLast.gridwidth = 0;
        GuiConnect.gbcLast.fill = 2;
        this.entryPanel.add((Component)idL, gbcLabel);
        this.entryPanel.add((Component)this.idF, gbcLast);
        this.entryPanel.add((Component)pwdL, gbcLabel);
        this.entryPanel.add((Component)this.pwdF, gbcLast);
        this.entryPanel.add((Component)serverL, gbcLabel);
        this.entryPanel.add((Component)this.server, gbcLast);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        GuiUtil.setAccessible(this.okButton, this.okButton.getText(), this.okButton.getText());
        GuiUtil.setAccessible(this.cancelButton, this.cancelButton.getText(), this.cancelButton.getText());
        Component comp = this.server.getEditor().getEditorComponent();
        comp.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GuiConnect.this.okButton.doClick();
                }
            }
        });
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        Dimension d = this.getSize();
        this.setSize(new Dimension(d.width + 20, d.height + 20));
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.dispose();
        } else {
            String id;
            String serverEntered = (String)this.server.getSelectedItem();
            GuiMain.userName = id = this.idF.getText();
            String pwd = new String(this.pwdF.getPassword());
            if (GuiConnect.parseServer(serverEntered)) {
                if (this.server.getSelectedIndex() < 0) {
                    servers.add(0, serverEntered);
                }
                if (GuiClient.serverStatus() <= 4) {
                    if (Constants.isWindows(GuiClient.serverStatusResp.osType)) {
                        GuiMain.userName = id = id.toLowerCase();
                    }
                    if (GuiClient.signon(id, pwd) <= 4 && GuiClient.checkServerVersion("5.0.0") != 97) {
                        GuiMain.splitPane.repaint();
                        GuiMain.pBaseTree.newTree();
                        GuiMain.setServer(GuiClient.serverStatusResp.serverName);
                        String currentLaf = UIManager.getLookAndFeel().getClass().getName();
                        if (!GuiMain.prefs.lookAndFeel.equals(currentLaf)) {
                            if (!GuiMain.prefs.lookAndFeel.equals("System")) {
                                GuiMain.pGuiMain.setLookAndFeel(GuiMain.prefs.lookAndFeel);
                            }
                            GuiMain.pGuiMain.setLAFbutton();
                        }
                        GuiClient.getChartCustomizations(GuiUtil.getUserName());
                        this.dispose();
                        if (GuiMain.dashTotalsRow == null) {
                            new DashInitialize();
                        }
                    }
                }
            }
        }
        GuiManager.getGuiManager().getGuiMain().showNull();
    }

    static void createServerList(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            GuiConnect.parseServer(args[i]);
            servers.add(args[i]);
        }
    }

    private static boolean parseServer(String serverToParse) {
        boolean ok = false;
        StringTokenizer tokens = new StringTokenizer(serverToParse, ":");
        if (tokens.countTokens() == 2) {
            GuiClient.server = tokens.nextToken();
            try {
                GuiClient.port = Integer.parseInt(tokens.nextToken());
                ok = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!ok) {
            GuiClient.server = null;
            GuiClient.port = 0;
            new JOptionPane();
            JOptionPane.showMessageDialog(null, SERV_FORMAT_ERROR + serverToParse, ERROR_TITLE, 0);
        }
        Variables.server = GuiClient.server;
        Variables.port = GuiClient.port;
        return ok;
    }
}

