/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DoubleLineBorder;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.UilButtonPanelBean;

public class PrintPreviewPanel
extends JFrame
implements ActionListener,
WindowListener,
ComponentListener {
    private PrintPreviewable printable;
    private int pageWidth;
    private int pageHeight;
    private int zoom = 25;
    private int scale = 100;
    private boolean isPortrait = true;
    private Dimension currentSize = null;
    private JComboBox zoomBox;
    private JComboBox scaleBox;
    private JRadioButton portraitButton;
    private JRadioButton landscapeButton;
    private JComboBox paperSize;
    private JButton printButton;
    private JButton closeButton;
    private JButton sizeToFitButton;
    private PrintPreviewLayout layout;
    private PrinterJob printerJob;
    private PageFormat pageFormat;
    private JScrollPane scrollPane;
    private GridBagPanel toolBar;
    private boolean allowScaling = true;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public PrintPreviewPanel(PrintPreviewable printable, boolean allowScaling) {
        this(printable, "", allowScaling);
    }

    public PrintPreviewPanel(PrintPreviewable printable, String title, boolean allowScaling) {
        super(title);
        this.setIconImage(this.guiMain.getFrame().getIconImage());
        this.printable = printable;
        this.allowScaling = allowScaling;
        this.buildGUI();
    }

    private void buildGUI() {
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.addComponentListener(this);
        this.addWindowListener(this);
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
            this.remove(this.toolBar);
        }
        this.toolBar = new GridBagPanel(new Insets(3, 3, 3, 0));
        this.toolBar.setDefaultAnchor(21);
        UilButtonPanelBean buttonPanel = new UilButtonPanelBean();
        buttonPanel.setSpacerSize(5);
        buttonPanel.setIncrementWidth(1);
        this.printButton = new JButton(Util.getString("LABEL_PRINT_BUTTON"));
        this.printButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PRINT_BUTTON"));
        this.printButton.addActionListener(this);
        buttonPanel.add(this.printButton);
        this.toolBar.add(buttonPanel);
        this.addSeparator(this.toolBar);
        JLabel zoomLabel = new JLabel(Util.getString("LABEL_ZOOM_BOX"));
        String[] zoomFactors = new String[]{"10%", "25%", "50%", "75%", "100%"};
        this.zoomBox = new JComboBox<String>(zoomFactors);
        this.zoomBox.setEditable(true);
        this.zoomBox.setSelectedItem(Integer.toString(this.zoom) + "%");
        zoomLabel.setLabelFor(this.zoomBox);
        zoomLabel.setDisplayedMnemonic(GuiUtil.getMnemonic("MNEMONIC_ZOOM_BOX"));
        this.zoom = this.getInt(this.zoomBox.getSelectedItem().toString());
        this.zoomBox.addActionListener(this);
        this.zoomBox.setMaximumSize(this.zoomBox.getPreferredSize());
        Insets labelInsets = new Insets(3, 3, 3, 0);
        Insets boxInsets = new Insets(3, 0, 3, 5);
        this.toolBar.add((JComponent)zoomLabel, labelInsets);
        this.toolBar.add((JComponent)this.zoomBox, boxInsets);
        this.addSeparator(this.toolBar);
        ButtonGroup bg = new ButtonGroup();
        this.portraitButton = new JRadioButton(Util.getString("LABEL_PORTRAIT_BUTTON"));
        this.portraitButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_PORTRAIT_BUTTON"));
        this.portraitButton.addActionListener(this);
        this.landscapeButton = new JRadioButton(Util.getString("LABEL_LANDSCAPE_BUTTON"));
        this.landscapeButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_LANDSCAPE_BUTTON"));
        this.landscapeButton.addActionListener(this);
        JPanel orientationPanel = new JPanel(new GridLayout(2, 1));
        orientationPanel.add(this.portraitButton);
        orientationPanel.add(this.landscapeButton);
        this.toolBar.add(orientationPanel);
        bg.add(this.portraitButton);
        bg.add(this.landscapeButton);
        this.portraitButton.setSelected(this.isPortrait);
        this.landscapeButton.setSelected(!this.isPortrait);
        this.addSeparator(this.toolBar);
        this.closeButton = new JButton(Util.getString("LABEL_CLOSE_BUTTON"));
        this.closeButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CLOSE_BUTTON"));
        this.closeButton.addActionListener(this);
        buttonPanel = new UilButtonPanelBean();
        buttonPanel.setSpacerSize(5);
        buttonPanel.setIncrementWidth(1);
        buttonPanel.add(this.closeButton);
        this.toolBar.add(buttonPanel);
        this.toolBar.createStretchBox();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.layout = new PrintPreviewLayout();
        if (this.printerJob == null) {
            this.printerJob = PrinterJob.getPrinterJob();
            PageFormat defaultPage = this.printerJob.defaultPage();
            this.pageFormat = this.printerJob.pageDialog(defaultPage);
            if (this.pageFormat == defaultPage) {
                this.cleanupResources();
                return;
            }
        }
        if (this.pageFormat.getOrientation() == 1) {
            this.portraitButton.setSelected(true);
            this.isPortrait = true;
        } else {
            this.landscapeButton.setSelected(true);
            this.isPortrait = false;
        }
        if (this.pageFormat.getHeight() <= 0.0 || this.pageFormat.getWidth() <= 0.0) {
            System.err.println("Unable to determine default page size");
            return;
        }
        this.pageHeight = (int)this.pageFormat.getHeight();
        this.pageWidth = (int)this.pageFormat.getWidth();
        int width = this.pageWidth * this.zoom / 100;
        int height = this.pageHeight * this.zoom / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage bi = new BufferedImage(this.pageWidth, this.pageHeight, 1);
                Graphics g = bi.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.pageWidth, this.pageHeight);
                if (this.printable.print(g, this.pageFormat, pageIndex) == 0) {
                    PrintPreviewPage previewPage = new PrintPreviewPage(width, height, bi);
                    this.layout.add(previewPage);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException pe) {
            pe.printStackTrace();
            System.err.println("Unable to create Print Preview: " + pe.toString());
        }
        this.scrollPane = new JScrollPane(this.layout);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.toolBar.setMinimumSize(this.toolBar.getPreferredSize());
        if (this.currentSize == null) {
            this.pack();
        } else {
            this.setSize(this.currentSize);
        }
        GuiUtil.centerDialog(this);
        this.getRootPane().setDefaultButton(this.printButton);
        this.invalidate();
        this.validate();
        this.setVisible(true);
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void addSeparator(GridBagPanel panel) {
        JPanel separator = new JPanel();
        separator.setBorder(new DoubleLineBorder(null, Color.black, 1));
        panel.add((JComponent)separator, 3);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.printButton) {
            this.printerJob.setPageable(this.printable);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            if (this.printerJob.printDialog()) {
                try {
                    this.printerJob.print();
                }
                catch (PrinterException pe) {
                    System.err.println(pe.getMessage());
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
        } else if (source == this.closeButton) {
            this.cleanupResources();
        } else if (source == this.zoomBox) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            this.currentSize = this.getSize();
            Thread thread = new Thread(){

                public void run() {
                    PrintPreviewPanel.this.zoom = PrintPreviewPanel.this.getInt(PrintPreviewPanel.this.zoomBox.getSelectedItem().toString());
                    int width = PrintPreviewPanel.this.pageWidth * PrintPreviewPanel.this.zoom / 100;
                    int height = PrintPreviewPanel.this.pageHeight * PrintPreviewPanel.this.zoom / 100;
                    Component[] comps = PrintPreviewPanel.this.layout.getComponents();
                    for (int i = 0; i < comps.length; ++i) {
                        if (!(comps[i] instanceof PrintPreviewPage)) continue;
                        PrintPreviewPage previewPage = (PrintPreviewPage)comps[i];
                        previewPage.setScaledSize(width, height);
                    }
                    PrintPreviewPanel.this.layout.doLayout();
                    PrintPreviewPanel.this.layout.getParent().getParent().validate();
                    PrintPreviewPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    PrintPreviewPanel.this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
                }
            };
            thread.start();
        } else if (source == this.scaleBox) {
            this.currentSize = this.getSize();
            this.scale = this.getInt(this.scaleBox.getSelectedItem().toString());
            this.printable.setScale(this.scale);
            this.scaleBox.hidePopup();
            this.refreshGUI();
        } else if (source == this.sizeToFitButton) {
            this.currentSize = this.getSize();
            this.scale = this.printable.fitToPage(this.pageFormat);
            String newScale = this.scale + "%";
            this.scaleBox.addItem(newScale);
            this.scaleBox.setSelectedItem(newScale);
            this.refreshGUI();
        } else if (source == this.portraitButton) {
            if (this.isPortrait) {
                return;
            }
            this.currentSize = this.getSize();
            this.pageFormat.setOrientation(1);
            this.isPortrait = true;
            this.refreshGUI();
        } else if (source == this.landscapeButton) {
            if (!this.isPortrait) {
                return;
            }
            this.currentSize = this.getSize();
            this.pageFormat.setOrientation(0);
            this.isPortrait = false;
            this.refreshGUI();
        }
    }

    private void refreshGUI() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(3));
        this.currentSize = this.getSize();
        this.setVisible(false);
        this.buildGUI();
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    private int getInt(String string) {
        int number = 100;
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.trim();
        try {
            number = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    private void cleanupResources() {
        this.printable.setScale(100);
        this.zoom = 25;
        this.scale = 100;
        this.printable.setBufferedImage(null);
        this.setVisible(false);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.guiMain.getFrame().setCursor(Cursor.getPredefinedCursor(0));
        this.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.cleanupResources();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        int prefWidth = this.getPreferredSize().width;
        int currWidth = this.getSize().width;
        int currHeight = this.getSize().height;
        if (currWidth < prefWidth) {
            this.setSize(new Dimension(prefWidth, currHeight));
        }
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    class PrintPreviewPage
    extends JPanel {
        private int width;
        private int height;
        private Image sourceImg;
        private Image scaledImg;

        public PrintPreviewPage(int w, int h, Image source) {
            this.width = w;
            this.height = h;
            this.sourceImg = source;
            this.scaledImg = this.sourceImg.getScaledInstance(this.width, this.height, 4);
            this.scaledImg.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.width = w;
            this.height = h;
            this.scaledImg = this.sourceImg.getScaledInstance(this.width, this.height, 4);
            this.scaledImg.flush();
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.width + insets.left + insets.right, this.height + insets.top + insets.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.scaledImg, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PrintPreviewLayout
    extends JPanel {
        private int H_GAP = 16;
        private int V_GAP = 10;
        private int childHeight = 0;
        private int childWidth = 0;
        private Dimension preferredSize = null;

        PrintPreviewLayout() {
        }

        public Dimension getPreferredSize() {
            int col;
            int row;
            int compCount = this.getComponentCount();
            if (compCount == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension childSize = comp.getPreferredSize();
            this.childWidth = childSize.width;
            this.childHeight = childSize.height;
            int parentWidth = this.getParent().getSize().width;
            if (parentWidth == 0) {
                parentWidth = 640;
            }
            if ((row = compCount / (col = Math.max((parentWidth - this.H_GAP) / (this.childWidth + this.H_GAP), 1))) * col < compCount) {
                ++row;
            }
            int width = col * (this.childWidth + this.H_GAP) + this.H_GAP;
            int height = row * (this.childHeight + this.V_GAP) + this.V_GAP;
            Insets insets = this.getInsets();
            this.preferredSize = new Dimension(width + insets.left + insets.right, height + insets.top + insets.bottom);
            return this.preferredSize;
        }

        public Dimension getMaximumSize() {
            if (this.preferredSize != null) {
                return this.preferredSize;
            }
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.preferredSize != null) {
                return this.preferredSize;
            }
            return this.getPreferredSize();
        }

        public void doLayout() {
            int col;
            int row;
            Insets insets = this.getInsets();
            int x = insets.left + this.H_GAP;
            int y = insets.top + this.V_GAP;
            int compCount = this.getComponentCount();
            if (compCount == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension childSize = comp.getPreferredSize();
            int childWidth = childSize.width;
            int childHeight = childSize.height;
            int parentWidth = this.getParent().getSize().width;
            if (parentWidth == 0) {
                parentWidth = this.getParent().getPreferredSize().width;
            }
            if ((row = compCount / (col = Math.max((parentWidth - this.H_GAP) / (childWidth + this.H_GAP), 1))) * col < compCount) {
                ++row;
            }
            int index = 0;
            for (int i = 0; i < row; ++i) {
                for (int j = 0; j < col; ++j) {
                    if (index >= compCount) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, childWidth, childHeight);
                    x += childWidth + this.H_GAP;
                }
                y += childHeight + this.V_GAP;
                x = insets.left + this.H_GAP;
            }
        }
    }
}

