/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScriptDefinitionDialog
extends JDialog
implements ActionListener {
    private static String title = MessageLog.getMessageNoID("GUI2074L");
    private static final String OK = "K";
    private static final String CANCEL = "X";
    protected AlertDefinition alertDef;
    protected Container pane;
    protected GridBagConstraints c;
    private NameList computers;
    private JComboBox computersCombo;
    private JTextField scriptNameField;
    static IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ScriptDefinitionDialog(AlertDefinition pAlertDef, NameList pComputers) {
        super(guiMain.getFrame(), title, true);
        this.alertDef = pAlertDef;
        if (!AlertConditionManager.hasSourceAgent(this.alertDef.aldCondition)) {
            this.computers = pComputers;
        } else {
            this.computers = new NameList();
            this.computers.nlID = 0;
            this.computers.nlName = MessageLog.getMessageNoID("GUI2075L");
            this.computers.nlNext = pComputers;
        }
    }

    protected void addFootnote() {
    }

    protected String getSpecialParm(int parmIndex) {
        return "(null)";
    }

    private void listParameters() {
        String[] msgIDs = AlertConditionManager.getScriptParameterStringIdList(this.alertDef.aldCondition);
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i <= msgIDs.length; ++i) {
            buf.setLength(0);
            buf.append('$');
            buf.append(String.valueOf(i));
            buf.append(" = ");
            String s = msgIDs[i - 1];
            s = s != null ? MessageLog.getMessageNoID(s) : this.getSpecialParm(i);
            buf.append(s);
            JLabel label = new JLabel(buf.toString());
            label.setForeground(Color.black);
            if (i == msgIDs.length) {
                this.c.weighty = 1.0;
            }
            this.pane.add((Component)label, this.c);
        }
        this.addFootnote();
    }

    public void show() {
        DefaultComboBoxModel<NameList> model = new DefaultComboBoxModel<NameList>();
        NameList initial = this.computers;
        NameList selected = null;
        while (this.computers != null) {
            model.addElement(this.computers);
            if (this.computers.nlID == this.alertDef.aldScriptComputerID) {
                selected = this.computers;
            }
            this.computers = this.computers.nlNext;
        }
        if (selected == null) {
            selected = initial;
        }
        model.setSelectedItem(selected);
        this.computersCombo = new TComboBox((ComboBoxModel)model);
        this.scriptNameField = TTextField.newTTextField(this.alertDef.aldScriptName, 10, 64, false, true);
        JPanel panel = new JPanel(new GridBagLayout());
        String s = MessageLog.getMessageNoID("GUI2077L");
        JLabel label = new JLabel(s);
        label.setForeground(Color.black);
        label.setFont(BaseTree.boldFont);
        GuiUtil.setAccessibleLabel(label, this.scriptNameField, "MNEMONIC_SCRIPTNAME", MessageLog.getMessageNoID("GUI2077L"), "DESCRIPTION_SCRIPTNAME");
        this.c = new GridBagConstraints();
        this.c.insets.right = 2;
        this.c.insets.left = 2;
        this.c.insets.bottom = 8;
        this.c.anchor = 13;
        panel.add((Component)label, this.c);
        this.c.gridwidth = 0;
        this.c.anchor = 17;
        panel.add((Component)this.scriptNameField, this.c);
        s = MessageLog.getMessageNoID("GUI2078L");
        label = new JLabel(s);
        label.setForeground(Color.black);
        label.setFont(BaseTree.boldFont);
        this.c.insets.bottom = 0;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.gridheight = 0;
        panel.add((Component)label, this.c);
        this.c.anchor = 17;
        this.c.gridwidth = 0;
        panel.add((Component)this.computersCombo, this.c);
        this.pane = this.getContentPane();
        this.pane.setLayout(new GridBagLayout());
        this.c.gridheight = 1;
        this.c.insets.left = 6;
        this.c.insets.right = 6;
        this.c.insets.top = 15;
        this.c.insets.bottom = 6;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.pane.add((Component)panel, this.c);
        Color background = this.pane.getBackground();
        PrimitiveConditionEditor.HorizontalSeparator separator = new PrimitiveConditionEditor.HorizontalSeparator(background);
        this.c.weightx = 1.0;
        this.c.insets.top = 10;
        this.c.insets.bottom = 0;
        this.pane.add((Component)separator, this.c);
        s = MessageLog.getMessageNoID("GUI2079L");
        label = new JLabel(s);
        label.setForeground(Color.black);
        label.setFont(BaseTree.boldFont);
        this.c.insets.top = 6;
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.anchor = 18;
        this.pane.add((Component)label, this.c);
        this.c.insets.left = 40;
        this.c.insets.right = 6;
        this.c.insets.top = 0;
        this.c.insets.bottom = 0;
        this.listParameters();
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.insets.left = 6;
        this.c.insets.right = 6;
        this.c.insets.top = 12;
        this.c.insets.bottom = 10;
        this.c.anchor = 10;
        separator = new PrimitiveConditionEditor.HorizontalSeparator(background);
        this.pane.add((Component)separator, this.c);
        s = MessageLog.getMessageNoID("GUI0113L");
        JButton okButton = new JButton(s);
        okButton.setActionCommand(OK);
        GuiUtil.setAccessible(okButton, okButton.getText(), okButton.getText());
        okButton.addActionListener(this);
        okButton.setEnabled(!Util.isEmpty(this.alertDef.aldScriptName));
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(okButton);
        panel.add(Box.createHorizontalStrut(10));
        s = MessageLog.getMessageNoID("GUI0114L");
        JButton cancelButton = new JButton(s);
        cancelButton.setActionCommand(CANCEL);
        GuiUtil.setAccessible(cancelButton, cancelButton.getText(), cancelButton.getText());
        cancelButton.addActionListener(this);
        panel.add(cancelButton);
        panel.add(Box.createHorizontalStrut(10));
        s = MessageLog.getMessageNoID("GUI0072L");
        JButton helpButton = new JButton(s);
        helpButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        GuiUtil.setAccessible(helpButton, helpButton.getText(), helpButton.getText());
        helpButton.addActionListener(Help.getDisplayHelpFromSource());
        panel.add(helpButton);
        this.c.insets.left = 0;
        this.c.insets.right = 0;
        this.c.insets.top = 10;
        this.c.insets.bottom = 15;
        this.c.fill = 0;
        this.c.gridheight = 0;
        this.pane.add((Component)panel, this.c);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        GuiUtil.centerDialog(this);
        s = AlertConditionManager.getScriptHelpId(this.alertDef.aldCondition);
        Help.setHelpID(helpButton, s);
        Help.setHelpID(this.getRootPane(), s);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        super.show();
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command == OK) {
            NameList element = (NameList)this.computersCombo.getSelectedItem();
            this.alertDef.aldScriptComputerID = element.nlID;
            this.alertDef.aldScriptName = this.scriptNameField.getText();
        }
        this.dispose();
    }
}

