/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.eclipse.aperi.common.Util;

public class SortTable
extends JTable {
    private int[] indexes = new int[0];
    private Vector sortingColumns = new Vector();
    private int sortedColumn = -1;
    private boolean ascending = true;
    private TableSorterArrow hRenderer = new TableSorterArrow();
    private MouseAdapter headMouseListener = new HeaderListener(this.hRenderer);
    public boolean sortInProgress = false;

    public SortTable() {
        this(null);
    }

    public SortTable(TableModel model) {
        super(model);
        this.tableHeader.addMouseListener(this.headMouseListener);
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        for (int n = this.columnModel.getColumnCount() - 1; n >= 0; --n) {
            this.columnModel.getColumn(n).setHeaderRenderer(this.hRenderer);
        }
        this.reallocateIndexes();
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        Object v2;
        String s2;
        Class<?> type = this.dataModel.getColumnClass(column);
        Object o1 = this.dataModel.getValueAt(row1, column);
        Object o2 = this.dataModel.getValueAt(row2, column);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (type.getSuperclass() == Number.class) {
            Number n2;
            double d2;
            Number n1 = (Number)this.dataModel.getValueAt(row1, column);
            double d1 = n1.doubleValue();
            if (d1 < (d2 = (n2 = (Number)this.dataModel.getValueAt(row2, column)).doubleValue())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        if (type == Date.class) {
            Date d2;
            long n2;
            Date d1 = (Date)this.dataModel.getValueAt(row1, column);
            long n1 = d1.getTime();
            if (n1 < (n2 = (d2 = (Date)this.dataModel.getValueAt(row2, column)).getTime())) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            return 0;
        }
        if (type == String.class) {
            String s22;
            String s1 = (String)this.dataModel.getValueAt(row1, column);
            int result = s1.compareTo(s22 = (String)this.dataModel.getValueAt(row2, column));
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
        if (type == Boolean.class) {
            Boolean bool2;
            boolean b2;
            Boolean bool1 = (Boolean)this.dataModel.getValueAt(row1, column);
            boolean b1 = bool1;
            if (b1 == (b2 = (bool2 = (Boolean)this.dataModel.getValueAt(row2, column)).booleanValue())) {
                return 0;
            }
            if (b1) {
                return 1;
            }
            return -1;
        }
        Object v1 = this.dataModel.getValueAt(row1, column);
        String s1 = v1.toString();
        int result = s1.compareTo(s2 = (v2 = this.dataModel.getValueAt(row2, column)).toString());
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return 1;
        }
        return 0;
    }

    public int compare(int row1, int row2) {
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public void reallocateIndexes() {
        this.sortedColumn = -1;
        if (this.hRenderer != null) {
            this.hRenderer.setColumn(-1);
        }
        int rowCount = this.dataModel.getRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
        this.reallocateIndexes();
    }

    public void sort() {
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public Object getValueAt(int aRow, int aColumn) {
        return super.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        super.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        if (column != this.sortedColumn) {
            this.sortByColumn(column, true);
        } else {
            this.sortByColumn(column, !this.ascending);
        }
        super.tableChanged(new TableModelEvent(this.getModel()));
    }

    public int convertRowToIndex(int aRow) {
        return this.indexes[aRow];
    }

    public int convertIndexToRow(int aIndex) {
        int aRow;
        for (aRow = this.indexes.length - 1; aRow >= 0 && this.indexes[aRow] != aIndex; --aRow) {
        }
        return aRow;
    }

    public int getSelectedIndex() {
        int aRow = this.getSelectedRow();
        return aRow >= 0 ? this.convertRowToIndex(aRow) : -1;
    }

    public void sortByColumn(int column, boolean ascending) {
        this.ascending = ascending;
        this.sortedColumn = column;
        this.hRenderer.setColumn(column);
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        int sIndex = this.getSelectedIndex();
        this.sort();
        if (sIndex != -1) {
            int sRow = this.convertIndexToRow(sIndex);
            this.sortInProgress = true;
            this.setRowSelectionInterval(sRow, sRow);
            this.sortInProgress = false;
        }
    }

    class TableSorterArrow
    extends JButton
    implements TableCellRenderer {
        JButton downButton;
        JButton upButton;
        int dataColumn = -1;

        public TableSorterArrow() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setHorizontalTextPosition(2);
            this.setIcon(new BlankIcon());
            this.downButton = new JButton();
            this.downButton.setMargin(new Insets(0, 0, 0, 0));
            this.downButton.setHorizontalTextPosition(2);
            this.downButton.setIcon(new DownArrowIcon());
            this.downButton.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_DESCENDING"));
            this.upButton = new JButton();
            this.upButton.setMargin(new Insets(0, 0, 0, 0));
            this.upButton.setHorizontalTextPosition(2);
            this.upButton.setIcon(new UpArrowIcon());
            this.upButton.setToolTipText(Util.getString("TOOLTIP_BUTTON_SORT_ASCENDING"));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JButton button = this;
            if (this.dataColumn != -1 && column == table.convertColumnIndexToView(this.dataColumn)) {
                button = SortTable.this.ascending ? this.upButton : this.downButton;
            }
            button.setText(value == null ? "" : value.toString());
            return button;
        }

        public void setColumn(int dataColumn) {
            this.dataColumn = dataColumn;
        }

        private class BlankIcon
        implements Icon,
        UIResource {
            private BlankIcon() {
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
            }

            public int getIconWidth() {
                return 11;
            }

            public int getIconHeight() {
                return 11;
            }
        }

        private class DownArrowIcon
        implements Icon,
        UIResource {
            private DownArrowIcon() {
            }

            public int getIconWidth() {
                return 11;
            }

            public int getIconHeight() {
                return 11;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(UIManager.getColor("controlDkShadow"));
                g.translate(x, y);
                for (int i = 0; i <= 5; ++i) {
                    g.drawLine(6 - i, 8 - i, 6 + i, 8 - i);
                }
                g.translate(-x, -y);
            }
        }

        private class UpArrowIcon
        implements Icon,
        UIResource {
            private UpArrowIcon() {
            }

            public int getIconWidth() {
                return 11;
            }

            public int getIconHeight() {
                return 11;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(UIManager.getColor("controlDkShadow"));
                g.translate(x, y);
                for (int i = 0; i <= 5; ++i) {
                    g.drawLine(6 - i, 3 + i, 6 + i, 3 + i);
                }
                g.translate(-x, -y);
            }
        }
    }

    class HeaderListener
    extends MouseAdapter {
        TableSorterArrow hRenderer;
        int mouseColumn;

        HeaderListener(TableSorterArrow hRenderer) {
            this.hRenderer = hRenderer;
        }

        public void mouseClicked(MouseEvent e) {
            this.mouseColumn = SortTable.this.getColumnModel().getColumnIndexAtX(e.getX());
            if (e.getClickCount() == 1 && this.mouseColumn != -1) {
                boolean shiftPressed;
                boolean bl = shiftPressed = (e.getModifiers() & 1) != 0;
                if (shiftPressed) {
                    SortTable.this.sortByColumn(SortTable.this.convertColumnIndexToModel(this.mouseColumn), false);
                } else {
                    SortTable.this.sortByColumn(SortTable.this.convertColumnIndexToModel(this.mouseColumn));
                }
            }
        }
    }
}

