/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.aperi.gui.SizeLimitedDocument;

public class TTextField
extends JTextField
implements ActionListener,
DocumentListener {
    private boolean onDialog;
    private boolean disable = true;
    private JButton defaultButton;

    private TTextField(Document doc, String text, int displayColumns, boolean pOnDialog) {
        super(doc, text, displayColumns);
        this.onDialog = pOnDialog;
        if (this.onDialog) {
            doc.addDocumentListener(this);
        }
        this.addActionListener(this);
    }

    private TTextField(Document doc, String text, int displayColumns, boolean pOnDialog, boolean pDisable) {
        super(doc, text, displayColumns);
        this.onDialog = pOnDialog;
        this.disable = pDisable;
        if (this.onDialog) {
            doc.addDocumentListener(this);
        }
        this.addActionListener(this);
    }

    public static TTextField newTTextField(String text, int displayColumns, int maxColumns, boolean isNumeric, boolean pOnDialog) {
        SizeLimitedDocument doc = new SizeLimitedDocument(maxColumns, isNumeric);
        return new TTextField(doc, text, displayColumns, pOnDialog);
    }

    public static TTextField newTTextField(String text, int displayColumns, int maxColumns, boolean isNumeric) {
        return TTextField.newTTextField(text, displayColumns, maxColumns, isNumeric, false);
    }

    public static TTextField newTTextField(String text, int columns, boolean isNumeric) {
        return TTextField.newTTextField(text, columns, columns, isNumeric);
    }

    public static TTextField newTTextField(int columns, boolean isNumeric) {
        return TTextField.newTTextField(null, columns, columns, isNumeric);
    }

    public static TTextField newTTextField(int displayColumns, int maxColumns, boolean isNumeric) {
        return TTextField.newTTextField(null, displayColumns, maxColumns, isNumeric);
    }

    public static TTextField newTTextField(Document doc, String text, int displayColumns, boolean pOnDialog) {
        return new TTextField(doc, text, displayColumns, pOnDialog);
    }

    public static TTextField newTTextField(Document doc, String text, int displayColumns, boolean pOnDialog, boolean pDisable) {
        return new TTextField(doc, text, displayColumns, pOnDialog, pDisable);
    }

    public void setDisable(boolean pBool) {
        this.disable = pBool;
    }

    public String getText() {
        String result = super.getText();
        if (result == null) {
            result = "";
        }
        return result;
    }

    private void getDefaultButton() {
        if (this.defaultButton != null) {
            return;
        }
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            this.defaultButton = rootPane.getDefaultButton();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (!this.onDialog) {
            FocusManager.getCurrentManager().focusNextComponent(this);
            return;
        }
        String s = this.getText();
        if (s.length() == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.getDefaultButton();
        if (this.defaultButton != null) {
            this.defaultButton.doClick();
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        this.getDefaultButton();
        if (this.defaultButton != null) {
            this.defaultButton.setEnabled(true);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        Document doc;
        if (this.disable && (doc = event.getDocument()).getLength() == 0) {
            this.getDefaultButton();
            if (this.defaultButton != null) {
                this.defaultButton.setEnabled(false);
            }
        }
    }
}

