/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.xmsg.MessageLog;

public class TreeSelectorNode
extends DefaultMutableTreeNode
implements Comparable {
    public boolean selectable;
    public boolean excludable;
    public boolean expandOnRightOnly;
    public boolean childrenFetched;
    public int hiOrderSortKey;
    public TreeSelector.ExcludeList excludeParents;
    protected String selectErrorMsgID;
    private boolean buttonFlag = true;
    public boolean showClusterName;
    public boolean showVsName;
    public boolean isNonClusteredLabel;

    public TreeSelectorNode(NameList name, boolean selectable, boolean excludable, boolean allowsChildren) {
        this(name, selectable, excludable, allowsChildren, false, null);
    }

    public TreeSelectorNode(NameList name, boolean excludable, boolean allowsChildren, String selectErrorMsgID) {
        this(name, false, excludable, allowsChildren, false, selectErrorMsgID);
    }

    public TreeSelectorNode(NameList name, boolean selectable, boolean excludable, boolean allowsChildren, boolean expandOnRightOnly, String selectErrorMsgID) {
        this(name, selectable, excludable, allowsChildren, expandOnRightOnly, selectErrorMsgID, false, false);
    }

    public TreeSelectorNode(NameList name, boolean selectable, boolean excludable, boolean allowsChildren, boolean expandOnRightOnly, String selectErrorMsgID, boolean pShowClusterName, boolean pShowVsName) {
        super(name, allowsChildren);
        this.selectable = selectable;
        this.excludable = excludable;
        this.expandOnRightOnly = expandOnRightOnly;
        this.selectErrorMsgID = selectErrorMsgID;
        this.showClusterName = pShowClusterName;
        this.showVsName = pShowVsName;
    }

    public NameList getNameList() {
        return (NameList)this.getUserObject();
    }

    public Object clone() {
        TreeSelectorNode c = null;
        c = (TreeSelectorNode)super.clone();
        c.setUserObject(this.getNameList().clone());
        return c;
    }

    public void setSortKey(int sortKey) {
        this.hiOrderSortKey = sortKey;
    }

    public int compareTo(Object o) {
        TreeSelectorNode that = (TreeSelectorNode)o;
        int result = this.hiOrderSortKey - that.hiOrderSortKey;
        if (result == 0) {
            NameList thatName = that.getNameList();
            NameList thisName = this.getNameList();
            result = thisName.toString().compareTo(thatName.toString());
            if (result == 0) {
                result = thisName.nlID - thatName.nlID;
            }
        }
        return result;
    }

    protected boolean isSelectable() {
        return true;
    }

    protected void displaySelectionError() {
        String errorMsg;
        if (this.selectErrorMsgID == null) {
            Object[] args = new String[]{this.getNameList().toString()};
            errorMsg = MessageLog.getMessageNoTS("GUI0249E", args);
        } else {
            errorMsg = MessageLog.getMessageNoTS(this.selectErrorMsgID, null);
        }
        GuiUtil.displayErrorMessage(errorMsg);
    }

    public void setButtonFlag(boolean buttonFlag) {
        this.buttonFlag = buttonFlag;
    }

    public boolean getButtonFlag() {
        return this.buttonFlag;
    }

    public String toString() {
        NameList nl = (NameList)this.getUserObject();
        if (Constants.isVirtualServer(nl.nlID2) && this.showVsName) {
            String retName = Util.getTranslatedName(nl.nlName) + "[" + nl.nlHostName + "]";
            if (this.showClusterName) {
                retName = retName + "(" + nl.nlClusterName + ")";
            }
            return retName;
        }
        if (nl.nlClusterID > 0 && this.showClusterName && nl.nlInfo != 99) {
            return Util.getTranslatedName(nl.nlName) + "(" + nl.nlClusterName + ")";
        }
        return Util.getTranslatedName(nl.nlName);
    }

    public boolean canSelect() {
        return this.selectable;
    }

    public void setNonClusteredLabel() {
        this.isNonClusteredLabel = true;
    }
}

