/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public class WindowMenu
extends JMenu
implements ActionListener,
MenuListener {
    private static final String WINDOW = Util.getString("LABEL_WINDOW_MENU");
    private static final String closeAllStr = MessageLog.getMessageNoID("GUI0063L");
    private static final String showDashStr = MessageLog.getMessageNoID("GUI6001L");
    private static final String showWindowsStr = MessageLog.getMessageNoID("GUI0082L");
    private static final JMenuItem closeAll = new JMenuItem(closeAllStr);
    private static final JMenuItem showDash = new JMenuItem(showDashStr);
    private final JMenu showWindows = new windowJMenu(showWindowsStr);
    private static Icon redPointer = IconFactory.getCurrentPointerChangesPendingIcon();
    private static Icon blackPointer = IconFactory.getCurrentPointerIcon();
    private static Icon blank = IconFactory.getBlankIcon(redPointer.getIconWidth());

    public WindowMenu() {
        super(WINDOW);
        super.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_WINDOW"));
        super.getAccessibleContext().setAccessibleName(WINDOW);
        super.getAccessibleContext().setAccessibleDescription(WINDOW);
        GuiUtil.setAccessible(closeAll, closeAllStr, closeAllStr);
        GuiUtil.setAccessible(showDash, showDashStr, showDashStr);
        GuiUtil.setAccessible(this.showWindows, showWindowsStr, showWindowsStr);
        closeAll.addActionListener(this);
        closeAll.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        showDash.addActionListener(this);
        this.showWindows.addMenuListener(this);
        this.add(closeAll);
        this.add(showDash);
        this.add(this.showWindows);
    }

    public void menuDeselected(MenuEvent e) {
    }

    public void menuCanceled(MenuEvent e) {
    }

    public void menuSelected(MenuEvent e) {
        this.showWindows.removeAll();
        DataDisplayInfo ddiCurr = DataDisplayInfo.getCurrent();
        int i = 0;
        for (DataDisplayInfo ddi = DataDisplayInfo.getRoot(); ddi != null; ddi = ddi.getNext()) {
            JMenuItem jmi = new JMenuItem(ddi.getDescription());
            jmi.setActionCommand(Integer.toString(i++));
            jmi.addActionListener(this);
            if (ddi == ddiCurr) {
                if (ddi.changesPending()) {
                    jmi.setIcon(redPointer);
                } else {
                    jmi.setIcon(blackPointer);
                }
            } else if (ddi.changesPending()) {
                jmi.setIcon(IconFactory.getRedLightIcon());
            } else {
                jmi.setIcon(blank);
            }
            this.showWindows.add(jmi);
        }
    }

    public void actionPerformed(ActionEvent event) {
        IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
        if (event.getSource() == closeAll) {
            DataDisplayInfo.removeAllWithoutChanges();
            if (DataDisplayInfo.getCurrent() == null) {
                guiMain.showNull();
            } else {
                DataDisplayInfo.getCurrent().reDisplay();
            }
        } else if (event.getSource() == showDash) {
            guiMain.showNull();
        } else {
            int ddiNum = Integer.decode(event.getActionCommand());
            DataDisplayInfo ddi = DataDisplayInfo.getRoot();
            int i = 0;
            while (i++ < ddiNum) {
                ddi = ddi.getNext();
            }
            ddi.reDisplay();
        }
    }

    class windowJMenu
    extends JMenu {
        public windowJMenu(String s) {
            super(s);
        }

        protected Point getPopupMenuOrigin() {
            int x = 0;
            int y = 0;
            JPopupMenu pm = this.getPopupMenu();
            pm.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension s = this.getSize();
            Dimension pmSize = pm.getPreferredSize();
            Point position = this.getLocationOnScreen();
            x = position.x + s.width + pmSize.width < screenSize.width ? s.width : 0 - pmSize.width;
            y = position.y + pmSize.height < screenSize.height - 26 ? 0 : screenSize.height - 26 - position.y - pmSize.height;
            return new Point(x, y);
        }
    }
}

