/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;

class WrappingHeaderRenderer
extends JPanel
implements TableCellRenderer {
    String text = null;
    Font font;
    int alignment = 0;

    public WrappingHeaderRenderer() {
        super(false);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.removeAll();
    }

    public void setHorizontalAlignment(int align) {
        this.alignment = align;
    }

    public void setText(String label) {
        this.text = label;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.text == null) {
            this.text = value.toString();
        }
        this.font = table.getFont().deriveFont(1);
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.removeAll();
        StringTokenizer st = new StringTokenizer(this.text, "\r\n");
        int lineCount = st.countTokens();
        if (lineCount == 1) {
            this.setLayout(new BorderLayout());
        } else {
            this.setLayout(new GridLayout(lineCount, 1));
        }
        while (st.hasMoreElements()) {
            JLabel label = new JLabel(st.nextToken(), this.alignment);
            label.setOpaque(false);
            label.setForeground(Color.black);
            label.setBackground(Color.white);
            label.setFont(this.font);
            LookAndFeel.installColorsAndFont(label, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
            this.add(label);
        }
        this.setBorder(new LineBorder(Color.black, 1));
        return this;
    }

    public void paint(Graphics g) {
        int x = 0;
        int y = 0;
        g.setColor(this.getBackground());
        g.fillRect(x, y, this.getMaximumSize().width, this.getMaximumSize().height);
        g.setColor(Color.black);
        g.setFont(this.font);
        FontMetrics fm = g.getFontMetrics();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JLabel)) continue;
            JLabel label = (JLabel)comps[i];
            Rectangle2D stringBounds = fm.getStringBounds(label.getText(), g);
            int stringWidth = (int)stringBounds.getWidth();
            int parentWidth = this.getWidth();
            x = (parentWidth - stringWidth) / 2;
            int stringBaseLineStart = 0;
            int parentHeight = this.getHeight();
            int numberOfComps = comps.length;
            if (numberOfComps == 1) {
                y = (parentHeight - (int)stringBounds.getHeight()) / 2;
                y += (int)stringBounds.getHeight() - fm.getDescent();
            } else {
                int availableSpace = parentHeight / (numberOfComps + 1);
                y = (availableSpace - (int)stringBounds.getHeight()) / 2;
                y += availableSpace * (i + 0);
                y += (int)stringBounds.getHeight();
                y += fm.getDescent() * i;
            }
            g.drawString(label.getText(), x, y += stringBaseLineStart);
        }
        this.paintBorder(g);
    }
}

