/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.admin.ServicesDDI;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class GenericServiceTreeNode
extends BaseTreeNode {
    private String uniqueType;
    private String requestType;
    private byte state;

    public GenericServiceTreeNode(Object name, String rt, String ut, byte s) {
        this.setUserObject(name);
        this.requestType = rt;
        this.uniqueType = ut;
        this.state = s;
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (this.state == 1) {
            renderer.setIcon(IconFactory.getStateUpIcon());
        } else if (this.state == 3) {
            renderer.setIcon(IconFactory.getStateUpgradingIcon());
        } else {
            renderer.setIcon(IconFactory.getStateDownIcon());
        }
    }

    public void select(TreeSelectionEvent event) {
        if (this.ddi == null) {
            this.ddi = new ServicesDDI();
            this.ddi.setDescription(MessageLog.getMessageNoID("ADG0114L") + ":  " + this.getUserObject());
            this.ddi.treeNode = this;
        }
        this.ddi.reDisplay();
    }

    public abstract boolean isRepresentingTheServerService();

    public abstract JPanel getPanel();

    public String getRequestType() {
        return this.requestType;
    }

    public String getUniqueType() {
        return this.uniqueType;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte b) {
        this.state = b;
    }
}

