/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.admin.ConfigSettingsDDI;
import org.eclipse.aperi.gui.admin.ConfigSettingsPanel;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogFileRetentionPanel
extends ConfigSettingsPanel
implements ComponentListener {
    private JTextField runsField;
    private JTextField daysField;
    private ConfigSettings settings;
    private boolean setFocus;
    private ConfigSettingsDDI ddi;
    private Component invalidField;

    public LogFileRetentionPanel(ConfigSettingsDDI pDDI) {
        this.ddi = pDDI;
        this.setFocus = false;
    }

    public JComponent getComponent(ConfigSettings pSettings) {
        this.settings = pSettings != null ? pSettings : this.makeDefaultSettings();
        String s = MessageLog.getMessageNoID("GUI2082L");
        JLabel label = new JLabel(s);
        label.setForeground(Color.black);
        label.setFont(BaseTree.boldFont);
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets.top = 6;
        c.insets.left = 6;
        result.add((Component)label, c);
        s = MessageLog.getMessageNoID("GUI2084L");
        label = new JLabel(s);
        JPanel panel = new JPanel(new GridBagLayout());
        c.gridwidth = 1;
        c.insets.top = 5;
        c.insets.left = 0;
        panel.add((Component)label, c);
        s = String.valueOf(this.settings.csRetainCopies);
        this.runsField = TTextField.newTTextField(s, 3, 4, true);
        c.insets.left = 4;
        GuiUtil.setAccessibleLabel(label, this.runsField, "MNEMONIC_LABEL_RUNS", this.runsField.getText(), this.runsField.getText());
        panel.add((Component)this.runsField, c);
        label = new JLabel("");
        c.insets.left = 2;
        c.gridwidth = 0;
        panel.add((Component)label, c);
        s = MessageLog.getMessageNoID("GUI2085L");
        label = new JLabel(s);
        c.gridwidth = 1;
        c.gridheight = 0;
        c.insets.left = 0;
        c.insets.top = 0;
        panel.add((Component)label, c);
        s = String.valueOf(this.settings.csRetainDays);
        this.daysField = TTextField.newTTextField(s, 3, 5, true);
        c.insets.left = 4;
        panel.add((Component)this.daysField, c);
        label = new JLabel("");
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets.left = 2;
        panel.add((Component)label, c);
        c.anchor = 18;
        c.insets.left = 20;
        GuiUtil.setAccessibleLabel(label, this.daysField, "MNEMONIC_LABEL_DAYS", this.daysField.getText(), this.daysField.getText());
        result.add((Component)panel, c);
        return result;
    }

    public ConfigSettings getData() {
        String s = this.runsField.getText();
        if (!Util.isEmpty(s)) {
            try {
                this.settings.csRetainCopies = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (!Util.isEmpty(s = this.daysField.getText())) {
            try {
                this.settings.csRetainDays = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.settings;
    }

    public void validate(ConfigSettings ignored) throws GeneralException {
        int x = -1;
        String s = this.runsField.getText();
        try {
            x = Integer.parseInt(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (x <= 0) {
            this.ddi.badField = 1;
            s = MessageLog.getMessageNoTS("GUI2086E", null);
            throw new GeneralException(s);
        }
        x = -1;
        s = this.daysField.getText();
        try {
            x = Integer.parseInt(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (x < 0) {
            this.ddi.badField = 2;
            s = MessageLog.getMessageNoTS("GUI2087E", null);
            throw new GeneralException(s);
        }
    }

    private void setInvalidField() {
        this.invalidField = this.ddi.badField == 1 ? this.runsField : this.daysField;
    }

    public void selectField(boolean visible) {
        this.setInvalidField();
        if (visible) {
            this.invalidField.requestFocus();
        } else {
            this.setFocus = true;
        }
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
        if (!this.setFocus) {
            return;
        }
        Component component = event.getComponent();
        if (component == this.invalidField) {
            this.setFocus = false;
            component.requestFocus();
        }
    }
}

