/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.admin.ConfigSettingsDDI;
import org.eclipse.aperi.gui.admin.ConfigSettingsPanel;
import org.eclipse.aperi.gui.admin.SnmpSettingsPanel;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.xmsg.MessageLog;

public class NetworkSettingsPanel
extends ConfigSettingsPanel
implements ComponentListener {
    private static final int TEC_SERVER_FIELD = 0;
    private static final int TEC_PORT_FIELD = 1;
    private static final int SMTP_SERVER_FIELD = 2;
    private static final int SMTP_PORT_FIELD = 3;
    private static final int DEFAULT_DOMAIN_FIELD = 4;
    private static final int REPLY_TO_FIELD = 5;
    private static final int RETURN_TO_FIELD = 6;
    private static final int SRM_ADMIN_FIELD = 7;
    private static final int DEL_AFTER_DAYS = 8;
    private static final int N_FIELDS = 9;
    private static final String[] validationMsgs = new String[]{"GUI2093E", null, "GUI2061E", null, "GUI2062E", "GUI2063E", "GUI2064E", null, "GUI6005E"};
    private JTextField[] fieldArray;
    private JTextField smtpServer;
    private JTextField smtpPort;
    private JTextField smtpDefaultDomain;
    private JTextField smtpReplyTo;
    private JTextField smtpReturnTo;
    private JTextField smtpSrmAdmin;
    private JTextField delafterdays;
    private ConfigSettingsDDI ddi;
    private boolean setFocus;
    private ConfigSettings settings;
    private JTextField tecServer;
    private JTextField tecPort;
    private SnmpSettingsPanel[] snmpArray;

    public NetworkSettingsPanel(ConfigSettingsDDI pDDI) {
        this.ddi = pDDI;
        this.setFocus = false;
    }

    public JComponent getComponent(ConfigSettings pSettings) {
        this.settings = pSettings != null ? pSettings : this.makeDefaultSettings();
        this.smtpServer = TTextField.newTTextField(this.settings.csSmtp.ssServer, 20, 128, false);
        this.tecServer = TTextField.newTTextField(this.settings.csTecServer, 20, 128, false);
        String s = Integer.toString(this.settings.csTecPort);
        this.tecPort = TTextField.newTTextField(s, 5, true);
        s = Integer.toString(this.settings.csSmtp.ssPort);
        this.smtpPort = TTextField.newTTextField(s, 5, true);
        this.smtpDefaultDomain = TTextField.newTTextField(this.settings.csSmtp.ssDfltDomain, 20, 128, false);
        this.smtpReplyTo = TTextField.newTTextField(this.settings.csSmtp.ssReplyTo, 20, 128, false);
        this.smtpReturnTo = TTextField.newTTextField(this.settings.csSmtp.ssReturn, 20, 128, false);
        s = this.settings.csSmtp.getSrmAdminString();
        this.smtpSrmAdmin = TTextField.newTTextField(s, 20, 255, false);
        s = String.valueOf(this.settings.csDellogDays);
        this.delafterdays = TTextField.newTTextField(s, 3, 5, true);
        this.fieldArray = new JTextField[9];
        this.fieldArray[0] = this.tecServer;
        this.fieldArray[1] = this.tecPort;
        this.fieldArray[2] = this.smtpServer;
        this.fieldArray[3] = this.smtpPort;
        this.fieldArray[4] = this.smtpDefaultDomain;
        this.fieldArray[5] = this.smtpReplyTo;
        this.fieldArray[6] = this.smtpReturnTo;
        this.fieldArray[7] = this.smtpSrmAdmin;
        this.fieldArray[8] = this.delafterdays;
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.anchor = 17;
        c.fill = 2;
        c.insets.top = 3;
        c.insets.left = 6;
        c.insets.right = 6;
        c.insets.bottom = 3;
        JPanel subPanel = new JPanel(new GridBagLayout());
        subPanel.setBorder(GuiUtil.getBorder("SNMP"));
        Color separatorColor = subPanel.getBackground();
        this.snmpArray = new SnmpSettingsPanel[this.settings.csSnmp.length];
        for (int i = 0; i < this.snmpArray.length; ++i) {
            SnmpSettingsPanel snmpPanel;
            if (i > 0) {
                PrimitiveConditionEditor.HorizontalSeparator separator = new PrimitiveConditionEditor.HorizontalSeparator(separatorColor);
                c.insets.right = 10;
                subPanel.add((Component)separator, c);
                c.insets.right = 6;
            }
            this.snmpArray[i] = snmpPanel = new SnmpSettingsPanel(this.settings.csSnmp[i], i);
            subPanel.add((Component)snmpPanel, c);
        }
        result.add((Component)subPanel, c);
        subPanel = new JPanel(new GridBagLayout());
        s = "TEC";
        subPanel.setBorder(GuiUtil.getBorder(s));
        s = MessageLog.getMessageNoID("GUI2090L");
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        c.insets.top = 0;
        c.insets.right = 0;
        c.insets.bottom = 5;
        c.insets.left = 4;
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        subPanel.add((Component)label, c);
        s = MessageLog.getMessageNoID("GUI2091L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.tecServer, "MNEMONIC_TECSERVER", s, "DESCRIPTION_TECSERVER");
        c.insets.left = 40;
        c.insets.bottom = 0;
        c.insets.right = 3;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        subPanel.add((Component)label, c);
        c.gridwidth = 0;
        c.insets.left = 0;
        subPanel.add((Component)this.tecServer, c);
        s = MessageLog.getMessageNoID("GUI2092L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.tecPort, "MNEMONIC_TECPORT", s, "DESCRIPTION_TECPORT");
        c.insets.left = 40;
        c.insets.bottom = 7;
        c.gridwidth = 1;
        subPanel.add((Component)label, c);
        c.insets.left = 0;
        subPanel.add((Component)this.tecPort, c);
        s = Util.getString("LABEL_DEFAULT_TEC_PORT");
        label = new JLabel(s);
        c.weightx = 1.0;
        c.gridwidth = 0;
        subPanel.add((Component)label, c);
        c.gridheight = 1;
        c.fill = 2;
        c.insets.top = 4;
        c.insets.left = 6;
        c.insets.right = 6;
        c.insets.bottom = 2;
        subPanel = new JPanel(new GridBagLayout());
        s = MessageLog.getMessageNoID("GUI0220L");
        subPanel.setBorder(GuiUtil.getBorder(s));
        s = MessageLog.getMessageNoID("GUI2057L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.smtpServer, "MNEMONIC_SMPTSERVER", s, "DESCRIPTION_SMPTSERVER");
        c.insets.left = 4;
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.insets.right = 3;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        subPanel.add((Component)label, c);
        c.insets.left = 0;
        c.gridwidth = 0;
        subPanel.add((Component)this.smtpServer, c);
        s = MessageLog.getMessageNoID("GUI2088L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.smtpPort, "MNEMONIC_SMPTPORT", s, "DESCRIPTION_SMPTPORT");
        c.insets.left = 4;
        c.insets.top = 0;
        c.gridwidth = 1;
        subPanel.add((Component)label, c);
        c.insets.left = 0;
        subPanel.add((Component)this.smtpPort, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        s = MessageLog.getMessageNoID("GUI2089L");
        label = new JLabel(s);
        subPanel.add((Component)label, c);
        c.weightx = 0.0;
        c.fill = 0;
        s = MessageLog.getMessageNoID("GUI2056L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.smtpDefaultDomain, "MNEMONIC_SMPTDEFAULTDOMAIN", s, "DESCRIPTION_SMPTDEFAULTDOMAIN");
        s = MessageLog.getMessageNoID("GUI2053T");
        c.insets.left = 4;
        c.insets.top = 0;
        c.gridwidth = 1;
        subPanel.add((Component)label, c);
        this.smtpDefaultDomain.setToolTipText(s);
        c.insets.left = 0;
        c.gridwidth = 0;
        subPanel.add((Component)this.smtpDefaultDomain, c);
        s = MessageLog.getMessageNoID("GUI2055L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.smtpReturnTo, "MNEMONIC_SMPTRETURNTO", s, "DESCRIPTION_SMPTRETURNTO");
        s = MessageLog.getMessageNoID("GUI2058T");
        c.insets.left = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        subPanel.add((Component)label, c);
        this.smtpReturnTo.setToolTipText(s);
        c.insets.left = 0;
        c.gridwidth = 0;
        subPanel.add((Component)this.smtpReturnTo, c);
        s = MessageLog.getMessageNoID("GUI2054L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.smtpReplyTo, "MNEMONIC_SMPTREPLYTO", s, "DESCRIPTION_SMPTREPLYTO");
        s = MessageLog.getMessageNoID("GUI2059T");
        c.insets.left = 4;
        c.gridwidth = 1;
        subPanel.add((Component)label, c);
        this.smtpReplyTo.setToolTipText(s);
        c.insets.left = 0;
        c.gridwidth = 0;
        subPanel.add((Component)this.smtpReplyTo, c);
        s = Util.getString("LABEL_DATA_ADMIN_COLON");
        label = new JLabel(s);
        s = Util.getString("DESC_SRM_ADMIN");
        GuiUtil.setAccessibleLabel(label, this.smtpSrmAdmin, "", s, s);
        c.insets.left = 4;
        c.insets.bottom = 7;
        c.gridwidth = 1;
        c.gridheight = 0;
        subPanel.add((Component)label, c);
        this.smtpSrmAdmin.setToolTipText(s);
        c.insets.left = 0;
        c.gridwidth = 0;
        subPanel.add((Component)this.smtpSrmAdmin, c);
        c.insets.top = 2;
        c.insets.left = 6;
        c.insets.right = 6;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 2;
        result.add((Component)subPanel, c);
        subPanel = new JPanel(new GridBagLayout());
        s = MessageLog.getMessageNoID("GUI6002L");
        subPanel.setBorder(GuiUtil.getBorder(s));
        s = MessageLog.getMessageNoID("GUI6003L");
        label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.delafterdays, "MNEMONIC_ALERTLOG", s, "DESCRIPTION_ALERTLOG");
        c.insets.left = 4;
        c.insets.top = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.weightx = 0.0;
        subPanel.add((Component)label, c);
        c.insets.left = 0;
        subPanel.add((Component)this.delafterdays, c);
        c.gridwidth = 0;
        c.weightx = 1.0;
        s = MessageLog.getMessageNoID("GUI6004L");
        label = new JLabel(s);
        subPanel.add((Component)label, c);
        c.weightx = 0.0;
        c.insets.top = 2;
        c.insets.left = 6;
        c.insets.right = 6;
        c.gridheight = 1;
        c.fill = 0;
        c.weightx = 1.0;
        c.fill = 2;
        result.add((Component)subPanel, c);
        c.insets.top = 0;
        c.insets.bottom = 0;
        c.insets.right = 0;
        c.insets.left = 0;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.gridheight = 0;
        result.add(Box.createVerticalStrut(1), c);
        return result;
    }

    public ConfigSettings getData() {
        for (int i = 0; i < this.snmpArray.length; ++i) {
            this.settings.csSnmp[i] = this.snmpArray[i].getData();
        }
        this.settings.csTecServer = this.tecServer.getText();
        String s = this.tecPort.getText();
        this.settings.csTecPort = s.length() > 0 ? Integer.parseInt(s) : 5524;
        this.settings.csSmtp.ssServer = this.smtpServer.getText();
        s = this.smtpPort.getText();
        this.settings.csSmtp.ssPort = s.length() > 0 ? Integer.parseInt(s) : 25;
        this.settings.csSmtp.ssReplyTo = this.smtpReplyTo.getText();
        this.settings.csSmtp.ssReturn = this.smtpReturnTo.getText();
        this.settings.csSmtp.ssDfltDomain = this.smtpDefaultDomain.getText();
        this.settings.csSmtp.setSrmAdmin(this.smtpSrmAdmin.getText());
        s = this.delafterdays.getText();
        if (s.length() > 0) {
            this.settings.csDellogDays = Integer.parseInt(s);
        }
        return this.settings;
    }

    public void validate(ConfigSettings ignored) throws GeneralException {
        String text;
        for (int i = 0; i < validationMsgs.length; ++i) {
            JTextField field;
            if (validationMsgs[i] == null || (text = (field = this.fieldArray[i]).getText()).length() != 0) continue;
            this.ddi.badField = i;
            text = MessageLog.getMessageNoTS(validationMsgs[i], null);
            throw new GeneralException(text);
        }
        boolean haveSnmpHost = false;
        for (int i = 0; i < this.snmpArray.length; ++i) {
            this.ddi.badField = 9 + i;
            if (!this.snmpArray[i].validateData()) continue;
            haveSnmpHost = true;
        }
        if (!haveSnmpHost) {
            this.ddi.badField = 9;
            text = MessageLog.getMessageNoTS("GUI0271E", null);
            throw new GeneralException(text);
        }
    }

    public void selectField(boolean visible) {
        if (visible) {
            if (this.ddi.badField >= 9) {
                int index = this.ddi.badField - 9;
                this.snmpArray[index].requestFocus();
            } else {
                this.fieldArray[this.ddi.badField].requestFocus();
            }
        } else {
            this.setFocus = true;
        }
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
        if (!this.setFocus || this.ddi.badField >= 9) {
            return;
        }
        int field = this.ddi.badField;
        Component component = event.getComponent();
        if (component == this.fieldArray[field]) {
            this.setFocus = false;
            component.requestFocus();
        }
    }
}

