/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class OutOfBandFabricAgentTreeNode
extends AgentTreeNode
implements GuiRequestor,
ActionListener {
    private String node_name;
    private String node_ip;
    private int node_state;
    private JPopupMenu popup;
    private static String checkMenuItemString;
    private static String viewLogMenuItemString;
    private static String removeMenuItemString;
    private static String refreshMenuItemString;
    private OutOfBandFabricAgentDDI addi;

    OutOfBandFabricAgentTreeNode(Object name, String ipaddress, byte agentstate) {
        super(name, 0, agentstate);
        this.node_name = (String)name;
        this.node_ip = ipaddress;
        this.node_state = agentstate;
        this.setUserObject(name);
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        switch (this.node_state) {
            case 1: {
                renderer.setIcon(IconFactory.getStateUpIcon());
                break;
            }
            case 0: {
                renderer.setIcon(IconFactory.getStateDownIcon());
                break;
            }
            default: {
                renderer.setIcon(IconFactory.getStateDefectedIcon());
            }
        }
    }

    public void showPopupMenu(MouseEvent event) {
        this.popup = this.getPopupMenu();
        checkMenuItemString = FabricGuiUtil.getString("FabricOutOfBand_Check");
        JMenuItem checkMenu = new JMenuItem(checkMenuItemString);
        checkMenu.setActionCommand(checkMenuItemString);
        checkMenu.addActionListener(this);
        checkMenu.setEnabled(true);
        this.popup.add(checkMenu);
        removeMenuItemString = MessageLog.getMessageNoID("ADG0262L");
        JMenuItem removeMenu = new JMenuItem(removeMenuItemString);
        removeMenu.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        removeMenu.setActionCommand(removeMenuItemString);
        removeMenu.addActionListener(this);
        removeMenu.setEnabled(this.capabilities.isAperiAdmin());
        this.popup.add(removeMenu);
        refreshMenuItemString = MessageLog.getMessageNoID("ADG0003L");
        JMenuItem refreshMenu = new JMenuItem(refreshMenuItemString);
        refreshMenu.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        refreshMenu.setActionCommand(refreshMenuItemString);
        refreshMenu.addActionListener(this);
        refreshMenu.setEnabled(true);
        this.popup.add(refreshMenu);
        super.showPopupMenu(this.popup, event);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            OutOfBandFabricAgentInfo oobfai = (OutOfBandFabricAgentInfo)response.responseData;
            switch (oobfai.request_type) {
                case 4: {
                    this.setNodeIconBasedOnStatusFromServer(oobfai.status);
                    if (oobfai.status == 2) {
                        String msg = MessageLog.getMessageNoID("ADG0294M", this.node_name);
                        JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0295T"), 1);
                        break;
                    }
                    String msg = this.node_name + " " + FabricGuiUtil.getInbandFabricAgentStatusString(oobfai.status);
                    JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0295T"), 1);
                    break;
                }
                case 3: {
                    BaseTree.MyTree.removeNodeFromParent(this);
                    if (this.ddi == null) break;
                    this.ddi.remove();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if (actionCommand.equals(checkMenuItemString)) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            OutOfBandFabricAgentInfo oobfai = new OutOfBandFabricAgentInfo();
            request.requestData = oobfai;
            request.flags = (byte)4;
            oobfai.request_type = 4;
            oobfai.hostname = this.node_name;
            oobfai.ipaddress = this.node_ip;
            GuiClient.doRequest(this, request);
        }
        if (actionCommand.equals(viewLogMenuItemString)) {
            JOptionPane.showMessageDialog(guiMain.getFrame(), FabricGuiUtil.getString("FabricOutOfBand_ViewLog"));
        }
        if (actionCommand.equals(removeMenuItemString)) {
            String desc = Util.getString("CONFIRM_DELETE", this.node_name);
            String title = MessageLog.getMessageNoID("ADG0262L");
            int choice = JOptionPane.showConfirmDialog(guiMain.getFrame(), desc, title, 0, 2);
            if (choice == 0) {
                Request request = new Request();
                request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
                request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
                request.userName = GuiUtil.getUserName();
                OutOfBandFabricAgentInfo oobfai = new OutOfBandFabricAgentInfo();
                oobfai.hostname = this.node_name;
                oobfai.ipaddress = this.node_ip;
                oobfai.request_type = 3;
                request.requestData = oobfai;
                request.flags = (byte)4;
                GuiClient.doRequest(this, request);
            }
        } else if (actionCommand.equals(refreshMenuItemString)) {
            if (this.ddi != null) {
                this.ddi.fileClose();
            }
            this.refresh();
        }
    }

    private void refresh() {
        if (this.ddi == null) {
            this.addi = new OutOfBandFabricAgentDDI(this.node_name, this.node_ip);
            this.ddi = this.addi;
            this.ddi.treeNode = this;
            this.ddi.setDescription(MessageLog.getMessageNoID("ADG0201L") + ":  " + this.getUserObject());
        }
        this.ddi.reDisplay();
    }

    public void select(TreeSelectionEvent event) {
        this.refresh();
    }

    public void setNodeIconBasedOnStatusFromServer(int status) {
        this.node_state = status == 2 ? 1 : (status == 3 ? 0 : -1);
        BaseTree.MyTree.nodeChanged(this);
    }
}

