/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.admin.GenericServiceTreeNode;
import org.eclipse.aperi.gui.admin.LogConfigDialog;
import org.eclipse.aperi.gui.admin.ServerData;
import org.eclipse.aperi.gui.admin.ServiceData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class ServicesTreeNode
extends GenericServiceTreeNode
implements GuiRequestor,
ActionListener {
    protected int pendingRequests;
    protected int processedRequests;
    protected int threadsWaiting;
    public JPopupMenu popup = null;
    private LogConfigDialog lConfigDialog = null;
    private String actionCommand;
    private static String LOG = MessageLog.getMessageNoID("ADG0017L");
    private static String TRACING = MessageLog.getMessageNoID("ADG0304L");
    private static String AUDITLOG = MessageLog.getMessageNoID("ADG0326L");
    private static String BROADCAST = MessageLog.getMessageNoID("ADG0117L");
    private static String START = MessageLog.getMessageNoID("ADG0005L");
    private static String SHUTDOWN = MessageLog.getMessageNoID("ADG0006L");
    private static String NORMAL = MessageLog.getMessageNoID("ADG0007L");
    private static String IMMEDIATE = MessageLog.getMessageNoID("ADG0009L");
    private static String ABORT = MessageLog.getMessageNoID("ADG0011L");
    private static String STOP_TITLE = MessageLog.getMessageNoID("ADG0103T");
    private static String STOP_WARNING = MessageLog.getMessageNoID("ADG0104T");
    private static String STOP_NO = MessageLog.getMessageNoID("ADG0105L");
    private static String STOP_YES = MessageLog.getMessageNoID("ADG0106L");
    private static String NOT_CONNECTED = MessageLog.getMessageNoID("ADG0015T");

    public ServicesTreeNode(Object name, String requestType, byte state, int pendingRequests, int processedRequests, int threadsWaiting) {
        super(name, requestType, requestType, state);
        this.setAllowsChildren(false);
        this.pendingRequests = pendingRequests;
        this.processedRequests = processedRequests;
        this.threadsWaiting = threadsWaiting;
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.popup;
    }

    public void showPopupMenu(MouseEvent event) {
        boolean showPopup = true;
        if (event == null) {
            showPopup = false;
        }
        this.popup = this.getPopupMenu();
        JMenuItem log = new JMenuItem(LOG);
        JMenuItem tracing = new JMenuItem(TRACING);
        JMenuItem auditlog = new JMenuItem(AUDITLOG);
        JMenuItem broadcast = new JMenuItem(BROADCAST);
        JMenuItem start = new JMenuItem(START);
        JMenu shutdown = new JMenu(SHUTDOWN);
        JMenuItem normal = new JMenuItem(NORMAL);
        JMenuItem immediate = new JMenuItem(IMMEDIATE);
        JMenuItem abort = new JMenuItem(ABORT);
        this.popup.add(log);
        log.setActionCommand(LOG);
        log.addActionListener(this);
        log.setName(LOG);
        tracing.setName(TRACING);
        auditlog.setName(AUDITLOG);
        shutdown.setName(SHUTDOWN);
        start.setName(START);
        broadcast.setName(BROADCAST);
        normal.setName(NORMAL);
        immediate.setName(IMMEDIATE);
        abort.setName(ABORT);
        if (this.isRepresentingTheServerService()) {
            log.setToolTipText(MessageLog.getMessageNoID("ADG0129T"));
            if (this.getState() != 2) {
                tracing.setToolTipText(MessageLog.getMessageNoID("ADG0306T"));
                tracing.setActionCommand(TRACING);
                tracing.addActionListener(this);
                tracing.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                broadcast.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(tracing);
            }
            if (this.getState() != 2) {
                auditlog.setToolTipText(MessageLog.getMessageNoID("ADG0328L"));
                auditlog.setActionCommand(AUDITLOG);
                auditlog.addActionListener(this);
                auditlog.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                broadcast.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(auditlog);
            }
            broadcast.setToolTipText(MessageLog.getMessageNoID("ADG0118T"));
            broadcast.setActionCommand(BROADCAST);
            broadcast.addActionListener(this);
            broadcast.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
            this.popup.add(broadcast);
        } else {
            log.setToolTipText(MessageLog.getMessageNoID("ADG0130T"));
        }
        if (this.getState() != 2) {
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.SchedulerSvp")) {
                tracing.setToolTipText(MessageLog.getMessageNoID("ADG0317T"));
                tracing.setActionCommand(TRACING);
                tracing.addActionListener(this);
                tracing.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(tracing);
            }
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.AgentSvp")) {
                tracing.setToolTipText(MessageLog.getMessageNoID("ADG0318T"));
                tracing.setActionCommand(TRACING);
                tracing.addActionListener(this);
                tracing.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(tracing);
            }
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.GuiSvp")) {
                tracing.setToolTipText(MessageLog.getMessageNoID("ADG0319T"));
                tracing.setActionCommand(TRACING);
                tracing.addActionListener(this);
                tracing.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(tracing);
            }
            if (this.getRequestType().equals("org.eclipse.aperi.server.svp.CimomSvp")) {
                tracing.setToolTipText(MessageLog.getMessageNoID("ADG0320T"));
                tracing.setActionCommand(TRACING);
                tracing.addActionListener(this);
                tracing.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
                this.popup.add(tracing);
            }
            shutdown.setToolTipText(MessageLog.getMessageNoID("ADG0102T"));
            shutdown.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
            this.popup.add(shutdown);
            normal.setToolTipText(MessageLog.getMessageNoID("ADG0008T"));
            normal.setActionCommand(NORMAL);
            normal.addActionListener(this);
            shutdown.add(normal);
            immediate.setToolTipText(MessageLog.getMessageNoID("ADG0010T"));
            immediate.setActionCommand(IMMEDIATE);
            immediate.addActionListener(this);
            shutdown.add(immediate);
            abort.setToolTipText(MessageLog.getMessageNoID("ADG0012T"));
            abort.setActionCommand(ABORT);
            abort.addActionListener(this);
            shutdown.add(abort);
        } else {
            start.setToolTipText(MessageLog.getMessageNoID("ADG0101T"));
            start.setActionCommand(START);
            start.addActionListener(this);
            start.setEnabled(ServicesTreeNode.guiMain.getUserPrefs().administrator);
            this.popup.add(start);
        }
        if (showPopup) {
            this.showPopupMenu(this.popup, event);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.actionCommand = event.getActionCommand();
        if (this.actionCommand == START) {
            this.stateChange((byte)4);
        } else if (this.actionCommand == NORMAL) {
            this.stateChange((byte)1);
        } else if (this.actionCommand == IMMEDIATE) {
            this.stateChange((byte)2);
        } else if (this.actionCommand == ABORT) {
            this.stateChange((byte)3);
        } else if (this.actionCommand == BROADCAST) {
            Request request = new Request();
            ServerRequest.broadcast(request);
            GuiClient.doRequest(this, request);
        } else if (this.actionCommand == LOG) {
            new LogViewer(this, this.getRequestType());
        } else if (this.actionCommand == TRACING) {
            this.tracingConfig();
        } else if (this.actionCommand == AUDITLOG) {
            this.auditConfig();
        }
    }

    private void tracingConfig() {
        Request request = new Request();
        ServerRequest.serverGetTracingConfig(request, this.getRequestType());
        GuiClient.doRequest(this, request);
    }

    private void auditConfig() {
        Request request = new Request();
        ServerRequest.serverGetAuditConfig(request, this.getRequestType());
        GuiClient.doRequest(this, request);
    }

    private void stateChange(byte newState) {
        Object[] options = new String[]{STOP_NO, STOP_YES};
        if (this.isRepresentingTheServerService()) {
            IGuiMain guiMain;
            int answer = JOptionPane.showOptionDialog(ServicesTreeNode.guiMain.getFrame(), STOP_WARNING, STOP_TITLE, 0, 2, null, options, options[0]);
            if (answer == 1 && (guiMain = GuiManager.getGuiManager().getGuiMain()).disconnectFromServer()) {
                Request request = new Request();
                ServerRequest.stateChange(request, newState, this.getRequestType());
                GuiClient.doRequest(this, request);
            }
        } else {
            this.doStateChange(newState, this.getRequestType());
            this.setState(this.getState() == 2 ? (byte)1 : 2);
            BaseTree.MyTree.nodeChanged(this);
        }
    }

    private void doStateChange(byte state, String serviceID) {
        Request request = new Request();
        ServerRequest.stateChange(request, state, serviceID);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (this.actionCommand == TRACING || this.actionCommand == AUDITLOG) {
            if (status != 0) {
                String msg = MessageLog.getMessage("ADG0315E");
                JOptionPane.showMessageDialog(guiMain.getFrame(), msg, MessageLog.getMessageNoID("ADG0307L"), 0);
            } else {
                HashMap config = (HashMap)response.responseData;
                String name = (String)this.getUserObject();
                this.lConfigDialog = null;
                if (this.lConfigDialog == null) {
                    String title = null;
                    if (name.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.ServerSvp"))) {
                        title = MessageLog.getMessageNoID("ADG0314L");
                    } else if (name.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.SchedulerSvp"))) {
                        title = MessageLog.getMessageNoID("ADG0321L");
                    } else if (name.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.AgentSvp"))) {
                        title = MessageLog.getMessageNoID("ADG0322L");
                    } else if (name.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.GuiSvp"))) {
                        title = MessageLog.getMessageNoID("ADG0323L");
                    } else if (name.equals(RequestTypeManager.getExternalName("org.eclipse.aperi.server.svp.CimomSvp"))) {
                        title = MessageLog.getMessageNoID("ADG0324L");
                    }
                    if (this.actionCommand == AUDITLOG) {
                        title = MessageLog.getMessageNoID("ADG0327L");
                        this.lConfigDialog = new LogConfigDialog(title, this.getRequestType(), true);
                    } else {
                        this.lConfigDialog = new LogConfigDialog(title, this.getRequestType());
                    }
                }
                this.lConfigDialog.setLocationRelativeTo(null);
                this.lConfigDialog.show(config, this.getRequestType());
            }
        }
    }

    public boolean isRepresentingTheServerService() {
        return this.getRequestType().equals("org.eclipse.aperi.server.svp.ServerSvp");
    }

    public JPanel getPanel() {
        if (this.isRepresentingTheServerService()) {
            return new ServerData(this);
        }
        return new ServiceData(this);
    }
}

