/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.charting;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.charting.AperiChartAdapter;
import org.eclipse.aperi.gui.charting.AperiChartFactory;

public class AperiChart
extends JPanel {
    private static final long serialVersionUID = 1L;
    private AperiChartAdapter chart;

    public AperiChart(int chartType, int yAxisType, int xAxisType, double[][] yValues, double[][] xValues, String[] seriesNames) {
        this.commonConfiguration(chartType, yAxisType, xAxisType, seriesNames);
        this.getChart().setXYValues(xValues, yValues);
    }

    public AperiChart(int chartType, int yAxisType, int xAxisType, Number[][] chartData, String[] seriesNames, Object[] categoryNames) {
        this.commonConfiguration(chartType, yAxisType, xAxisType, seriesNames);
        this.getChart().setYSeries(chartData);
        this.getChart().setXCategories(categoryNames);
    }

    private void commonConfiguration(int chartType, int yAxisType, int xAxisType, String[] seriesNames) {
        this.setChart(AperiChartFactory.newChart());
        this.getChart().setChartType(chartType);
        this.getChart().setYValueFormat(yAxisType);
        this.getChart().setYValueLabelsVisible(this.getChart().getYValueFormat() != 0);
        this.getChart().setXValueFormat(xAxisType);
        this.getChart().setYSeriesNames(seriesNames);
        this.getChart().setLegendAnchor(2);
        this.getChart().setLegendOrientation(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getChart(), "Center");
    }

    protected AperiChartAdapter getChart() {
        return this.chart;
    }

    private void setChart(AperiChartAdapter chart) {
        this.chart = chart;
    }
}

