/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.common.CIMOMMgmtAgentTreeLabel;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.common.CIMOMMgmtUpdateCIMOMReq;

public class CIMOMMgmtAddCIMOMDialog
extends JDialog
implements ActionListener,
DocumentListener,
GuiRequestor {
    private static final String CANCEL_ACTION = Util.getString("LABEL_CANCEL");
    private static final String SAVE_ACTION = Util.getString("LABEL_SAVE");
    protected static final String IP = Util.getString("LABEL_CIMOM_HOSTNAME");
    protected static final String PORT = Util.getString("LABEL_CIMOM_PORT");
    protected static final String USER_ID = Util.getString("CIMOM_MGMT_USER_ID_LABEL");
    protected static final String PASSWORD = Util.getString("CIMOM_MGMT_PASSWORD_LABEL");
    protected static final String PASSWORD_CONFIRM = Util.getString("CIMOM_MGMT_PASSWORD_CONFIRM_LABEL");
    protected static final String INTEROP_SCHEMA_NAMESPACE = Util.getString("CIMOM_MGMT_INTEROP_SCHEMA_NAMESPACE_LABEL");
    protected static final String PROTOCOL = Util.getString("CIMOM_MGMT_PROTOCOL_LABEL");
    protected static final String TRUSTSTORE_LOCATION = Util.getString("CIMOM_MGMT_TRUSTSTORE_LOCATION_LABEL");
    protected static final String TRUSTSTORE_PASSPHRASE = Util.getString("CIMOM_MGMT_TRUSTSTORE_PASSPHRASE_LABEL");
    protected static final String DISPLAY_NAME = Util.getString("CIMOM_MGMT_DISPLAY_NAME_LABEL");
    protected static final String DESCRIPTION = Util.getString("CIMOM_MGMT_DESCRIPTION_LABEL");
    protected static final String CHECKBOX_LABEL = Util.getString("CIMOM_MGT_TESTBEFORE_ADD_LABEL");
    private static final int DEFAULT_COLUMN_WIDTH = 20;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String[] PROTOCOL_CHOICES = new String[]{"https", "http"};
    private static final String FIELD = "CIMOM_FIELD";
    private static final String DEFAULT_PORT = "5989";
    private static final int LOWEST_PORT = 0;
    private static final int HIGHEST_PORT = Integer.MAX_VALUE;
    private static final String DEFAULT_NAMESPACE = "/root/ibm";
    private static final String DEFAULT_PORT_HTTPS = "5989";
    private static final String DEFAULT_PORT_HTTP = "5988";
    private boolean portHasBeenModifiedByUser = false;
    HashMap model = new HashMap();
    JButton saveButton;
    JButton cancelButton;
    CIMOMMgmtAgentTreeLabel treeNode;

    public CIMOMMgmtAddCIMOMDialog(Frame owner, String title, CIMOMMgmtAgentTreeLabel treeNode) throws HeadlessException {
        super(owner, title);
        this.treeNode = treeNode;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.buildPanel(this.getContentPane());
        this.validateAndEnable(null);
        this.pack();
        GuiUtil.centerDialog(this);
        this.configureHelp();
        this.portHasBeenModifiedByUser = false;
        this.equalizeFieldsSize();
        this.setVisible(true);
    }

    private void buildPanel(Container contentPane) {
        contentPane.add((Component)this.buildCimomPanel(), "North");
        contentPane.add((Component)this.buildButtonPanel(), "South");
    }

    private JPanel buildCimomPanel() {
        JPanel cimomPanel = new JPanel();
        cimomPanel.setLayout(new FlowLayout(0));
        cimomPanel.add(this.buildGridBag(), "Before");
        return cimomPanel;
    }

    private Component buildGridBag() {
        GridBagPanel gbp = new GridBagPanel();
        this.buildTextRow(gbp, IP, true);
        this.buildTextRow(gbp, PORT, "5989", false);
        this.buildTextRow(gbp, USER_ID, false);
        this.buildPasswordRow(gbp, PASSWORD, false);
        this.buildPasswordRow(gbp, PASSWORD_CONFIRM, false);
        this.buildTextRow(gbp, INTEROP_SCHEMA_NAMESPACE, DEFAULT_NAMESPACE, true);
        this.buildComboboxRow(gbp, PROTOCOL, PROTOCOL_CHOICES);
        this.buildTextRow(gbp, TRUSTSTORE_LOCATION, false);
        this.buildPasswordRow(gbp, TRUSTSTORE_PASSPHRASE, false);
        this.buildTextRow(gbp, DISPLAY_NAME, false);
        this.buildTextRow(gbp, DESCRIPTION, false);
        this.buildCheckboxRow(gbp, CHECKBOX_LABEL, true);
        gbp.createStretchBox();
        return gbp;
    }

    protected void buildTextRow(GridBagPanel gridbag, String label, boolean required) {
        this.buildTextRow(gridbag, label, null, required);
    }

    protected void buildTextRow(GridBagPanel gridbag, String label, String value, boolean required) {
        JTextField textField = new JTextField(value);
        this.buildRowWithTextField(gridbag, label, textField, required);
    }

    protected void buildPasswordRow(GridBagPanel gridbag, String label, boolean required) {
        JPasswordField passwordField = new JPasswordField();
        this.buildRowWithTextField(gridbag, label, passwordField, required);
    }

    private void buildRowWithTextField(GridBagPanel gridbag, String label, JTextField textField, boolean required) {
        gridbag.add(required ? new BoldLabel(label) : new JLabel(label));
        textField.setColumns(20);
        this.addEditListeners(label, textField);
        gridbag.add(textField);
        this.model.put(label, textField);
        gridbag.newRow();
    }

    private void buildComboboxRow(GridBagPanel gridbag, String label, String[] choices) {
        gridbag.add(new JLabel(label));
        JComboBox<String> combo = new JComboBox<String>(choices);
        combo.setPreferredSize(new Dimension(50, 20));
        combo.setEditable(false);
        combo.setActionCommand(label);
        combo.addActionListener(this);
        gridbag.add(combo);
        this.model.put(label, combo);
        gridbag.newRow();
    }

    private void buildCheckboxRow(GridBagPanel gridbag, String label, boolean checkedByDefault) {
        gridbag.add(new JLabel(label));
        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(checkedByDefault);
        checkBox.setActionCommand(label);
        checkBox.addActionListener(this);
        gridbag.add(checkBox);
        this.model.put(label, checkBox);
        gridbag.newRow();
    }

    private void addEditListeners(String label, JTextField textField) {
        textField.setActionCommand(label);
        textField.addActionListener(this);
        textField.getDocument().addDocumentListener(this);
        textField.getDocument().putProperty(FIELD, label);
    }

    public void changedUpdate(DocumentEvent e) {
        this.validateAndEnable((String)e.getDocument().getProperty(FIELD));
    }

    public void insertUpdate(DocumentEvent e) {
        this.validateAndEnable((String)e.getDocument().getProperty(FIELD));
    }

    public void removeUpdate(DocumentEvent e) {
        this.validateAndEnable((String)e.getDocument().getProperty(FIELD));
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            this.setVisible(false);
            this.treeNode.buildCIMOMList((CIMOM[])response.responseData);
            this.dispose();
        } else {
            this.enableSaveAndCancelButtons(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CANCEL_ACTION)) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getActionCommand().equals(SAVE_ACTION)) {
            Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtAddCIMOMsHandler");
            request.requestData = this.getCIMOMFromPanel();
            this.enableSaveAndCancelButtons(false);
            GuiClient.doRequest(this, request);
        } else {
            this.validateAndEnable(e.getActionCommand());
        }
    }

    private CIMOMMgmtUpdateCIMOMReq getCIMOMFromPanel() {
        CIMOM result = new CIMOM();
        result.setServiceUrl(this.getServiceUrl());
        result.setUserId(this.getTextFromField(USER_ID));
        result.setPassword(this.getTextFromField(PASSWORD));
        result.setProtocol(this.getTextFromCombo(PROTOCOL));
        result.setDisplayName(this.getTextFromField(DISPLAY_NAME));
        result.setDescription(this.getTextFromField(DESCRIPTION));
        result.setInteropSchemaNamespace(this.getTextFromField(INTEROP_SCHEMA_NAMESPACE));
        if (result.getProtocol().equals(HTTPS)) {
            result.setTrustStoreLocation(this.getTextFromField(TRUSTSTORE_LOCATION));
            result.setTrustStoreLocation(this.getTextFromField(TRUSTSTORE_PASSPHRASE));
        }
        return new CIMOMMgmtUpdateCIMOMReq(result, this.getStateFromCheckBox(CHECKBOX_LABEL));
    }

    private String getServiceUrl() {
        StringBuffer result = new StringBuffer(this.getTextFromCombo(PROTOCOL));
        result.append("://").append(this.getTextFromField(IP));
        String port = this.getTextFromField(PORT);
        if (port != null && port.length() != 0) {
            result.append(":").append(port);
        }
        return result.toString();
    }

    private String getTextFromCombo(String key) {
        return (String)((JComboBox)this.model.get(key)).getSelectedItem();
    }

    private boolean getStateFromCheckBox(String key) {
        return ((JCheckBox)this.model.get(key)).isSelected();
    }

    private String getTextFromField(String key) {
        String rez = this.getTextField(key).getText();
        return rez != null ? rez.trim() : null;
    }

    private JTextField getTextField(String key) {
        return (JTextField)this.model.get(key);
    }

    private void validateAndEnable(String who) {
        JTextField confirmField;
        String confirmText;
        if (PORT.equals(who)) {
            this.portHasBeenModifiedByUser = true;
        } else if (PROTOCOL.equals(who) && !this.portHasBeenModifiedByUser) {
            if (this.getTextFromCombo(PROTOCOL).equals(HTTPS)) {
                this.getTextField(PORT).setText("5989");
            } else {
                this.getTextField(PORT).setText(DEFAULT_PORT_HTTP);
            }
            this.portHasBeenModifiedByUser = false;
        }
        boolean saveEnabled = this.validString(this.getTextFromField(IP)) && this.validString(this.getTextFromField(INTEROP_SCHEMA_NAMESPACE));
        if (!this.validPort(this.getTextFromField(PORT))) {
            saveEnabled = false;
            this.getTextField(PORT).setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
        } else {
            this.getTextField(PORT).setBorder(BorderFactory.createBevelBorder(1));
        }
        boolean secure = this.getTextFromCombo(PROTOCOL).equals(HTTPS);
        this.getTextField(TRUSTSTORE_LOCATION).setEditable(secure);
        this.getTextField(TRUSTSTORE_PASSPHRASE).setEditable(secure);
        JTextField passwordField = this.getTextField(PASSWORD);
        String passwordText = passwordField.getText();
        if (passwordText == null) {
            passwordText = "";
        }
        if ((confirmText = (confirmField = this.getTextField(PASSWORD_CONFIRM)).getText()) == null) {
            confirmText = "";
        }
        if (!passwordText.equals(confirmText)) {
            passwordField.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
            confirmField.setBorder(BorderFactory.createBevelBorder(1, Color.RED, Color.BLACK));
            saveEnabled = false;
        } else {
            passwordField.setBorder(BorderFactory.createBevelBorder(1));
            confirmField.setBorder(BorderFactory.createBevelBorder(1));
        }
        this.saveButton.setEnabled(saveEnabled);
    }

    private boolean validPort(String n) {
        return n == null || n.trim().length() == 0 || this.isNumber(n.trim());
    }

    private boolean validString(String s) {
        return s != null & s.trim().length() != 0;
    }

    private boolean isNumber(String number) {
        boolean result = false;
        try {
            int port = Integer.parseInt(number);
            result = port >= 0 && port <= Integer.MAX_VALUE;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        this.saveButton = new JButton(SAVE_ACTION);
        buttonPanel.add(this.buildButton(this.saveButton));
        this.saveButton.setEnabled(false);
        this.cancelButton = new JButton(CANCEL_ACTION);
        buttonPanel.add(this.buildButton(this.cancelButton));
        this.cancelButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_CANCEL"));
        this.saveButton.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_SAVE"));
        return buttonPanel;
    }

    private JButton buildButton(JButton button) {
        button.setActionCommand(button.getName());
        button.addActionListener(this);
        button.setEnabled(true);
        return button;
    }

    public String getHelpID() {
        return "adm_agnts_add_cimom";
    }

    private void configureHelp() {
        String helpID = this.getHelpID();
        Help.setHelpID(this.getRootPane(), helpID);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    private void enableSaveAndCancelButtons(boolean enable) {
        if (enable) {
            this.validateAndEnable(null);
            this.cancelButton.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else {
            this.saveButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void equalizeFieldsSize() {
        int width = 0;
        Font font = null;
        for (int phase = 0; phase < 2; ++phase) {
            for (String key : this.model.keySet()) {
                Object obj = this.model.get(key);
                if (!(obj instanceof JComponent)) continue;
                JComponent field = (JComponent)obj;
                if (phase == 0) {
                    width = Math.max(width, (int)field.getSize().getWidth());
                    if (font != null || !(field instanceof JTextField) || field instanceof JPasswordField) continue;
                    font = field.getFont();
                    continue;
                }
                field.setFont(font);
                FontMetrics metrics = field.getFontMetrics(field.getFont());
                int height = Math.max(metrics.getHeight() + 2, 20);
                field.setPreferredSize(new Dimension(width, height));
                field.setMinimumSize(new Dimension(width, height));
            }
        }
    }
}

