/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.common.CIMOMMgmtAgentTreeLabel;
import org.eclipse.aperi.gui.common.CIMOMMgmtDetailsDDI;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class CIMOMMgmtAgentTreeNode
extends BaseTreeNode {
    private CIMOM cimom;

    public CIMOMMgmtAgentTreeNode(CIMOM cimom) {
        super(CIMOMMgmtAgentTreeNode.getLabel(cimom));
        this.cimom = cimom;
        this.setAllowsChildren(false);
    }

    private static String getLabel(CIMOM cimom) {
        StringBuffer label = new StringBuffer();
        label.append(CIMOMMgmtAgentTreeNode.getBestDisplayName(cimom));
        return label.toString();
    }

    private static String getBestDisplayName(CIMOM cimom2) {
        String name = cimom2.getDisplayName();
        if (name == null || name.length() == 0) {
            name = cimom2.getServiceUrl();
        }
        return name;
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (this.cimom.getStatus() == CIMOMConnectionStatus.SUCCESS) {
            renderer.setIcon(IconFactory.getStateUpIcon());
            renderer.setFont(BaseTree.plainFont);
        } else if (this.cimom.getStatus() == CIMOMConnectionStatus.UNKNOWN) {
            renderer.setIcon(IconFactory.getStateUnknownIcon());
            renderer.setFont(BaseTree.boldFont);
        } else {
            renderer.setIcon(IconFactory.getStateFailedIcon());
            renderer.setFont(BaseTree.boldFont);
        }
    }

    public void select(TreeSelectionEvent event) {
        this.launchDDI();
    }

    private void launchDDI() {
        if (this.ddi == null) {
            this.ddi = new CIMOMMgmtDetailsDDI(this, this.cimom);
        } else {
            this.ddi.reDisplay();
        }
    }

    public void showPopupMenu(MouseEvent event) {
        if (event != null) {
            JPopupMenu popup = this.getPopupMenu();
            popup.add(this.checkCIMOMMenu());
            popup.add(this.removeCIMOMMenu());
            this.showPopupMenu(popup, event);
        }
    }

    private JMenuItem removeCIMOMMenu() {
        JMenuItem addCimomMenu = new JMenuItem(Util.getString("CIMOM_MGMT_REM"));
        addCimomMenu.setToolTipText(Util.getString("CIMOM_MGMT_REM_TIP"));
        addCimomMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                int choice = JOptionPane.showConfirmDialog(guiMain.getFrame(), Util.getString("GUI8100I", CIMOMMgmtAgentTreeNode.getBestDisplayName(CIMOMMgmtAgentTreeNode.this.cimom)), Util.getString("CIMOM_MGMT_REM_TITLE"), 0, 2);
                if (choice == 0) {
                    CIMOMMgmtAgentTreeNode.this.removeCIMOMrequest(CIMOMMgmtAgentTreeNode.this.cimom);
                }
            }
        });
        addCimomMenu.setEnabled(this.capabilities.isAperiAdmin());
        return addCimomMenu;
    }

    protected void removeCIMOMrequest(CIMOM cimom2) {
        Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtRemoveCIMOMsHandler");
        request.requestData = cimom2;
        GuiClient.doRequest(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    ((CIMOMMgmtAgentTreeLabel)CIMOMMgmtAgentTreeNode.this.getParent()).buildCIMOMList((CIMOM[])response.responseData);
                }
            }
        }, request);
    }

    private JMenuItem checkCIMOMMenu() {
        JMenuItem addCimomMenu = new JMenuItem(Util.getString("CIMOM_MGMT_TST"));
        addCimomMenu.setToolTipText(Util.getString("CIMOM_MGMT_TST_TIP"));
        addCimomMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Request request = GuiUtil.newGUIDeviceRequest("org.eclipse.aperi.server.handler.gui.cimom.CIMOMMgmtTestCIMOMsHandler");
                request.requestData = CIMOMMgmtAgentTreeNode.this.cimom;
                GuiClient.doRequest(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                        if (status <= 4) {
                            int messageType;
                            String message;
                            CIMOMConnectionStatus cimomStatus = (CIMOMConnectionStatus)response.responseData;
                            if (cimomStatus == CIMOMConnectionStatus.SUCCESS) {
                                message = Util.getString("GUI8102I", CIMOMMgmtAgentTreeNode.getBestDisplayName(CIMOMMgmtAgentTreeNode.this.cimom));
                                messageType = 1;
                            } else {
                                message = Util.getString("GUI8101I", CIMOMMgmtAgentTreeNode.getBestDisplayName(CIMOMMgmtAgentTreeNode.this.cimom), CIMOMMgmtAgentTreeNode.this.getLocalizedStatus(cimomStatus));
                                messageType = 0;
                            }
                            JOptionPane.showMessageDialog(guiMain.getFrame(), message, Util.getString("CIMOM_MGMT_TST_TITLE"), messageType);
                        }
                    }
                }, request);
            }
        });
        return addCimomMenu;
    }

    public void cleanYourself() {
        if (this.ddi != null) {
            this.ddi.remove();
        }
    }

    public Object getState() {
        return new Boolean(this.ddi != null);
    }

    public Object getUniqueID() {
        return this.cimom.getServiceUrl();
    }

    public void setState(Object object) {
        if (object != null && ((Boolean)object).booleanValue()) {
            this.launchDDI();
        }
    }

    private String getLocalizedStatus(CIMOMConnectionStatus status) {
        if (status == CIMOMConnectionStatus.SUCCESS) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_SUCCESS");
        }
        if (status == CIMOMConnectionStatus.UNCONFIGURED) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED");
        }
        if (status == CIMOMConnectionStatus.UNKNOWN) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
        }
        if (status == CIMOMConnectionStatus.INVALID_NAMESPACE) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE");
        }
        if (status == CIMOMConnectionStatus.TIMEOUT) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_TIMEOUT");
        }
        if (status == CIMOMConnectionStatus.REFUSED) {
            return Util.getString("DISK_COMMON_STATE_UNREACHABLE");
        }
        if (status == CIMOMConnectionStatus.LOGIN_FAILED) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED");
        }
        if (status == CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR");
        }
        if (status == CIMOMConnectionStatus.SSL_REGISTRATION_INVALID) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID");
        }
        if (status == CIMOMConnectionStatus.CIMCLIENT_ERROR) {
            return Util.getString("CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR");
        }
        return Util.getString("CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
    }
}

