/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.EditElementManagerConfigDialog;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.GuiConfig;
import org.eclipse.aperi.xmsg.MessageLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ElementManagerManager {
    private static final String XML_ELM_LAUNCHSTRING = "launchString";
    private static final String XML_ATTR_VALUE = "value";
    private static final String XML_ELM_DISPLAYNAME = "displayName";
    private static final String XML_ELM_MANAGER = "manager";
    private static final String XML_ATTR_GUID = "GUID";
    private static final String XML_ELM_DEVICE = "device";
    private static final String XML_ELM_ELEMENTMANAGERS = "elementManagers";
    private static final String DEFAULT_URLREGEXP = "(^http://.*)|(^https://.*)|(^ftp://.*)";
    private static final String PROPERTY_URLREGEXP = "URLRegexp";
    private static final String DEFAULT_WINDOWSEXECPREAMBLE = "cmd /c start \"\" ";
    private static final String PROPERTY_WINDOWSEXECPREAMBLE = "windowsExecPreamble";
    private static final String DEFAULT_WINDOWSURLPERAMBLE = "cmd /c start \"\" ";
    private static final String PROPERTY_WINDOWSURLPREAMBLE = "windowsURLPreamble";
    private static final String DEFAULT_UNIXEXECPREAMBLE = "/bin/sh -c ";
    private static final String PROPERTY_UNIXEXECPREAMBLE = "unixExecPreamble";
    private static final String DEFAULT_UNINXURLPREAMBLE = "${DEFAULT_BROWSER} ";
    private static final String PROPERTY_UNIXURLPREAMBLE = "unixURLPreamble";
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private HashMap userDefinedElementManagers = null;
    private static String elementDBFile = "element.xml";
    private HashMap internal2external;
    private HashMap external2internal;
    private Properties guiProperties = new Properties();
    private static String guiConfigFile = "GUI.properties";
    private static String WHITESPACE_REGEXP = "^\\s*$";
    private static ElementManagerManager instance = null;

    private ElementManagerManager() {
        this.createPropertyNameMaps();
        this.getElementManagers();
        this.getGUIProperties();
    }

    private void createPropertyNameMaps() {
        this.internal2external = new HashMap();
        this.external2internal = new HashMap();
        this.internal2external.put(PROPERTY_URLREGEXP, Util.getString("ELEMENT_MANAGER_PROPERTY_URLREGEXP"));
        this.internal2external.put(PROPERTY_WINDOWSEXECPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSEXEC"));
        this.internal2external.put(PROPERTY_WINDOWSURLPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSURL"));
        this.internal2external.put(PROPERTY_UNIXEXECPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXEXEC"));
        this.internal2external.put(PROPERTY_UNIXURLPREAMBLE, Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXURL"));
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_URLREGEXP"), PROPERTY_URLREGEXP);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSEXEC"), PROPERTY_WINDOWSEXECPREAMBLE);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_WINDOWSURL"), PROPERTY_WINDOWSURLPREAMBLE);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXEXEC"), PROPERTY_UNIXEXECPREAMBLE);
        this.external2internal.put(Util.getString("ELEMENT_MANAGER_PROPERTY_UNIXURL"), PROPERTY_UNIXURLPREAMBLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getElementManagers() {
        this.userDefinedElementManagers = new HashMap();
        InputStream stream = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            stream = GuiConfig.getFileInputStream(elementDBFile);
            if (stream != null) {
                Document document = builder.parse(stream);
                this.buildData(document);
            }
        }
        catch (Exception e) {
            this.userDefinedElementManagers = new HashMap();
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8203E", this.getExceptionMessage(e)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String getExceptionMessage(Exception e) {
        String mess = e.getLocalizedMessage();
        if (mess == null) {
            mess = e.toString();
        }
        return mess;
    }

    private void buildData(Document node) {
        Node elementManager = this.getFirstChildNodeMatching(node, (short)1, XML_ELM_ELEMENTMANAGERS);
        if (elementManager != null) {
            Node device = this.getFirstChildNodeMatching(elementManager, (short)1, XML_ELM_DEVICE);
            while (device != null) {
                this.addDevice(device);
                device = this.getNextSiblingNodeMatching(device, (short)1, XML_ELM_DEVICE);
            }
        }
    }

    private void addDevice(Node device) {
        try {
            String GUID2 = this.getAttribute(device, XML_ATTR_GUID);
            if (GUID2 != null) {
                ArrayList<ElementManager> managerList = new ArrayList<ElementManager>();
                Node manager = this.getFirstChildNodeMatching(device, (short)1, XML_ELM_MANAGER);
                while (manager != null) {
                    managerList.add(new ElementManager(GUID2, this.getAttribute(this.getFirstChildNodeMatching(manager, (short)1, XML_ELM_DISPLAYNAME), XML_ATTR_VALUE), this.getAttribute(this.getFirstChildNodeMatching(manager, (short)1, XML_ELM_LAUNCHSTRING), XML_ATTR_VALUE)));
                    manager = this.getNextSiblingNodeMatching(manager, (short)1, XML_ELM_MANAGER);
                }
                this.userDefinedElementManagers.put(GUID2, managerList);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(Util.getString("ELEMENT_MANAGER_ERROR_CORRUPT"));
        }
    }

    private String getAttribute(Node device, String name) {
        NamedNodeMap nodeMap = device.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            if (!this.isMatchingNode(nodeMap.item(i), (short)2, name)) continue;
            return nodeMap.item(i).getNodeValue();
        }
        throw new RuntimeException(Util.getString("ELEMENT_MANAGER_ERROR_CORRUPT"));
    }

    private Node getFirstMatchingNode(Node node, short nodeType, String nodeName) {
        Node child;
        for (child = node; child != null && !this.isMatchingNode(child, nodeType, nodeName); child = child.getNextSibling()) {
        }
        return child;
    }

    private Node getNextSiblingNodeMatching(Node node, short nodeType, String nodeName) {
        return this.getFirstMatchingNode(node.getNextSibling(), nodeType, nodeName);
    }

    private Node getFirstChildNodeMatching(Node node, short nodeType, String nodeName) {
        return this.getFirstMatchingNode(node.getFirstChild(), nodeType, nodeName);
    }

    private boolean isMatchingNode(Node node, short nodeType, String nodeName) {
        return node.getNodeType() == nodeType && node.getNodeName().equalsIgnoreCase(nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveElementManagers() {
        boolean retval = true;
        OutputStream stream = null;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element elementManagers = document.createElement(XML_ELM_ELEMENTMANAGERS);
            document.appendChild(elementManagers);
            for (String GUID2 : this.userDefinedElementManagers.keySet()) {
                ArrayList managerList = (ArrayList)this.userDefinedElementManagers.get(GUID2);
                if (managerList == null) continue;
                Element deviceNode = document.createElement(XML_ELM_DEVICE);
                deviceNode.setAttribute(XML_ATTR_GUID, GUID2);
                elementManagers.appendChild(deviceNode);
                for (int j = 0; j < managerList.size(); ++j) {
                    ElementManager manager = (ElementManager)managerList.get(j);
                    Element managerNode = document.createElement(XML_ELM_MANAGER);
                    deviceNode.appendChild(managerNode);
                    Element displayNameNode = document.createElement(XML_ELM_DISPLAYNAME);
                    displayNameNode.setAttribute(XML_ATTR_VALUE, manager.managerDisplayName);
                    managerNode.appendChild(displayNameNode);
                    Element launchStringNode = document.createElement(XML_ELM_LAUNCHSTRING);
                    launchStringNode.setAttribute(XML_ATTR_VALUE, manager.managerLaunchString);
                    managerNode.appendChild(launchStringNode);
                }
            }
            document.normalize();
            SerializerFactory serializerFactory = SerializerFactory.getSerializerFactory((String)"xml");
            OutputFormat of = new OutputFormat(document);
            of.setLineSeparator(System.getProperty("line.separator"));
            of.setIndenting(true);
            stream = GuiConfig.getFileOutputStream(elementDBFile);
            Serializer serializer = serializerFactory.makeSerializer(stream, of);
            serializer.asDOMSerializer().serialize(document);
            stream.flush();
        }
        catch (Exception e) {
            retval = false;
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8204E", this.getExceptionMessage(e)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
        return retval;
    }

    private void getGUIProperties() {
        this.guiProperties.setProperty(PROPERTY_URLREGEXP, DEFAULT_URLREGEXP);
        this.guiProperties.setProperty(PROPERTY_UNIXEXECPREAMBLE, DEFAULT_UNIXEXECPREAMBLE);
        this.guiProperties.setProperty(PROPERTY_UNIXURLPREAMBLE, DEFAULT_UNINXURLPREAMBLE);
        this.guiProperties.setProperty(PROPERTY_WINDOWSEXECPREAMBLE, "cmd /c start \"\" ");
        this.guiProperties.setProperty(PROPERTY_WINDOWSURLPREAMBLE, "cmd /c start \"\" ");
        Properties tempProperties = new Properties();
        try {
            GuiConfig.loadProperties(guiConfigFile, tempProperties);
            this.guiProperties.putAll((Map<?, ?>)tempProperties);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8206E", this.getExceptionMessage(e)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
    }

    private String getGUIProperty(String propertyName, String defaultValue) {
        String value = this.guiProperties.getProperty(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static synchronized ElementManagerManager getInstance() {
        if (instance == null) {
            instance = new ElementManagerManager();
        }
        return instance;
    }

    public void launchElementManager(Object element, ElementManagerHelperInterface provider) {
        Object[] elementManagers = this.getElementManagers(element, provider);
        if (elementManagers == null || elementManagers.length == 0) {
            this.displayNoManagerDialog(element, provider);
        } else {
            String elementManager = elementManagers.length == 1 ? elementManagers[0] : (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8203I", provider.extractDisplayName(element)), Util.getString("ELEMENT_MANAGER_SELECT_TITLE"), 3, null, elementManagers, elementManagers[0]);
            if (elementManager != null) {
                this.doLaunch(elementManager);
            }
        }
    }

    public boolean hasElementManager(Object element, ElementManagerHelperInterface provider) {
        return this.getElementManager(element, provider) != null;
    }

    public String getElementManager(Object element, ElementManagerHelperInterface provider) {
        String manager;
        ElementManager elementManager = this.getLocalManager(provider.extractGUID(element));
        if (elementManager == null) {
            manager = provider.extractDefaultElementManager(element);
            if (manager != null && (manager.length() == 0 || manager.matches(WHITESPACE_REGEXP))) {
                manager = null;
            }
        } else {
            manager = elementManager.managerLaunchString;
        }
        if (manager != null && manager.length() == 0) {
            manager = null;
        }
        return manager;
    }

    public String[] getElementManagers(Object element, ElementManagerHelperInterface provider) {
        ElementManager[] elementManagers;
        ArrayList<String> managers = new ArrayList<String>();
        String manager = provider.extractDefaultElementManager(element);
        if (manager != null && manager.length() != 0 && !manager.matches(WHITESPACE_REGEXP)) {
            managers.add(manager);
        }
        if ((elementManagers = this.getLocalManagers(provider.extractGUID(element))) != null) {
            for (int i = 0; i < elementManagers.length; ++i) {
                managers.add(elementManagers[i].managerLaunchString);
            }
        }
        return managers.toArray(new String[managers.size()]);
    }

    public void setElementManager(Object element, String manager, ElementManagerHelperInterface provider) {
        this.setLocalManager(provider.extractGUID(element), provider.extractDisplayName(element), manager);
    }

    public void setElementManagerDialog(Object element, ElementManagerHelperInterface provider) {
        Object[] message;
        String elementManager = null;
        String[] elementManagers = this.getElementManagers(element, provider);
        JTextField newElement = new JTextField();
        if (elementManagers != null && elementManagers.length != 0) {
            newElement.setText(elementManagers[0]);
            message = new Object[]{MessageLog.getMessageNoID("GUI8200I", provider.extractDisplayName(element)), newElement, new JComboBox<String>(elementManagers)};
        } else {
            message = new Object[]{MessageLog.getMessageNoID("GUI8200I", provider.extractDisplayName(element)), newElement};
        }
        int response = JOptionPane.showOptionDialog(this.guiMain.getFrame(), message, Util.getString("ELEMENT_MANAGER_EDIT_TITLE"), 2, 3, null, null, null);
        if (response != 0) {
            return;
        }
        elementManager = newElement.getText().trim();
        if (elementManager.length() != 0) {
            if (elementManagers != null) {
                for (int i = 0; i < elementManagers.length; ++i) {
                    if (!elementManager.equals(elementManagers[i])) continue;
                    return;
                }
            }
            this.setElementManager(element, elementManager, provider);
        } else {
            this.deleteElementManager(element, provider);
        }
    }

    public void deleteElementManager(Object element, ElementManagerHelperInterface provider) {
        this.deleteLocalManager(provider.extractGUID(element));
    }

    public void deleteElementManagerDialog(Object element, ElementManagerHelperInterface provider) {
        Object[] localManagers = this.getLocalManagersElementLaunchString(provider.extractGUID(element));
        if (localManagers != null && localManagers.length > 0) {
            if (localManagers.length == 1) {
                int choice = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8202I", localManagers[0], provider.extractDisplayName(element)), Util.getString("ELEMENT_MANAGER_DELETE_TITLE"), 0);
                if (choice == 0) {
                    this.deleteElementManager(element, provider);
                }
            } else {
                String dElementManagerLaunchString = (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8202I", "", provider.extractDisplayName(element)), Util.getString("ELEMENT_MANAGER_DELETE_TITLE"), 3, null, localManagers, localManagers[0]);
                if (dElementManagerLaunchString != null) {
                    this.deleteLocalManager(provider.extractGUID(element), dElementManagerLaunchString);
                }
            }
        } else {
            this.displayNoManagerDialog(element, provider);
        }
    }

    private String getWindowsLauncher(String thing) {
        String preamble = this.isURL(thing) ? this.getWindowsURLPreamble() : this.getWindowsExecPreamble();
        return preamble + " " + thing;
    }

    private String[] getUnixLauncher(String thing) {
        ArrayList<String> al = new ArrayList<String>();
        if (this.isURL(thing)) {
            int response;
            String unixURLPreamble = this.getUnixURLPreamble();
            if (unixURLPreamble.trim().startsWith("$")) {
                unixURLPreamble = this.getUnixEnv(unixURLPreamble);
            }
            if (unixURLPreamble.equals("") && (response = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8209E"), Util.getString("ELEMENT_MANAGER_NO_DEFAULT_BROWSER_TITLE"), 2)) == 0) {
                new EditElementManagerConfigDialog(this.guiMain.getFrame());
                unixURLPreamble = this.getUnixURLPreamble();
                if (unixURLPreamble.trim().startsWith("$")) {
                    unixURLPreamble = this.getUnixEnv(unixURLPreamble);
                }
            }
            if (!unixURLPreamble.equals("")) {
                al.add(unixURLPreamble);
                al.add(thing);
            } else {
                JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8201E"), Util.getString("ELEMENT_MANAGER_NO_DEFAULT_BROWSER_TITLE"), 0);
            }
        } else {
            StringTokenizer st = new StringTokenizer(this.getUnixExecPreamble());
            while (st.hasMoreTokens()) {
                al.add(st.nextToken());
            }
            al.add(thing);
        }
        return al.toArray(new String[al.size()]);
    }

    private boolean isURL(String thing) {
        return thing.matches(this.getURLRegexp());
    }

    private void displayNoManagerDialog(Object element, ElementManagerHelperInterface provider) {
        JOptionPane.showMessageDialog(this.guiMain.getFrame(), MessageLog.getMessageNoID("GUI8201I", provider.extractDisplayName(element)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
    }

    private void doLaunch(String elementManager) {
        try {
            if (GuiConfig.isWindows()) {
                Runtime.getRuntime().exec(this.getWindowsLauncher(elementManager));
            } else {
                String[] cmd = this.getUnixLauncher(elementManager);
                if (cmd.length > 0) {
                    Runtime.getRuntime().exec(cmd);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8205E", this.getExceptionMessage(e)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
    }

    private String getLocalManagerElementLaunchString(String GUID2) {
        ElementManager elementManager = this.getLocalManager(GUID2);
        if (elementManager == null) {
            return null;
        }
        return elementManager.managerLaunchString;
    }

    private String[] getLocalManagersElementLaunchString(String GUID2) {
        ElementManager[] elementManagers = this.getLocalManagers(GUID2);
        if (elementManagers == null) {
            return null;
        }
        String[] launchStrings = new String[elementManagers.length];
        for (int i = 0; i < launchStrings.length; ++i) {
            launchStrings[i] = elementManagers[i].managerLaunchString;
        }
        return launchStrings;
    }

    private String getLocalManagerDisplayName(String GUID2) {
        ElementManager elementManager = this.getLocalManager(GUID2);
        if (elementManager == null) {
            return null;
        }
        return elementManager.managerDisplayName;
    }

    private ElementManager getLocalManager(String GUID2) {
        ArrayList al = (ArrayList)this.userDefinedElementManagers.get(GUID2);
        if (al != null) {
            return (ElementManager)al.get(0);
        }
        return null;
    }

    private ElementManager[] getLocalManagers(String GUID2) {
        ArrayList al = (ArrayList)this.userDefinedElementManagers.get(GUID2);
        if (al != null) {
            return al.toArray(new ElementManager[al.size()]);
        }
        return null;
    }

    private void setLocalManager(String GUID2, String displayName, String manager) {
        ArrayList<ElementManager> al = (ArrayList<ElementManager>)this.userDefinedElementManagers.get(GUID2);
        if (al == null) {
            al = new ArrayList<ElementManager>();
        }
        al.add(0, new ElementManager(GUID2, displayName, manager));
        this.userDefinedElementManagers.put(GUID2, al);
        this.saveElementManagers();
    }

    private void deleteLocalManager(String GUID2) {
        this.userDefinedElementManagers.remove(GUID2);
        this.saveElementManagers();
    }

    private void deleteLocalManager(String GUID2, String elementManagerLaunchString) {
        ArrayList managerList = (ArrayList)this.userDefinedElementManagers.get(GUID2);
        for (int i = 0; i < managerList.size(); ++i) {
            ElementManager manager = (ElementManager)managerList.get(i);
            if (!manager.managerLaunchString.equals(elementManagerLaunchString)) continue;
            managerList.remove(i);
            break;
        }
        this.userDefinedElementManagers.put(GUID2, managerList);
        this.saveElementManagers();
    }

    private String getURLRegexp() {
        return this.guiProperties.getProperty(PROPERTY_URLREGEXP);
    }

    public String getWindowsExecPreamble() {
        return this.guiProperties.getProperty(PROPERTY_WINDOWSEXECPREAMBLE);
    }

    public String getWindowsURLPreamble() {
        return this.guiProperties.getProperty(PROPERTY_WINDOWSURLPREAMBLE);
    }

    public String getUnixExecPreamble() {
        return this.guiProperties.getProperty(PROPERTY_UNIXEXECPREAMBLE);
    }

    public String getUnixURLPreamble() {
        return this.guiProperties.getProperty(PROPERTY_UNIXURLPREAMBLE);
    }

    public String[][] getAllUserDefinedManagers() {
        String[][] managers = new String[this.userDefinedElementManagers.size()][];
        Iterator i = this.userDefinedElementManagers.keySet().iterator();
        int j = 0;
        while (i.hasNext()) {
            String key = (String)i.next();
            ElementManager[] value = this.getLocalManagers(key);
            managers[j] = new String[value.length + 2];
            managers[j][0] = value[0].managerGUID;
            managers[j][1] = value[0].managerDisplayName;
            for (int k = 0; k < value.length; ++k) {
                managers[j][k + 2] = value[k].managerLaunchString;
            }
            ++j;
        }
        return managers;
    }

    public boolean setAllUserDefinedManagers(String[][] managers) {
        this.userDefinedElementManagers.clear();
        for (int i = 0; i < managers.length; ++i) {
            ArrayList<ElementManager> al = new ArrayList<ElementManager>();
            for (int j = 2; j < managers[i].length; ++j) {
                al.add(new ElementManager(managers[i][0], managers[i][1], managers[i][j]));
            }
            this.userDefinedElementManagers.put(managers[i][0], al);
        }
        return this.saveElementManagers();
    }

    public boolean setModifiedUserDefinedManagers(String[][] modifiedManagers) {
        for (int i = 0; i < modifiedManagers.length; ++i) {
            ArrayList<ElementManager> managers = new ArrayList<ElementManager>();
            for (int j = 2; j < modifiedManagers[i].length; ++j) {
                managers.add(new ElementManager(modifiedManagers[i][0], modifiedManagers[i][1], modifiedManagers[i][j]));
            }
            if (managers.size() > 0) {
                this.userDefinedElementManagers.put(modifiedManagers[i][0], managers);
                continue;
            }
            this.userDefinedElementManagers.remove(modifiedManagers[i][0]);
        }
        return this.saveElementManagers();
    }

    public HashMap getConfig() {
        HashMap extConf = new HashMap();
        for (Object key : this.guiProperties.keySet()) {
            extConf.put(this.internal2external.get(key), this.guiProperties.get(key));
        }
        return extConf;
    }

    public boolean setConfig(HashMap config) {
        boolean retval = true;
        Properties tempProperties = new Properties();
        if (config != null) {
            for (Object extKey : config.keySet()) {
                tempProperties.setProperty((String)this.external2internal.get(extKey), (String)config.get(extKey));
            }
        }
        try {
            GuiConfig.storeProperties(guiConfigFile, tempProperties);
            this.guiProperties.clear();
            this.getGUIProperties();
        }
        catch (Exception e) {
            retval = false;
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), Util.getString("GUI8207E", this.getExceptionMessage(e)), Util.getString("ELEMENT_MANAGER_LAUNCH_TITLE"), 0);
        }
        return retval;
    }

    private String getUnixEnv(String var) {
        StringBuffer stdout = new StringBuffer();
        try {
            String line;
            Process proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo " + var});
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                stdout.append(line);
            }
            proc.waitFor();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return stdout.toString().trim();
    }

    private class ElementManager
    implements Serializable {
        String managerGUID;
        String managerDisplayName;
        String managerLaunchString;

        public ElementManager(String managerGUID, String managerDisplayName, String managerLaunchString) {
            this.managerGUID = managerGUID;
            this.managerDisplayName = managerDisplayName;
            this.managerLaunchString = managerLaunchString;
        }
    }
}

