/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;

public class GuiConfig {
    private static final String windowsUserConfigDir = "Application Data" + File.separator + "Aperi" + File.separator + "config";
    private static final String unixUserConfigDir = ".Aperi" + File.separator + "config";

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("windows");
    }

    public static void loadProperties(String filename, Properties properties) throws IOException {
        File propertyFile = new File(GuiConfig.getUserConfigDir().append(File.separator).append(filename).toString());
        BufferedInputStream in = null;
        if (propertyFile.canRead()) {
            try {
                in = new BufferedInputStream(new FileInputStream(propertyFile));
                properties.load(in);
                ((InputStream)in).close();
            }
            catch (FileNotFoundException f) {
                // empty catch block
            }
        }
    }

    public static void storeProperties(String filename, Properties properties) throws IOException, FileNotFoundException {
        StringBuffer dir = GuiConfig.getUserConfigDir();
        GuiConfig.mkDirectory(dir.toString());
        File propertyFile = new File(dir.append(File.separator).append(filename).toString());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(propertyFile));
        properties.store(out, null);
        ((OutputStream)out).close();
    }

    public static boolean mkDirectory(String dir) {
        File configDir = new File(dir);
        return configDir.isDirectory() && configDir.canWrite() || configDir.mkdirs();
    }

    public static StringBuffer getUserConfigDir() {
        StringBuffer dir = new StringBuffer(System.getProperty("user.home", ""));
        dir.append(File.separator);
        if (GuiConfig.isWindows()) {
            dir.append(windowsUserConfigDir);
        } else {
            dir.append(unixUserConfigDir);
        }
        return dir;
    }

    public static FileInputStream getFileInputStream(String fileName) throws FileNotFoundException {
        StringBuffer dir = GuiConfig.getUserConfigDir();
        File file = new File(dir.append(File.separator).append(fileName).toString());
        if (file.canRead()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public static FileOutputStream getFileOutputStream(String fileName) throws FileNotFoundException {
        StringBuffer dir = GuiConfig.getUserConfigDir();
        GuiConfig.mkDirectory(dir.toString());
        File file = new File(dir.append(File.separator).append(fileName).toString());
        return new FileOutputStream(file);
    }
}

