/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.DirtyListenerInterface;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleData;

public class RolesGridBagPanel
extends GridBagPanel {
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    HashMap model = new HashMap();
    private String NO_MAPPING = Util.getString("ROLES_CFG_NO_MAPPING");
    private DirtyListenerInterface dirtyListener;
    private static HashMap name2Type = new HashMap();
    private static HashMap type2Name = new HashMap();
    private static String[] typeNames;

    private int type2Position(int typeID) {
        return Arrays.binarySearch(typeNames, (String)type2Name.get(new Integer(typeID)));
    }

    public RolesGridBagPanel(HashMap model) {
        this.setTitle(Util.getString("ROLES_CFG_MAIN_TITLE"));
        this.buildPanel(model);
    }

    private void buildPanel(HashMap model) {
        ArrayList al = new ArrayList(model.keySet());
        Collections.sort(al);
        Collections.reverse(al);
        if (al.contains(RoleChecker.APERI_ADMINISTRATOR)) {
            al.remove(RoleChecker.APERI_ADMINISTRATOR);
            al.add(0, RoleChecker.APERI_ADMINISTRATOR);
        }
        if (al.contains(RoleChecker.APERI_SUPERUSER)) {
            al.remove(RoleChecker.APERI_SUPERUSER);
            al.add(0, RoleChecker.APERI_SUPERUSER);
        }
        Iterator i = al.iterator();
        while (i.hasNext()) {
            this.buildRow((RoleData)model.get((String)i.next()));
        }
        this.createStretchBox();
    }

    private void buildRow(RoleData groupMap) {
        RoleRow roleRow = new RoleRow();
        roleRow.groupMap = groupMap;
        String roleName = groupMap.getRoleName();
        String globalizedRoleName = this.getGlobalizedRoleName(roleName);
        this.add(new JLabel(globalizedRoleName));
        roleRow.groupNameTextField = new JTextField();
        roleRow.groupNameTextField.setEditable(false);
        this.add((JComponent)roleRow.groupNameTextField, 21, 2);
        roleRow.groupTypeComboBox = new JComboBox<String>(typeNames);
        roleRow.groupTypeComboBox.setSelectedIndex(this.type2Position(groupMap.getGroupType()));
        roleRow.groupTypeComboBox.setActionCommand(groupMap.getRoleName());
        roleRow.groupTypeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                RolesGridBagPanel.this.editTypeField(ae.getActionCommand());
            }
        });
        this.model.put(groupMap.getRoleName(), roleRow);
        this.setGroup(groupMap.getRoleName(), groupMap.getGroupName());
        this.setType(groupMap.getRoleName(), groupMap.getGroupType());
        JButton editButton = new JButton(Util.getString("ROLES_CFG_EDIT"));
        editButton.setActionCommand(roleName);
        boolean editable = true;
        int id = RoleChecker.getRoleID(roleName);
        if (id == RoleChecker.SUPERUSER && !this.capabilities.isSuperuser()) {
            editable = false;
        }
        if (editable) {
            editButton.setEnabled(true);
            editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RolesGridBagPanel.this.editTextField(ae.getActionCommand());
                }
            });
        } else {
            editButton.setEnabled(false);
        }
        this.add((JComponent)editButton, 21, 0);
        JButton deleteButton = new JButton(Util.getString("ROLES_CFG_DELETE"));
        if (editable) {
            deleteButton.setEnabled(true);
            deleteButton.setActionCommand(groupMap.getRoleName());
            deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    RolesGridBagPanel.this.deleteTextField(ae.getActionCommand());
                }
            });
        } else {
            deleteButton.setEnabled(false);
        }
        this.add((JComponent)deleteButton, 21, 0);
        roleRow.allowDelete = editable;
        roleRow.deleteButton = deleteButton;
        deleteButton.setEnabled(editable && !this.getGroup(groupMap.getRoleName()).equals(this.NO_MAPPING));
        this.newRow();
    }

    private String getGlobalizedRoleName(String roleName) {
        String globalizedName = null;
        if (roleName.equals(RoleChecker.APERI_SUPERUSER)) {
            globalizedName = Util.getString("ROLE_SUPERUSER");
        } else if (roleName.equals(RoleChecker.APERI_ADMINISTRATOR)) {
            globalizedName = Util.getString("ROLE_ADMIN");
        } else if (roleName.equals(RoleChecker.DISK_ADMINISTRATOR)) {
            globalizedName = Util.getString("ROLE_DISK_AD");
        } else if (roleName.equals(RoleChecker.DISK_OPERATOR)) {
            globalizedName = Util.getString("ROLE_DISK_OP");
        } else if (roleName.equals(RoleChecker.FABRIC_ADMINISTRATOR)) {
            globalizedName = Util.getString("ROLE_FABRIC_AD");
        } else if (roleName.equals(RoleChecker.FABRIC_OPERATOR)) {
            globalizedName = Util.getString("ROLE_FABRIC_OP");
        } else if (roleName.equals(RoleChecker.DATA_ADMINISTRATOR)) {
            globalizedName = Util.getString("ROLE_DATA_AD");
        } else if (roleName.equals(RoleChecker.DATA_OPERATOR)) {
            globalizedName = Util.getString("ROLE_DATA_OP");
        } else if (roleName.equals(RoleChecker.TAPE_ADMINISTRATOR)) {
            globalizedName = Util.getString("ROLE_TAPE_AD");
        } else if (roleName.equals(RoleChecker.TAPE_OPERATOR)) {
            globalizedName = Util.getString("ROLE_TAPE_OP");
        }
        return globalizedName;
    }

    private void setGroup(String role, String group) {
        if (group != null) {
            group = group.trim();
        }
        if (group == null || group.length() == 0 || group.equalsIgnoreCase(this.NO_MAPPING)) {
            group = this.NO_MAPPING;
        }
        RoleRow row = (RoleRow)this.model.get(role);
        row.groupNameTextField.setText(group);
        row.groupMap.setGroupName(group);
    }

    private void setType(String role, int type) {
        ((RoleRow)this.model.get((Object)role)).groupMap.setGroupType(type);
    }

    private RoleRow getRow(String role) {
        return (RoleRow)this.model.get(role);
    }

    private String getType(String role) {
        return (String)this.getRow((String)role).groupTypeComboBox.getSelectedItem();
    }

    private String getGroup(String role) {
        String rez = this.getRow((String)role).groupNameTextField.getText();
        return rez != null ? rez.trim() : null;
    }

    protected void editTypeField(String role) {
        this.setType(role, this.mapType(this.getType(role)));
        this.talkDirty(role);
    }

    private int mapType(String type) {
        return (Integer)name2Type.get(type);
    }

    protected void editTextField(String role) {
        String group;
        String oldGroup = group = this.getGroup(role);
        String globalizedRoleName = this.getGlobalizedRoleName(role);
        group = (String)JOptionPane.showInputDialog(this.guiMain.getFrame(), Util.getString("GUI8001I", globalizedRoleName), Util.getString("ROLES_CFG_EDIT_DIALOG"), 3, null, null, group);
        if (group != null) {
            group = group.trim();
            if (role.equals(RoleChecker.APERI_SUPERUSER) && !oldGroup.equals(this.NO_MAPPING) && (group.trim().length() == 0 || group.equalsIgnoreCase(this.NO_MAPPING)) && !this.askConfirmDeleteSuperuser(role, oldGroup)) {
                return;
            }
            this.setGroup(role, group);
            this.getRow((String)role).deleteButton.setEnabled(this.getRow((String)role).allowDelete && !this.getGroup(role).equals(this.NO_MAPPING));
            if (!oldGroup.equals(this.getGroup(role))) {
                this.talkDirty(role);
            }
        }
    }

    protected void deleteTextField(String role) {
        String group = this.getGroup(role);
        String globalizedRoleName = this.getGlobalizedRoleName(role);
        if (!group.equals(this.NO_MAPPING)) {
            boolean confirmed = true;
            if (role.equals(RoleChecker.APERI_SUPERUSER)) {
                confirmed = this.askConfirmDeleteSuperuser(role, group);
            } else {
                int choice = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), Util.getString("GUI8000I", group, globalizedRoleName), Util.getString("ROLES_CFG_DELETE_DIALOG"), 0);
                boolean bl = confirmed = choice == 0;
            }
            if (confirmed) {
                this.setGroup(role, null);
                this.getRow((String)role).deleteButton.setEnabled(false);
                this.talkDirty(role);
            }
        }
    }

    public HashMap getModel() {
        HashMap<String, RoleData> newModel = new HashMap<String, RoleData>(this.model);
        for (String key : newModel.keySet()) {
            RoleRow row = this.getRow(key);
            RoleData map = row.groupMap;
            if (row.groupNameTextField.getText().compareTo(this.NO_MAPPING) == 0) {
                map.setGroupName(null);
            } else {
                map.setGroupName(row.groupNameTextField.getText());
            }
            map.setGroupType((Integer)name2Type.get(row.groupTypeComboBox.getSelectedItem()));
            newModel.put(key, map);
        }
        return newModel;
    }

    private void talkDirty(String label) {
        if (this.dirtyListener != null) {
            this.dirtyListener.dirtyTalk(this, label);
        }
    }

    public void addDirtyListener(DirtyListenerInterface dirtyListener) {
        this.dirtyListener = dirtyListener;
    }

    public void removeDirtyListener(DirtyListenerInterface dirtyListener) {
        if (this.dirtyListener == this.dirtyListener) {
            this.dirtyListener = null;
        }
    }

    private boolean askConfirmDeleteSuperuser(String role, String group) {
        String globalizedRoleName = this.getGlobalizedRoleName(role);
        int choice = JOptionPane.showConfirmDialog(this.guiMain.getFrame(), Util.getString("GUI8218W", group, globalizedRoleName), Util.getString("ROLES_CFG_MAIN_TITLE"), 0, 2);
        return choice == 0;
    }

    public boolean validatePanel(Hashtable dirtyRows) {
        return true;
    }

    static {
        name2Type.put("Local", new Integer(RoleData.LOCAL_GROUP));
        name2Type.put("Domain", new Integer(RoleData.DOMAIN_GROUP));
        name2Type.put("Active Directory", new Integer(RoleData.ACTIVE_DIR_GROUP));
        name2Type.put("LDAP", new Integer(RoleData.LDAP_GROUP));
        typeNames = name2Type.keySet().toArray(new String[0]);
        Arrays.sort(typeNames);
        for (Object key : name2Type.keySet()) {
            type2Name.put(name2Type.get(key), key);
        }
    }

    private static class RoleRow {
        RoleData groupMap;
        JTextField groupNameTextField;
        JComboBox groupTypeComboBox;
        JButton deleteButton;
        boolean allowDelete;

        private RoleRow() {
        }
    }
}

