/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertSummary
extends PanelClasses {
    private JPanel panel;
    private JPanel titlePanel;
    private JPanel alertPanel;
    private GridBagConstraints gbcIndent;
    private GridBagConstraints gbcPlop;
    private GridBagConstraints gbcLast;
    private Insets insetA;
    private Insets insetB;
    private Insets insetC;
    private static final DecimalFormat decimalFormatter = new DecimalFormat();
    private static final String NA = MessageLog.getMessageNoID("STG0019T");

    public AlertSummary(DashTotalsRow pTotalsRow) {
        super(pTotalsRow);
    }

    public Component getComponent(Object whatever, boolean AddListener) {
        this.gbcIndent = new GridBagConstraints();
        this.gbcPlop = new GridBagConstraints();
        this.gbcLast = new GridBagConstraints();
        this.insetA = new Insets(1, 0, 2, 9);
        this.insetB = new Insets(1, 0, 2, 1);
        this.insetC = new Insets(1, 0, 2, 0);
        this.gbcIndent.anchor = 17;
        this.gbcIndent.insets = this.insetA;
        this.gbcPlop.anchor = 17;
        this.gbcPlop.insets = this.insetB;
        this.gbcLast.gridwidth = 0;
        this.gbcLast.insets = this.insetC;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.alertPanel = GuiUtil.getPanel();
        this.titlePanel.add(this.getLabel("STG5240L"));
        BoldLabel allAlertsLabel = this.getLabel("STG0005T");
        BoldLabel computerAlertsLabel = this.getLabel("STG1102L");
        BoldLabel hardDiskAlertsLabel = this.getLabel("STG1240L");
        BoldLabel filesystemAlertsLabel = this.getLabel("STG5003L");
        BoldLabel storageSubsystemLabel = this.getLabel("SAG0001L");
        BoldLabel switchLabel = this.getLabel("STG2702L");
        BoldLabel fabricLabel = this.getLabel("STG2700L");
        BoldLabel endpointDeviceLabel = this.getLabel("STG2704L");
        BoldLabel externalLabel = this.getLabel("STG2707L");
        BoldLabel tapeLibraryLabel = this.getLabel("STG7737L");
        String allAlertsActiveDesc = Util.getString("DESC_DASH_ALERTALL_ACTIVE");
        String computerAlertsActiveDesc = Util.getString("DESC_DASH_ALERTCOMPUTER_ACTIVE");
        String hardDiskAlertsActiveDesc = Util.getString("DESC_DASH_ALERTDISK_ACTIVE");
        String filesystemAlertsActiveDesc = Util.getString("DESC_DASH_ALERTFS_ACTIVE");
        String strorageSubsytemAlertsActiveDesc = Util.getString("DESC_DASH_ALERT_SSUBSYST_ACTIVE");
        String switchAlertsActiveDesc = Util.getString("DESC_DASH_ALERTSWITCH_ACTIVE");
        String fabricAlertsActiveDesc = Util.getString("DESC_DASH_ALERTFABRIC_ACTIVE");
        String endpointDeviceAlertsActiveDesc = Util.getString("DESC_DASH_ALERTENDPOINT_ACTIVE");
        String externalAlertsActiveDesc = Util.getString("DESC_DASH_ALERTEXTERNAL_ACTIVE");
        String tapeLibraryAlertsActiveDesc = Util.getString("TAPE_LIB_ALERTS");
        Object[] args = new Object[]{GuiUtil.getUserName()};
        String userMsg = MessageLog.getMessageNoID("STG5241L", args);
        BoldLabel userAlertsLabel = new BoldLabel(userMsg);
        String userAlertsActiveDesc = MessageLog.getMessageNoID("STG5279L", args);
        this.addLine(allAlertsLabel, AlertSummary.totalsRow.dtrAllAlerts, allAlertsActiveDesc);
        this.addLine(computerAlertsLabel, AlertSummary.totalsRow.dtrComputerAlerts, computerAlertsActiveDesc);
        this.addLine(hardDiskAlertsLabel, AlertSummary.totalsRow.dtrHardDiskAlerts, hardDiskAlertsActiveDesc);
        this.addLine(filesystemAlertsLabel, AlertSummary.totalsRow.dtrFilesystemAlerts, filesystemAlertsActiveDesc);
        this.addLine(userAlertsLabel, AlertSummary.totalsRow.dtrUserAlerts, userAlertsActiveDesc);
        this.addLine(storageSubsystemLabel, AlertSummary.totalsRow.dtrStorageSubsystemAlerts, strorageSubsytemAlertsActiveDesc);
        this.addLine(switchLabel, AlertSummary.totalsRow.dtrSwitchAlerts, switchAlertsActiveDesc);
        this.addLine(fabricLabel, AlertSummary.totalsRow.dtrFabricAlerts, fabricAlertsActiveDesc);
        this.addLine(endpointDeviceLabel, AlertSummary.totalsRow.dtrEndpointDeviceAlerts, endpointDeviceAlertsActiveDesc);
        this.addLine(externalLabel, AlertSummary.totalsRow.dtrExternalAlerts, externalAlertsActiveDesc);
        this.addLine(tapeLibraryLabel, AlertSummary.totalsRow.dtrTapeLibraryAlerts, tapeLibraryAlertsActiveDesc);
        GuiUtil.completePanel(this.alertPanel);
        this.panel.add((Component)this.titlePanel, "North");
        this.panel.add((Component)this.alertPanel, "Center");
        return this.panel;
    }

    private BoldLabel getLabel(String msg) {
        return new BoldLabel(MessageLog.getMessageNoID(msg));
    }

    private JLabel getNumber(int num) {
        if (num < 0) {
            return new JLabel(NA);
        }
        return new JLabel(decimalFormatter.format(num));
    }

    private void addLine(JLabel label, int number, String activeAlert) {
        JLabel datum = this.getNumber(number);
        if (number > 0) {
            label.setForeground(Color.red);
            datum.setForeground(Color.red);
            GuiUtil.setAccessibleDescription(label, activeAlert);
            label.setFont(label.getFont().deriveFont(3));
        }
        this.alertPanel.add((Component)label, this.gbcIndent);
        this.alertPanel.add((Component)datum, this.gbcPlop);
        this.alertPanel.add((Component)new JLabel(" "), this.gbcLast);
    }
}

