/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.dashboard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.dashboard.DashMain;
import org.eclipse.aperi.gui.dashboard.PanelClasses;
import org.eclipse.aperi.server.guireq.DashTotalsRow;
import org.eclipse.aperi.xmsg.MessageLog;

public class SystemSummary
extends PanelClasses {
    private JPanel panel;
    private JPanel titlePanel;
    private JPanel summaryPanel;
    private GridBagConstraints gbcIndent;
    private GridBagConstraints gbcPlop;
    private GridBagConstraints gbcLast;
    private Insets insetA;
    private Insets insetB;
    private Insets insetC;
    private static final DecimalFormat decimalFormatter = new DecimalFormat();
    private static final String NA = MessageLog.getMessageNoID("STG0019T");
    private static final String IS_DOWN = "STG5254L";
    private static final String ARE_DOWN = "STG5255L";

    public SystemSummary(DashTotalsRow pTotalsRow) {
        super(pTotalsRow);
    }

    public Component getComponent(Object whatever, boolean addListeners) {
        this.gbcIndent = new GridBagConstraints();
        this.gbcPlop = new GridBagConstraints();
        this.gbcLast = new GridBagConstraints();
        if (DashMain.screenWidth <= 800) {
            this.insetA = new Insets(1, 0, 1, 9);
            this.insetB = new Insets(1, 0, 1, 1);
            this.insetC = new Insets(1, 0, 1, 0);
        } else {
            this.insetA = new Insets(1, 0, 2, 9);
            this.insetB = new Insets(1, 0, 2, 1);
            this.insetC = new Insets(1, 0, 2, 0);
        }
        this.gbcIndent.anchor = 17;
        this.gbcIndent.insets = this.insetA;
        this.gbcPlop.anchor = 17;
        this.gbcPlop.gridwidth = 2;
        this.gbcPlop.insets = this.insetB;
        this.gbcLast.gridwidth = 0;
        this.gbcLast.insets = this.insetC;
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.titlePanel = new JPanel();
        this.summaryPanel = GuiUtil.getPanel();
        this.titlePanel.add(this.getLabel("STG5238L"));
        BoldLabel FsCapacityLabel = this.getLabel("STG2092L");
        BoldLabel UsedSpaceLabel = this.getLabel("STG2005L");
        BoldLabel FreeSpaceLabel = this.getLabel("STG2006L");
        BoldLabel DiskCapacityLabel = this.getLabel("STG1115L");
        BoldLabel DiskUnallocatedLabel = this.getLabel("STG5235L");
        BoldLabel NumStorageSysLabel = this.getLabel("STG4191L");
        BoldLabel NumLunsLabel = this.getLabel("STG4198L");
        BoldLabel LunCapacityLabel = this.getLabel("STG6059L");
        BoldLabel UsableLunCapLabel = this.getLabel("STG6080L");
        BoldLabel NumAgentsLabel = this.getLabel("STG5228L");
        BoldLabel NumComputersLabel = this.getLabel("STG5229L");
        BoldLabel NumDisksLabel = this.getLabel("STG5231L");
        BoldLabel NumFsLabel = this.getLabel("STG5232L");
        JLabel FsCapacity = this.getSize(SystemSummary.totalsRow.dtrFilesystemCapacity);
        JLabel UsedSpace = this.getSize(SystemSummary.totalsRow.dtrUsedSpace);
        JLabel FreeSpace = this.getSize(SystemSummary.totalsRow.dtrFreeSpace);
        JLabel DiskCapacity = this.getSize(SystemSummary.totalsRow.dtrDiskCapacity);
        JLabel DiskUnallocated = this.getSize(SystemSummary.totalsRow.dtrDiskUnallocated);
        JLabel LunCapacity = this.getSize(SystemSummary.totalsRow.dtrLunCapacity);
        JLabel UsableLunCap = this.getSize(SystemSummary.totalsRow.dtrUsableLunCap);
        if (SystemSummary.totalsRow.dtrTotalComputers < 0) {
            SystemSummary.totalsRow.dtrTotalComputers = 0;
        }
        JLabel NumStorageSys = this.getNumber(SystemSummary.totalsRow.dtrTotalStorageSubsystems);
        JLabel NumLuns = this.getNumber(SystemSummary.totalsRow.dtrTotalLUNs);
        JLabel NumAgents = this.getNumber(SystemSummary.totalsRow.dtrTotalAgents);
        JLabel NumAgentsDown = this.getAgentsDown();
        JLabel NumComputers = this.getNumber(SystemSummary.totalsRow.dtrTotalComputers);
        JLabel NumDisks = this.getNumber(SystemSummary.totalsRow.dtrTotalDisks);
        JLabel NumFs = this.getNumber(SystemSummary.totalsRow.dtrTotalFilesystems);
        this.addLine(FsCapacityLabel, FsCapacity);
        this.addLine(UsedSpaceLabel, UsedSpace);
        this.addLine(FreeSpaceLabel, FreeSpace);
        this.addLine(DiskCapacityLabel, DiskCapacity);
        this.addLine(DiskUnallocatedLabel, DiskUnallocated);
        if (SystemSummary.totalsRow.dtrTotalStorageSubsystems > 0) {
            this.addLine(LunCapacityLabel, LunCapacity);
            this.addLine(UsableLunCapLabel, UsableLunCap);
        }
        if (NumAgentsDown == null) {
            this.addLine(NumAgentsLabel, NumAgents);
        } else {
            this.gbcPlop.gridwidth = 1;
            this.addLine(NumAgentsLabel, NumAgents, NumAgentsDown);
            this.gbcPlop.gridwidth = 2;
        }
        this.addLine(NumComputersLabel, NumComputers);
        if (SystemSummary.totalsRow.dtrTotalStorageSubsystems > 0) {
            this.addLine(NumStorageSysLabel, NumStorageSys);
        }
        this.addLine(NumDisksLabel, NumDisks);
        if (SystemSummary.totalsRow.dtrTotalStorageSubsystems > 0) {
            this.addLine(NumLunsLabel, NumLuns);
        }
        this.addLine(NumFsLabel, NumFs);
        GuiUtil.completePanel(this.summaryPanel);
        this.panel.add((Component)this.titlePanel, "North");
        this.panel.add((Component)this.summaryPanel, "Center");
        return this.panel;
    }

    private JLabel getAgentsDown() {
        JLabel numAgentsDown = null;
        if (SystemSummary.totalsRow.dtrTotalAgentsDown > 0) {
            String down = SystemSummary.totalsRow.dtrTotalAgentsDown == 1 ? IS_DOWN : ARE_DOWN;
            String number = decimalFormatter.format(SystemSummary.totalsRow.dtrTotalAgentsDown);
            numAgentsDown = new JLabel(" (" + MessageLog.getMessageNoID(down, number) + ")");
            numAgentsDown.setForeground(Color.red);
            GuiUtil.setAccessibleDescription(numAgentsDown, numAgentsDown.getText());
            numAgentsDown.setFont(numAgentsDown.getFont().deriveFont(3));
        }
        return numAgentsDown;
    }

    private BoldLabel getLabel(String msg) {
        return new BoldLabel(MessageLog.getMessageNoID(msg));
    }

    private JLabel getSize(long size) {
        if (size <= 0L) {
            return new JLabel(NA);
        }
        return new JLabel(Util.formatBytes(size * 512L));
    }

    private JLabel getNumber(int num) {
        if (num <= 0) {
            return new JLabel(NA);
        }
        return new JLabel(decimalFormatter.format(num));
    }

    private void addLine(JLabel label, JLabel datum) {
        this.addLine(label, datum, null);
    }

    private void addLine(JLabel label, JLabel datum1, JLabel datum2) {
        this.summaryPanel.add((Component)label, this.gbcIndent);
        this.summaryPanel.add((Component)datum1, this.gbcPlop);
        if (datum2 != null) {
            this.summaryPanel.add((Component)datum2, this.gbcPlop);
        }
        this.summaryPanel.add((Component)new JLabel(" "), this.gbcLast);
    }
}

