/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.common.model;

import java.io.Serializable;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.common.model.DataAccessor;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.request.Response;

public class DiskDataAccessor {
    private static DiskDataAccessor diskDataAccessor = null;

    public static DiskDataAccessor getInstance() {
        if (diskDataAccessor == null) {
            diskDataAccessor = new DiskDataAccessor();
        }
        return diskDataAccessor;
    }

    public void getAllStorageSubsystems(GuiRequestor requestor) {
        GUIRequestData reqData = new GUIRequestData(0);
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getSubsystemPorts(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(1);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getHostPortsBySubsystem(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(2);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getStoragePoolsBySubsytstem(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(3);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getIOGroupsBySVC(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(4);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getMDiskGroupsBySVC(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(5);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getUnmanagedMDisksBySVC(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(6);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getSupportedRaidLevels(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(7);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getMaxVolumes(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(8);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getAssignedHostPortsBySubsystem(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(9);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getStorageSubsystemCapabilities(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(12);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void getVolumeIdsBySubsystem(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(30);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolumeNamesBySubsystem(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(51);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolumesBySubsystem(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(31);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolumeIdsByStoragePool(GuiRequestor requestor, String subsystemId, String stgpoolId) {
        GUIRequestData reqData = new GUIRequestData(32);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("storagepool.id", (Serializable)((Object)stgpoolId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolumesByStoragePool(GuiRequestor requestor, String subsystemId, String stgpoolId) {
        GUIRequestData reqData = new GUIRequestData(33);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("storagepool.id", (Serializable)((Object)stgpoolId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolumeIdsByHost(GuiRequestor requestor, String subsystemId, String hostId) {
        GUIRequestData reqData = new GUIRequestData(34);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("host.id", (Serializable)((Object)hostId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolumesByHost(GuiRequestor requestor, String subsystemId, String hostId) {
        GUIRequestData reqData = new GUIRequestData(35);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("host.id", (Serializable)((Object)hostId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolume(GuiRequestor requestor, String subsystemId, String volumeId) {
        GUIRequestData reqData = new GUIRequestData(36);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("volume.id", (Serializable)((Object)volumeId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getMDisksByMDiskGroup(GuiRequestor requestor, String subsystemId, String mdiskGroupId) {
        GUIRequestData reqData = new GUIRequestData(37);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("mdiskgroup.id", (Serializable)((Object)mdiskGroupId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDiskIdsByIOGroup(GuiRequestor requestor, String subsystemId, String ioGroupId) {
        GUIRequestData reqData = new GUIRequestData(38);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("iogroup.id", (Serializable)((Object)ioGroupId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDiskIdsByMDiskGroup(GuiRequestor requestor, String subsystemId, String mdiskgroupId) {
        GUIRequestData reqData = new GUIRequestData(39);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("mdiskgroup.id", (Serializable)((Object)mdiskgroupId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDisksByMDiskGroup(GuiRequestor requestor, String subsystemId, String mdiskgroupId) {
        GUIRequestData reqData = new GUIRequestData(40);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("mdiskgroup.id", (Serializable)((Object)mdiskgroupId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDiskIdsByHost(GuiRequestor requestor, String subsystemId, String hostId) {
        GUIRequestData reqData = new GUIRequestData(41);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("host.id", (Serializable)((Object)hostId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDisksByHost(GuiRequestor requestor, String subsystemId, String hostId) {
        GUIRequestData reqData = new GUIRequestData(42);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("host.id", (Serializable)((Object)hostId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDiskIdsBySVC(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(43);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDisksBySVC(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(44);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVDisk(GuiRequestor requestor, String subsystemId, String vdiskId) {
        GUIRequestData reqData = new GUIRequestData(45);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("vdisk.id", (Serializable)((Object)vdiskId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getPortAssignments(GuiRequestor requestor, String subsystemId, String volumeId) {
        GUIRequestData reqData = new GUIRequestData(46);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("volume.id", (Serializable)((Object)volumeId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getPortAssignmentsExt(GuiRequestor requestor, String subsystemId, String[] volumeIds) {
        GUIRequestData reqData = new GUIRequestData(49);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("volume.ids", (Serializable)volumeIds);
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getVolumeSizeRange(GuiRequestor requestor, String subsystemId, String stgpoolId) {
        GUIRequestData reqData = new GUIRequestData(47);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("storagepool.id", (Serializable)((Object)stgpoolId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void areVolumeActionsInProgress(GuiRequestor requestor, String subsystemId) {
        GUIRequestData reqData = new GUIRequestData(48);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public void getFabrics(GuiRequestor requestor) {
        GUIRequestData reqData = new GUIRequestData(71);
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler", reqData);
    }

    public void getActiveZoneSet(GuiRequestor requestor, String fabricId) {
        GUIRequestData reqData = new GUIRequestData(72);
        reqData.addParameter("fabric.id", (Serializable)((Object)fabricId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler", reqData);
    }

    public void getZones(GuiRequestor requestor, String fabricId, String zoneSetId) {
        GUIRequestData reqData = new GUIRequestData(73);
        reqData.addParameter("fabric.id", (Serializable)((Object)fabricId));
        reqData.addParameter("zoneset.id", (Serializable)((Object)zoneSetId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler", reqData);
    }

    public void getPortsByZone(GuiRequestor requestor, String fabricId, String zoneSetId, String zoneId) {
        GUIRequestData reqData = new GUIRequestData(74);
        reqData.addParameter("fabric.id", (Serializable)((Object)fabricId));
        reqData.addParameter("zoneset.id", (Serializable)((Object)zoneSetId));
        reqData.addParameter("zone.id", (Serializable)((Object)zoneId));
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.FabricInfoHandler", reqData);
    }

    public void setStorageSubsystemAttributes(GuiRequestor requestor, String subsystemId, Hashtable attributes) {
        GUIRequestData reqData = new GUIRequestData(10);
        reqData.addParameter("subsystem.id", (Serializable)((Object)subsystemId));
        reqData.addParameter("subsystem.attrs", attributes);
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.SubsystemInfoHandler", reqData);
    }

    public void deleteStorageSubsystems(GuiRequestor requestor, String[] subsystemIds, String[] ssInternalIds) {
        GUIRequestData reqData = new GUIRequestData(11);
        reqData.addParameter("subsystem.ids", (Serializable)subsystemIds);
        reqData.addParameter("subsystem.internalIds", (Serializable)ssInternalIds);
        DataAccessor.sendDeviceRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.DiskDeviceActionHandler", DeviceRequest.DR_DISK, reqData);
    }

    public void setStorageVolumeAttributes(GuiRequestor requestor, String volumeId, Hashtable attributes) {
        GUIRequestData reqData = new GUIRequestData(50);
        reqData.addParameter("volume.id", (Serializable)((Object)volumeId));
        reqData.addParameter("volume.attrs", attributes);
        DataAccessor.sendGuiRequest(requestor, "org.eclipse.aperi.server.handler.gui.disk.VolumeInfoHandler", reqData);
    }

    public static void test() {
        DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
        diskAccessor.getAllStorageSubsystems(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        });
        diskAccessor.getSubsystemPorts(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1");
        diskAccessor.getHostPortsBySubsystem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1");
        diskAccessor.getStoragePoolsBySubsytstem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "2");
        diskAccessor.getIOGroupsBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5");
        diskAccessor.getMDiskGroupsBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5");
        diskAccessor.getUnmanagedMDisksBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5");
        diskAccessor.getVDiskIdsByIOGroup(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5", "3");
        diskAccessor.getMDisksByMDiskGroup(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5", "502");
        diskAccessor.getVolumeIdsBySubsystem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1");
        diskAccessor.getVolumesBySubsystem(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "2");
        diskAccessor.getVolumeIdsByStoragePool(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1", "2");
        diskAccessor.getVolumesByStoragePool(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "2", "102");
        diskAccessor.getVolumeIdsByHost(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1", "1");
        diskAccessor.getVolumesByHost(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "2", "1");
        diskAccessor.getVolume(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1", "3");
        diskAccessor.getVDiskIdsBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5");
        diskAccessor.getVDisksBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5");
        diskAccessor.getVDiskIdsByMDiskGroup(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5", "501");
        diskAccessor.getVDisksByMDiskGroup(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5", "501");
        diskAccessor.getVDiskIdsByHost(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5", "1");
        diskAccessor.getVDisksByHost(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5", "1");
        diskAccessor.getVDisk(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "5", "502");
        diskAccessor.getPortAssignments(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1", "1");
        diskAccessor.getActiveZoneSet(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "2");
        diskAccessor.getZones(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1", "1");
        diskAccessor.getPortsByZone(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "2", "2", "12");
        diskAccessor.areVolumeActionsInProgress(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
            }
        }, "1");
    }
}

