/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.common.model;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.disk.common.CIMOMSelectorDbHelper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.IoGroup;
import org.eclipse.aperi.infrastructure.database.objects.Runs;
import org.eclipse.aperi.infrastructure.database.objects.StorageExtent;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.database.tables.TResIoGroupTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageExtentTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TRunsTable;
import org.eclipse.aperi.logging.TraceLogger;

public abstract class DiskDbAccessor {
    public static HashMap[] getStorageSubsystemCapabilities(String[] pSubsystemInternalIDs, String[] pAttribList, LogTraceHelper pLTH) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getStorageSubsystemCapabilities", pSubsystemInternalIDs[0]);
        }
        HashMap[] mSSCArray = new HashMap[pSubsystemInternalIDs.length];
        for (int mLoop = 0; mLoop < pSubsystemInternalIDs.length; ++mLoop) {
            int subsysId = Integer.parseInt(pSubsystemInternalIDs[mLoop]);
            Object[] mCIMOMInfos = CIMOMSelectorDbHelper.Subsystem.getCimomInformation(subsysId);
            if (mCIMOMInfos == null || mCIMOMInfos.length <= 0) continue;
            Arrays.sort(mCIMOMInfos);
            int mCapabiltyDataId = CIMOMSelectorDbHelper.Subsystem.getCorrespondingCapabilityDataId(((CIMOMSelectorDbHelper.CIMOMInformation)mCIMOMInfos[0]).getNamespaceId(), subsysId);
            CapabilityData mCapability = CIMOMSelectorDbHelper.getCapabilityData(mCapabiltyDataId);
            mSSCArray[mLoop] = DiskReportingHelper.getAttributes(mCapability, pAttribList, pLTH);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getStorageSubsystemCapabilities", mSSCArray);
        }
        return mSSCArray;
    }

    public static HashMap[] getMDisksByMDiskGroup(String pMDiskGroupID, String[] pAttribList, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksByMDiskGroup", pMDiskGroupID);
        }
        String query = "select * FROM T_RES_STORAGE_EXTENT where  POOL_ID = " + pMDiskGroupID + " AND MODE <> 0 ";
        return DiskDbAccessor.executeQuery(query, pAttribList, pConn);
    }

    private static Hashtable getMDisksWhereClause(String pMDiskGroupID, LogTraceHelper pLTH) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksWhereClause", pMDiskGroupID);
        }
        Hashtable<ColumnInfo, String> mReturn = new Hashtable<ColumnInfo, String>();
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "POOL_ID", pLTH);
        mReturn.put(mInfo, pMDiskGroupID);
        int mode = 2;
        ColumnInfo mInfoMode = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "MODE", pLTH);
        mReturn.put(mInfoMode, String.valueOf(mode));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getMDisksWhereClause", mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap[] getMDisksBySVC(String pSubsystemID, int mode, String[] pAttribList, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksBySVC", pSubsystemID + ", " + mode);
        }
        Hashtable mWhereClause = DiskDbAccessor.getMDisksBySVCWhereClause(pSubsystemID, mode, pLTH);
        StorageExtent.StorageExtentCursor mCursor = null;
        Vector<HashMap> mdisks = new Vector<HashMap>();
        try {
            mCursor = StorageExtent.getCursor(pConn, mWhereClause, null);
            while (mCursor.next()) {
                StorageExtent mCurrInst = mCursor.getAttributes();
                HashMap mMDiskAttrs = DiskReportingHelper.getAttributes(mCurrInst, pAttribList, pLTH);
                mdisks.add(mMDiskAttrs);
            }
        }
        finally {
            try {
                if (mCursor != null) {
                    mCursor.close();
                }
            }
            catch (Exception ignore) {}
            pConn.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getMDisksBySVC", mdisks);
        }
        return mdisks.toArray(new HashMap[0]);
    }

    private static Hashtable getMDisksBySVCWhereClause(String pSubsystemID, int mode, LogTraceHelper pLTH) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getMDisksBySVCWhereClause", pSubsystemID + "," + mode);
        }
        Hashtable<ColumnInfo, String> mReturn = new Hashtable<ColumnInfo, String>();
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "SUBSYSTEM_ID", pLTH);
        mReturn.put(mInfo, pSubsystemID);
        if (mode != -1) {
            ColumnInfo mInfoMode = DiskReportingHelper.getColumnInfo(TResStorageExtentTable.class, "MODE", pLTH);
            mReturn.put(mInfoMode, String.valueOf(mode));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getMDisksBySVCWhereClause", mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap[] getIOGroupsBySVC(String pSvcID, String[] pAttribList, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getIOGroupsBySVC", pSvcID);
        }
        Hashtable mWhereClause = DiskDbAccessor.getIOGroupsWhereClause(pSvcID, pLTH);
        IoGroup.IoGroupCursor mCursor = null;
        Vector<HashMap> ioGroups = new Vector<HashMap>();
        try {
            mCursor = IoGroup.getCursor(pConn, mWhereClause, null);
            while (mCursor.next()) {
                IoGroup mCurrInst = mCursor.getAttributes();
                HashMap mIoGroupAttrs = DiskReportingHelper.getAttributes(mCurrInst, pAttribList, pLTH);
                ioGroups.add(mIoGroupAttrs);
            }
        }
        finally {
            try {
                if (mCursor != null) {
                    mCursor.close();
                }
            }
            catch (Exception ignore) {}
            pConn.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getIOGroupsBySVC", ioGroups);
        }
        return ioGroups.toArray(new HashMap[0]);
    }

    private static Hashtable getIOGroupsWhereClause(String pSubsystemID, LogTraceHelper pLTH) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getIOGroupsWhereClause", pSubsystemID);
        }
        Hashtable<ColumnInfo, String> mReturn = new Hashtable<ColumnInfo, String>();
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(TResIoGroupTable.class, "SUBSYSTEM_ID", pLTH);
        mReturn.put(mInfo, pSubsystemID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getIOGroupsWhereClause", mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getVDiskIdsForByIOGroup(String subsystemID, String ioGroupID, HashMap pAttributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException, InvalidParameterException, MissingParameterException, IDParseException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getVDiskIdsForByIOGroup", subsystemID + ", " + ioGroupID);
        }
        LinkedList<Object> mReturn = new LinkedList<Object>();
        Hashtable mWhereClause = DiskDbAccessor.getVDiskByIOGroupWhereClause(ioGroupID, pLTH);
        StorageVolume.StorageVolumeCursor mCursor = null;
        try {
            mCursor = StorageVolume.getCursor(pConn, mWhereClause, null);
            while (mCursor.next()) {
                StorageVolume mVolCurrInst = mCursor.getAttributes();
                Object mSSub = null;
                mReturn.add(ExternalKeyConverter.getStorageVolumeKey(mVolCurrInst, subsystemID, pLTH));
            }
        }
        finally {
            try {
                if (mCursor != null) {
                    mCursor.close();
                }
            }
            catch (Exception ignore) {}
            pConn.commit();
        }
        String[] mTest = new String[]{};
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getVDiskIdsForByIOGroup", mReturn);
        }
        return mReturn.toArray(mTest);
    }

    private static Hashtable getVDiskByIOGroupWhereClause(String pIOGroupID, LogTraceHelper pLTH) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getVDiskByIOGroupWhereClause", pIOGroupID);
        }
        Hashtable<ColumnInfo, String> mReturn = new Hashtable<ColumnInfo, String>();
        ColumnInfo mInfo = DiskReportingHelper.getColumnInfo(TResStorageVolumeTable.class, "IO_GROUP_ID", pLTH);
        mReturn.put(mInfo, pIOGroupID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getVDiskByIOGroupWhereClause", mReturn);
        }
        return mReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateSubsystemAttributes(String pSubsystemID, Hashtable attributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException {
        int retcode;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "updateSubsystemAttributes", pSubsystemID);
        }
        Hashtable mWhereClause = ExternalKeyConverter.getStorageSubsystemWhereClause(pSubsystemID, pLTH);
        Hashtable htinput = new Hashtable();
        for (String key : attributes.keySet()) {
            htinput.put(TResStorageSubsystemTable.getColumnInfo(key), attributes.get(key));
        }
        try {
            retcode = StorageSubsystem.update(pConn, htinput, mWhereClause);
        }
        finally {
            pConn.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "updateSubsystemAttributes", retcode);
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int updateVolumeAttributes(String pVolumeID, Hashtable attributes, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException {
        int retcode;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "updateVolumeAttributes", pVolumeID);
        }
        Hashtable mWhereClause = ExternalKeyConverter.getVolumeWhereclause(pLTH, pVolumeID, pConn);
        Hashtable htinput = new Hashtable();
        for (String key : attributes.keySet()) {
            htinput.put(TResStorageVolumeTable.getColumnInfo(key), attributes.get(key));
        }
        try {
            retcode = StorageVolume.update(pConn, htinput, mWhereClause);
        }
        finally {
            pConn.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "updateVolumeAttributes", retcode);
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberOfJobs(int scheduleID, int status, LogTraceHelper pLTH, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getNumberOfJobs", "" + scheduleID + ", " + status);
        }
        int numJobs = 0;
        Hashtable<ColumnInfo, String> mWhereClause = new Hashtable<ColumnInfo, String>();
        ColumnInfo sidnfo = DiskReportingHelper.getColumnInfo(TRunsTable.class, "SCHEDULE_ID", pLTH);
        mWhereClause.put(sidnfo, String.valueOf(scheduleID));
        ColumnInfo statusInfo = DiskReportingHelper.getColumnInfo(TRunsTable.class, "STATUS", pLTH);
        mWhereClause.put(statusInfo, String.valueOf(status));
        Runs.RunsCursor mCursor = null;
        try {
            mCursor = Runs.getCursor(pConn, mWhereClause, null);
            while (mCursor.next()) {
                Runs mRunCurrInst = mCursor.getAttributes();
                numJobs += mRunCurrInst.getNumberJobs();
            }
        }
        finally {
            try {
                if (mCursor != null) {
                    mCursor.close();
                }
            }
            catch (Exception ignore) {}
            pConn.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "getNumberOfJobs", numJobs);
        }
        return numJobs;
    }

    public static HashMap[] getVolumeNamesForSubsystem(String subsystemID, String[] pAttribList, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getVolumeNamesForSubsystem", subsystemID);
        }
        String query = "select DISPLAY_NAME from T_RES_STORAGE_VOLUME  where SUBSYSTEM_ID = " + subsystemID;
        return DiskDbAccessor.executeQuery(query, pAttribList, pConn);
    }

    public static HashMap[] getPort2HostMapping(String[] pAttribList, DBConnection pConn) throws ServerException, SQLException {
        String query = "select distinct PORT.NAME AS PORT_WWN, H2P.HOST_URL from   T_VIEW_HOST2PORT H2P, T_RES_PORT PORT where  PORT.PORT_ID = H2P.PORT_ID and HOST_URL is not NULL";
        return DiskDbAccessor.executeQuery(query, pAttribList, pConn);
    }

    public static HashMap[] getPortsForSubsystem(String subsystemID, String[] pAttribList, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getPortsForSubsystem", subsystemID);
        }
        String query = "select distinct PORT.PORT_ID, PORT.NAME as PORT_WWN, PORT2FABRIC.FABRIC_WWN,  CAST (null as varchar(255)) HOST_URL, CAST (null as varchar(255)) SUBSYSTEM_DISPLAY_NAME  from T_RES_PORT PORT LEFT JOIN T_VIEW_ALL_PORTS PORT2FABRIC on PORT.NAME = PORT2FABRIC.PORT_WWN  where PORT.SUBSYSTEM_ID = " + subsystemID;
        if (pConn.getConnection().getClass().getName().contains("derby")) {
            return null;
        }
        return DiskDbAccessor.executeQuery(query, pAttribList, pConn);
    }

    public static HashMap[] getHostPortsInFabricForSubsystem(String subsystemID, String[] pAttribList, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getHostPortsForSubsystem", subsystemID);
        }
        String query = "select distinct PORT_WWN, FABRIC_WWN, HOST_URL, SUBSYSTEM_DISPLAY_NAME  from T_VIEW_ALL_PORTS   where FABRIC_WWN in (select distinct FABRIC_WWN from T_VIEW_ALL_PORTS where SUBSYSTEM_ID = " + subsystemID + ") " + " and (SUBSYSTEM_ID IS NULL or (SUBSYSTEM_TYPE = 'SVC' and SUBSYSTEM_ID <> " + subsystemID + ")) ";
        if (pConn.getConnection().getClass().getName().contains("derby")) {
            return null;
        }
        return DiskDbAccessor.executeQuery(query, pAttribList, pConn);
    }

    public static HashMap[] getDefinedHostPortsForSubsystem(String subsystemID, String[] pAttribList, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "getHostPortsForSubsystem", subsystemID);
        }
        String query = "select distinct PORT.NAME as PORT_WWN, CAST (null as char(16)) FABRIC_WWN, HOST2PORT.HOST_URL as HOST_URL,  CAST (null as varchar(255)) SUBSYSTEM_DISPLAY_NAME   from  T_RES_PORT PORT, T_VIEW_HOST2PORT HOST2PORT left outer join T_VIEW_HOSTPORT2FABRIC HOSTPORT2FABRIC on HOST2PORT.PORT_ID = HOSTPORT2FABRIC.PORT_ID where PORT.PORT_ID = HOST2PORT.PORT_ID and HOSTPORT2FABRIC.PORT_ID is null";
        if (pConn.getConnection().getClass().getName().contains("derby")) {
            return null;
        }
        return DiskDbAccessor.executeQuery(query, pAttribList, pConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap[] executeQuery(String query, String[] pAttribList, DBConnection pConn) throws ServerException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(DiskDbAccessor.class.getName(), "executeQuery", query);
        }
        Vector results = new Vector();
        DBResultSet dbr = null;
        try {
            dbr = ComplexQuery.sqlQuery(pConn, query, null);
            while (dbr.next()) {
                HashMap<String, Object> attribMap = new HashMap<String, Object>();
                for (int i = 0; i < pAttribList.length; ++i) {
                    String key = pAttribList[i];
                    attribMap.put(key, dbr.getObject(key));
                }
                results.add(attribMap);
            }
        }
        catch (Exception e) {
            pConn.rollback();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(DiskDbAccessor.class.getName(), "executeQuery", e);
            }
        }
        finally {
            block19: {
                try {
                    if (dbr != null) {
                        dbr.getStatement().close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block19;
                    TraceLogger.exception(DiskDbAccessor.class.getName(), "executeQuery", e);
                }
            }
            pConn.commit();
        }
        HashMap[] resultsMap = results.toArray(new HashMap[0]);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "executeQuery", results);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(DiskDbAccessor.class.getName(), "executeQuery", resultsMap);
        }
        return resultsMap;
    }
}

