/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BoldLabel;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.request.Response;

public class SubsystemDetailsPanel
extends JPanel
implements ActionListener {
    private GUIStorageSubsystem subsystem;
    private SubsystemDDI theDDI;
    private GridBagConstraints c = new GridBagConstraints();
    private JPanel summaryPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private JLabel lbSubsystem = new JLabel();
    private JLabel lbState;
    private JLabel lbVendor = new JLabel();
    private JLabel lbType = new JLabel();
    private JLabel lbUsedCapacity = new JLabel();
    private JLabel lbUnusedCapacity = new JLabel();
    private JLabel lbSerialNumber = new JLabel();
    private JLabel lbRevision = new JLabel();
    private JLabel lbManagementAddress = new JLabel();
    private BoldLabel lbManuallyName = new BoldLabel();
    private JLabel lbIpAddress = new JLabel();
    private BoldLabel lbUdp1 = new BoldLabel();
    private BoldLabel lbUdp2 = new BoldLabel();
    private BoldLabel lbUdp3 = new BoldLabel();
    private JTextField txManuallyName = new JTextField();
    private JTextField txUdp1 = new JTextField();
    private JTextField txUdp2 = new JTextField();
    private JTextField txUdp3 = new JTextField();
    private JButton buLaunch = new JButton();
    private JButton buSet = new JButton();
    private JButton buReset = new JButton();
    private String savedName = null;
    private String savedUdp1 = null;
    private String savedUdp2 = null;
    private String savedUdp3 = null;
    private String savedElmMgr = "";
    private boolean redisplay = false;
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object element) {
            return "subsystem:" + ((GUIStorageSubsystem)element).getInternalId();
        }

        public String extractDefaultElementManager(Object element) {
            return ((GUIStorageSubsystem)element).getElementManager();
        }

        public String extractDisplayName(Object element) {
            return ((GUIStorageSubsystem)element).getName();
        }
    };

    public SubsystemDetailsPanel(GUIStorageSubsystem sys, SubsystemDDI ddi) {
        this.theDDI = ddi;
        this.subsystem = sys;
    }

    public JComponent getComponent() {
        this.setLayout(new FlowLayout(0));
        this.summaryPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout());
        this.c.anchor = 17;
        this.c.insets = new Insets(3, 3, 3, 10);
        this.c.fill = 2;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_STORAGE_SUBSYS_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.lbSubsystem.setText(GUIEntityUtil.getDisplayText(this.subsystem.getDeviceId()));
        this.summaryPanel.add((Component)this.lbSubsystem, this.c);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.lbManuallyName.setText(Util.getString("DISK_COMMON_LABEL"));
        this.summaryPanel.add((Component)this.lbManuallyName, this.c);
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.txManuallyName.setText(GUIEntityUtil.getDisplayText(this.subsystem.getUserProvidedName()));
        GuiUtil.setAccessible(this.txManuallyName, this.txManuallyName.getText(), this.txManuallyName.getText());
        GuiUtil.setAccessibleLabel(this.lbManuallyName, this.txManuallyName, "", this.lbManuallyName.getText(), this.lbManuallyName.getText());
        this.summaryPanel.add((Component)this.txManuallyName, this.c);
        this.savedName = this.txManuallyName.getText();
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_STATE_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 3;
        this.lbState = GUIEntityUtil.getEntityStateLabel(this.subsystem);
        this.summaryPanel.add((Component)this.lbState, this.c);
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_VENDOR_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 4;
        String vendor = this.subsystem.getVendor();
        if (vendor != null && vendor.equalsIgnoreCase("UNKNOWN")) {
            vendor = Util.getString("DISK_COMMON_UNKNOWN");
        }
        this.lbVendor.setText(GUIEntityUtil.getDisplayText(vendor));
        this.summaryPanel.add((Component)this.lbVendor, this.c);
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_TYPE_SUBSYS_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 5;
        if (this.subsystem.getType() == 0) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_ESS"));
        } else if (this.subsystem.getType() == 1) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_FASTT"));
        } else if (this.subsystem.getType() == 2) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_DS6000"));
        } else if (this.subsystem.getType() == 3) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_DS8000"));
        } else if (this.subsystem.getType() == 4) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_SVC"));
        } else if (this.subsystem.getType() == 5) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_HDS"));
        } else if (this.subsystem.getType() == 6) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_EMC"));
        } else if (this.subsystem.getType() == 7) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_HP"));
        } else if (this.subsystem.getType() == 9) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_FUJITSU"));
        } else if (this.subsystem.getType() == 8) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_SUN"));
        } else if (this.subsystem.getType() == 10) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_HPXP128"));
        } else if (this.subsystem.getType() == 99) {
            this.lbType.setText(Util.getString("DISK_SUBSYSTEMS_TYPE_OTHER"));
        }
        this.summaryPanel.add((Component)this.lbType, this.c);
        this.c.gridx = 0;
        this.c.gridy = 6;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_UNUSEDCAP_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 6;
        double unusedCap = GUIEntityUtil.convertStorageCapacity(this.subsystem.getUnusedCapacity(), 0, 3, 10);
        this.lbUnusedCapacity.setText(GUIEntityUtil.getNumberString(new Double(unusedCap), 2, Locale.getDefault()));
        this.summaryPanel.add((Component)this.lbUnusedCapacity, this.c);
        this.c.gridx = 0;
        this.c.gridy = 7;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_USEDCAP_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 7;
        double usedCap = GUIEntityUtil.convertStorageCapacity(this.subsystem.getUsedCapacity(), 0, 3, 10);
        this.lbUsedCapacity.setText(GUIEntityUtil.getNumberString(new Double(usedCap), 2, Locale.getDefault()));
        this.summaryPanel.add((Component)this.lbUsedCapacity, this.c);
        this.c.gridx = 0;
        this.c.gridy = 8;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_SERIAL_NUMBER_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 8;
        this.lbSerialNumber.setText(GUIEntityUtil.getDisplayText(this.subsystem.getSerialNumber()));
        this.summaryPanel.add((Component)this.lbSerialNumber, this.c);
        this.c.gridx = 0;
        this.c.gridy = 9;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_REVISION_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 9;
        this.lbRevision.setText(GUIEntityUtil.getDisplayText(this.subsystem.getRevision()));
        this.summaryPanel.add((Component)this.lbRevision, this.c);
        this.c.gridx = 0;
        this.c.gridy = 10;
        this.lbUdp1.setText(Util.getString("DISK_UDP1_LABEL"));
        this.summaryPanel.add((Component)this.lbUdp1, this.c);
        this.c.gridx = 1;
        this.c.gridy = 10;
        this.txUdp1.setText(GUIEntityUtil.getDisplayText(this.subsystem.getUserAttrib1()));
        this.summaryPanel.add((Component)this.txUdp1, this.c);
        GuiUtil.setAccessible(this.txUdp1, this.txUdp1.getText(), this.txUdp1.getText());
        GuiUtil.setAccessibleLabel(this.lbUdp1, this.txUdp1, "", this.lbUdp1.getText(), this.txUdp1.getText());
        this.savedUdp1 = this.txUdp1.getText();
        this.c.gridx = 0;
        this.c.gridy = 11;
        this.lbUdp2.setText(Util.getString("DISK_UDP2_LABEL"));
        this.summaryPanel.add((Component)this.lbUdp2, this.c);
        this.c.gridx = 1;
        this.c.gridy = 11;
        this.txUdp2.setText(GUIEntityUtil.getDisplayText(this.subsystem.getUserAttrib2()));
        this.summaryPanel.add((Component)this.txUdp2, this.c);
        GuiUtil.setAccessible(this.txUdp2, this.txUdp2.getText(), this.txUdp2.getText());
        GuiUtil.setAccessibleLabel(this.lbUdp2, this.txUdp2, "", this.lbUdp2.getText(), this.txUdp2.getText());
        this.savedUdp2 = this.txUdp2.getText();
        this.c.gridx = 0;
        this.c.gridy = 12;
        this.lbUdp3.setText(Util.getString("DISK_UDP3_LABEL"));
        this.summaryPanel.add((Component)this.lbUdp3, this.c);
        this.c.gridx = 1;
        this.c.gridy = 12;
        this.txUdp3.setText(GUIEntityUtil.getDisplayText(this.subsystem.getUserAttrib3()));
        this.summaryPanel.add((Component)this.txUdp3, this.c);
        GuiUtil.setAccessible(this.txUdp3, this.txUdp3.getText(), this.txUdp3.getText());
        GuiUtil.setAccessibleLabel(this.lbUdp3, this.txUdp3, "", this.lbUdp3.getText(), this.txUdp3.getText());
        this.savedUdp3 = this.txUdp3.getText();
        this.c.gridx = 0;
        this.c.gridy = 13;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_COMMON_IP_ADDRESS")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 13;
        this.lbIpAddress.setText(GUIEntityUtil.getDisplayText(this.subsystem.getIpAddress()));
        this.summaryPanel.add((Component)this.lbIpAddress, this.c);
        this.c.gridx = 0;
        this.c.gridy = 14;
        this.summaryPanel.add((Component)new BoldLabel(Util.getString("DISK_MANAGEMENT_ADDRESS_LABEL")), this.c);
        this.c.gridx = 1;
        this.c.gridy = 14;
        this.savedElmMgr = ElementManagerManager.getInstance().getElementManager(this.subsystem, this.getElementManagerHelper());
        this.lbManagementAddress.setText(GUIEntityUtil.getDisplayText(this.savedElmMgr));
        this.summaryPanel.add((Component)this.lbManagementAddress, this.c);
        this.buLaunch.setText(Util.getString("DISK_LAUNCH_ELEMENT_MANAGER_LABEL"));
        this.buLaunch.setEnabled(ElementManagerManager.getInstance().hasElementManager(this.subsystem, this.getElementManagerHelper()));
        this.buLaunch.addActionListener(this);
        this.buttonPanel.add(this.buLaunch);
        GuiUtil.setAccessible(this.buLaunch, this.buLaunch.getText(), this.buLaunch.getText());
        this.buSet.setText(Util.getString("DISK_SET_LAUNCHELEMENTMGR_BUTTON"));
        this.buSet.addActionListener(this);
        this.buttonPanel.add(this.buSet);
        GuiUtil.setAccessible(this.buSet, this.buSet.getText(), this.buSet.getText());
        this.buReset.setText(Util.getString("DISK_RESET_LAUNCHELEMENTMGR_BUTTON"));
        this.buReset.addActionListener(this);
        this.buttonPanel.add(this.buReset);
        GuiUtil.setAccessible(this.buReset, this.buReset.getText(), this.buReset.getText());
        this.c.gridx = 1;
        this.c.gridy = 15;
        this.c.insets = new Insets(3, 0, 3, 10);
        this.summaryPanel.add((Component)this.buttonPanel, this.c);
        this.add((Component)this.summaryPanel, "Before");
        this.showAndAddListeners();
        return this;
    }

    public void showAndAddListeners() {
        this.guiMain.setSaveActionEnabled(true, false);
        this.guiMain.addSaveActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (e.getActionCommand().equals("Save")) {
            this.saveAll(true);
        } else if (source == this.buLaunch) {
            ElementManagerManager.getInstance().launchElementManager(this.subsystem, this.getElementManagerHelper());
        } else if (source == this.buSet) {
            ElementManagerManager.getInstance().setElementManagerDialog(this.subsystem, this.getElementManagerHelper());
            this.lbManagementAddress.setText(ElementManagerManager.getInstance().getElementManager(this.subsystem, this.getElementManagerHelper()));
            this.buLaunch.setEnabled(ElementManagerManager.getInstance().hasElementManager(this.subsystem, this.getElementManagerHelper()));
        } else if (source == this.buReset) {
            ElementManagerManager.getInstance().deleteElementManager(this.subsystem, this.getElementManagerHelper());
            this.lbManagementAddress.setText(ElementManagerManager.getInstance().getElementManager(this.subsystem, this.getElementManagerHelper()));
            this.buLaunch.setEnabled(ElementManagerManager.getInstance().hasElementManager(this.subsystem, this.getElementManagerHelper()));
        }
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    public void saveAll(boolean isRedisplay) {
        this.redisplay = isRedisplay;
        Hashtable<String, String> attributes = new Hashtable<String, String>();
        if (!this.txManuallyName.getText().equals(this.savedName)) {
            attributes.put("USER_PROVIDED_NAME", this.txManuallyName.getText());
        }
        if (!this.txUdp1.getText().equals(this.savedUdp1)) {
            attributes.put("USER_ATTRIB1", this.txUdp1.getText());
        }
        if (!this.txUdp2.getText().equals(this.savedUdp2)) {
            attributes.put("USER_ATTRIB2", this.txUdp2.getText());
        }
        if (!this.txUdp3.getText().equals(this.savedUdp3)) {
            attributes.put("USER_ATTRIB3", this.txUdp3.getText());
        }
        if (attributes.size() > 0) {
            DiskDataAccessor.getInstance().setStorageSubsystemAttributes(new GuiRequestor(){

                public void handleResponse(short status, Response response) {
                    int numRow;
                    Serializable respData;
                    if (status <= 4 && (respData = response.responseData) != null && (numRow = ((Integer)respData).intValue()) == 1) {
                        SubsystemDetailsPanel.this.savedName = SubsystemDetailsPanel.this.txManuallyName.getText();
                        SubsystemDetailsPanel.this.savedUdp1 = SubsystemDetailsPanel.this.txUdp1.getText();
                        SubsystemDetailsPanel.this.savedUdp2 = SubsystemDetailsPanel.this.txUdp2.getText();
                        SubsystemDetailsPanel.this.savedUdp3 = SubsystemDetailsPanel.this.txUdp3.getText();
                        if (SubsystemDetailsPanel.this.redisplay) {
                            SubsystemDetailsPanel.this.theDDI.nullOutPanel();
                            SubsystemDetailsPanel.this.theDDI.reDisplay();
                        }
                    }
                }
            }, this.subsystem.getId(), attributes);
        }
    }

    public void changesPending(boolean isRedisplay) {
        if (this.hasChanged()) {
            int action = JOptionPane.showConfirmDialog(this, Util.getString("DISK_SUBSYSTEMS_DETAILS_SAVE_LABEL", GUIEntityUtil.getDisplayText(this.subsystem.getDeviceId())), Util.getString("DISK_SUBSYSTEMS_DETAILS_SAVE_TITLE"), 1);
            switch (action) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    this.saveAll(isRedisplay);
                }
            }
        }
    }

    public boolean hasChanged() {
        return !this.txManuallyName.getText().equals(this.savedName) || !this.txUdp1.getText().equals(this.savedUdp1) || !this.txUdp2.getText().equals(this.savedUdp2) || !this.txUdp3.getText().equals(this.savedUdp3);
    }
}

