/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.TUpDownListSelector;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;

public abstract class BaseSelectSubsystemPortsStep
extends WizardPage {
    private JLabel titleLabel = null;
    private JLabel descLabel = null;
    private JLabel desc2Label = null;
    private TUpDownListSelector portList = null;
    protected HashMap portWWPN = new HashMap();
    private HashMap ssportData = null;
    protected HashMap portData = null;
    protected DefaultListModel srcModel = new DefaultListModel();
    protected DefaultListModel selModel = new DefaultListModel();
    private JList sourceList = null;
    private JList selectedList = null;
    private JButton nextButton = null;
    protected boolean isHelpSet = false;
    private boolean getData = false;
    private boolean skipStep = false;
    private String subSystemID = null;
    private int portsPerView = -1;
    private JDialog wizardDialog = null;
    private GUIStorageSubsystem subSystem = null;
    private DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    public static String SUBSYSTEM_DATA = "Subsystem Ports";

    public BaseSelectSubsystemPortsStep(int buttonFlags, GUIStorageSubsystem ss) {
        super(buttonFlags);
        this.setName(this.getClass().getName());
        this.subSystemID = ss.getId();
        this.subSystem = ss;
        this.portsPerView = this.subSystem.getCapabilityData().getPortsPerView();
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container pane = this.getContentPane();
        pane.add(this.create());
    }

    public JPanel create() {
        JPanel tempPanel = new JPanel();
        tempPanel.setLayout(new BoxLayout(tempPanel, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"));
        this.titleLabel.setAlignmentX(0.0f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        tempPanel.add(titlePanel);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BoxLayout(descPanel, 0));
        this.descLabel = new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_LABEL"));
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        descPanel.add(this.descLabel);
        descPanel.add(Box.createHorizontalGlue());
        tempPanel.add(descPanel);
        JPanel desc2Panel = new JPanel();
        desc2Panel.setLayout(new BoxLayout(desc2Panel, 0));
        this.desc2Label = this.portsPerView == 2 ? new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_SINGLE_PORT_LABEL")) : new JLabel(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_MULTIPLE_PORT_LABEL"));
        this.desc2Label.setAlignmentX(0.0f);
        this.desc2Label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        desc2Panel.add(this.desc2Label);
        desc2Panel.add(Box.createHorizontalGlue());
        tempPanel.add(desc2Panel);
        if (this.portsPerView == 2) {
            this.sourceList = new JList(this.srcModel);
            this.selectedList = new JList(this.selModel);
        } else {
            this.sourceList = new JList(this.selModel);
            this.selectedList = new JList(this.srcModel);
        }
        JPanel portPanel = new JPanel();
        portPanel.setLayout(new BoxLayout(portPanel, 1));
        this.portList = new TUpDownListSelector(this.sourceList, this.selectedList, Util.getString("DISK_VOLUME_HOST_PORT_SRC_LABEL"), Util.getString("DISK_VOLUME_HOST_PORT_SEL_LABEL"), true);
        portPanel.add(this.portList);
        portPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        tempPanel.add(portPanel);
        return tempPanel;
    }

    public void addData(Vector vPorts) {
    }

    public JDialog getWizardDialog() {
        return null;
    }

    public boolean skipSubsystemStep() {
        return this.skipStep;
    }

    public void fillData() {
        GUIPort port = null;
        String portItem = new String();
        if (!this.getData) {
            this.getData = true;
            this.getPortsFromSystem();
            if (this.portData == null) {
                this.getData = false;
                return;
            }
            Vector listVector = new Vector(this.portData.values());
            GUIEntityUtil.sort(listVector);
            Iterator iter = listVector.iterator();
            DefaultListModel model = new DefaultListModel();
            this.ssportData = new HashMap();
            this.selModel.removeAllElements();
            this.srcModel.removeAllElements();
            while (iter.hasNext()) {
                port = (GUIPort)iter.next();
                portItem = port.getWwpn() + "( " + port.getHostName() + " )";
                this.srcModel.addElement(portItem);
                this.ssportData.put(portItem, port);
                this.portWWPN.put(port.getWwpn(), portItem);
            }
            if (this.portsPerView == 2) {
                this.selModel.add(0, this.srcModel.get(0));
                this.srcModel.remove(0);
                this.sourceList = new JList(this.srcModel);
                this.selectedList = new JList(this.selModel);
                this.sourceList.setSelectedIndex(0);
                this.portList.invalidate();
            } else {
                this.sourceList = new JList(this.selModel);
                this.selectedList = new JList(this.srcModel);
            }
        }
    }

    public void getPortsFromSystem() {
    }

    public void skip() {
        this.skipStep = true;
    }

    public boolean nextBegin() {
        boolean retval = true;
        ArrayList selectedPorts = this.portList.getSelList();
        String sPort = null;
        GUIPort port = null;
        Vector<GUIPort> vPorts = new Vector<GUIPort>();
        if (this.portsPerView == 2 && selectedPorts.size() > 1) {
            JOptionPane.showMessageDialog(this, Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_DESC_SINGLE_PORT_LABEL"), Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"), 0);
            retval = false;
        }
        if (selectedPorts == null && retval) {
            int action = JOptionPane.showConfirmDialog(this, Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_CONFIRMATION"), Util.getString("DISK_SUBSYSTEMPORTS_LABEL"), 2);
            switch (action) {
                case 0: {
                    retval = false;
                    break;
                }
                case 2: {
                    retval = false;
                }
            }
        } else {
            ListIterator ll = selectedPorts.listIterator();
            while (ll.hasNext()) {
                sPort = ll.next().toString();
                port = (GUIPort)this.ssportData.get(sPort);
                vPorts.add(port);
            }
        }
        this.addData(vPorts);
        return retval;
    }

    public boolean previousBegin() {
        return true;
    }
}

