/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIFabric;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIZone;
import org.eclipse.aperi.gui.disk.common.model.GUIZoneSet;
import org.eclipse.aperi.gui.fabric.zone.ZoneUIAccessor;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;

public abstract class BaseZoneActionStep
extends WizardPage
implements ActionListener {
    private DiskDataAccessor diskAccessor = null;
    private ZoneUIAccessor zoneAccessor = ZoneUIAccessor.getInstance();
    private ZoneCapabilities zoneCap = null;
    private GUIFabric fab = null;
    private BaseZoneActionStep zoneStep = this;
    private boolean zoneError = false;
    private int totalFabrics = -1;
    private int fabricSize = -1;
    private int currentFabric = -1;
    private ZoneAction zoneAction = null;
    private int zoneActionDisplay = -1;
    private String fabricID = new String();
    private String zonesetID = new String();
    private GUIZoneSet zoneset = null;
    protected HashMap fabricsMap = null;
    private HashMap zoneMap = null;
    private HashMap zoneNameMap = null;
    private String[] portsInZone;
    protected HashMap zoneSteps = null;
    protected HashMap zoneList = null;
    private Vector fabrics = new Vector();
    private Vector existingZones = null;
    private Vector hostportData = null;
    private Vector ssportData = null;
    private Vector hostportsVector = null;
    private Vector ssportsVector = null;
    private Vector hostportsVectorString = null;
    private Vector ssportsVectorString = null;
    private Vector excludedHostports = new Vector();
    private Vector excludedSSports = new Vector();
    private Container zonePane = null;
    private Container pane = null;
    private JPanel zoneNoPorts = null;
    private JPanel zoneCommonPorts = null;
    private JPanel actionPanel = null;
    private JPanel noFabricPanel = null;
    private JPanel fabricPanel = null;
    private GridBagPanel tempPanel = null;
    private JButton nextButton = null;
    private JLabel titleLabel = null;
    private JTextArea titleLabel2 = null;
    private JTextArea titleLabel3 = null;
    private JLabel zoneActionLabel = null;
    private JLabel titleLabelNoZoneAction = null;
    private JLabel newZoneLabel = null;
    private JLabel zoneNameLabel = null;
    private JLabel updateZoneLabel = null;
    private JLabel dontDoLabel = null;
    private JLabel portListLabel = null;
    private JLabel ssportListLabel = null;
    private JLabel zoneSetLabel = null;
    private JLabel noZoneLabel = null;
    private JLabel noFabricLabel = null;
    private JTextArea commonZoneLabel = null;
    private JDialog wizardDialog = null;
    private JRadioButton newZoneRadioButton = null;
    private JRadioButton updateZoneRadioButton = null;
    private JRadioButton dontDoRadioButton = null;
    private JTextField zoneNameTextField = null;
    private JComboBox zoneExistComboBox = null;
    private JList portList = null;
    private JList ssportList = null;
    private JScrollPane jportPanel = null;
    private JScrollPane ssjportPanel = null;
    public static String ZONE_ACTION_DATA = "Zone Actions";
    public static String ZONE_LIST_DATA = "Zone List";
    private String subSystemID = null;
    private int width = -1;
    private int height = -1;
    protected boolean skipStep = false;
    private boolean getData = true;
    protected boolean isHelpSet = false;
    private boolean getRefreshData = false;

    public BaseZoneActionStep(int buttonFlags, String ssID) {
        super(buttonFlags);
        this.setName(this.getClass().getName());
        this.diskAccessor = DiskDataAccessor.getInstance();
        this.subSystemID = ssID;
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        this.pane = this.getContentPane();
        this.pane.add(this.create());
    }

    public JPanel create() {
        this.zoneSteps = new HashMap();
        this.zoneList = new HashMap();
        this.tempPanel = new GridBagPanel();
        this.fabricPanel = new JPanel();
        this.fabricPanel.setLayout(new BoxLayout(this.fabricPanel, 1));
        this.tempPanel.add((JComponent)this.fabricPanel, 23);
        this.tempPanel.newRow();
        this.noFabricPanel = new JPanel();
        this.noFabricPanel.setLayout(new BoxLayout(this.noFabricPanel, 3));
        this.noFabricLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_NO_FABRICS_LABEL"));
        this.noFabricLabel.setBorder(BorderFactory.createEmptyBorder(40, 20, 10, 5));
        Font font = this.noFabricLabel.getFont();
        GuiUtil.setAccessible(this.noFabricLabel, this.noFabricLabel.getText(), this.noFabricLabel.getText());
        this.noFabricLabel.setFont(font.deriveFont(1));
        this.noFabricPanel.add(this.noFabricLabel);
        this.zoneNoPorts = new JPanel();
        this.zoneNoPorts.setLayout(new BoxLayout(this.zoneNoPorts, 0));
        JPanel zonePanel = new JPanel();
        zonePanel.setLayout(new BoxLayout(zonePanel, 0));
        this.noZoneLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_NO_ZONE_LABEL"));
        this.noZoneLabel.setAlignmentX(0.5f);
        this.noZoneLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        zonePanel.add(this.noZoneLabel);
        zonePanel.add(Box.createHorizontalGlue());
        this.zoneNoPorts.add(zonePanel);
        this.zoneCommonPorts = new JPanel();
        this.zoneCommonPorts.setLayout(new BoxLayout(this.zoneCommonPorts, 0));
        JPanel comZonePanel = new JPanel();
        comZonePanel.setLayout(new BoxLayout(comZonePanel, 0));
        this.commonZoneLabel = new JTextArea(Util.getString("DISK_VOLUME_ZONE_ACTION_COMMON_ZONE_LABEL"));
        this.commonZoneLabel.setEditable(false);
        this.commonZoneLabel.setLineWrap(true);
        this.commonZoneLabel.setWrapStyleWord(true);
        this.commonZoneLabel.setBackground((Color)UIManager.get("Label.background"));
        this.commonZoneLabel.setForeground((Color)UIManager.get("Label.foreground"));
        this.commonZoneLabel.setFont((Font)UIManager.get("Label.font"));
        this.commonZoneLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        comZonePanel.add(this.commonZoneLabel);
        comZonePanel.add(Box.createHorizontalGlue());
        this.zoneCommonPorts.add(comZonePanel);
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel();
        this.titleLabel.setAlignmentX(0.5f);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        this.fabricPanel.add(titlePanel);
        JPanel titlePanel2 = new JPanel();
        titlePanel2.setLayout(new BoxLayout(titlePanel2, 1));
        this.titleLabel3 = new JTextArea(Util.getString("DISK_VOLUME_ZONE_ACTION_TITLE3_LABEL"));
        this.titleLabel3.setEditable(false);
        this.titleLabel3.setLineWrap(true);
        this.titleLabel3.setWrapStyleWord(true);
        this.titleLabel3.setBackground((Color)UIManager.get("Label.background"));
        this.titleLabel3.setForeground((Color)UIManager.get("Label.foreground"));
        this.titleLabel3.setFont((Font)UIManager.get("Label.font"));
        this.titleLabel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.titleLabel3.setAlignmentX(0.5f);
        titlePanel2.add(this.titleLabel3);
        this.fabricPanel.add(titlePanel2);
        JPanel zoneSetPanel = new JPanel();
        zoneSetPanel.setLayout(new BoxLayout(zoneSetPanel, 0));
        String zoneset = new String();
        this.zoneSetLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", zoneset));
        this.zoneSetLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.zoneSetLabel.setAlignmentX(0.0f);
        zoneSetPanel.add(this.zoneSetLabel);
        this.width = Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL").length() * this.zoneSetLabel.getFontMetrics(this.getFont()).charWidth(0) + 20;
        this.height = this.zoneSetLabel.getFontMetrics(this.getFont()).getHeight() + 5;
        this.zoneSetLabel.setMinimumSize(new Dimension(this.width, this.height));
        this.zoneSetLabel.setPreferredSize(new Dimension(this.width, this.height));
        this.zoneSetLabel.setMaximumSize(new Dimension(this.width * 2, this.height));
        zoneSetPanel.add(Box.createHorizontalGlue());
        this.fabricPanel.add(zoneSetPanel);
        this.zonePane = new JPanel();
        this.zonePane.setLayout(new BoxLayout(this.zonePane, 3));
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new BoxLayout(this.actionPanel, 1));
        this.actionPanel.setBorder(BorderFactory.createTitledBorder(Util.getString("DISK_VOLUME_ZONE_ACTION_ACTION_LABEL")));
        this.zonePane.add(this.actionPanel);
        JPanel newZonePanel = new JPanel();
        newZonePanel.setLayout(new BoxLayout(newZonePanel, 0));
        this.newZoneRadioButton = new JRadioButton(Util.getString("DISK_VOLUME_ZONE_ACTION_NEW_ZONE_LABEL"));
        newZonePanel.add(this.newZoneRadioButton);
        this.newZoneRadioButton.addActionListener(this);
        this.newZoneRadioButton.setAlignmentX(1.0f);
        newZonePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        newZonePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        newZonePanel.add(Box.createHorizontalGlue());
        GuiUtil.setAccessible(this.newZoneRadioButton, this.newZoneRadioButton.getText(), this.newZoneRadioButton.getText());
        this.actionPanel.add(newZonePanel);
        JPanel zoneNamePanel = new JPanel();
        zoneNamePanel.setLayout(new BoxLayout(zoneNamePanel, 0));
        this.zoneNameLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_NAME_LABEL"));
        this.zoneNameTextField = new JTextField();
        zoneNamePanel.add(Box.createRigidArea(new Dimension(50, 0)));
        zoneNamePanel.add(this.zoneNameLabel);
        PlainDocument pd = new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                if (str != null && str.length() + this.getLength() <= 15) {
                    super.insertString(offs, str, a);
                }
            }
        };
        this.zoneNameTextField = new JTextField(pd, "", 15);
        this.width = 16 * this.zoneNameTextField.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.zoneNameTextField.getFontMetrics(this.getFont()).getHeight() + 5;
        this.zoneNameTextField.setMinimumSize(new Dimension(this.width, this.height));
        this.zoneNameTextField.setPreferredSize(new Dimension(this.width, this.height));
        this.zoneNameTextField.setMaximumSize(new Dimension(this.width * 2, this.height));
        zoneNamePanel.add(this.zoneNameTextField);
        zoneNamePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        zoneNamePanel.setAlignmentX(1.0f);
        zoneNamePanel.add(Box.createHorizontalGlue());
        this.actionPanel.add(zoneNamePanel);
        GuiUtil.setAccessibleLabel(this.zoneNameLabel, this.zoneNameTextField, "", this.zoneNameLabel.getText(), this.zoneNameLabel.getText());
        JPanel zoneExistPanel = new JPanel();
        zoneExistPanel.setLayout(new BoxLayout(zoneExistPanel, 0));
        this.updateZoneRadioButton = new JRadioButton(Util.getString("DISK_VOLUME_ZONE_ACTION_UPDATE_ZONE_LABEL"));
        this.updateZoneRadioButton.addActionListener(this);
        zoneExistPanel.add(this.updateZoneRadioButton);
        Vector existingZones = new Vector();
        this.zoneExistComboBox = new JComboBox(existingZones);
        zoneExistPanel.add(this.zoneExistComboBox);
        zoneExistPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        zoneExistPanel.add(Box.createHorizontalGlue());
        GuiUtil.setAccessible(this.updateZoneRadioButton, this.updateZoneRadioButton.getText(), this.updateZoneRadioButton.getText());
        GuiUtil.setAccessible(this.zoneExistComboBox, this.zoneExistComboBox.getName(), this.zoneExistComboBox.getName());
        this.actionPanel.add(zoneExistPanel);
        JPanel dontDoPanel = new JPanel();
        dontDoPanel.setLayout(new BoxLayout(dontDoPanel, 0));
        this.dontDoRadioButton = new JRadioButton(Util.getString("DISK_VOLUME_ZONE_ACTION_DONTDO_LABEL"));
        dontDoPanel.add(this.dontDoRadioButton);
        this.dontDoRadioButton.addActionListener(this);
        dontDoPanel.add(Box.createHorizontalGlue());
        this.dontDoRadioButton.setSelected(true);
        GuiUtil.setAccessible(this.dontDoRadioButton, this.dontDoRadioButton.getText(), this.dontDoRadioButton.getText());
        dontDoPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.actionPanel.add(dontDoPanel);
        ButtonGroup group = new ButtonGroup();
        group.add(this.newZoneRadioButton);
        group.add(this.updateZoneRadioButton);
        group.add(this.dontDoRadioButton);
        this.zoneNameTextField.setEnabled(false);
        this.zoneExistComboBox.setEnabled(false);
        this.fabricPanel.add(Box.createVerticalGlue());
        JPanel portPanel = new JPanel();
        JPanel hostportPanel = new JPanel();
        portPanel.setLayout(new BoxLayout(portPanel, 2));
        hostportPanel.setLayout(new BoxLayout(hostportPanel, 3));
        this.portListLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_HOST_PORTS_LABEL"));
        hostportPanel.add(this.portListLabel);
        this.portList = new JList();
        this.jportPanel = new JScrollPane(this.portList);
        this.jportPanel.setPreferredSize(new Dimension(50, 80));
        hostportPanel.add(this.jportPanel);
        GuiUtil.setAccessibleLabel(this.portListLabel, this.portList, "", this.portListLabel.getText(), this.portListLabel.getText());
        Vector portData = new Vector();
        this.portList.setListData(portData);
        JPanel ssportPanel = new JPanel();
        ssportPanel.setLayout(new BoxLayout(ssportPanel, 3));
        this.ssportListLabel = new JLabel(Util.getString("DISK_VOLUME_ZONE_ACTION_SUBSYSTEM_PORTS_LABEL"));
        ssportPanel.add(this.ssportListLabel);
        this.ssportList = new JList();
        this.ssjportPanel = new JScrollPane(this.ssportList);
        this.ssjportPanel.setPreferredSize(new Dimension(40, 80));
        ssportPanel.add(this.ssjportPanel);
        GuiUtil.setAccessibleLabel(this.ssportListLabel, this.ssportList, "", this.ssportListLabel.getText(), this.ssportListLabel.getText());
        portPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        portPanel.add(hostportPanel);
        portPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        portPanel.add(ssportPanel);
        portPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.actionPanel.add(portPanel);
        this.fabricPanel.add(this.zonePane);
        this.zoneAction = new ZoneAction();
        this.nextButton = this.getNextButton();
        this.tempPanel.add((JComponent)new JLabel(), 1);
        return this.tempPanel;
    }

    public void fillData() {
        block37: {
            block38: {
                block39: {
                    if (this.getData) {
                        String hostname;
                        int i;
                        this.getData = false;
                        this.getFabricsFromSystem();
                        if (this.fabricsMap == null) {
                            this.getData = false;
                            this.tempPanel.remove(this.fabricPanel);
                            this.tempPanel.add((JComponent)this.noFabricPanel, 0, 1, 2);
                            return;
                        }
                        GUIFabric ff = null;
                        Vector<Object> fabricids = new Vector(this.fabricsMap.keySet());
                        String fabid = new String();
                        for (int i2 = 0; i2 < fabricids.size(); ++i2) {
                            fabid = (String)fabricids.get(i2);
                            ff = (GUIFabric)this.fabricsMap.get(fabid);
                            if (ff.getActiveZoneSet() == null) {
                                this.fabricsMap.remove(fabid);
                            }
                            if (ff.isZoningSupported()) continue;
                            this.fabricsMap.remove(fabid);
                        }
                        this.hostportData = this.getHostPorts();
                        this.hostportData = GUIEntityUtil.sort(this.hostportData);
                        this.ssportData = this.getSubsystemPorts();
                        if (this.ssportData != null) {
                            this.ssportData = GUIEntityUtil.sort(this.ssportData);
                        }
                        Vector<GUIFabric> hfabs = new Vector<GUIFabric>();
                        Vector fabs = new Vector();
                        GUIPort hport = null;
                        GUIPort sport = null;
                        for (int i3 = 0; i3 < this.hostportData.size(); ++i3) {
                            try {
                                hport = (GUIPort)this.hostportData.get(i3);
                            }
                            catch (ClassCastException ce) {
                                hport = null;
                            }
                            if (hport != null) {
                                fabs = hport.getFabrics();
                            }
                            for (int j = 0; fabs != null && j < fabs.size(); ++j) {
                                ff = (GUIFabric)this.fabricsMap.get((String)fabs.get(j));
                                if (ff == null || hfabs.contains(ff)) continue;
                                hfabs.add(ff);
                            }
                        }
                        Vector<GUIFabric> sfabs = new Vector<GUIFabric>();
                        for (int i4 = 0; this.ssportData != null && i4 < this.ssportData.size(); ++i4) {
                            sport = (GUIPort)this.ssportData.get(i4);
                            fabs = sport.getFabrics();
                            for (int j = 0; fabs != null && j < fabs.size(); ++j) {
                                ff = (GUIFabric)this.fabricsMap.get((String)fabs.get(j));
                                if (ff == null || sfabs.contains(ff)) continue;
                                sfabs.add(ff);
                            }
                        }
                        this.fabrics = new Vector();
                        if (sfabs.size() > hfabs.size()) {
                            sfabs.retainAll(hfabs);
                            this.fabrics = sfabs;
                        } else {
                            hfabs.retainAll(sfabs);
                            this.fabrics = hfabs;
                        }
                        fabricids = new Vector();
                        for (int f = 0; f < this.fabrics.size(); ++f) {
                            fabricids.add(((GUIFabric)this.fabrics.get(f)).getId());
                        }
                        boolean contains = false;
                        this.excludedHostports = new Vector();
                        sport = null;
                        for (i = 0; i < this.hostportData.size(); ++i) {
                            contains = false;
                            try {
                                sport = (GUIPort)this.hostportData.get(i);
                            }
                            catch (ClassCastException ce) {
                                sport = null;
                            }
                            if (sport != null) {
                                fabs = sport.getFabrics();
                            }
                            for (int j = 0; fabs != null && j < fabs.size(); ++j) {
                                String tfabric = (String)fabs.get(j);
                                if (!fabricids.contains(tfabric)) continue;
                                contains = true;
                                break;
                            }
                            if (sport == null || contains) continue;
                            String portname = sport.getWwpn();
                            hostname = sport.getHostName();
                            if (hostname != null && hostname.trim().length() > 0) {
                                portname = portname + " (" + hostname + ")";
                            }
                            this.excludedHostports.add(portname);
                        }
                        this.excludedSSports = new Vector();
                        sport = null;
                        for (i = 0; this.ssportData != null && i < this.ssportData.size(); ++i) {
                            contains = false;
                            sport = (GUIPort)this.ssportData.get(i);
                            fabs = sport.getFabrics();
                            for (int j = 0; fabs != null && j < fabs.size(); ++j) {
                                String tfabric = (String)fabs.get(j);
                                if (!fabricids.contains(tfabric)) continue;
                                contains = true;
                                break;
                            }
                            if (contains) continue;
                            String portname = sport.getWwpn();
                            hostname = sport.getHostName();
                            if (hostname != null && hostname.trim().length() > 0) {
                                portname = portname + " (" + hostname + ")";
                            }
                            this.excludedSSports.add(portname);
                        }
                        this.totalFabrics = this.fabrics.size();
                        if (this.totalFabrics > 0) {
                            this.currentFabric = 0;
                            GUIFabric firstFabric = (GUIFabric)this.fabrics.get(this.currentFabric);
                            String title1 = Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC_LABEL", firstFabric.getDeviceId(), Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC2_LABEL", String.valueOf(this.currentFabric + 1), String.valueOf(this.totalFabrics)));
                            this.titleLabel.setText(title1);
                            this.getFabricsInfo(firstFabric);
                            this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", firstFabric.getActiveZoneSet().getDeviceId()));
                            switch (this.zoneActionDisplay) {
                                case -1: {
                                    this.tempPanel.remove(this.zoneNoPorts);
                                    this.tempPanel.remove(this.zoneCommonPorts);
                                    this.tempPanel.add((JComponent)this.fabricPanel, 23);
                                    break;
                                }
                                case 0: {
                                    this.tempPanel.remove(this.zoneCommonPorts);
                                    this.tempPanel.remove(this.fabricPanel);
                                    this.tempPanel.add((JComponent)this.zoneNoPorts, 0, 1, 2);
                                    break;
                                }
                                case 1: {
                                    this.tempPanel.remove(this.fabricPanel);
                                    this.tempPanel.remove(this.zoneNoPorts);
                                    this.tempPanel.add((JComponent)this.zoneCommonPorts, 0, 1, 2);
                                }
                            }
                            this.zoneNameTextField.setText("");
                            this.dontDoRadioButton.setSelected(true);
                            this.zoneExistComboBox.setEnabled(false);
                            this.zoneNameTextField.setEnabled(false);
                        } else {
                            this.tempPanel.remove(this.zoneCommonPorts);
                            this.tempPanel.remove(this.fabricPanel);
                            this.tempPanel.add((JComponent)this.zoneNoPorts, 0, 1, 2);
                        }
                    }
                    if (!this.getRefreshData || this.totalFabrics <= 0) break block37;
                    this.fab = (GUIFabric)this.fabrics.get(this.currentFabric);
                    if (this.zoneSteps == null || this.zoneSteps.size() <= 0) break block38;
                    this.zoneAction = (ZoneAction)this.zoneSteps.get(this.fab.getDeviceId());
                    if (this.zoneAction == null) break block39;
                    switch (this.zoneAction.action) {
                        case 0: {
                            this.newZoneRadioButton.setSelected(true);
                            this.zoneNameTextField.setText(this.zoneAction.zoneName);
                            this.zoneExistComboBox.setEnabled(false);
                            this.zoneNameTextField.setEnabled(true);
                            break;
                        }
                        case 1: {
                            this.updateZoneRadioButton.setSelected(true);
                            this.zoneNameTextField.setEnabled(false);
                            if (this.zoneAction.zoneset != null) {
                                this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", this.zoneAction.zoneset.getDeviceId()));
                                this.zoneExistComboBox.setEnabled(true);
                                DefaultComboBoxModel existZoneModel = new DefaultComboBoxModel(this.zoneAction.eZones);
                                this.zoneExistComboBox.setModel(existZoneModel);
                                this.zoneExistComboBox.setSelectedItem(this.zoneAction.zone);
                                break;
                            }
                            break block38;
                        }
                        case 2: {
                            this.zoneNameTextField.setEnabled(false);
                            this.zoneExistComboBox.setEnabled(false);
                            this.dontDoRadioButton.setSelected(true);
                            break;
                        }
                    }
                    break block38;
                }
                this.zoneNameTextField.setText(new String());
                this.dontDoRadioButton.setSelected(true);
            }
            this.getRefreshData = false;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = null;
        Object mdiskGroupID = null;
        int selectedIndex = -1;
        if (e == null) {
            return;
        }
        source = e.getSource();
        if (source == null) {
            return;
        }
        if (source.equals(this.updateZoneRadioButton)) {
            this.zoneNameTextField.setText(new String());
            this.zoneNameTextField.setEnabled(false);
            this.zoneExistComboBox.setEnabled(true);
            DefaultComboBoxModel existZoneModel = new DefaultComboBoxModel(this.existingZones);
            this.zoneExistComboBox.setModel(existZoneModel);
        } else if (source.equals(this.newZoneRadioButton)) {
            this.zoneExistComboBox.setEnabled(false);
            this.zoneNameTextField.setEnabled(true);
        } else if (source.equals(this.dontDoRadioButton)) {
            this.zoneNameTextField.setText(new String());
            this.zoneExistComboBox.setEnabled(false);
            this.zoneNameTextField.setEnabled(false);
        }
    }

    public void getPortsByZone(String fabricID, String zoneSetID, String zoneID) {
        this.nextButton.setEnabled(false);
        this.diskAccessor.getPortsByZone(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4) {
                    BaseZoneActionStep.access$002(BaseZoneActionStep.this, (String[])response.responseData);
                }
                BaseZoneActionStep.this.nextButton.setEnabled(true);
            }
        }, fabricID, zoneSetID, zoneID);
    }

    public void getFabricsInfo(GUIFabric thisFabric) {
        int i;
        this.hostportsVector = new Vector();
        this.ssportsVector = new Vector();
        this.hostportsVectorString = new Vector();
        this.ssportsVectorString = new Vector();
        this.existingZones = new Vector();
        this.fabricID = thisFabric.getId();
        this.zoneset = thisFabric.getActiveZoneSet();
        this.zoneMap = this.zoneset.getZones();
        if (this.zoneMap != null) {
            this.existingZones = new Vector(this.zoneMap.values());
            this.existingZones = GUIEntityUtil.sort(this.existingZones);
        }
        this.zoneNameMap = new HashMap();
        for (int i2 = 0; i2 < this.existingZones.size(); ++i2) {
            String zname = ((GUIZone)this.existingZones.get(i2)).toString();
            this.zoneNameMap.put(zname, zname);
        }
        DefaultComboBoxModel existZoneModel = new DefaultComboBoxModel(this.existingZones);
        this.zoneExistComboBox.setModel(existZoneModel);
        this.checkZones();
        this.fab = thisFabric;
        this.zoneAccessor.ping(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                BaseZoneActionStep.this.nextButton.setEnabled(false);
                if (status < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    BaseZoneActionStep.this.zoneCap = (ZoneCapabilities)hashMap.get("pingZoneAgent");
                    if (BaseZoneActionStep.this.zoneCap == null) {
                        if (hashMap.containsKey("pingError")) {
                            int errorInt = (Integer)hashMap.get("pingError");
                            String error = "";
                            String msg = "";
                            switch (errorInt) {
                                case 5: {
                                    error = Util.getString("FabricZone_TokenError");
                                    msg = Util.getString("FMSG_PING_INVALID_TOKEN_ERROR");
                                    break;
                                }
                                case 3: {
                                    error = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                    msg = Util.getString("FMSG_PING_LOCKED_ERROR");
                                    break;
                                }
                                case 4: {
                                    error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    msg = Util.getString("FMSG_PING_NOTAVAILABLE_ERROR");
                                    break;
                                }
                                case 1: {
                                    error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    msg = Util.getString("FMSG_PING_GENERAL_ERROR");
                                }
                            }
                            BaseZoneActionStep.this.zoneError = true;
                            BaseZoneActionStep.this.dontDoRadioButton.setSelected(true);
                            BaseZoneActionStep.this.zoneExistComboBox.setEnabled(false);
                            BaseZoneActionStep.this.zoneNameTextField.setEnabled(false);
                            JOptionPane.showMessageDialog(BaseZoneActionStep.this.zoneStep, msg, Util.getString("DISK_ZONE_ACTIONS_LABEL"), 0);
                        }
                        BaseZoneActionStep.this.zoneCap = new ZoneCapabilities();
                    } else {
                        BaseZoneActionStep.this.zoneError = false;
                    }
                    BaseZoneActionStep.this.fab.setZoneCapabilities(BaseZoneActionStep.this.zoneCap);
                }
                BaseZoneActionStep.this.nextButton.setEnabled(true);
            }
        }, this.fabricID);
        Vector fabs = new Vector();
        GUIPort hport = null;
        Vector<String> portWWPNs = new Vector<String>();
        String hostname = new String();
        String portname = new String();
        HashMap<String, String> hportMap = new HashMap<String, String>();
        for (i = 0; i < this.hostportData.size(); ++i) {
            try {
                hport = (GUIPort)this.hostportData.get(i);
                fabs = hport.getFabrics();
                for (int j = 0; fabs != null && j < fabs.size(); ++j) {
                    if (!this.fabricID.equals((String)fabs.get(j))) continue;
                    portname = hport.getWwpn();
                    hostname = hport.getHostName();
                    if (hportMap.get(portname) != null) continue;
                    hportMap.put(portname, portname);
                    this.hostportsVector.add(hport);
                    if (hostname != null && hostname.trim().length() > 0) {
                        portname = portname + " (" + hostname + ")";
                    }
                    this.hostportsVectorString.add(portname);
                    portWWPNs.add(hport.getWwpn());
                }
                continue;
            }
            catch (ClassCastException ce) {
                portWWPNs.add((String)this.hostportData.get(i));
            }
        }
        hport = null;
        for (i = 0; i < this.ssportData.size(); ++i) {
            try {
                hport = (GUIPort)this.ssportData.get(i);
                fabs = hport.getFabrics();
                HashMap<String, String> sportMap = new HashMap<String, String>();
                for (int j = 0; fabs != null && j < fabs.size(); ++j) {
                    if (!this.fabricID.equals((String)fabs.get(j))) continue;
                    portname = hport.getWwpn();
                    hostname = hport.getHostName();
                    if (sportMap.get(portname) != null) continue;
                    sportMap.put(portname, portname);
                    this.ssportsVector.add(hport);
                    if (hostname != null && hostname.trim().length() > 0) {
                        portname = portname + " (" + hostname + ")";
                    }
                    this.ssportsVectorString.add(portname);
                    portWWPNs.add(hport.getWwpn());
                }
                continue;
            }
            catch (ClassCastException ce) {
                portWWPNs.add((String)this.hostportData.get(i));
            }
        }
        this.zoneActionDisplay = this.hostportsVector.size() < 0 && this.ssportsVector.size() < 0 ? 0 : -1;
        GUIZone ezone = null;
        boolean found = false;
        Vector<String> zonePorts = new Vector<String>();
        for (int i3 = 0; i3 < this.existingZones.size(); ++i3) {
            ezone = (GUIZone)this.existingZones.get(i3);
            this.portsInZone = ezone.getPorts();
            zonePorts = new Vector();
            for (int j = 0; j < this.portsInZone.length; ++j) {
                zonePorts.add(this.portsInZone[j]);
            }
            if (!zonePorts.containsAll(portWWPNs)) continue;
            found = true;
            this.zoneActionDisplay = 1;
            break;
        }
        DefaultComboBoxModel hpmodel = new DefaultComboBoxModel(this.hostportsVectorString);
        this.portList.setModel(hpmodel);
        DefaultComboBoxModel ssmodel = new DefaultComboBoxModel(this.ssportsVectorString);
        this.ssportList.setModel(ssmodel);
    }

    public Vector getHostPorts() {
        return new Vector();
    }

    public Vector getSubsystemPorts() {
        return new Vector();
    }

    public void getFabricsFromSystem() {
    }

    public boolean nextBegin() {
        boolean breturn = false;
        this.getRefreshData = true;
        if (this.currentFabric < 0) {
            breturn = true;
            --this.currentFabric;
            this.addData();
            if (this.excludedHostports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_HOST_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_HOSTPORTS_LABEL", this.excludedHostports.toString()));
            }
            if (this.excludedSSports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_SUBSYSTEMPORTS_LABEL", this.excludedSSports.toString()));
            }
            return true;
        }
        this.fab = (GUIFabric)this.fabrics.get(this.currentFabric);
        this.zoneAction = new ZoneAction();
        this.zoneAction.fabricID = ((GUIFabric)this.fabrics.get(this.currentFabric)).getDeviceId();
        this.zoneAction.zoneset = this.zoneset;
        if (this.zoneError) {
            this.dontDoRadioButton.setSelected(true);
            this.newZoneRadioButton.setEnabled(false);
            this.updateZoneRadioButton.setEnabled(false);
        } else {
            this.newZoneRadioButton.setEnabled(true);
            this.updateZoneRadioButton.setEnabled(true);
        }
        if (this.newZoneRadioButton.isSelected()) {
            this.zoneAction.action = 0;
            this.zoneAction.zoneName = this.zoneNameTextField.getText();
            String error = this.checkZoneNameString(this.zoneAction.zoneName);
            if (error != null) {
                JOptionPane.showMessageDialog(this, error, Util.getString("DISK_VOLUME_ZONE_ACTION_NEW_ZONE_LABEL"), 0);
                return false;
            }
            this.zoneAction.actionString = new String(Util.getString("DISK_VOLUME_ZONE_ACTIONSTRING_CREATE_ZONE_LABEL", this.zoneAction.zoneName, this.zoneAction.fabricID));
        } else if (this.updateZoneRadioButton.isSelected()) {
            this.zoneAction.action = 1;
            this.zoneAction.zone = (GUIZone)this.zoneExistComboBox.getSelectedItem();
            if (this.zoneAction.zone != null) {
                this.zoneAction.zoneName = this.zoneAction.zone.getName();
            }
            this.zoneAction.actionString = new String(Util.getString("DISK_VOLUME_ZONE_ACTIONSTRING_UPDATE_ZONE_LABEL", this.zoneAction.zoneName, this.zoneAction.fabricID));
        } else if (this.dontDoRadioButton.isSelected()) {
            this.zoneAction.action = 2;
            this.zoneAction.actionString = new String(Util.getString("DISK_VOLUME_ZONE_ACTION_DONTDO_WARNING_LABEL", this.zoneAction.fabricID));
        }
        if (this.zoneSteps.containsKey(this.zoneAction.fabricID)) {
            this.zoneSteps.remove(this.zoneAction.fabricID);
            this.zoneList.remove(this.zoneAction.fabricID);
        }
        this.zoneSteps.put(this.zoneAction.fabricID, this.zoneAction);
        this.zoneList.put(this.zoneAction.fabricID, this.zoneAction.actionString);
        this.zoneAction.hostPorts = this.hostportsVector;
        this.zoneAction.ssPorts = this.ssportsVector;
        this.zoneAction.eZones = this.existingZones;
        this.zoneAction = new ZoneAction();
        ++this.currentFabric;
        if (this.currentFabric >= this.totalFabrics) {
            breturn = true;
            --this.currentFabric;
            this.addData();
            if (this.excludedHostports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_HOST_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_HOSTPORTS_LABEL", this.excludedHostports.toString()));
            }
            if (this.excludedSSports.size() > 0) {
                this.zoneList.put(Util.getString("DISK_VOLUME_SUBSYSTEM_PORT_LABEL"), Util.getString("DISK_VOLUME_ZONE_ACTION_EXCLUDED_SUBSYSTEMPORTS_LABEL", this.excludedSSports.toString()));
            }
        } else {
            this.fab = (GUIFabric)this.fabrics.get(this.currentFabric);
            this.getFabricsInfo(this.fab);
            this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", this.fab.getActiveZoneSet().getDeviceId()));
            String title1 = Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC_LABEL", this.fab.getDeviceId(), Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC2_LABEL", String.valueOf(this.currentFabric + 1), String.valueOf(this.totalFabrics)));
            this.titleLabel.setText(title1);
            this.zoneNameTextField.setText("");
            this.dontDoRadioButton.setSelected(true);
            switch (this.zoneActionDisplay) {
                case -1: {
                    this.tempPanel.remove(this.zoneNoPorts);
                    this.tempPanel.remove(this.zoneCommonPorts);
                    this.tempPanel.add(this.fabricPanel);
                    break;
                }
                case 0: {
                    this.tempPanel.remove(this.zoneCommonPorts);
                    this.tempPanel.remove(this.fabricPanel);
                    this.tempPanel.add(this.zoneNoPorts);
                    break;
                }
                case 1: {
                    this.tempPanel.remove(this.fabricPanel);
                    this.tempPanel.remove(this.zoneNoPorts);
                    this.tempPanel.add(this.zoneCommonPorts);
                }
            }
            breturn = false;
        }
        return breturn;
    }

    private String checkZoneNameString(String name) {
        String error = null;
        if (name.length() <= 0) {
            return Util.getString("FabricZoneFrame_ZoneConfigurationErrorTitle");
        }
        if (name.indexOf(32) != -1) {
            return Util.getString("FabricZoneFrame_BadCharZoneNameErrorMsg");
        }
        if (!this.fab.getZoneCapabilities().isAllowsNumericNameStart() && Character.isDigit(name.charAt(0))) {
            error = Util.getString("FabricZoneFrame_NumericalZoneNameErrorMsg");
            return error;
        }
        if (!this.fab.getZoneCapabilities().isSupportsSpecialCharacters()) {
            char[] chars = name.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != '$' && chars[i] != '-' && chars[i] != ' ' && chars[i] != '%' && chars[i] != '&') continue;
                error = Util.getString("FabricZoneFrame_BadCharZoneNameErrorMsg");
                return error;
            }
        }
        if (this.zoneNameMap.get(name) != null) {
            error = Util.getString("FabricZoneFrame_DuplicateZoneNameErrorMsg");
            return error;
        }
        return error;
    }

    private void checkZones() {
        if (this.existingZones.size() <= 0) {
            this.updateZoneRadioButton.setEnabled(false);
            this.zoneExistComboBox.setEnabled(false);
        } else if (this.updateZoneRadioButton.isSelected()) {
            this.zoneExistComboBox.setEnabled(true);
        } else {
            this.zoneExistComboBox.setEnabled(false);
        }
    }

    public void addData() {
    }

    public JDialog getWizardDialog() {
        return null;
    }

    public void skip() {
        this.skipStep = true;
    }

    public boolean previousBegin() {
        boolean bret = false;
        this.getRefreshData = false;
        --this.currentFabric;
        if (this.currentFabric >= 0) {
            bret = false;
            String fabricID = ((GUIFabric)this.fabrics.get(this.currentFabric)).getDeviceId();
            String title1 = Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC_LABEL", fabricID, Util.getString("DISK_VOLUME_ZONE_ACTION_FABRIC2_LABEL", String.valueOf(this.currentFabric + 1), String.valueOf(this.totalFabrics)));
            this.titleLabel.setText(title1);
            this.zoneAction = (ZoneAction)this.zoneSteps.get(fabricID);
            switch (this.zoneAction.action) {
                case 0: {
                    this.newZoneRadioButton.setSelected(true);
                    this.zoneNameTextField.setEnabled(true);
                    this.zoneExistComboBox.setSelectedIndex(0);
                    this.zoneExistComboBox.setEnabled(false);
                    this.zoneNameTextField.setText(this.zoneAction.zoneName);
                    break;
                }
                case 1: {
                    this.updateZoneRadioButton.setSelected(true);
                    this.zoneNameTextField.setEnabled(false);
                    if (this.zoneAction.zoneset != null) {
                        this.zoneSetLabel.setText(Util.getString("DISK_VOLUME_ZONE_ACTION_ZONE_SET_LABEL", this.zoneAction.zoneset.getDeviceId()));
                        this.zoneExistComboBox.setEnabled(true);
                        DefaultComboBoxModel existZoneModel = new DefaultComboBoxModel(this.zoneAction.eZones);
                        this.zoneExistComboBox.setModel(existZoneModel);
                        this.zoneExistComboBox.setSelectedItem(this.zoneAction.zone);
                    }
                    this.zoneNameTextField.setText(new String());
                    break;
                }
                case 2: {
                    this.dontDoRadioButton.setSelected(true);
                    this.zoneExistComboBox.setSelectedIndex(0);
                    this.zoneNameTextField.setText(new String());
                    this.zoneNameTextField.setEnabled(false);
                    this.zoneExistComboBox.setEnabled(false);
                    break;
                }
            }
        } else {
            bret = true;
        }
        return bret;
    }

    public boolean previousComplete() {
        this.currentFabric = -1;
        this.getData = true;
        return true;
    }

    public boolean nextComplete() {
        this.getData = true;
        return true;
    }

    static /* synthetic */ String[] access$002(BaseZoneActionStep x0, String[] x1) {
        x0.portsInZone = x1;
        return x1;
    }

    protected class ZoneAction {
        public String fabricID = new String();
        public GUIZoneSet zoneset = null;
        public GUIZone zone = null;
        public String zoneName = new String();
        public int action = 2;
        public String actionString = new String();
        public Vector eZones = new Vector();
        public Vector hostPorts = new Vector();
        public Vector ssPorts = new Vector();

        protected ZoneAction() {
        }

        public String toString() {
            return this.fabricID + "," + this.zoneset + "," + this.zone + "," + this.zoneName + "," + this.action + "," + this.actionString;
        }
    }
}

