/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskSetCharacteristicsStep;
import org.eclipse.aperi.request.Response;

public class CreateVDiskAddMDiskDialog
extends JDialog
implements ActionListener,
TJCTableMouseInterface {
    public static CreateVDiskAddMDiskDialog addMDiskDialog = null;
    private JLabel titleLabel = null;
    private JLabel mdiskGroupLabel = null;
    private JLabel noDataLabel = null;
    private JTextField mdiskGroupTextField = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton helpButton = null;
    private JPanel mdiskTablePanel = null;
    private DefaultListModel mdiskListModel = null;
    private static String svcID = null;
    private static GUIMDiskGroup mdGroup = null;
    private DiskDataAccessor diskAccessor;
    private DiskDataController diskController = null;
    private DiskGuiTable mdiskTable = null;
    private mdiskTableModel tableModel = null;
    private boolean dblClick = false;
    private static CreateVDiskSetCharacteristicsStep addDialogparent = null;
    private Hashtable vdiskData = null;
    private Vector tempList = null;
    private static final String[] COL_NAMES = new String[]{Util.getString("DISK_MDISKID_LABEL"), Util.getString("DISK_NAME_LABEL"), Util.getString("DISK_STATUS_LABEL"), Util.getString(Util.getString("DISK_CAPACITY_LABEL_MB"))};
    private static final int MDISK_ID = 0;
    private static final int MDISK_NAME = 1;
    private static final int MDISK_STATUS = 2;
    private static final int MDISK_CAPACITY = 3;
    private HashMap mdiskMap = new HashMap();
    private String[] mdiskIDs = null;
    private String[] mdiskStatus = new String[]{Util.getString("DISK_MDISK_STATUS_ONLINE"), Util.getString("DISK_MDISK_STATUS_OFFLINE"), Util.getString("DISK_MDISK_STATUS_EXCLUDED"), Util.getString("DISK_MDISK_STATUS_DEGRADED")};
    private GUIMDisk md = null;
    private Vector mdisks = new Vector();
    private static boolean getData = false;
    private static boolean progress = false;

    private CreateVDiskAddMDiskDialog(JDialog dialogParent, String SVC_ID, GUIMDiskGroup mdiskGroup) {
        super(dialogParent, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), true);
        this.setName(this.getClass().getName());
        this.diskAccessor = DiskDataAccessor.getInstance();
        svcID = SVC_ID;
        mdGroup = mdiskGroup;
        this.create();
        this.setResizable(false);
        this.helpButton.addActionListener(Help.getDisplayHelpFromSource());
        Help.setHelpID(this.helpButton, DiskConstants.DISK_ADD_MDISK);
        Help.setHelpID(this.getRootPane(), DiskConstants.DISK_ADD_MDISK);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
    }

    public static CreateVDiskAddMDiskDialog getAddMDiskDialogInstance(WizardPage parent, String SVC_ID, GUIMDiskGroup mdiskGroup) {
        if (addMDiskDialog == null) {
            JDialog dialogParent = (JDialog)parent.getParent().getParent().getParent().getParent().getParent();
            addDialogparent = (CreateVDiskSetCharacteristicsStep)parent;
            addMDiskDialog = new CreateVDiskAddMDiskDialog(dialogParent, SVC_ID, mdiskGroup);
        } else {
            svcID = SVC_ID;
            mdGroup = mdiskGroup;
            getData = false;
        }
        return addMDiskDialog;
    }

    public void create() {
        this.setTitle(Util.getString("DISK_VDISK_ADDMDISK_LABEL"));
        Container pane = this.getContentPane();
        pane.setLayout(new BoxLayout(pane, 1));
        JPanel mdiskGroupPanel = new JPanel();
        String mdname = mdGroup.getDeviceId();
        mdiskGroupPanel.setLayout(new BoxLayout(mdiskGroupPanel, 0));
        this.mdiskGroupLabel = new JLabel(Util.getString("DISK_VDISK_MDGROUP_LABEL"));
        this.mdiskGroupTextField = new JTextField(mdname);
        mdiskGroupPanel.add(this.mdiskGroupLabel);
        mdiskGroupPanel.add(this.mdiskGroupTextField);
        this.mdiskGroupTextField.setText(mdname);
        this.mdiskGroupTextField.setEditable(false);
        this.mdiskGroupTextField.setSize(new Dimension(mdname.length(), 10));
        mdiskGroupPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        mdiskGroupPanel.add(Box.createHorizontalGlue());
        pane.add(mdiskGroupPanel);
        GuiUtil.setAccessibleLabel(this.mdiskGroupLabel, this.mdiskGroupTextField, "", this.mdiskGroupLabel.getText(), this.mdiskGroupLabel.getText());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VDISK_ADDMDISK_MDISKS"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        titlePanel.add(this.titleLabel);
        titlePanel.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        pane.add(titlePanel);
        this.mdiskTablePanel = new JPanel();
        this.mdiskTablePanel.setLayout(new BoxLayout(this.mdiskTablePanel, 0));
        this.mdiskTable = new DiskGuiTable();
        this.mdiskTable.setMouseListener(this);
        this.mdiskTable.setColumnHidden(0, true);
        this.mdiskTable.setRowIcon(10, false);
        this.mdiskTablePanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.mdiskTable.setCellRenderer(BigDecimal.class, TableCellRenderers.number);
        this.mdiskTablePanel.add(this.mdiskTable);
        this.mdiskTablePanel.setPreferredSize(new Dimension(350, 100));
        pane.add(this.mdiskTablePanel);
        this.noDataLabel = new JLabel(Util.getString("DISK_NO_DATA_LABEL"));
        this.noDataLabel.setAlignmentX(0.0f);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.okButton = new JButton(Util.getString("DISK_OK_BUTTON"));
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.cancelButton = new JButton(Util.getString("DISK_CANCEL_BUTTON"));
        this.cancelButton.addActionListener(this);
        this.helpButton = new JButton(Util.getString("DISK_HELP_BUTTON"));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.helpButton);
        pane.add(buttonPanel);
    }

    public void invalidate() {
        super.invalidate();
        if (!getData) {
            if (this.mdiskGroupTextField != null) {
                this.mdiskGroupTextField.setText(mdGroup.getDeviceId());
            }
            this.fillData(svcID);
            getData = true;
        }
    }

    private boolean addMDisksToMDiskGroup() {
        int[] mdiskids = new int[]{};
        if (this.mdiskTable.isVisible()) {
            mdiskids = this.mdiskTable.getSelectedRows();
        }
        for (int i = 0; i < mdiskids.length; ++i) {
            if (mdiskids.length > 0 && this.mdiskTable.isVisible()) continue;
            String s = Util.getString("DISK_VDISK_ADDMDISK_WARNING");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), 1);
            return true;
        }
        Vector<Object> mdiskIDs = new Vector<Object>();
        for (int i = 0; i < mdiskids.length; ++i) {
            mdiskIDs.add(this.mdiskTable.getDataSource().getValueAt(mdiskids[i], 0));
        }
        String[] mdisks = mdiskIDs.toArray(new String[0]);
        this.diskController = DiskDataController.getInstance();
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        progress = true;
        this.diskController.addMisks(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                int jobID;
                Response jobStatusResponse;
                if (status <= 4 && (jobStatusResponse = GuiDeviceJob.getJobStatus(jobID = ((Integer)response.responseData).intValue(), true)) != null) {
                    AsyncResult result = (AsyncResult)jobStatusResponse.responseData;
                    if (result != null && result.getRc() <= 0) {
                        getData = false;
                        CreateVDiskAddMDiskDialog.this.invalidate();
                        String s = Util.getString("DISK_SUBSYSTEMS_SAVE_CONFIRMATION_LABEL");
                        JOptionPane.showMessageDialog(addMDiskDialog, s, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), 1);
                        addDialogparent.invalidateMDGroups();
                    } else {
                        addDialogparent.invalidateMDGroups();
                        String s = Util.getString("DMSG_DISK_ADD_MDISK_FAILED");
                        JOptionPane.showMessageDialog(addMDiskDialog, s, Util.getString("DISK_VDISK_ADDMDISK_LABEL"), 0);
                    }
                    progress = false;
                    CreateVDiskAddMDiskDialog.this.closeDialog();
                }
            }
        }, mdGroup.getId(), mdisks);
        return true;
    }

    public void closeDialog() {
        this.dispose();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = null;
        if (e == null) {
            return;
        }
        source = e.getSource();
        if (source == null) {
            return;
        }
        if (source.equals(this.okButton)) {
            this.addMDisksToMDiskGroup();
        }
        if (source.equals(this.cancelButton)) {
            this.dispose();
            getData = false;
        }
    }

    public boolean select(int viewRow, int viewCol) {
        boolean selectIt = true;
        if (this.dblClick) {
            this.dblClick = false;
            selectIt = false;
        }
        return selectIt;
    }

    public void showDefaultChart(int dataRow) {
    }

    public void selectionChanged(boolean state) {
        if (!progress) {
            try {
                int i = this.mdiskTable.getSelectedRows()[0];
            }
            catch (NullPointerException npex) {
                this.okButton.setEnabled(false);
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayex) {
                this.okButton.setEnabled(false);
                return;
            }
        }
    }

    public void doubleClick(int dataRow, int dataCol) {
        this.dblClick = true;
    }

    public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
    }

    private DefaultListModel addVectorToModel(Vector vv) {
        DefaultListModel model = new DefaultListModel();
        if (vv == null) {
            return model;
        }
        for (int i = 0; i < vv.size(); ++i) {
            model.add(i, vv.get(i));
        }
        return model;
    }

    private void fillData(String svcid) {
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.mdisks.removeAllElements();
        this.diskAccessor.getUnmanagedMDisksBySVC(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    CreateVDiskAddMDiskDialog.this.mdiskMap = (HashMap)response.responseData;
                    CreateVDiskAddMDiskDialog.access$402(CreateVDiskAddMDiskDialog.this, CreateVDiskAddMDiskDialog.this.mdiskMap.keySet().toArray(new String[0]));
                    if (CreateVDiskAddMDiskDialog.this.mdiskMap != null) {
                        Iterator iter = CreateVDiskAddMDiskDialog.this.mdiskMap.values().iterator();
                        while (iter.hasNext()) {
                            CreateVDiskAddMDiskDialog.this.md = (GUIMDisk)iter.next();
                            CreateVDiskAddMDiskDialog.this.mdisks.add(CreateVDiskAddMDiskDialog.this.md.getName());
                        }
                        if (CreateVDiskAddMDiskDialog.this.mdisks.size() <= 0) {
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setVisible(false);
                            CreateVDiskAddMDiskDialog.this.mdiskTablePanel.add(CreateVDiskAddMDiskDialog.this.noDataLabel);
                        } else {
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setVisible(true);
                            CreateVDiskAddMDiskDialog.this.mdiskTablePanel.remove(CreateVDiskAddMDiskDialog.this.noDataLabel);
                            CreateVDiskAddMDiskDialog.this.tableModel = new mdiskTableModel();
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setFrozenColumns(0);
                            CreateVDiskAddMDiskDialog.this.mdiskTable.setBaseTableModel(CreateVDiskAddMDiskDialog.this.tableModel);
                            CreateVDiskAddMDiskDialog.this.mdiskTable.sortByColumn(0, 1);
                            CreateVDiskAddMDiskDialog.this.okButton.setEnabled(true);
                        }
                    }
                }
                CreateVDiskAddMDiskDialog.this.cancelButton.setEnabled(true);
            }
        }, svcID);
    }

    static /* synthetic */ String[] access$402(CreateVDiskAddMDiskDialog x0, String[] x1) {
        x0.mdiskIDs = x1;
        return x1;
    }

    private class mdiskTableModel
    extends BaseTableModel {
        public mdiskTableModel() {
            this.columnNames = COL_NAMES;
            this.rowCount = CreateVDiskAddMDiskDialog.this.mdiskMap.size();
        }

        public Object getTableDataItem(int row, int col) {
            this.rowCount = CreateVDiskAddMDiskDialog.this.mdiskMap.size();
            if (this.rowCount <= 0) {
                return null;
            }
            GUIMDisk mdisk = (GUIMDisk)CreateVDiskAddMDiskDialog.this.mdiskMap.get(CreateVDiskAddMDiskDialog.this.mdiskIDs[row]);
            switch (col) {
                case 0: {
                    return mdisk.getId();
                }
                case 1: {
                    return mdisk.getName();
                }
                case 2: {
                    return CreateVDiskAddMDiskDialog.this.mdiskStatus[mdisk.getState()];
                }
                case 3: {
                    long ll = new Long(mdisk.getCapacity());
                    ll = GUIEntityUtil.convertStorageCapacity(ll, 0, 2);
                    return new BigDecimal(ll);
                }
            }
            return "";
        }
    }
}

