/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.disk.api.VolumeID;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.Wizard;
import org.eclipse.aperi.gui.WizardEvent;
import org.eclipse.aperi.gui.WizardListener;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDataController;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.volume.BaseZoneActionStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeReviewStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSelectSubsystemPortsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeSetCharacteristicsStep;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeZoneActionStep;
import org.eclipse.aperi.request.Response;

public class CreateVolumeWizard
extends Wizard
implements WizardListener {
    private CreateVolumeSelectHostPortsStep hostStep = null;
    private CreateVolumeZoneActionStep zoneStep = null;
    private CreateVolumeReviewStep reviewStep = null;
    private CreateVolumeSetCharacteristicsStep charStep = null;
    private CreateVolumeSelectSubsystemPortsStep portStep = null;
    private String SS_ID = null;
    private String deviceID = null;
    private Vector volumeVector = new Vector();
    private Vector hostports = new Vector();
    private Vector ssports = new Vector();
    private String[] hostportWWPNs = null;
    private String[] ssportWWPNs = null;
    private String[] volumeIDs = null;
    private DiskDataController diskController = null;
    private GUIStorageSubsystem subSystem = null;
    private JDialog wizardDialog = null;
    private HashMap volumeData = null;
    private HashMap unitsMap = new HashMap();
    private int WIZARD_FLAGS = 31;

    public CreateVolumeWizard(GUIStorageSubsystem ss) {
        this.subSystem = ss;
        this.SS_ID = this.subSystem.getId();
        this.deviceID = this.subSystem.getDeviceId();
        this.addWizardListener(this);
        this.volumeData = new HashMap();
        this.charStep = new CreateVolumeSetCharacteristicsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.charStep);
        this.hostStep = new CreateVolumeSelectHostPortsStep(this.WIZARD_FLAGS, this.subSystem);
        this.add(this.hostStep);
        if (this.subSystem.isTargetPortRestrictionSupported() && 4 != this.subSystem.getCapabilityData().getPortsPerView()) {
            this.portStep = new CreateVolumeSelectSubsystemPortsStep(this.WIZARD_FLAGS, this.subSystem);
            this.add(this.portStep);
        }
        this.zoneStep = new CreateVolumeZoneActionStep(this.WIZARD_FLAGS, this.SS_ID);
        this.add(this.zoneStep);
        this.reviewStep = new CreateVolumeReviewStep(this.WIZARD_FLAGS, this.SS_ID);
        this.add(this.reviewStep);
        this.unitsMap.put(Util.getString("DISK_BYTES"), "0");
        this.unitsMap.put(Util.getString("DISK_KB"), "1");
        this.unitsMap.put(Util.getString("DISK_MB"), "2");
        this.unitsMap.put(Util.getString("DISK_GB"), "3");
        this.unitsMap.put(Util.getString("DISK_TB"), "4");
        this.unitsMap.put(Util.getString("DISK_PB"), "5");
    }

    public CreateVolumeSelectSubsystemPortsStep getSubsystemPortsStep() {
        return this.portStep;
    }

    public CreateVolumeSelectHostPortsStep getHostPortsStep() {
        return this.hostStep;
    }

    public WizardPage getCurrentStep() {
        return (WizardPage)this.getCurrentPage();
    }

    public void addVolumeData(String key, Object data) {
        this.volumeData.put(key, data);
    }

    public HashMap getData() {
        return this.volumeData;
    }

    public void nextBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextBegin());
        if ((WizardPage)e.getCurrentPage() == this.hostStep) {
            if (this.hostStep.skipSubsystemStep()) {
                e.setNewPage(this.zoneStep);
            } else if (this.hostStep.skipToReviewStep()) {
                e.setNewPage(this.reviewStep);
            }
        }
    }

    public void nextComplete(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).nextComplete());
        if ((WizardPage)e.getNewPage() == this.hostStep) {
            this.hostStep.getSSPortsFromSystem();
        }
        if ((WizardPage)e.getNewPage() == this.portStep) {
            this.portStep.fillData();
        }
        if ((WizardPage)e.getNewPage() == this.zoneStep) {
            this.zoneStep.fillData();
        }
        if ((WizardPage)e.getNewPage() == this.reviewStep) {
            this.reviewStep.fillData();
        }
    }

    public void previousBegin(WizardEvent e) {
        e.setAllowChange(((WizardPage)e.getCurrentPage()).previousBegin());
        if ((WizardPage)e.getCurrentPage() == this.reviewStep) {
            if (this.hostStep.skipSubsystemStep()) {
                e.setNewPage(this.zoneStep);
            } else if (this.hostStep.skipToReviewStep()) {
                e.setNewPage(this.hostStep);
            }
        }
    }

    public void finished(WizardEvent e) {
        super.finished(e);
        if (((WizardPage)e.getCurrentPage()).equals(this.reviewStep)) {
            String s = Util.getString("DISK_VOLUMES_WIZARD_FINISHED");
            JOptionPane.showMessageDialog(this, s, Util.getString("DISK_VOLUME_WIZARD_TITLE", this.deviceID), 1);
            this.closeWizard();
            new VolumeThread(this).start();
        }
    }

    public void canceled(WizardEvent e) {
        int action = JOptionPane.showConfirmDialog(this, Util.getString("DISK_VOLUMES_WIZARD_CANCELED"), Util.getString("DISK_VOLUME_WIZARD_TITLE", this.deviceID), 0);
        switch (action) {
            case 0: {
                super.canceled(e);
                this.closeWizard();
                break;
            }
        }
    }

    private void closeWizard() {
        JDialog wizardDialog = (JDialog)this.getParent().getParent().getParent().getParent();
        wizardDialog.dispose();
    }

    static /* synthetic */ String[] access$602(CreateVolumeWizard x0, String[] x1) {
        x0.hostportWWPNs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$802(CreateVolumeWizard x0, String[] x1) {
        x0.ssportWWPNs = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1002(CreateVolumeWizard x0, String[] x1) {
        x0.volumeIDs = x1;
        return x1;
    }

    public class VolumeJobResultThread
    extends JobResultThread {
        public VolumeJobResultThread(int jobID) {
            super(jobID);
        }

        public void run() {
            Response jobStatusResponse = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (jobStatusResponse != null) {
                int i;
                AsyncResult result = (AsyncResult)jobStatusResponse.responseData;
                AsyncResult[] subResults = result.getSubJobResults();
                for (i = 0; subResults != null && i < subResults.length; ++i) {
                    Exception tpcEx = subResults[i].getReturnException();
                    if (tpcEx != null) {
                        String errorMsg = tpcEx.getMessage();
                        if (tpcEx instanceof SRMRuntimeException) {
                            errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                        }
                        if (errorMsg != null) {
                            // empty if block
                        }
                    }
                    if (subResults[i] == null || subResults[i].getResults() == null || subResults[i].getRc() > 0) continue;
                    VolumeID[] volumeIds = (VolumeID[])subResults[i].getResults();
                    CreateVolumeWizard.this.volumeVector.add(volumeIds[0].getStorageVolumeID());
                }
                CreateVolumeWizard.access$602(CreateVolumeWizard.this, new String[CreateVolumeWizard.this.hostports.size()]);
                for (i = 0; i < CreateVolumeWizard.this.hostports.size(); ++i) {
                    ((CreateVolumeWizard)CreateVolumeWizard.this).hostportWWPNs[i] = ((GUIPort)CreateVolumeWizard.this.hostports.get(i)).getWwpn();
                }
                if (!CreateVolumeWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVolumeWizard.this.subSystem.getCapabilityData().getPortsPerView()) {
                    CreateVolumeWizard.access$802(CreateVolumeWizard.this, new String[CreateVolumeWizard.this.ssports.size()]);
                    for (i = 0; i < CreateVolumeWizard.this.ssports.size(); ++i) {
                        ((CreateVolumeWizard)CreateVolumeWizard.this).ssportWWPNs[i] = ((GUIPort)CreateVolumeWizard.this.ssports.get(i)).getWwpn();
                    }
                } else {
                    CreateVolumeWizard.access$802(CreateVolumeWizard.this, null);
                }
                CreateVolumeWizard.access$1002(CreateVolumeWizard.this, CreateVolumeWizard.this.volumeVector.toArray(new String[0]));
                if (CreateVolumeWizard.this.hostportWWPNs.length > 0 && CreateVolumeWizard.this.volumeIDs.length > 0) {
                    CreateVolumeWizard.this.diskController.assignPorts(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                            if (status <= 4) {
                                int jobID = (Integer)response.responseData;
                                new JobResultThread(jobID).start();
                            }
                        }
                    }, CreateVolumeWizard.this.volumeIDs, CreateVolumeWizard.this.ssportWWPNs, CreateVolumeWizard.this.hostportWWPNs);
                }
            }
        }
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        protected String fabricID = null;

        public JobResultThread(int jobID) {
            this.jobID = jobID;
        }

        public JobResultThread(int jobID, String fabricID) {
            this.jobID = jobID;
            this.fabricID = fabricID;
        }

        public void run() {
            Response jobStatusResponse = GuiDeviceJob.getJobStatus(this.jobID, true);
            if (this.fabricID != null) {
                AsyncResult result;
                boolean errorOccured = false;
                if (jobStatusResponse != null && (result = (AsyncResult)jobStatusResponse.responseData) != null && (result.getReturnException() != null || result.getRc() > 0)) {
                    errorOccured = true;
                }
                if (errorOccured) {
                    CreateVolumeWizard.this.diskController.rollbackFabricTransaction(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                        }
                    }, this.fabricID);
                } else {
                    CreateVolumeWizard.this.diskController.releaseFabric(new GuiRequestor(){

                        public void handleResponse(short status, Response response) {
                        }
                    }, this.fabricID);
                }
            }
            if (jobStatusResponse != null) {
                AsyncResult result = (AsyncResult)jobStatusResponse.responseData;
                AsyncResult[] subResults = result.getSubJobResults();
                for (int i = 0; subResults != null && i < subResults.length; ++i) {
                    Exception tpcEx = subResults[i].getReturnException();
                    if (tpcEx != null) {
                        String errorMsg = tpcEx.getMessage();
                        if (tpcEx instanceof SRMRuntimeException) {
                            errorMsg = ((SRMRuntimeException)tpcEx).getLocalizedMessage();
                        }
                        if (errorMsg != null) {
                            // empty if block
                        }
                    }
                    if (subResults[i] == null || subResults[i].getResults() == null || subResults[i].getRc() > 0) continue;
                    Object[] retvals = subResults[i].getResults();
                }
            }
        }
    }

    public class ZoneRequestor
    implements GuiRequestor {
        String fabricID = null;

        public ZoneRequestor(String fabricID) {
            this.fabricID = fabricID;
        }

        public void handleResponse(short status, Response response) {
            if (status <= 4) {
                int jobID = (Integer)response.responseData;
                new JobResultThread(jobID, this.fabricID).start();
            }
        }
    }

    public class VolumeThread
    extends Thread {
        private CreateVolumeWizard wizard;

        public VolumeThread(CreateVolumeWizard cvWizard) {
            this.wizard = cvWizard;
        }

        public void run() {
            this.createVolumes();
        }

        private void createVolumes() {
            int i;
            int volumeQuantity = 0;
            long size = 0L;
            String name = new String();
            String units = new String();
            CreateVolumeWizard.this.wizardDialog = (JDialog)this.wizard.getParent().getParent().getParent().getParent();
            CreateVolumeWizard.this.diskController = DiskDataController.getInstance();
            volumeQuantity = Integer.valueOf(CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUME_QUANTITY_LABEL")).toString());
            size = Long.valueOf(CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUME_SIZE_LABEL")).toString());
            units = CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_UNITS_LABEL")).toString();
            units = (String)CreateVolumeWizard.this.unitsMap.get(units);
            size = GUIEntityUtil.convertStorageCapacity(size, Integer.valueOf(units), 0);
            Vector volumeList = (Vector)CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUMES_LABEL"));
            String[] volumeNames = volumeList != null ? volumeList.toArray(new String[0]) : null;
            GUIStoragePool sPool = (GUIStoragePool)CreateVolumeWizard.this.volumeData.get(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"));
            CreateVolumeWizard.this.hostports = (Vector)CreateVolumeWizard.this.volumeData.get(CreateVolumeSelectHostPortsStep.HOSTPORTS_DATA);
            CreateVolumeWizard.this.ssports = (Vector)CreateVolumeWizard.this.volumeData.get(CreateVolumeSelectSubsystemPortsStep.SUBSYSTEM_DATA);
            CreateVolumeWizard.access$602(CreateVolumeWizard.this, new String[CreateVolumeWizard.this.hostports.size()]);
            for (i = 0; i < CreateVolumeWizard.this.hostports.size(); ++i) {
                ((CreateVolumeWizard)CreateVolumeWizard.this).hostportWWPNs[i] = ((GUIPort)CreateVolumeWizard.this.hostports.get(i)).getWwpn();
            }
            if (CreateVolumeWizard.this.subSystem.isTargetPortRestrictionSupported() && 4 != CreateVolumeWizard.this.subSystem.getCapabilityData().getPortsPerView() && CreateVolumeWizard.this.ssports != null) {
                CreateVolumeWizard.access$802(CreateVolumeWizard.this, new String[CreateVolumeWizard.this.ssports.size()]);
                for (i = 0; i < CreateVolumeWizard.this.ssports.size(); ++i) {
                    ((CreateVolumeWizard)CreateVolumeWizard.this).ssportWWPNs[i] = ((GUIPort)CreateVolumeWizard.this.ssports.get(i)).getWwpn();
                }
            } else {
                CreateVolumeWizard.access$802(CreateVolumeWizard.this, null);
            }
            HashMap zoneActionSteps = (HashMap)CreateVolumeWizard.this.volumeData.get(CreateVolumeZoneActionStep.ZONE_ACTION_DATA);
            if (zoneActionSteps != null) {
                Iterator iter = zoneActionSteps.values().iterator();
                Vector vv = new Vector(zoneActionSteps.values());
                while (iter.hasNext()) {
                    int i2;
                    String[] portWWpn;
                    Vector ports;
                    BaseZoneActionStep.ZoneAction zoneAction = (BaseZoneActionStep.ZoneAction)iter.next();
                    if (zoneAction.action == 0) {
                        zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                        ports = zoneAction.hostPorts;
                        portWWpn = new String[ports.size()];
                        for (i2 = 0; i2 < ports.size(); ++i2) {
                            portWWpn[i2] = ((GUIPort)ports.get(i2)).getWwpn();
                        }
                        CreateVolumeWizard.this.diskController.createZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, portWWpn);
                        continue;
                    }
                    if (zoneAction.action != 1) continue;
                    zoneAction.hostPorts.addAll(zoneAction.ssPorts);
                    ports = zoneAction.hostPorts;
                    portWWpn = new String[ports.size()];
                    for (i2 = 0; i2 < ports.size(); ++i2) {
                        portWWpn[i2] = ((GUIPort)ports.get(i2)).getWwpn();
                    }
                    CreateVolumeWizard.this.diskController.updateZone(new ZoneRequestor(zoneAction.fabricID), zoneAction.fabricID, zoneAction.zoneset.getName(), zoneAction.zoneName, portWWpn);
                }
            }
            if (CreateVolumeWizard.this.hostportWWPNs == null || CreateVolumeWizard.this.hostportWWPNs.length == 0) {
                CreateVolumeWizard.this.diskController.createVolumes(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                    }
                }, size, sPool.getId(), volumeQuantity, volumeNames, false);
            } else {
                CreateVolumeWizard.this.diskController.createVolumesAndAssignPorts(new GuiRequestor(){

                    public void handleResponse(short status, Response response) {
                    }
                }, size, sPool.getId(), volumeQuantity, volumeNames, CreateVolumeWizard.this.ssportWWPNs, CreateVolumeWizard.this.hostportWWPNs);
            }
        }
    }
}

