/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIPortAssignment;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.BaseSelectHostPortsStep;
import org.eclipse.aperi.gui.disk.volume.PortAssignmentWizard;
import org.eclipse.aperi.request.Response;

public class PortAssignmentSelectHostPortsStep
extends BaseSelectHostPortsStep {
    private HashMap portsmap = new HashMap();
    private GUIPortAssignment portassign = null;
    private String SS_ID = null;
    private GUIVolume selectedVolume = null;
    public static String SUBSYSTEM_DATA = "Subsystem Ports";
    public static String DISK_VOLUME_HOST_PORT_UNASSIGN_DS4000_WARNING = "Unassign of the selected ports from the volume will result in all ports being unassigned from the volume.";
    public static String DISK_VOLUME_HOST_PORT_UNASSIGN_SVC_WARNING = "Unassign of the selected ports from the virtual disk will result in all ports in the host being unassigned from the virtual disk.";

    public PortAssignmentSelectHostPortsStep(int buttonFlags, GUIStorageSubsystem ss) {
        super(buttonFlags, ss);
        this.SS_ID = ss.getId();
        this.setName("PortAssignmentSelectHostPortsStep");
        this.getPreviousButton().setEnabled(false);
        this.setUpHelp(DiskConstants.DISK_ASSIGN_HOST_PORTS);
    }

    public Object next() {
        if (this.subSystem.isTargetPortRestrictionSupported() && 4 != this.subSystem.getCapabilityData().getPortsPerView() && this.subSystem.getType() != 4) {
            return "PortAssignmentSelectSubsystemPortsStep";
        }
        return "PortAssignmentZoneActionStep";
    }

    public JPanel create() {
        return super.create();
    }

    public void getAssignedPorts() {
        this.diskAccessor = DiskDataAccessor.getInstance();
        PortAssignmentWizard paWizard = (PortAssignmentWizard)this.getParent();
        this.selectedVolume = paWizard.getSelectedVolume();
        this.originalList = new Vector();
        this.diskAccessor.getPortAssignments(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status <= 4 && response != null) {
                    PortAssignmentSelectHostPortsStep.this.portsmap = (HashMap)response.responseData;
                    if (!PortAssignmentSelectHostPortsStep.this.portsmap.isEmpty()) {
                        Iterator iter = PortAssignmentSelectHostPortsStep.this.portsmap.values().iterator();
                        Vector ss = new Vector();
                        String temp2 = new String();
                        while (iter.hasNext()) {
                            PortAssignmentSelectHostPortsStep.this.portassign = (GUIPortAssignment)iter.next();
                            temp2 = PortAssignmentSelectHostPortsStep.this.portassign.getHostPortWwpn();
                            PortAssignmentSelectHostPortsStep.this.assignedhostports.put(temp2, temp2);
                        }
                        String portItem = new String();
                        for (String temp2 : PortAssignmentSelectHostPortsStep.this.assignedhostports.values()) {
                            if (PortAssignmentSelectHostPortsStep.this.portWWPN.containsKey(temp2) && PortAssignmentSelectHostPortsStep.this.srcModel.contains(portItem = (String)PortAssignmentSelectHostPortsStep.this.portWWPN.get(temp2))) {
                                PortAssignmentSelectHostPortsStep.this.srcModel.removeElement(portItem);
                            }
                            if (portItem.length() > 0) {
                                PortAssignmentSelectHostPortsStep.this.selModel.addElement(portItem);
                                PortAssignmentSelectHostPortsStep.this.originalList.add(portItem);
                            } else {
                                PortAssignmentSelectHostPortsStep.this.selModel.addElement(temp2);
                                PortAssignmentSelectHostPortsStep.this.originalList.add(temp2);
                            }
                            portItem = new String();
                        }
                        PortAssignmentSelectHostPortsStep.this.sourceList.setModel(PortAssignmentSelectHostPortsStep.this.srcModel);
                        PortAssignmentSelectHostPortsStep.this.selectedList.setModel(PortAssignmentSelectHostPortsStep.this.selModel);
                        PortAssignmentSelectHostPortsStep.this.originalListRHS = PortAssignmentSelectHostPortsStep.this.portList.getSelList();
                        PortAssignmentSelectHostPortsStep.this.originalListLHS = PortAssignmentSelectHostPortsStep.this.portList.getSrcList();
                        if (PortAssignmentSelectHostPortsStep.this.originalListRHS == null) {
                            PortAssignmentSelectHostPortsStep.this.originalListRHS = new ArrayList();
                        }
                        if (PortAssignmentSelectHostPortsStep.this.originalListLHS == null) {
                            PortAssignmentSelectHostPortsStep.this.originalListLHS = new ArrayList();
                        }
                    }
                }
            }
        }, this.SS_ID, this.selectedVolume.getId());
    }

    public boolean nextBegin() {
        int i;
        boolean retVal = super.nextBegin();
        if (this.portAssignFlag) {
            this.portAssignFlag = false;
            return false;
        }
        Object hport = null;
        this.unAssignedPorts = new Vector();
        this.unAssignedPortsWithHosts = new Vector();
        HashMap<String, Object> srcMap = new HashMap<String, Object>();
        GUIPort port = null;
        for (i = 0; i < this.srcModel.size(); ++i) {
            try {
                port = (GUIPort)this.srcModel.get(i);
                srcMap.put(port.getWwpn(), port);
                continue;
            }
            catch (ClassCastException ce) {
                String wwpn = (String)this.srcModel.get(i);
                srcMap.put(wwpn, wwpn);
            }
        }
        for (i = 0; i < this.originalList.size(); ++i) {
            try {
                port = (GUIPort)srcMap.get(this.originalList.get(i));
                if (port == null) continue;
                this.unAssignedPorts.add(port.getWwpn());
                continue;
            }
            catch (ClassCastException ce) {
                int ind;
                String portItem = (String)srcMap.get(this.originalList.get(i));
                String wwpn = new String();
                if (portItem == null) continue;
                if (!this.unAssignedPortsWithHosts.contains(portItem)) {
                    this.unAssignedPortsWithHosts.add(portItem);
                }
                wwpn = (ind = portItem.indexOf(40)) != -1 ? portItem.substring(0, ind) : portItem;
                this.unAssignedPorts.add(wwpn);
            }
        }
        if (this.unAssignedPorts.size() > 0) {
            if (this.subSystem.getType() == 1 || this.subSystem.getType() == 5) {
                this.warningMessage(DISK_VOLUME_HOST_PORT_UNASSIGN_DS4000_WARNING);
            } else if (this.subSystem.getType() == 4) {
                this.warningMessage(DISK_VOLUME_HOST_PORT_UNASSIGN_SVC_WARNING);
            }
        }
        PortAssignmentWizard paWizard = (PortAssignmentWizard)this.getParent();
        paWizard.removeData(HOSTPORTS_ASSIGNED_DATA);
        paWizard.removeData(HOSTPORTS_UNASSIGNED_DATA);
        paWizard.removeData(HOSTPORTS_UNASSIGNED_HOSTS_DATA);
        paWizard.addData(HOSTPORTS_ASSIGNED_DATA, this.assignedhostports);
        paWizard.addData(HOSTPORTS_UNASSIGNED_DATA, this.unAssignedPorts);
        paWizard.addData(HOSTPORTS_UNASSIGNED_HOSTS_DATA, this.unAssignedPortsWithHosts);
        HashMap paData = paWizard.getData();
        Vector unAssignhostports = (Vector)paData.get(HOSTPORTS_UNASSIGNED_HOSTS_DATA);
        return retVal;
    }

    public void addData(Vector ports) {
        PortAssignmentWizard paWizard = (PortAssignmentWizard)this.getParent();
        paWizard.addData(HOSTPORTS_DATA, ports);
        if (ports == null || ports.size() < 1) {
            this.skipToReviewStep = true;
        }
        if (paWizard.getSubsystemPortsStep() == null || this.addSSData) {
            paWizard.addData(SUBSYSTEM_DATA, this.ssportData);
        }
    }

    public JDialog getWizard() {
        PortAssignmentWizard paWizard = (PortAssignmentWizard)this.getParent();
        JDialog wizardDialog = (JDialog)paWizard.getParent().getParent().getParent().getParent();
        return wizardDialog;
    }
}

