/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.math.BigDecimal;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;

public class VolumeTableModel
extends BaseTableModel {
    private VolumeDDI aDDI;
    private static final String[] COL_NAMES = new String[]{Util.getString("DISK_VOLUME_LABEL"), Util.getString("DISK_SUBSYSTEM_LABEL"), Util.getString("DISK_COMMON_SUBSYSTEM_LABEL"), Util.getString("DISK_LCU_LABEL"), Util.getString("DISK_TYPE_LABEL"), Util.getString("DISK_SIZE_LABEL"), Util.getString("DISK_UNIT_LABEL")};
    private static final int SYS_VOLID = 0;
    private static final int SYS_SUBID = 1;
    private static final int SYS_SUBNAME = 2;
    private static final int SYS_LCU = 3;
    private static final int SYS_TYPE = 4;
    private static final int SYS_SIZE = 5;
    private static final int SYS_UNIT = 6;
    private static final int SYS_ASSIGN = 7;
    public static final int FILTER_NONE = 0;
    public static final int FILTER_BY_ARRAY = 1;
    public static final int FILTER_BY_HOST = 2;
    public static final int FILTER_ALL = 3;

    VolumeTableModel(VolumeDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getRowCount();
    }

    public Object getTableDataItem(int row, int col) {
        try {
            GUIVolume vol = this.aDDI.getRowDataAt(row);
            switch (col) {
                case 0: {
                    return GUIEntityUtil.getDisplayText(vol.getDeviceId());
                }
                case 1: {
                    return GUIEntityUtil.getDisplayText(vol.getSubsystemDeviceId());
                }
                case 2: {
                    return GUIEntityUtil.getDisplayText(vol.getSubsystemName());
                }
                case 3: {
                    return GUIEntityUtil.getDisplayText(vol.getLcu());
                }
                case 4: {
                    if (vol.getFormat() == 0) {
                        return Util.getString("DISK_FB_LABEL");
                    }
                    if (vol.getFormat() == 1 || vol.getFormat() == 2) {
                        return Util.getString("DISK_CKD_LABEL");
                    }
                    return DiskConstants.DISK_VALUE_IS_NULL;
                }
                case 5: {
                    switch (vol.getFormat()) {
                        case 0: {
                            return new Double(GUIEntityUtil.convertStorageCapacity(vol.getCapacity(), 0, 3, 10));
                        }
                        case 1: {
                            switch (this.aDDI.subsystem.getType()) {
                                case 0: {
                                    return BigDecimal.valueOf(vol.getCapacity()).divide(new BigDecimal("798720"), 4).toBigInteger();
                                }
                                case 2: 
                                case 3: {
                                    return BigDecimal.valueOf(vol.getCapacity()).divide(new BigDecimal("712140"), 4).toBigInteger();
                                }
                            }
                            return DiskConstants.DISK_VALUE_IS_NULL;
                        }
                        case 2: {
                            switch (this.aDDI.subsystem.getType()) {
                                case 0: {
                                    return BigDecimal.valueOf(vol.getCapacity()).divide(new BigDecimal("860160"), 4).toBigInteger();
                                }
                                case 2: 
                                case 3: {
                                    return BigDecimal.valueOf(vol.getCapacity()).divide(new BigDecimal("849960"), 4).toBigInteger();
                                }
                            }
                            return DiskConstants.DISK_VALUE_IS_NULL;
                        }
                    }
                    return DiskConstants.DISK_VALUE_IS_NULL;
                }
                case 6: {
                    if (vol.getFormat() == 0) {
                        return Util.getString("DISK_GB_LABEL");
                    }
                    if (vol.getFormat() == 1 || vol.getFormat() == 2) {
                        return Util.getString("DISK_CYL_LABEL");
                    }
                    return DiskConstants.DISK_VALUE_IS_NULL;
                }
            }
            return DiskConstants.DISK_VALUE_IS_NULL;
        }
        catch (ArrayIndexOutOfBoundsException arrayex) {
            return DiskConstants.DISK_VALUE_IS_NULL;
        }
    }

    public boolean checkIfNull(String text) {
        return text == null || text.equals("");
    }
}

