/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.details;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.details.BaseDetailsPanel;
import org.eclipse.aperi.gui.fabric.details.BladeTableModel;
import org.eclipse.aperi.gui.fabric.details.DetailsDDI;
import org.eclipse.aperi.gui.fabric.details.DetailsSubPanel;
import org.eclipse.aperi.gui.fabric.details.DoDeviceRequestThread;
import org.eclipse.aperi.gui.fabric.details.EventTableModel;
import org.eclipse.aperi.gui.fabric.details.MaxSizePanel;
import org.eclipse.aperi.gui.fabric.details.MyStringTokenizer;
import org.eclipse.aperi.gui.fabric.details.SensorTableModel;
import org.eclipse.aperi.gui.fabric.details.TablePanel;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.fabric.details.GuiDetailsReq;

public class SwitchDetailsPanel
extends BaseDetailsPanel
implements ChangeListener {
    static final String END_OF_ENTITY = ">EOE<";
    DetailsSubPanel detailsPanel;
    TablePanel sensorsPanel;
    TablePanel eventsPanel;
    TablePanel bladesPanel;
    TablePanel blades2Panel;
    JPanel sensorsPanel2;
    JPanel eventsPanel2;
    private static final boolean DEBUG_LAYOUT = false;
    JPanel outerPanel;
    boolean hasBeenRun = false;
    boolean bladesDisplayed = false;
    JTabbedPane tab;

    public SwitchDetailsPanel(String entityType, String entityID) {
        super(entityType, entityID);
    }

    public void buildPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeDetailPanel(), "Center");
    }

    public JPanel makeTabbedPanel(Component c) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints panelGbc = new GridBagConstraints();
        panelGbc.anchor = 18;
        panelGbc.weightx = 1.0;
        panelGbc.weighty = 1.0;
        panelGbc.insets = new Insets(15, 15, 15, 15);
        panelGbc.gridwidth = 0;
        panelGbc.fill = 1;
        p.add(c, panelGbc);
        return p;
    }

    public JPanel makeDetailPanel() {
        this.hasBeenRun = false;
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new BorderLayout(15, 15));
        this.tab = new JTabbedPane();
        this.detailsPanel = new DetailsSubPanel(this.entityType, this.entityID, new Insets(0, 0, 0, 0), false);
        this.tab.add((Component)this.makeTabbedPanel(this.detailsPanel), FabricGuiUtil.getString("FabricDetails_DetailsTwistie"));
        this.outerPanel.add(this.tab);
        this.sensorsPanel = new TablePanel();
        this.eventsPanel = new TablePanel();
        this.bladesPanel = new TablePanel();
        this.sensorsPanel2 = this.makeTabbedPanel(this.sensorsPanel);
        this.tab.add((Component)this.sensorsPanel2, FabricGuiUtil.getString("FabricDetails_SensorsTwistie"));
        this.eventsPanel2 = this.makeTabbedPanel(this.eventsPanel);
        this.tab.add((Component)this.eventsPanel2, FabricGuiUtil.getString("FabricDetails_EventsTwistie"));
        this.tab.addChangeListener(this);
        return this.outerPanel;
    }

    public JPanel makeTabelPanel(BaseTableModel model) {
        MaxSizePanel panel = new MaxSizePanel();
        panel.setLayout(new BorderLayout());
        MegaTable table = new MegaTable();
        table.setPreferredSize(new Dimension(2048, 2048));
        if (model != null) {
            table.setBaseTableModel(model);
        }
        panel.add((Component)table, "Center");
        return panel;
    }

    public void queryData() {
        GuiDetailsReq gdr = new GuiDetailsReq(this.entityType, this.entityID, 0);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.fabric.GuiDetailsHndlr", gdr);
        this.doRequest(this, request);
    }

    void parseSensor(MyStringTokenizer st, Vector sensors) {
        try {
            st.nextToken();
            st.nextToken();
            Hashtable<String, String> h = new Hashtable<String, String>();
            String token = st.nextToken();
            while (!token.trim().equals(END_OF_ENTITY)) {
                MyStringTokenizer st3 = new MyStringTokenizer(token);
                String type = st3.nextToken().trim();
                st3.nextToken();
                String value = st3.nextTokenSafe("");
                if (type.equals("Type")) {
                    h.put("FabricSensorsEvents_Type", value);
                } else if (type.equals("Status")) {
                    h.put("FabricSensorsEvents_Status", value);
                } else if (type.equals("Message")) {
                    h.put("FabricSensorsEvents_Message", value);
                }
                token = st.nextTokenSafe();
            }
            sensors.add(h);
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
    }

    void parseEvent(MyStringTokenizer st, Vector events) {
        try {
            st.nextToken();
            st.nextToken();
            Hashtable<String, String> h = new Hashtable<String, String>();
            String token = st.nextToken();
            while (!token.trim().equals(END_OF_ENTITY)) {
                MyStringTokenizer st3 = new MyStringTokenizer(token);
                String type = st3.nextToken().trim();
                st3.nextToken();
                String value = st3.nextTokenSafe("").trim();
                if (type.equals("Type")) {
                    h.put("FabricSensorsEvents_Type", value);
                } else if (type.equals("RealTime")) {
                    value = value.substring(9, 11) + ":" + value.substring(11, 13);
                    h.put("FabricSensorsEvents_Time", value);
                } else if (type.equals("Index")) {
                    h.put("FabricSensorsEvents_ID", value);
                } else if (type.equals("Description")) {
                    h.put("FabricSensorsEvents_Description", value);
                }
                token = st.nextTokenSafe();
            }
            events.add(h);
        }
        catch (NoSuchElementException nsee) {
            nsee.printStackTrace();
        }
    }

    void parseEntity(MyStringTokenizer st, Vector sensors, Vector events) {
        String token = st.nextToken();
        MyStringTokenizer st2 = new MyStringTokenizer(token);
        String tmp = st2.nextToken();
        tmp = st2.nextToken();
        String type = st2.nextToken();
        if (type.trim().equals("sensor")) {
            this.parseSensor(st, sensors);
        } else if (type.trim().equals("event")) {
            this.parseEvent(st, events);
        } else {
            while (!st.nextToken().trim().equals(END_OF_ENTITY)) {
            }
        }
    }

    void parseSensorAndEventData(GuiDetailsReq data) {
        Vector sensors = new Vector();
        Vector events = new Vector();
        for (int i = 0; i < data.sensorsEvents.getResults().length; ++i) {
            Object o = data.sensorsEvents.getResults()[i];
            String s = (String)o;
            String s2 = "";
            StringTokenizer stt = new StringTokenizer(s, "\n");
            while (stt.hasMoreTokens()) {
                String s3 = stt.nextToken();
                if (s3.trim().equals("Entity")) {
                    s2 = s2 + END_OF_ENTITY + "\n";
                }
                s2 = s2 + s3 + "\n";
            }
            s = s2 + END_OF_ENTITY + "\n";
            try {
                MyStringTokenizer st = new MyStringTokenizer(s, "\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!token.trim().equals("Entity")) continue;
                    this.parseEntity(st, sensors, events);
                }
                continue;
            }
            catch (NoSuchElementException nsee) {
                nsee.printStackTrace();
            }
        }
        this.sensorsPanel.setTableModel(new SensorTableModel(sensors));
        this.eventsPanel.setTableModel(new EventTableModel(events));
    }

    public void handleResponse(short status, Response response) {
        this.sensorsPanel.setStatus("");
        this.eventsPanel.setStatus("");
        if (response != null && status == 0) {
            GuiDetailsReq data = (GuiDetailsReq)response.responseData;
            if (data.mode != 1) {
                if (data.mode == 0) {
                    this.dataInDb = data;
                    this.displayDataInPanel(data);
                    if (this.guiMain instanceof GuiMain) {
                        GuiMain.setTheTitle(this.getTheTitle(data));
                    }
                    DetailsDDI.setDDIDescription(this, this.getTheTitle(data));
                    if (data.blades != null && data.blades.size() > 0) {
                        this.bladesPanel.setTableModel(new BladeTableModel(data.blades));
                        if (!this.bladesDisplayed) {
                            this.tab.add((Component)this.makeTabbedPanel(this.bladesPanel), FabricGuiUtil.getString("FabricDetails_BladesTwistie"));
                            this.bladesDisplayed = true;
                        }
                    }
                } else if (data.mode == 3 && data.sensorsEvents != null) {
                    this.parseSensorAndEventData(data);
                }
            }
        }
    }

    void getSensorAndEventData() {
        if (!this.hasBeenRun) {
            this.hasBeenRun = true;
            if (this.dataInDb != null && this.dataInDb.data != null) {
                String switchWWN;
                GuiDetailsReq gdr = new GuiDetailsReq(this.entityType, this.entityID, 3);
                gdr.switchId = switchWWN = (String)this.dataInDb.data.get("FabricDetails_WWN");
                DeviceRequest request = new DeviceRequest("org.eclipse.aperi.server.svp.GuiSvp", "org.eclipse.aperi.server.handler.gui.fabric.GuiDetailsDeviceHndlr");
                request.requestData = gdr;
                this.sensorsPanel.setStatus(FabricGuiUtil.getString("FabricSensorsEvents_sensorAndEventInfo"));
                this.eventsPanel.setStatus(FabricGuiUtil.getString("FabricSensorsEvents_sensorAndEventInfo"));
                new DoDeviceRequestThread(this, request);
            }
        }
    }

    static void dumpPanel(Container c, String spaces) {
        spaces = spaces + " ";
        System.out.println(spaces + "container2 " + c.getClass().getName());
        Component[] clist = c.getComponents();
        for (int i = 0; i < clist.length; ++i) {
            if (clist[i] instanceof Container) {
                SwitchDetailsPanel.dumpPanel((Container)clist[i], spaces);
                continue;
            }
            System.out.println(spaces + "component " + clist[i].getClass().getName());
        }
    }

    static void invalidateTree(Container c) {
        c.invalidate();
        Component[] clist = c.getComponents();
        for (int i = 0; i < clist.length; ++i) {
            if (!(clist[i] instanceof Container)) continue;
            clist[i].invalidate();
            SwitchDetailsPanel.invalidateTree((Container)clist[i]);
        }
    }

    public boolean isEditable() {
        return true;
    }

    public void getDataFromPanel(GuiDetailsReq data) {
        if (this.detailsPanel != null) {
            this.detailsPanel.getDataFromPanel(data);
        }
    }

    public void displayDataInPanel(GuiDetailsReq data) {
        if (data != null && this.detailsPanel != null) {
            this.detailsPanel.displayDataInPanel(data);
        }
    }

    public boolean changesPending() {
        boolean res = false;
        if (this.detailsPanel != null) {
            res = this.detailsPanel.changesPending();
        }
        return res;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.tab.getSelectedComponent() == this.sensorsPanel2 || this.tab.getSelectedComponent() == this.eventsPanel2) {
            this.getSensorAndEventData();
        }
    }
}

