/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.reports;

import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.server.guireq.fabric.reports.RespPortConnections;

public class PortConnectionsAdjuster
extends CustomReportDataAdjuster {
    private static final String FABRIC_ID = Util.getString("FabricDetails_FabricID");
    private static final String SWITCH_ID = Util.getString("FabricDetails_switch");
    private static final String SWITCH_PORT = Util.getString("FabricSwitchPort");
    private static final String SWITCH_PORT_STATE = Util.getString("FabricSwitchPortState");
    private static final String CONNECTION_STATE = Util.getString("FabricConnectionState");
    private static final String CONNECTED_PORT = Util.getString("FabricConnectedPort");
    private static final String CONNECTED_PORT_STATE = Util.getString("FabricConnectedPortState");
    private static final String DEVICE = Util.getString("FabricDevice");
    private static final String DEVICE_STATE = Util.getString("FabricDeviceState");
    public String[] colNames = new String[]{FABRIC_ID, SWITCH_ID, SWITCH_PORT, SWITCH_PORT_STATE, CONNECTION_STATE, CONNECTED_PORT, CONNECTED_PORT_STATE, DEVICE, DEVICE_STATE};
    public static final int FABRIC_ID_COL = 0;
    public static final int SWITCH_ID_COL = 1;
    public static final int SWITCH_PORT_COL = 2;
    public static final int SWITCH_PORT_STATE_COL = 3;
    public static final int CONNECTION_STATE_COL = 4;
    public static final int CONNECTED_PORT_COL = 5;
    public static final int CONNECTED_PORT_STATE_COL = 6;
    public static final int DEVICE_COL = 7;
    public static final int DEVICE_STATE_COL = 8;
    private GuiReportReq grr;
    private RespPortConnections[] data;
    private MutableInteger[] mInt;
    private int[] rendererArray;
    private int rows;
    public int frozenRows;
    public int frozenLabels;
    public static final int FROZEN_LABEL_ROWS = 2;
    public static final int FROZEN_ROWS = 2;
    public static final int FROZEN_COLUMNS = 0;
    private boolean batch;
    private ColumnPopulator populator;

    public PortConnectionsAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.populator = null;
        this.frozenColumns = 0;
        int index = 0;
        if (grr.reportSubtype == 104) {
            this.populator = new Port_Populator();
            this.frozenRows = 0;
            this.frozenLabels = 0;
            this.rendererArray = new int[this.colNames.length];
            for (index = 0; index < this.colNames.length; ++index) {
                this.rendererArray[index] = 0;
            }
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.data = (RespPortConnections[])dataArray;
        this.rows = this.data.length;
        this.mInt = new MutableInteger[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.mInt[i] = new MutableInteger();
        }
    }

    public void adjustData() {
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int getNumberFrozenRows() {
        return 0;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int[] getSelectedIDs() {
        int[] IDarray = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            RespPortConnections respPortConnections = this.data[i];
        }
        return IDarray;
    }

    public Object getCellData(int row, int col) {
        return this.populator.getCellData(row, col);
    }

    private class Port_Populator
    implements ColumnPopulator {
        private Port_Populator() {
        }

        public Object getCellData(int row, int column) {
            RespPortConnections record = PortConnectionsAdjuster.this.data[row];
            Object result = null;
            switch (column) {
                case 0: {
                    result = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].FabricID;
                    break;
                }
                case 1: {
                    result = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].SwitchID;
                    break;
                }
                case 2: {
                    result = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].Switch_Port;
                    break;
                }
                case 3: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].Switch_Port_State;
                    result = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value);
                    break;
                }
                case 4: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].Connection_State;
                    result = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value);
                    break;
                }
                case 5: {
                    result = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].Connected_Port;
                    break;
                }
                case 6: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].Connected_Port_State;
                    result = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value);
                    break;
                }
                case 7: {
                    result = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].Device;
                    break;
                }
                case 8: {
                    ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value = ((PortConnectionsAdjuster)PortConnectionsAdjuster.this).data[row].Device_State;
                    result = FabricGuiUtil.getStatusString(((PortConnectionsAdjuster)PortConnectionsAdjuster.this).mInt[row].value);
                }
            }
            return result;
        }
    }

    private static interface ColumnPopulator {
        public Object getCellData(int var1, int var2);
    }
}

