/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.gui.fabric.zone.ZoneMemberPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneWizard;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;

public class AssignZoneMembersStep
extends WizardPage
implements ActionListener {
    ZoneCNS zoneCNS;
    ZoneMemberPanel zPanel;
    ZoneMember[] zoneMembers = null;

    public AssignZoneMembersStep(int buttonFlags, Zone zone, ZoneCNS cns, boolean newZone, ZoneMember[] zMems) {
        super(buttonFlags);
        this.setName("AssignZoneMembersStep");
        this.zoneCNS = cns;
        this.zoneMembers = zMems;
        this.create(zone, newZone);
    }

    public void create(Zone zone, boolean newZone) {
        Container pane = this.getContentPane();
        this.zPanel = new ZoneMemberPanel(newZone, zone, this.zoneCNS, this.zoneMembers);
        pane.add(this.zPanel);
        this.setUpHelp(FabricGuiUtil.FHELP_ZC_ZWIZ2);
    }

    public Object next() {
        return "AssignZoneSetsStep";
    }

    public boolean nextBegin() {
        boolean next = true;
        ZoneWizard zoneWizard = (ZoneWizard)this.getParent();
        Vector zMems = this.getZoneMembers();
        if (!(zMems != null && zMems.size() >= 1 || zoneWizard.supportsEmptyZone())) {
            next = false;
            JOptionPane.showMessageDialog(this, Util.getString("FabricZone_NoZoneMembersError"));
            return next;
        }
        if (zoneWizard.maxZoneMembers() > 0 && zMems.size() > zoneWizard.maxZoneMembers()) {
            next = false;
            JOptionPane.showMessageDialog(this, Util.getString("FabricZonePanel_MaxZoneMembers"));
            return next;
        }
        return next;
    }

    private JPanel getPane(JComponent component, JLabel title) {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(component);
        scrollPane.setPreferredSize(new Dimension(225, 380));
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        pane.add((Component)title, "North");
        pane.add((Component)scrollPane, "Center");
        return pane;
    }

    public Vector getZoneMembers() {
        return this.zPanel.getZoneMembers();
    }

    public void actionPerformed(ActionEvent e) {
    }
}

