/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiDeviceJob;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.gui.fabric.zone.ZoneDDI;
import org.eclipse.aperi.gui.fabric.zone.ZoneDefinitionPanel;
import org.eclipse.aperi.gui.fabric.zone.ZoneUIAccessor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.xmsg.IntlMessageFormat;

public class ZoneCNS
extends DataDisplayInfo
implements GuiRequestor {
    protected int zoneTab;
    protected int runNumber;
    private ZoneDDI zoneDDI = null;
    private String sanLabel;
    private String sanWWN;
    private HashMap[] switchZMems = null;
    private HashMap[] deviceSPMap = null;
    private HashMap[] nodeMemMap = null;
    private HashMap[] deviceMemMap = null;
    private HashMap[] portMap = null;
    private ZoneSet origActiveZS = null;
    private ZoneDefinition origZoneDef = new ZoneDefinition();
    private ZoneDefinition zoneDef = new ZoneDefinition();
    ZoneUIAccessor zoneAccessor = ZoneUIAccessor.getInstance();
    private ZoneDefinition activeZoneDef = new ZoneDefinition();
    private ZoneCapabilities zoneCap = new ZoneCapabilities();
    private String ZONE_CLASS = "Zone";
    private String ZONESET_CLASS = "ZoneSet";
    private String ERROR_CONFIG = "ConfigError";
    private HashMap zoneStatusTracker = new HashMap();
    private HashMap zsStatusTracker = new HashMap();
    public static boolean DEBUG = false;
    private boolean returnToDef = false;
    private int extra = 0;
    private Capabilities capabilities = guiMain.getCapabilities();

    public ZoneCNS(ZoneDDI ddi, String label, String wwn) {
        this.sanLabel = label;
        this.sanWWN = wwn;
        this.zoneDDI = ddi;
    }

    public void populateZoneDefinition() {
        this.zoneDDI.mainPanel.setStatusText(Util.getString("FabricZoneNotebook_RefreshStatus"), this.sanWWN);
        if (DEBUG) {
            this.populateDebugZoneDefinition(this.origZoneDef, false);
            this.populateDebugZoneDefinition(this.zoneDef, false);
            this.populateDebugZoneDefinition(this.activeZoneDef, true);
        } else {
            this.enableEditButton(false);
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
            request.userName = GuiUtil.getUserName();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put(GuiZoneConstants.POPULATE_ZONEDEF, this.sanWWN);
            request.requestData = data;
            request.flags = (byte)4;
            GuiClient.doRequest(this, request);
            this.populateActiveZoneDefinition();
            this.getSwitchZoneMembers();
            this.getDeviceSPZoneMembers();
            this.getNodeZoneMembers();
            this.getDeviceZoneMembers();
            this.getPortZoneMembers();
        }
    }

    private void populateActiveZoneDefinition() {
        Request request2 = new Request();
        request2.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request2.serviceName = RequestTypeManager.getInternalName(request2.typeCode);
        request2.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request2.userName = GuiUtil.getUserName();
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, this.sanWWN);
        request2.requestData = data2;
        request2.flags = (byte)4;
        GuiClient.doRequest(this, request2);
    }

    private void getSwitchZoneMembers() {
        Request request2 = new Request();
        request2.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request2.serviceName = RequestTypeManager.getInternalName(request2.typeCode);
        request2.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request2.userName = GuiUtil.getUserName();
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.ZM_SWITCHES, this.sanWWN);
        request2.requestData = data2;
        request2.flags = (byte)4;
        GuiClient.doRequest(this, request2);
    }

    private void getDeviceSPZoneMembers() {
        Request request2 = new Request();
        request2.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request2.serviceName = RequestTypeManager.getInternalName(request2.typeCode);
        request2.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request2.userName = GuiUtil.getUserName();
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.ZM_DEVICESP, this.sanWWN);
        request2.requestData = data2;
        request2.flags = (byte)4;
        GuiClient.doRequest(this, request2);
    }

    private void getNodeZoneMembers() {
        Request request2 = new Request();
        request2.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request2.serviceName = RequestTypeManager.getInternalName(request2.typeCode);
        request2.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request2.userName = GuiUtil.getUserName();
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.ZM_NODE, this.sanWWN);
        request2.requestData = data2;
        request2.flags = (byte)4;
        GuiClient.doRequest(this, request2);
    }

    private void getDeviceZoneMembers() {
        Request request2 = new Request();
        request2.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request2.serviceName = RequestTypeManager.getInternalName(request2.typeCode);
        request2.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request2.userName = GuiUtil.getUserName();
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.ZM_DEVICE, this.sanWWN);
        request2.requestData = data2;
        request2.flags = (byte)4;
        GuiClient.doRequest(this, request2);
    }

    private void getPortZoneMembers() {
        Request request2 = new Request();
        request2.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request2.serviceName = RequestTypeManager.getInternalName(request2.typeCode);
        request2.subType = "org.eclipse.aperi.server.handler.gui.fabric.ZoneRequestHandler";
        request2.userName = GuiUtil.getUserName();
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put(GuiZoneConstants.ZM_PORT, this.sanWWN);
        request2.requestData = data2;
        request2.flags = (byte)4;
        GuiClient.doRequest(this, request2);
    }

    public void populateActiveZoneDefPreSave(ZoneDefinitionPanel defPanel, int flag) {
        final ZoneDefinitionPanel dPanel = defPanel;
        final int flag2 = flag;
        this.zoneAccessor.populateActiveZoneDefinition(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                HashMap hashMap;
                ZoneDefinition newActiveZoneDef;
                if (status < 4 && !(newActiveZoneDef = (ZoneDefinition)(hashMap = (HashMap)response.responseData).get(GuiZoneConstants.POPULATE_ACTIVEZONEDEF)).equalsIgnoreDescriptions(ZoneCNS.this.activeZoneDef)) {
                    int opt = JOptionPane.showConfirmDialog(dPanel, Util.getString("FabricZone_ActiveMsg"), Util.getString("FabricZone_ActiveTitle"), 0);
                    if (opt == 1) {
                        ZoneCNS.this.returnToDef = true;
                    } else {
                        ZoneCNS.this.returnToDef = false;
                    }
                }
                ZoneCNS.this.saveZoneDefPanel(dPanel, flag2);
            }
        }, this.sanWWN);
    }

    public void ping() {
        this.zoneAccessor.ping(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    ZoneCNS.this.zoneCap = (ZoneCapabilities)hashMap.get("pingZoneAgent");
                    if (ZoneCNS.this.zoneCap == null) {
                        if (hashMap.containsKey("pingError")) {
                            int errorInt = (Integer)hashMap.get("pingError");
                            String error = "";
                            String msg = "";
                            switch (errorInt) {
                                case 5: {
                                    error = Util.getString("FabricZone_TokenError");
                                    msg = Util.getString("FMSG_PING_INVALID_TOKEN_ERROR");
                                    break;
                                }
                                case 3: {
                                    error = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                    msg = Util.getString("FMSG_PING_LOCKED_ERROR");
                                    break;
                                }
                                case 4: {
                                    error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    msg = Util.getString("FMSG_PING_NOTAVAILABLE_ERROR");
                                    break;
                                }
                                case 1: {
                                    error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                    msg = Util.getString("FMSG_PING_GENERAL_ERROR");
                                }
                            }
                            if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                                JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, msg);
                                ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(error, ZoneCNS.this.sanWWN);
                            }
                        } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                            ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                        }
                        ZoneCNS.this.zoneCap = new ZoneCapabilities();
                    } else {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                    ZoneCNS.this.refreshConfigurationPanel();
                }
            }
        }, this.sanWWN);
        if (this.zoneDDI.mainPanel != null) {
            this.zoneDDI.mainPanel.setStatusText(Util.getString("FabricZoneNotebook_GatheringZoning"), this.sanWWN);
        }
    }

    public void originalSaveZoneDefinition(int flag) {
        this.zoneAccessor.originalSaveZoneDefinition(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey(GuiZoneConstants.SAVE_RESPONSE)) {
                        int errorInt = (Integer)hashMap.get(GuiZoneConstants.SAVE_RESPONSE);
                        String error = "";
                        String msg = "";
                        switch (errorInt) {
                            case 4: {
                                error = Util.getString("FabricZone_TokenError");
                                msg = Util.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 3: {
                                error = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                msg = Util.getString("FMSG_SAVE_LOCKED_ERROR");
                                break;
                            }
                            case 5: {
                                error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                msg = Util.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                error = Util.getString("FabricZoneNotebook_ZSCommError");
                                msg = Util.getString("FMSG_SAVE_GENERAL_ERROR");
                            }
                        }
                        if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                            if (!error.equals("")) {
                                JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, msg);
                                ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(error, ZoneCNS.this.sanWWN);
                            }
                            ZoneCNS.this.populateZoneDefinition();
                        }
                    } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                }
            }
        }, this.sanWWN, flag, this.zoneDef);
        if (this.zoneDDI.mainPanel != null) {
            this.zoneDDI.mainPanel.setStatusText(Util.getString("FabricZoneNotebook_GatheringZoning"), this.sanWWN);
        }
    }

    private void saveZoneDefinition(Token token, int flag) {
        final Token myToken = token;
        this.zoneAccessor.saveZoneDefinition(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status < 4) {
                    Integer returnCode = (Integer)response.responseData;
                    new JobResultThread(returnCode, myToken).start();
                } else {
                    ZoneCNS.this.releaseToken(myToken);
                }
            }
        }, this.sanWWN, flag, this.zoneDef, token);
    }

    private void rollbackToken(Token token) {
        Token myToken = token;
        this.zoneAccessor.rollbackToken(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey(GuiZoneConstants.SAVE_RESPONSE)) {
                        int errorInt = (Integer)hashMap.get(GuiZoneConstants.SAVE_RESPONSE);
                        String error = "";
                        String msg = "";
                        switch (errorInt) {
                            case 4: {
                                error = Util.getString("FabricZone_TokenError");
                                msg = Util.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 3: {
                                error = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                msg = Util.getString("FMSG_SAVE_LOCKED_ERROR");
                                break;
                            }
                            case 5: {
                                error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                msg = Util.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                error = Util.getString("FabricZoneNotebook_ZSCommError");
                                msg = Util.getString("FMSG_SAVE_GENERAL_ERROR");
                            }
                        }
                        if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && !error.equals("")) {
                            JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, msg);
                            ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(error, ZoneCNS.this.sanWWN);
                        }
                    } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                    ZoneCNS.this.reDisplay();
                }
            }
        }, this.sanWWN, token);
    }

    private void releaseToken(Token token) {
        Token myToken = token;
        this.saveZoneDescriptions();
        this.zoneAccessor.releaseToken(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey(GuiZoneConstants.SAVE_RESPONSE)) {
                        int errorInt = (Integer)hashMap.get(GuiZoneConstants.SAVE_RESPONSE);
                        String error = "";
                        String msg = "";
                        switch (errorInt) {
                            case 4: {
                                error = Util.getString("FabricZone_TokenError");
                                msg = Util.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 3: {
                                error = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                msg = Util.getString("FMSG_SAVE_LOCKED_ERROR");
                                break;
                            }
                            case 5: {
                                error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                msg = Util.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                error = Util.getString("FabricZoneNotebook_ZSCommError");
                                msg = Util.getString("FMSG_SAVE_GENERAL_ERROR");
                            }
                        }
                        if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && !error.equals("")) {
                            JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, msg);
                            ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(error, ZoneCNS.this.sanWWN);
                        }
                    } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                    ZoneCNS.this.reDisplay();
                }
            }
        }, this.sanWWN, token);
    }

    private void saveZoneDescriptions() {
        this.zoneAccessor.saveDescriptions(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status < 4) {
                    // empty if block
                }
            }
        }, this.zoneDef, this.sanWWN);
    }

    public void saveZoneDefReserve(int flag) {
        final int newFlag = flag;
        this.enableEditButton(false);
        this.enableRefreshButton(false);
        this.zoneDDI.mainPanel.setStatusText(Util.getString("FabricZoneNotebook_SavingZoningStatus"), this.sanWWN);
        this.zoneAccessor.reserveToken(new GuiRequestor(){

            public void handleResponse(short status, Response response) {
                if (status < 4) {
                    HashMap hashMap = (HashMap)response.responseData;
                    if (hashMap.containsKey(GuiZoneConstants.SAVE_RESPONSE)) {
                        int errorInt = (Integer)hashMap.get(GuiZoneConstants.SAVE_RESPONSE);
                        String error = "";
                        String msg = "";
                        switch (errorInt) {
                            case 4: {
                                error = Util.getString("FabricZone_TokenError");
                                msg = Util.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                                break;
                            }
                            case 3: {
                                error = Util.getString("FabricZoneNotebook_pingLockedWarning");
                                msg = Util.getString("FMSG_SAVE_LOCKED_ERROR");
                                break;
                            }
                            case 5: {
                                error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                                msg = Util.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                                break;
                            }
                            case 1: {
                                error = Util.getString("FabricZoneNotebook_ZSCommError");
                                msg = Util.getString("FMSG_SAVE_GENERAL_ERROR");
                            }
                        }
                        if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null && !error.equals("")) {
                            JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, msg);
                            ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(error, ZoneCNS.this.sanWWN);
                        }
                        if (hashMap.containsKey(GuiZoneConstants.TOKEN)) {
                            Token token = (Token)hashMap.get(GuiZoneConstants.TOKEN);
                            ZoneCNS.this.saveZoneDefinition(token, newFlag);
                        } else {
                            ZoneCNS.this.reDisplay();
                        }
                    } else if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                        ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText("", ZoneCNS.this.sanWWN);
                    }
                }
            }
        }, this.sanWWN);
    }

    public boolean isUnsupportedChar(String name) {
        char[] chars = name.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '$' && chars[i] != '-' && chars[i] != ' ' && chars[i] != '%') continue;
            return true;
        }
        return false;
    }

    public boolean isNum(char c) {
        return c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '0';
    }

    public void reDisplay() {
        this.enableEditButton(false);
        this.ping();
        this.resetZoneDefinition();
        this.refreshConfigurationPanel();
        this.refreshDefinitionPanel();
        this.zoneDDI.show();
    }

    private void closeTab(int panel) {
        this.zoneDDI.mainPanel.closeTab(panel);
    }

    public void closeDefTab() {
        this.zoneDDI.mainPanel.closeTab(this.getDefTabIndex());
        this.zoneDDI.mainPanel.remove(this.getDefTabIndex());
    }

    public void closeConfigTab() {
        this.zoneDDI.mainPanel.closeTab(this.getConfigTabIndex());
        this.zoneDDI.mainPanel.remove(this.getConfigTabIndex());
    }

    private int getConfigTabIndex() {
        return this.zoneDDI.mainPanel.getConfigTabIndex(this.sanWWN, this.sanLabel);
    }

    private int getDefTabIndex() {
        return this.zoneDDI.mainPanel.getDefTabIndex(this.sanWWN, this.sanLabel);
    }

    public void panelToBeNulled() {
        if (this.runNumber > 0) {
            this.remove();
        }
    }

    public ZoneCapabilities getZoneCapabilities() {
        return this.zoneCap;
    }

    public String getHelpID() {
        switch (this.zoneTab) {
            default: 
        }
        return "welcome_gettingstarted";
    }

    public String getSanLabel() {
        return this.sanLabel;
    }

    public String getSanWWN() {
        return this.sanWWN;
    }

    public ZoneDefinition getZoneDefinition(boolean active) {
        if (active) {
            return this.activeZoneDef;
        }
        return this.zoneDef;
    }

    private void clearZoneDefErrors() {
        this.zoneStatusTracker = new HashMap();
        this.zsStatusTracker = new HashMap();
    }

    public void resetZoneDefinition() {
        this.clearZoneDefErrors();
        this.switchZMems = null;
        this.deviceSPMap = null;
        this.nodeMemMap = null;
        this.deviceMemMap = null;
        this.portMap = null;
        this.origActiveZS = null;
        this.origZoneDef = new ZoneDefinition();
        this.zoneDef = new ZoneDefinition();
        this.activeZoneDef = new ZoneDefinition();
        this.zoneCap = new ZoneCapabilities();
        this.returnToDef = false;
        this.populateZoneDefinition();
    }

    public ZoneDefinition getOriginalZoneDefinition() {
        return this.origZoneDef;
    }

    public ZoneSet getOriginalActivatedZoneSet() {
        return this.origActiveZS;
    }

    public boolean isOriginalActiveZoneSet(ZoneSet zs) {
        return this.origActiveZS != null && this.origActiveZS.getName().equals(zs.getName());
    }

    public void setOriginalActivatedZoneSet(ZoneSet zs) {
        this.origActiveZS = zs;
    }

    public boolean isNodeZoneAsset() {
        return this.zoneCap.isSupportsNodeWWN();
    }

    public boolean isZoneSetActive(ZoneSet zs) {
        ZoneSet activeZS = this.zoneDef.getActiveZoneSet();
        if (activeZS == null) {
            return false;
        }
        return activeZS.getName().equals(zs.getName());
    }

    public int getStringLength() {
        return this.zoneCap.getMaxNameLength();
    }

    public void showZoneDefPanel() {
        this.zoneDDI.mainPanel.addZoneDefTab(this.sanWWN);
    }

    private void populateDebugZoneDefinition(ZoneDefinition zdef, boolean active) {
        int tableSize = 20;
        ZoneSet newZS = null;
        ++this.extra;
        for (int i = 0; i < tableSize; ++i) {
            newZS = new ZoneSet("ZS name " + i, "ZS Description " + this.extra + i);
            if (i == 1) {
                zdef.addZoneSet(newZS);
                zdef.activateZoneSet(newZS);
            } else if (!active) {
                zdef.addZoneSet(newZS);
            }
            for (int j = 0; j < tableSize; ++j) {
                Zone newZone = new Zone("zone " + j, "description " + this.extra + j);
                if (!active) {
                    zdef.addZone(newZS, newZone);
                } else if (i == 1) {
                    zdef.addZone(newZS, newZone);
                }
                for (int k = 0; k < tableSize; ++k) {
                    short sh = 1;
                    ZoneMember zm = new ZoneMember(sh, "zmID " + k);
                    if (!active) {
                        zdef.addMember(newZone, zm);
                        continue;
                    }
                    if (i != 1) continue;
                    zdef.addMember(newZone, zm);
                }
            }
        }
    }

    public boolean hasZoneError(String zoneId) {
        return this.zoneStatusTracker.containsKey(this.getZoneIdentifier() + zoneId);
    }

    public void addZoneConfigError(String zoneId) {
        this.zoneStatusTracker.put(this.getZoneIdentifier() + zoneId, this.ERROR_CONFIG);
    }

    public boolean removeZoneConfigError(String zoneId) {
        if (this.zoneStatusTracker.containsKey(this.getZoneIdentifier() + zoneId)) {
            this.zoneStatusTracker.remove(this.getZoneIdentifier() + zoneId);
            return true;
        }
        return false;
    }

    public boolean hasAnyZoneError() {
        return this.zoneStatusTracker.size() > 0;
    }

    public boolean hasAnyZoneSetError() {
        return this.zsStatusTracker.size() > 0;
    }

    public void addZoneSetConfigError(String zsId) {
        this.zsStatusTracker.put(this.getZoneSetIdentifier() + zsId, this.ERROR_CONFIG);
    }

    public boolean hasZoneSetError(String zoneSetId) {
        return this.zsStatusTracker.containsKey(this.getZoneSetIdentifier() + zoneSetId);
    }

    public boolean removeZoneSetConfigError(String zsId) {
        if (this.zsStatusTracker.containsKey(this.getZoneSetIdentifier() + zsId)) {
            this.zsStatusTracker.remove(this.getZoneSetIdentifier() + zsId);
            return true;
        }
        return false;
    }

    public Vector checkForOrphanZones() {
        Vector<Zone> zones = new Vector<Zone>();
        Zone[] currZones = this.zoneDef.getZones();
        if (currZones != null) {
            for (int i = 0; i < currZones.length; ++i) {
                ZoneSet[] zs = this.zoneDef.getZoneSets(currZones[i]);
                if (zs != null && zs.length != 0) continue;
                zones.add(currZones[i]);
            }
        }
        return zones;
    }

    public String getZoneIdentifier() {
        return this.ZONE_CLASS;
    }

    public String getZoneSetIdentifier() {
        return this.ZONESET_CLASS;
    }

    public void deleteZoneSets(ZoneSet[] zs) {
        this.zoneDef.deleteZoneSets(zs);
    }

    public void deleteZoneSet(ZoneSet zs) {
        this.zoneDef.deleteZoneSet(zs);
    }

    public ZoneSet[] deleteZones(Zone[] zones) {
        return this.zoneDef.deleteZonesAndReturnDeletedZoneSets(zones);
    }

    public ZoneSet[] deleteZones(Zone zone) {
        return this.zoneDef.deleteZoneAndReturnDeletedZoneSets(zone);
    }

    public void deleteZone(Zone zone) {
        this.zoneDef.deleteZone(zone);
    }

    public void activateZoneSet(ZoneSet zs) {
        this.zoneDef.activateZoneSet(zs);
    }

    public String getActiveZoneSetLabel() {
        String returnString = null;
        ZoneSet activeZS = this.activeZoneDef.getActiveZoneSet();
        if (activeZS != null) {
            returnString = activeZS.getName();
        }
        return returnString;
    }

    public void deactivateZoneSet(ZoneSet zs) {
        this.zoneDef.deactivateZoneSet(zs);
    }

    public void addZoneMember(ZoneMember zm, Zone zone) {
        this.zoneDef.addMember(zone, zm);
    }

    public void addZoneAlias(ZoneAlias za, Zone zone) {
        this.zoneDef.addAlias(zone, za);
    }

    public void addZone(Zone zone, ZoneSet zSet) {
        this.zoneDef.addZone(zSet, zone);
    }

    public void addZoneSets(ZoneSet[] zs) {
        this.zoneDef.addZoneSets(zs);
    }

    public void addZoneSet(ZoneSet zs) {
        this.zoneDef.addZoneSet(zs);
    }

    public void addZone(Zone zone) {
        this.zoneDef.addZone(zone);
    }

    public ZoneSet[] getZoneSets() {
        return this.zoneDef.getZoneSets();
    }

    public ZoneSet[] getZoneSets(Zone zone) {
        return this.zoneDef.getZoneSets(zone);
    }

    public ZoneSet getZoneSet(String zsName) {
        return this.zoneDef.getZoneSet(zsName);
    }

    public Zone[] getAllZones() {
        return this.zoneDef.getZones();
    }

    public ZoneAlias[] getAllZoneAliases() {
        return this.zoneDef.getAliases();
    }

    public Zone getZone(String zoneName) {
        return this.zoneDef.getZone(zoneName);
    }

    public Zone[] getZones(ZoneSet zs) {
        return this.zoneDef.getZones(zs);
    }

    public ZoneMember[] getZoneMembers(Zone zone) {
        return this.zoneDef.getMembers(zone);
    }

    public ZoneMember[] getAllMembers() {
        return this.zoneDef.getMembers();
    }

    public ZoneAlias[] getZoneAliases(Zone zone) {
        return this.zoneDef.getAliases(zone);
    }

    public boolean containsZoneSet(String zsName) {
        ZoneSet zs = this.zoneDef.getZoneSet(zsName);
        return zs != null;
    }

    public boolean containsZone(String zoneName) {
        Zone zone = this.zoneDef.getZone(zoneName);
        return zone != null;
    }

    public HashMap[] getPortZMHash() {
        return this.portMap;
    }

    public HashMap[] getSwitchZMHash() {
        return this.switchZMems;
    }

    public HashMap[] getNodeZMHash() {
        return this.nodeMemMap;
    }

    public HashMap[] getDeviceZMHash() {
        return this.deviceMemMap;
    }

    public HashMap[] getDeviceSPZMHash() {
        return this.deviceSPMap;
    }

    public void refreshConfigurationPanel() {
        this.zoneDDI.mainPanel.refreshConfigurationPanel(this.sanWWN);
    }

    public void refreshDefinitionPanel() {
        this.zoneDDI.mainPanel.refreshDefinitionPanel(this.sanWWN);
    }

    private void enableEditButton(boolean enable) {
        if (this.capabilities.isFabricAdmin()) {
            this.zoneDDI.mainPanel.enableEditButton(enable, this.sanWWN);
        } else {
            this.zoneDDI.mainPanel.enableEditButton(false, this.sanWWN);
        }
    }

    private void enableRefreshButton(boolean enable) {
        this.zoneDDI.mainPanel.enableRefreshButton(enable, this.sanWWN);
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            HashMap hashMap = (HashMap)response.responseData;
            if (hashMap != null && hashMap.containsKey(GuiZoneConstants.POPULATE_ACTIVEZONEDEF)) {
                this.activeZoneDef = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_ACTIVEZONEDEF);
                this.refreshConfigurationPanel();
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.POPULATE_ZONEDEF)) {
                this.origZoneDef = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_ZONEDEF);
                this.origActiveZS = this.origZoneDef.getActiveZoneSet();
                this.zoneDef = (ZoneDefinition)hashMap.get(GuiZoneConstants.POPULATE_ZONEDEF);
                String[] zoneList = (String[])hashMap.get(GuiZoneConstants.NONSTD_ZONES);
                if (zoneList != null && zoneList.length > 0) {
                    String zoneListName = zoneList[0];
                    for (int i = 1; i < zoneList.length; ++i) {
                        zoneListName = zoneListName + ", " + zoneList[i];
                    }
                    String msg = IntlMessageFormat.format(FabricGuiUtil.getString("FabricZoneNotebook_NonStandardMembers"), new Object[]{this.sanWWN, new Integer(zoneList.length), zoneListName});
                    JOptionPane.showMessageDialog(this.zoneDDI.mainPanel, msg);
                } else {
                    this.enableEditButton(true);
                    this.enableRefreshButton(true);
                }
                this.refreshConfigurationPanel();
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_PORT)) {
                this.portMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_PORT);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_DEVICE)) {
                this.deviceMemMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_DEVICE);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_DEVICESP)) {
                this.deviceSPMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_DEVICESP);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_NODE)) {
                this.nodeMemMap = (HashMap[])hashMap.get(GuiZoneConstants.ZM_NODE);
            } else if (hashMap != null && hashMap.containsKey(GuiZoneConstants.ZM_SWITCHES)) {
                this.switchZMems = (HashMap[])hashMap.get(GuiZoneConstants.ZM_SWITCHES);
            }
        }
    }

    private void saveZoneDefPanel(ZoneDefinitionPanel defPanel, int flag) {
        if (!this.returnToDef) {
            this.saveZoneDefReserve(flag);
            defPanel.setCloseNow(true);
            this.closeDefTab();
        }
    }

    public void saveZoneDef(ZoneDefinitionPanel defPanel, int flag) {
        this.populateActiveZoneDefPreSave(defPanel, flag);
    }

    public class JobResultThread
    extends Thread {
        protected int jobID = 0;
        Token token = null;

        public JobResultThread(int jobID, Token mytoken) {
            this.jobID = jobID;
            this.token = mytoken;
        }

        public void run() {
            Response jobStatusResponse = GuiDeviceJob.getJobStatus(this.jobID, true, 32);
            if (jobStatusResponse != null) {
                AsyncResult result = (AsyncResult)jobStatusResponse.responseData;
                int errorInt = result.getRc();
                String error = "";
                String msg = "";
                switch (errorInt) {
                    case 4: {
                        error = Util.getString("FabricZone_TokenError");
                        msg = Util.getString("FMSG_SAVE_INVALID_TOKEN_ERROR");
                        break;
                    }
                    case 3: {
                        error = Util.getString("FabricZoneNotebook_pingLockedWarning");
                        msg = Util.getString("FMSG_SAVE_LOCKED_ERROR");
                        break;
                    }
                    case 5: {
                        error = Util.getString("FabricZoneNotebook_pingNoAgentWarning");
                        msg = Util.getString("FMSG_SAVE_NOTAVAILABLE_ERROR");
                        break;
                    }
                    case 1: {
                        error = Util.getString("FabricZoneNotebook_ZSCommError");
                        msg = Util.getString("FMSG_SAVE_GENERAL_ERROR");
                        break;
                    }
                    default: {
                        error = "";
                    }
                }
                if (((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel != null) {
                    if (!error.equals("")) {
                        JOptionPane.showMessageDialog(((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel, msg);
                    }
                    ((ZoneCNS)ZoneCNS.this).zoneDDI.mainPanel.setStatusText(error, ZoneCNS.this.sanWWN);
                }
                if (error.equals("")) {
                    ZoneCNS.this.releaseToken(this.token);
                }
            } else {
                ZoneCNS.this.releaseToken(this.token);
            }
        }
    }
}

