/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.zone;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.eclipse.aperi.gui.fabric.zone.ZoneCNS;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneAlias;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;

public class ZoneConfigurationTree
extends JTree {
    ZoneCNS zoneCNS;
    DefaultMutableTreeNode topNode;
    private boolean active = true;

    public ZoneConfigurationTree(ZoneCNS cns, boolean newActive) {
        this.zoneCNS = cns;
        this.active = newActive;
        this.populateTree();
        DefaultTreeModel treeModel = new DefaultTreeModel(this.topNode);
        this.setModel(treeModel);
        this.setTreeOptions();
    }

    public void populateTree() {
        this.topNode = new DefaultMutableTreeNode();
        ZoneDefinition def = this.zoneCNS.getZoneDefinition(this.active);
        ZoneSet[] zoneSets = def.getZoneSets();
        for (int i = 0; i < zoneSets.length; ++i) {
            DefaultMutableTreeNode zoneSetNode = new DefaultMutableTreeNode(new ZoneTreeNode(zoneSets[i].getName(), 0));
            Zone[] zones = def.getZones(zoneSets[i]);
            for (int j = 0; j < zones.length; ++j) {
                DefaultMutableTreeNode zoneNode = new DefaultMutableTreeNode(new ZoneTreeNode(zones[j].getName(), 1));
                ZoneMember[] zoneMembers = def.getMembers(zones[j]);
                for (int k = 0; k < zoneMembers.length; ++k) {
                    DefaultMutableTreeNode zoneMemNode = new DefaultMutableTreeNode(new ZoneTreeNode(zoneMembers[k].getName(), 2));
                    zoneNode.add(zoneMemNode);
                }
                ZoneAlias[] aliases = def.getAliases(zones[j]);
                for (int k = 0; k < aliases.length; ++k) {
                    DefaultMutableTreeNode aliasNode = new DefaultMutableTreeNode(new ZoneTreeNode(aliases[k].getName(), 3));
                    ZoneMember[] zoneAliasMembers = def.getMembers(aliases[k]);
                    for (int l = 0; l < zoneAliasMembers.length; ++l) {
                        DefaultMutableTreeNode zoneMemNode = new DefaultMutableTreeNode(new ZoneTreeNode(zoneAliasMembers[l].getName(), 2));
                        aliasNode.add(zoneMemNode);
                    }
                    zoneNode.add(aliasNode);
                }
                zoneSetNode.add(zoneNode);
            }
            this.topNode.add(zoneSetNode);
        }
    }

    public void rePopulateTree() {
    }

    private void setTreeOptions() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setSelectionRow(0);
    }

    class ZoneTreeNode {
        protected String name;
        protected int type = 0;

        public ZoneTreeNode(String newName, int newType) {
            this.name = newName;
            this.type = newType;
        }

        public String toString() {
            return this.name;
        }
    }
}

