/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.cartridges;

import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.cartridges.CartridgesDDI;
import org.eclipse.aperi.gui.tape.common.model.GUICartridge;

public class CartridgesTableModel
extends BaseTableModel {
    private CartridgesDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_LABEL_LABEL"), Util.getString("TAPE_DESCRIPTION_LABEL"), Util.getString("TAPE_CAPACITY_LABEL"), Util.getString("TAPE_TYPE_LABEL"), Util.getString("TAPE_CLEANER_MEDIA_LABEL"), Util.getString("TAPE_DUAL_SIDED_LABEL"), Util.getString("TAPE_LOCATION_LABEL")};
    private static final int CART_LABEL = 0;
    private static final int CART_DESC = 1;
    private static final int CART_CAP = 2;
    private static final int CART_TYPE = 3;
    private static final int CART_CM = 4;
    private static final int CART_DUALS = 5;
    private static final int CART_LOC = 6;

    CartridgesTableModel(CartridgesDDI ddi) {
        this.aDDI = ddi;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getCartridges().size();
    }

    public Object getTableDataItem(int row, int col) {
        GUICartridge cart = (GUICartridge)this.aDDI.getCartridges().elementAt(row);
        switch (col) {
            case 0: {
                return cart.getLabel();
            }
            case 1: {
                return cart.getDescription();
            }
            case 2: {
                return new Double(GUIEntityUtil.convertStorageCapacity(cart.getCapacity(), 0, 3, 2));
            }
            case 3: {
                return cart.getType();
            }
            case 4: {
                if (!cart.isCleanerMedia()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 5: {
                if (!cart.isDualSided()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 6: {
                return cart.getLocation();
            }
        }
        return "";
    }
}

