/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.io.Serializable;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;

public class GraphModel
implements Serializable {
    protected ID modelID;
    protected Hashtable store;
    protected boolean isWithPerfData;
    protected boolean isWithZoneData;
    protected Hashtable groupByCapabilitiesH;

    public GraphModel(ID modelID) {
        this.modelID = modelID;
        this.store = new Hashtable();
        this.groupByCapabilitiesH = new Hashtable();
        this.initGroupByCapabilities();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GraphModel(");
        sb.append("modelID=" + this.modelID);
        sb.append(", isWithPerfData=" + this.isWithPerfData + ", isWithZoneData=" + this.isWithZoneData);
        Vector<GraphEntity.Type> v = new Vector<GraphEntity.Type>();
        Enumeration enu = this.store.keys();
        while (enu.hasMoreElements()) {
            GraphEntity.Type type = (GraphEntity.Type)enu.nextElement();
            v.add(type);
        }
        Collections.sort(v, new Comparator(){

            public int compare(Object o1, Object o2) {
                String str1 = ((GraphEntity.Type)o1).getType().toString();
                String str2 = ((GraphEntity.Type)o2).getType().toString();
                return str1.compareTo(str2);
            }

            public boolean equals(Object obj) {
                return this.equals(obj);
            }
        });
        for (int i = 0; i < v.size(); ++i) {
            GraphEntity.Type type = (GraphEntity.Type)v.elementAt(i);
            sb.append("\r\n  " + type + ":");
            Hashtable h = (Hashtable)this.store.get(type);
            Enumeration enu2 = h.elements();
            while (enu2.hasMoreElements()) {
                Object value = enu2.nextElement();
                sb.append("\r\n    " + value);
            }
        }
        sb.append("\r\n)");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphModel)) {
            return false;
        }
        GraphModel a = (GraphModel)o;
        if (!this.modelID.equals(a.getModelID())) {
            return false;
        }
        return this.store.equals(a.store);
    }

    public int hashCode() {
        return this.modelID.hashCode();
    }

    public int compareTo(Object o) {
        ID a = this.getModelID();
        ID b = ((GraphModel)o).getModelID();
        return a.compareTo(b);
    }

    public ID getModelID() {
        return this.modelID;
    }

    public void setModelID(ID modelID) {
        this.modelID = modelID;
    }

    public GraphEntity get(GraphEntity.ID entityID) {
        if (entityID == null) {
            return null;
        }
        GraphEntity.Type entityType = entityID.getType();
        Hashtable h = (Hashtable)this.store.get(entityType);
        GraphEntity n = null;
        if (h != null) {
            n = (GraphEntity)h.get(entityID);
        }
        return n;
    }

    public Enumeration enumerate(GraphEntity.Type entityType) {
        Hashtable h = (Hashtable)this.store.get(entityType);
        return h == null ? new Vector().elements() : h.elements();
    }

    public Enumeration enumerateID(GraphEntity.Type entityType) {
        Hashtable h = (Hashtable)this.store.get(entityType);
        return h == null ? new Vector().elements() : h.keys();
    }

    public Enumeration associator(GraphEntity.Type entityType, GraphEntity.ID entityID) {
        Vector<GraphEntity> v = new Vector<GraphEntity>();
        if (entityType.isAssociation()) {
            Enumeration enu = this.enumerate(entityType);
            while (enu.hasMoreElements()) {
                GraphEntity entity1;
                GraphEntity entity2;
                GraphAssociation assoc = (GraphAssociation)enu.nextElement();
                GraphEntity.ID id1 = assoc.getFromID();
                GraphEntity.ID id2 = assoc.getToID();
                if (id1 != null && id1.equals(entityID) && (entity2 = this.get(id2)) != null) {
                    v.add(entity2);
                }
                if (id2 == null || !id2.equals(entityID) || (entity1 = this.get(id1)) == null) continue;
                v.add(entity1);
            }
        }
        return v.elements();
    }

    public Enumeration associatorID(GraphEntity.Type entityType, GraphEntity.ID entityID) {
        Vector<GraphEntity.ID> v = new Vector<GraphEntity.ID>();
        if (entityType.isAssociation()) {
            Enumeration enu = this.enumerate(entityType);
            while (enu.hasMoreElements()) {
                GraphAssociation assoc = (GraphAssociation)enu.nextElement();
                GraphEntity.ID id1 = assoc.getFromID();
                GraphEntity.ID id2 = assoc.getToID();
                if (id1 != null && id1.equals(entityID)) {
                    v.add(id2);
                }
                if (id2 == null || !id2.equals(entityID)) continue;
                v.add(id1);
            }
        }
        return v.elements();
    }

    public Enumeration reference(GraphEntity.Type entityType, GraphEntity.ID entityID) {
        Vector<GraphAssociation> v = new Vector<GraphAssociation>();
        if (entityType.isAssociation()) {
            Enumeration enu = this.enumerate(entityType);
            while (enu.hasMoreElements()) {
                GraphAssociation assoc = (GraphAssociation)enu.nextElement();
                GraphEntity.ID id1 = assoc.getFromID();
                GraphEntity.ID id2 = assoc.getToID();
                if (id1 != null && id1.equals(entityID)) {
                    v.add(assoc);
                }
                if (id2 == null || !id2.equals(entityID)) continue;
                v.add(assoc);
            }
        }
        return v.elements();
    }

    public Enumeration referenceID(GraphEntity.Type entityType, GraphEntity.ID entityID) {
        Vector<GraphEntity.ID> v = new Vector<GraphEntity.ID>();
        if (entityType.isAssociation()) {
            Enumeration enu = this.enumerateID(entityType);
            Hashtable h = (Hashtable)this.store.get(entityType);
            while (enu.hasMoreElements()) {
                GraphEntity.ID id = (GraphEntity.ID)enu.nextElement();
                GraphAssociation assoc = (GraphAssociation)h.get(id);
                GraphEntity.ID id1 = assoc.getFromID();
                GraphEntity.ID id2 = assoc.getToID();
                if (id1 != null && id1.equals(entityID)) {
                    v.add(id);
                }
                if (id2 == null || !id2.equals(entityID)) continue;
                v.add(id);
            }
        }
        return v.elements();
    }

    public Enumeration enumerateType() {
        return this.store.keys();
    }

    public void put(GraphEntity entity) {
        GraphEntity.ID entityID = entity.getEntityID();
        GraphEntity.Type entityType = entityID.getType();
        Hashtable<GraphEntity.ID, GraphEntity> h = (Hashtable<GraphEntity.ID, GraphEntity>)this.store.get(entityType);
        if (h == null) {
            h = new Hashtable<GraphEntity.ID, GraphEntity>();
            this.store.put(entityType, h);
        }
        h.put(entityID, entity);
    }

    public GraphEntity remove(GraphEntity.ID entityID) {
        GraphEntity.Type entityType = entityID.getType();
        Hashtable h = (Hashtable)this.store.get(entityType);
        GraphEntity n = null;
        if (h != null) {
            n = (GraphEntity)h.remove(entityID);
        }
        return n;
    }

    public Vector removeAll(GraphEntity.Type entityType) {
        Hashtable h = (Hashtable)this.store.get(entityType);
        if (h != null) {
            Vector v = new Vector(h.values());
            h.clear();
            this.store.remove(entityType);
            return v;
        }
        return new Vector();
    }

    public void clear() {
        this.store = new Hashtable();
        this.isWithPerfData = false;
        this.isWithZoneData = true;
    }

    public int size(GraphEntity.Type entityType) {
        Hashtable h = (Hashtable)this.store.get(entityType);
        return h == null ? 0 : h.size();
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        Enumeration enu = this.store.elements();
        while (enu.hasMoreElements()) {
            Hashtable h = (Hashtable)enu.nextElement();
            if (h.isEmpty()) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public boolean isWithPerfData() {
        return this.isWithPerfData;
    }

    public void setWithPerfData(boolean b) {
        this.isWithPerfData = b;
    }

    public boolean isWithZoneData() {
        return this.isWithZoneData;
    }

    public void setWithZoneData(boolean b) {
        this.isWithZoneData = b;
    }

    public void applyCollationKey() {
        RuleBasedCollator collator = (RuleBasedCollator)RuleBasedCollator.getInstance();
        Enumeration enu = this.store.elements();
        while (enu.hasMoreElements()) {
            Hashtable h = (Hashtable)enu.nextElement();
            Enumeration enu2 = h.elements();
            while (enu2.hasMoreElements()) {
                GraphEntity entity = (GraphEntity)enu2.nextElement();
                String s = entity.getDisplayName();
                if (s == null) continue;
                CollationKey collationKey = collator.getCollationKey(s);
                entity.setCollationKey(collationKey);
            }
        }
    }

    public void applyScope() {
    }

    public void applyPerfStatus() {
    }

    public void applyGrouping(Hashtable groupBySet) {
    }

    public void applyFiltering(int filteringLevel) {
    }

    protected void initGroupByCapabilities() {
    }

    public Integer getGroupByCapabilities(GraphScopedType scopedType) {
        return (Integer)this.groupByCapabilitiesH.get(scopedType);
    }

    public static class MultiEntityID
    extends ID {
        protected GraphEntity srcGroupEntity;
        protected Vector childFocusEntityIDV;

        public MultiEntityID(Object id) {
            super(id);
        }

        public MultiEntityID(String focusLevel, GraphEntity srcGroupEntity, Vector childFocusEntityIDV) {
            super(focusLevel, null);
            this.srcGroupEntity = srcGroupEntity;
            this.childFocusEntityIDV = childFocusEntityIDV;
            StringBuffer sb = new StringBuffer();
            sb.append(this.id);
            if (srcGroupEntity != null) {
                sb.append("-{" + srcGroupEntity.getGroupKey().getFullLabel() + "}");
            }
            sb.append("-{");
            for (int i = 0; i < childFocusEntityIDV.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                GraphEntity.ID childFocusEntityID = (GraphEntity.ID)childFocusEntityIDV.elementAt(i);
                sb.append(childFocusEntityID.getID());
            }
            sb.append("}");
            this.id = sb.toString();
        }

        public String toString() {
            return "GraphModel.MultiEntityID(id=" + this.id + ", focusLevel=" + this.focusLevel + ", focusEntityID=" + this.focusEntityID + ", childFocusEntityIDV=" + this.childFocusEntityIDV + ", srcGroupEntity=" + this.srcGroupEntity + ")";
        }

        public GraphEntity getSrcGroupEntity() {
            return this.srcGroupEntity;
        }

        public Vector getChildFocusEntityIDs() {
            return this.childFocusEntityIDV;
        }

        public void setChildFocusEntityIDs(Vector v) {
            this.childFocusEntityIDV = v;
        }
    }

    public static class ID
    implements Serializable,
    Comparable {
        protected Object id;
        protected String focusLevel;
        protected GraphEntity.ID focusEntityID;
        protected boolean needPerfData;
        protected boolean needZoneData;

        private ID(Object id) {
            this.id = id;
        }

        public ID(String focusLevel, GraphEntity.ID focusEntityID) {
            this.focusLevel = focusLevel;
            this.focusEntityID = focusEntityID;
            StringBuffer sb = new StringBuffer();
            sb.append(focusLevel);
            if (focusEntityID != null) {
                sb.append("-" + focusEntityID.getID());
            }
            this.id = sb.toString();
        }

        public String toString() {
            return "GraphModel.ID(id=" + this.id + ", focusLevel=" + this.focusLevel + ", focusEntityID=" + this.focusEntityID + ")";
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof ID)) {
                return false;
            }
            ID a = (ID)o;
            return this.id.equals(a.getID());
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public int compareTo(Object o) {
            Comparable a = (Comparable)this.getID();
            Object b = ((GraphEntity.ID)o).getID();
            return a.compareTo(b);
        }

        public Object getID() {
            return this.id;
        }

        public void setID(Object id) {
            this.id = id;
        }

        public String getFocusLevel() {
            return this.focusLevel;
        }

        public GraphEntity.ID getFocusEntityID() {
            return this.focusEntityID;
        }

        public void setFocusEntityID(GraphEntity.ID focusEntityID) {
            this.focusEntityID = focusEntityID;
        }

        public boolean isNeedPerfData() {
            return this.needPerfData;
        }

        public void setNeedPerfData(boolean b) {
            this.needPerfData = b;
        }

        public boolean isNeedZoneData() {
            return this.needZoneData;
        }

        public void setNeedZoneData(boolean b) {
            this.needZoneData = b;
        }
    }
}

