/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabric2VirtualFabric;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricGroup2Fabric;

public class GraphModelFabricL0
extends GraphModel {
    public GraphModelFabricL0(ID modelID) {
        super(modelID);
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
    }

    public void groupFocus() {
        String fabricGroupIDStr = "Focus";
        GraphFabricGroup fabricGroup = new GraphFabricGroup(fabricGroupIDStr);
        GraphFabricGroup.ID fabricGroupID = (GraphFabricGroup.ID)fabricGroup.getEntityID();
        fabricGroup.setIsHelper(Boolean.TRUE);
        this.put(fabricGroup);
        Integer fabricGroupStatus = null;
        Enumeration fabricEnu = this.enumerate(GraphFabric.TYPE);
        while (fabricEnu.hasMoreElements()) {
            GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
            GraphFabric.ID fabricID = (GraphFabric.ID)fabric.getEntityID();
            if (!fabric.getIsPhysical().booleanValue()) continue;
            fabricGroupStatus = GraphModelUtilities.aggregateStatus(fabricGroupStatus, fabric.getHealthStatus());
            GraphFabricGroup2Fabric assoc = new GraphFabricGroup2Fabric(fabricGroupID.getID() + "+" + fabricID.getID());
            assoc.setFabricGroupID(fabricGroupID);
            assoc.setFabricID(fabricID);
            this.put(assoc);
        }
        fabricGroup.setHealthStatus(fabricGroupStatus);
    }

    public void applyFiltering(int filteringLevel) {
        Enumeration fabricGroupEnu = this.enumerate(GraphFabricGroup.TYPE);
        while (fabricGroupEnu.hasMoreElements()) {
            GraphFabricGroup fabricGroup = (GraphFabricGroup)fabricGroupEnu.nextElement();
            GraphFabricGroup.ID fabricGroupID = (GraphFabricGroup.ID)fabricGroup.getEntityID();
            Enumeration fabricEnu = this.associator(GraphFabricGroup2Fabric.TYPE, fabricGroupID);
            while (fabricEnu.hasMoreElements()) {
                GraphFabric fabric = (GraphFabric)fabricEnu.nextElement();
                GraphFabric.ID fabricID = (GraphFabric.ID)fabric.getEntityID();
                int totalCountVirtualFabric = 0;
                int unfilteredCountVirtualFabric = 0;
                Enumeration virtualFabricEnu = this.associator(GraphFabric2VirtualFabric.TYPE, fabricID);
                while (virtualFabricEnu.hasMoreElements()) {
                    GraphFabric virtualFabric = (GraphFabric)virtualFabricEnu.nextElement();
                    ++totalCountVirtualFabric;
                    Boolean filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(virtualFabric) ? Boolean.FALSE : Boolean.TRUE);
                    virtualFabric.setIsFilterable(filterable);
                    if (filterable.booleanValue()) continue;
                    ++unfilteredCountVirtualFabric;
                }
                fabric.setNumOfVirtualFabrics(new Integer(totalCountVirtualFabric));
                fabric.setNumOfAbnormalVirtualFabrics(new Integer(unfilteredCountVirtualFabric));
                if (unfilteredCountVirtualFabric > 0) {
                    fabric.setIsFilterable(Boolean.FALSE);
                    continue;
                }
                Boolean filterable = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(fabric) ? Boolean.FALSE : Boolean.TRUE);
                fabric.setIsFilterable(filterable);
            }
            fabricGroup.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID() {
            super("FabricL0", null);
        }
    }
}

