/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk;
import org.eclipse.aperi.gui.topo.model.bean.GraphDisk2DiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskGroup2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphDiskPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2SubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPortGroup2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphLunGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphLunGroup2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2PoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphPool2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphPoolGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphPoolGroup2Pool;
import org.eclipse.aperi.gui.topo.model.bean.GraphPoolPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Disk;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2SubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemFCPortPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemGroup2Subsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystemPerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewSubsystemL2Connectivity;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubviewSubsystemL2Device;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchGroup2Switch;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2VolumePerf;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumeGroup2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolumePerf;

public class GraphModelSubsystemL2
extends GraphModel {
    public static final GraphScopedType SWGROUP = new GraphScopedType(GraphSwitchGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType VOLUMEGROUP_EXTERNAL = new GraphScopedType(GraphVolumeGroup.TYPE, "External");
    public static final GraphScopedType DISKGROUP = new GraphScopedType(GraphDiskGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType POOLGROUP = new GraphScopedType(GraphPoolGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType VOLUMEGROUP = new GraphScopedType(GraphVolumeGroup.TYPE, GraphModelConstant.SCOPE_NULL);
    public static final GraphScopedType DISKGROUP_EXTERNAL = new GraphScopedType(GraphDiskGroup.TYPE, "External");
    public static final GraphScopedType LUNGROUP = new GraphScopedType(GraphLunGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelSubsystemL2(ID modelID) {
        super(modelID);
    }

    protected void initGroupByCapabilities() {
        int bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_SWBYFABRIC;
        Integer groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(SWGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_VOLUMEBYSUBSYSTEM;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(VOLUMEGROUP_EXTERNAL, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_DISKBYPOOL;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(DISKGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_POOLBYRAID;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(POOLGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_VOLUMEBYPOOL;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(VOLUMEGROUP, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_DISKBYSUBSYSTEM;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(DISKGROUP_EXTERNAL, groupByBitmap);
        bitmap = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_LUNBYDEVICE;
        groupByBitmap = new Integer(bitmap);
        this.groupByCapabilitiesH.put(LUNGROUP, groupByBitmap);
    }

    public void applyScope() {
        GraphSubsystem subsystem;
        Enumeration subsystemEnu = this.enumerate(GraphSubsystem.TYPE);
        while (subsystemEnu.hasMoreElements()) {
            subsystem = (GraphSubsystem)subsystemEnu.nextElement();
            subsystem.addScope("Focus");
        }
        subsystemEnu = this.enumerate(GraphSubsystem.TYPE);
        while (subsystemEnu.hasMoreElements()) {
            subsystem = (GraphSubsystem)subsystemEnu.nextElement();
            GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
            if (!subsystem.containScope("Focus")) continue;
            Enumeration fcportEnu = this.associator(GraphSubsystem2FCPort.TYPE, subsystemID);
            while (fcportEnu.hasMoreElements()) {
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                fcport.addScope("Focus");
            }
        }
        Enumeration subsystem2diskEnu = this.enumerate(GraphSubsystem2Disk.TYPE);
        while (subsystem2diskEnu.hasMoreElements()) {
            GraphSubsystem2Disk subsystem2disk = (GraphSubsystem2Disk)subsystem2diskEnu.nextElement();
            GraphDisk.ID diskID = subsystem2disk.getDiskID();
            GraphDisk disk = (GraphDisk)this.get(diskID);
            disk.addScope("External");
        }
        Enumeration subsystem2volumeEnu = this.enumerate(GraphSubsystem2Volume.TYPE);
        while (subsystem2volumeEnu.hasMoreElements()) {
            GraphSubsystem2Volume subsystem2volume = (GraphSubsystem2Volume)subsystem2volumeEnu.nextElement();
            GraphVolume.ID volumeID = subsystem2volume.getVolumeID();
            GraphVolume volume = (GraphVolume)this.get(volumeID);
            volume.addScope("External");
        }
    }

    public void applyPerfStatus() {
        Enumeration subsystemEnu = this.enumerate(GraphSubsystem.TYPE);
        while (subsystemEnu.hasMoreElements()) {
            Enumeration enu;
            GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
            GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)subsystem.getEntityID();
            if (!subsystem.containScope("Focus") || !(enu = this.associator(GraphSubsystem2SubsystemPerf.TYPE, subsystemID)).hasMoreElements()) continue;
            GraphSubsystemPerf perf = (GraphSubsystemPerf)enu.nextElement();
            subsystem.setPerfStatus(perf.getHealthStatus());
        }
        Enumeration fcportEnu = this.enumerate(GraphFCPort.TYPE);
        while (fcportEnu.hasMoreElements()) {
            Enumeration enu;
            GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
            GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
            if (!fcport.containScope("Focus") || !(enu = this.associator(GraphFCPort2SubsystemFCPortPerf.TYPE, fcportID)).hasMoreElements()) continue;
            GraphSubsystemFCPortPerf perf = (GraphSubsystemFCPortPerf)enu.nextElement();
            fcport.setPerfStatus(perf.getHealthStatus());
        }
        Enumeration diskEnu = this.enumerate(GraphDisk.TYPE);
        while (diskEnu.hasMoreElements()) {
            Enumeration enu;
            GraphDisk disk = (GraphDisk)diskEnu.nextElement();
            GraphDisk.ID diskID = (GraphDisk.ID)disk.getEntityID();
            if (disk.containScope("External") || !(enu = this.associator(GraphDisk2DiskPerf.TYPE, diskID)).hasMoreElements()) continue;
            GraphDiskPerf perf = (GraphDiskPerf)enu.nextElement();
            disk.setPerfStatus(perf.getHealthStatus());
        }
        Enumeration poolEnu = this.enumerate(GraphPool.TYPE);
        while (poolEnu.hasMoreElements()) {
            GraphPool pool = (GraphPool)poolEnu.nextElement();
            GraphPool.ID poolID = (GraphPool.ID)pool.getEntityID();
            Enumeration enu = this.associator(GraphPool2PoolPerf.TYPE, poolID);
            if (!enu.hasMoreElements()) continue;
            GraphPoolPerf perf = (GraphPoolPerf)enu.nextElement();
            pool.setPerfStatus(perf.getHealthStatus());
        }
        Enumeration volumeEnu = this.enumerate(GraphVolume.TYPE);
        while (volumeEnu.hasMoreElements()) {
            Enumeration enu;
            GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
            GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
            if (volume.containScope("External") || !(enu = this.associator(GraphVolume2VolumePerf.TYPE, volumeID)).hasMoreElements()) continue;
            GraphVolumePerf perf = (GraphVolumePerf)enu.nextElement();
            volume.setPerfStatus(perf.getHealthStatus());
        }
    }

    public void applyGrouping(Hashtable groupBySet) {
        this.groupFocus();
        this.groupSubviewConnectivityFCPortBySingleGroup();
        this.groupSubviewConnectivitySwitch(groupBySet);
        this.groupSubviewConnectivity();
        this.groupSubviewDeviceExternalVolume(groupBySet);
        this.groupSubviewDeviceDisk(groupBySet);
        this.groupSubviewDevicePool(groupBySet);
        this.groupSubviewDeviceVolume(groupBySet);
        this.groupSubviewDeviceExternalDisk(groupBySet);
        this.groupSubviewDeviceLun(groupBySet);
        this.groupSubviewDevice();
        GraphGroupingUtilities.groupOrphanZone(this);
    }

    private void groupFocus() {
        GraphSubsystem.ID subsystemID = (GraphSubsystem.ID)((ID)this.modelID).getFocusEntityID();
        String subsystemGroupIDStr = "Focus";
        GraphSubsystemGroup subsystemGroup = new GraphSubsystemGroup(subsystemGroupIDStr);
        GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
        subsystemGroup.setIsHelper(Boolean.TRUE);
        this.put(subsystemGroup);
        GraphSubsystemGroup2Subsystem assoc = new GraphSubsystemGroup2Subsystem(subsystemGroupID.getID() + "+" + subsystemID.getID());
        assoc.setSubsystemGroupID(subsystemGroupID);
        assoc.setSubsystemID(subsystemID);
        this.put(assoc);
    }

    private void groupSubviewConnectivityFCPortBySingleGroup() {
        this.removeAll(GraphFCPortGroup.TYPE);
        this.removeAll(GraphFCPortGroup2FCPort.TYPE);
        Vector entityV = new Vector();
        Enumeration fcportEnu = this.enumerate(GraphFCPort.TYPE);
        while (fcportEnu.hasMoreElements()) {
            GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
            if (!fcport.containScope("Focus")) continue;
            entityV.add(fcport);
        }
        Integer groupByBitmap = GraphGroupingUtilities.GROUPBY_ALL;
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration fcportGroupKeyEnu = groupH.keys();
        while (fcportGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)fcportGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphFCPortGroup fcportGroup = new GraphFCPortGroup(idStr);
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            fcportGroup.setDisplayName(key.getLabel());
            fcportGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            fcportGroup.setPerfStatus(GraphModelUtilities.aggregatePerfStatus(entityV));
            fcportGroup.setSortingValue(key);
            fcportGroup.setGroupKey(key);
            this.put(fcportGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphFCPort fcport = (GraphFCPort)entityV.elementAt(i);
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                GraphFCPortGroup2FCPort assoc = new GraphFCPortGroup2FCPort(fcportGroupID.getID() + "+" + fcportID.getID());
                assoc.setFCPortGroupID(fcportGroupID);
                assoc.setFCPortID(fcportID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivitySwitch(Hashtable groupBySet) {
        this.removeAll(GraphSwitchGroup.TYPE);
        this.removeAll(GraphSwitchGroup2Switch.TYPE);
        Vector entityV = new Vector();
        Enumeration swEnu = this.enumerate(GraphSwitch.TYPE);
        while (swEnu.hasMoreElements()) {
            GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
            entityV.add(sw);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(SWGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration swGroupKeyEnu = groupH.keys();
        while (swGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)swGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphSwitchGroup swGroup = new GraphSwitchGroup(idStr);
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            swGroup.setDisplayName(key.getLabel());
            swGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            swGroup.setSortingValue(key);
            swGroup.setGroupKey(key);
            this.put(swGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphSwitch sw = (GraphSwitch)entityV.elementAt(i);
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                GraphSwitchGroup2Switch assoc = new GraphSwitchGroup2Switch(swGroupID.getID() + "+" + swID.getID());
                assoc.setSwitchGroupID(swGroupID);
                assoc.setSwitchID(swID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewConnectivity() {
        GraphSubviewSubsystemL2Connectivity connectivity = new GraphSubviewSubsystemL2Connectivity("Connectivity");
        GraphSubviewSubsystemL2Connectivity.ID connectivityID = (GraphSubviewSubsystemL2Connectivity.ID)connectivity.getEntityID();
        connectivity.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_CONNECTIVITY"));
        this.put(connectivity);
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), fcportGroup.getHealthStatus()));
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            connectivity.setHealthStatus(GraphModelUtilities.aggregateStatus(connectivity.getHealthStatus(), swGroup.getHealthStatus()));
        }
    }

    private void groupSubviewDeviceExternalVolume(Hashtable groupBySet) {
        int i;
        GraphVolumeGroup.ID volumeGroupID;
        Vector<GraphVolumeGroup.ID> volumeGroupIDV = new Vector<GraphVolumeGroup.ID>();
        Vector<GraphVolumeGroup2Volume.ID> volumeGroup2volumeIDV = new Vector<GraphVolumeGroup2Volume.ID>();
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            if (!volumeGroup.containScope("External")) continue;
            GraphVolumeGroup.ID volumeGroupID2 = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            volumeGroupIDV.add(volumeGroupID2);
        }
        Enumeration volumeGroup2volumeEnu = this.enumerate(GraphVolumeGroup2Volume.TYPE);
        while (volumeGroup2volumeEnu.hasMoreElements()) {
            GraphVolumeGroup2Volume volumeGroup2volume = (GraphVolumeGroup2Volume)volumeGroup2volumeEnu.nextElement();
            volumeGroupID = volumeGroup2volume.getVolumeGroupID();
            if (!volumeGroupIDV.contains(volumeGroupID)) continue;
            GraphVolumeGroup2Volume.ID volumeGroup2volumeID = (GraphVolumeGroup2Volume.ID)volumeGroup2volume.getEntityID();
            volumeGroup2volumeIDV.add(volumeGroup2volumeID);
        }
        for (i = 0; i < volumeGroupIDV.size(); ++i) {
            volumeGroupID = (GraphVolumeGroup.ID)volumeGroupIDV.elementAt(i);
            this.remove(volumeGroupID);
        }
        for (i = 0; i < volumeGroup2volumeIDV.size(); ++i) {
            GraphVolumeGroup2Volume.ID volumeGroup2volumeID = (GraphVolumeGroup2Volume.ID)volumeGroup2volumeIDV.elementAt(i);
            this.remove(volumeGroup2volumeID);
        }
        Vector entityV = new Vector();
        Enumeration volumeEnu = this.enumerate(GraphVolume.TYPE);
        while (volumeEnu.hasMoreElements()) {
            GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
            if (!volume.containScope("External")) continue;
            entityV.add(volume);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(VOLUMEGROUP_EXTERNAL);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration volumeGroupKeyEnu = groupH.keys();
        while (volumeGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)volumeGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = "External" + key.getID();
            GraphVolumeGroup volumeGroup = new GraphVolumeGroup(idStr);
            GraphVolumeGroup.ID volumeGroupID3 = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            volumeGroup.addScope("External");
            volumeGroup.setDisplayName(key.getLabel());
            volumeGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            volumeGroup.setSortingValue(key);
            volumeGroup.setGroupKey(key);
            this.put(volumeGroup);
            for (int i2 = 0; i2 < entityV.size(); ++i2) {
                GraphVolume volume = (GraphVolume)entityV.elementAt(i2);
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                GraphVolumeGroup2Volume assoc = new GraphVolumeGroup2Volume(volumeGroupID3.getID() + "+" + volumeID.getID());
                assoc.setVolumeGroupID(volumeGroupID3);
                assoc.setVolumeID(volumeID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDeviceDisk(Hashtable groupBySet) {
        int i;
        GraphDiskGroup.ID diskGroupID;
        Vector<GraphDiskGroup.ID> diskGroupIDV = new Vector<GraphDiskGroup.ID>();
        Vector<GraphDiskGroup2Disk.ID> diskGroup2diskIDV = new Vector<GraphDiskGroup2Disk.ID>();
        Enumeration diskGroupEnu = this.enumerate(GraphDiskGroup.TYPE);
        while (diskGroupEnu.hasMoreElements()) {
            GraphDiskGroup diskGroup = (GraphDiskGroup)diskGroupEnu.nextElement();
            if (diskGroup.containScope("External")) continue;
            GraphDiskGroup.ID diskGroupID2 = (GraphDiskGroup.ID)diskGroup.getEntityID();
            diskGroupIDV.add(diskGroupID2);
        }
        Enumeration diskGroup2diskEnu = this.enumerate(GraphDiskGroup2Disk.TYPE);
        while (diskGroup2diskEnu.hasMoreElements()) {
            GraphDiskGroup2Disk diskGroup2disk = (GraphDiskGroup2Disk)diskGroup2diskEnu.nextElement();
            diskGroupID = diskGroup2disk.getDiskGroupID();
            if (!diskGroupIDV.contains(diskGroupID)) continue;
            GraphDiskGroup2Disk.ID diskGroup2diskID = (GraphDiskGroup2Disk.ID)diskGroup2disk.getEntityID();
            diskGroup2diskIDV.add(diskGroup2diskID);
        }
        for (i = 0; i < diskGroupIDV.size(); ++i) {
            diskGroupID = (GraphDiskGroup.ID)diskGroupIDV.elementAt(i);
            this.remove(diskGroupID);
        }
        for (i = 0; i < diskGroup2diskIDV.size(); ++i) {
            GraphDiskGroup2Disk.ID diskGroup2diskID = (GraphDiskGroup2Disk.ID)diskGroup2diskIDV.elementAt(i);
            this.remove(diskGroup2diskID);
        }
        Vector entityV = new Vector();
        Enumeration diskEnu = this.enumerate(GraphDisk.TYPE);
        while (diskEnu.hasMoreElements()) {
            GraphDisk disk = (GraphDisk)diskEnu.nextElement();
            if (disk.containScope("External")) continue;
            entityV.add(disk);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(DISKGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration diskGroupKeyEnu = groupH.keys();
        while (diskGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)diskGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphDiskGroup diskGroup = new GraphDiskGroup(idStr);
            GraphDiskGroup.ID diskGroupID3 = (GraphDiskGroup.ID)diskGroup.getEntityID();
            diskGroup.setDisplayName(key.getLabel());
            diskGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            diskGroup.setPerfStatus(GraphModelUtilities.aggregatePerfStatus(entityV));
            diskGroup.setSortingValue(key);
            diskGroup.setGroupKey(key);
            this.put(diskGroup);
            for (int i2 = 0; i2 < entityV.size(); ++i2) {
                GraphDisk disk = (GraphDisk)entityV.elementAt(i2);
                GraphDisk.ID diskID = (GraphDisk.ID)disk.getEntityID();
                GraphDiskGroup2Disk assoc = new GraphDiskGroup2Disk(diskGroupID3.getID() + "+" + diskID.getID());
                assoc.setDiskGroupID(diskGroupID3);
                assoc.setDiskID(diskID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDevicePool(Hashtable groupBySet) {
        this.removeAll(GraphPoolGroup.TYPE);
        this.removeAll(GraphPoolGroup2Pool.TYPE);
        Vector entityV = new Vector();
        Enumeration poolEnu = this.enumerate(GraphPool.TYPE);
        while (poolEnu.hasMoreElements()) {
            GraphPool pool = (GraphPool)poolEnu.nextElement();
            entityV.add(pool);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(POOLGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration poolGroupKeyEnu = groupH.keys();
        while (poolGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)poolGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphPoolGroup poolGroup = new GraphPoolGroup(idStr);
            GraphPoolGroup.ID poolGroupID = (GraphPoolGroup.ID)poolGroup.getEntityID();
            poolGroup.setDisplayName(key.getLabel());
            poolGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            poolGroup.setPerfStatus(GraphModelUtilities.aggregatePerfStatus(entityV));
            poolGroup.setSortingValue(key);
            poolGroup.setGroupKey(key);
            this.put(poolGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphPool pool = (GraphPool)entityV.elementAt(i);
                GraphPool.ID poolID = (GraphPool.ID)pool.getEntityID();
                GraphPoolGroup2Pool assoc = new GraphPoolGroup2Pool(poolGroupID.getID() + "+" + poolID.getID());
                assoc.setPoolGroupID(poolGroupID);
                assoc.setPoolID(poolID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDeviceVolume(Hashtable groupBySet) {
        int i;
        GraphVolumeGroup.ID volumeGroupID;
        Vector<GraphVolumeGroup.ID> volumeGroupIDV = new Vector<GraphVolumeGroup.ID>();
        Vector<GraphVolumeGroup2Volume.ID> volumeGroup2volumeIDV = new Vector<GraphVolumeGroup2Volume.ID>();
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            if (volumeGroup.containScope("External")) continue;
            GraphVolumeGroup.ID volumeGroupID2 = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            volumeGroupIDV.add(volumeGroupID2);
        }
        Enumeration volumeGroup2volumeEnu = this.enumerate(GraphVolumeGroup2Volume.TYPE);
        while (volumeGroup2volumeEnu.hasMoreElements()) {
            GraphVolumeGroup2Volume volumeGroup2volume = (GraphVolumeGroup2Volume)volumeGroup2volumeEnu.nextElement();
            volumeGroupID = volumeGroup2volume.getVolumeGroupID();
            if (!volumeGroupIDV.contains(volumeGroupID)) continue;
            GraphVolumeGroup2Volume.ID volumeGroup2volumeID = (GraphVolumeGroup2Volume.ID)volumeGroup2volume.getEntityID();
            volumeGroup2volumeIDV.add(volumeGroup2volumeID);
        }
        for (i = 0; i < volumeGroupIDV.size(); ++i) {
            volumeGroupID = (GraphVolumeGroup.ID)volumeGroupIDV.elementAt(i);
            this.remove(volumeGroupID);
        }
        for (i = 0; i < volumeGroup2volumeIDV.size(); ++i) {
            GraphVolumeGroup2Volume.ID volumeGroup2volumeID = (GraphVolumeGroup2Volume.ID)volumeGroup2volumeIDV.elementAt(i);
            this.remove(volumeGroup2volumeID);
        }
        Vector entityV = new Vector();
        Enumeration volumeEnu = this.enumerate(GraphVolume.TYPE);
        while (volumeEnu.hasMoreElements()) {
            GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
            if (volume.containScope("External")) continue;
            entityV.add(volume);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(VOLUMEGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration volumeGroupKeyEnu = groupH.keys();
        while (volumeGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)volumeGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphVolumeGroup volumeGroup = new GraphVolumeGroup(idStr);
            GraphVolumeGroup.ID volumeGroupID3 = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            volumeGroup.setDisplayName(key.getLabel());
            volumeGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            volumeGroup.setPerfStatus(GraphModelUtilities.aggregatePerfStatus(entityV));
            volumeGroup.setSortingValue(key);
            volumeGroup.setGroupKey(key);
            this.put(volumeGroup);
            for (int i2 = 0; i2 < entityV.size(); ++i2) {
                GraphVolume volume = (GraphVolume)entityV.elementAt(i2);
                GraphVolume.ID volumeID = (GraphVolume.ID)volume.getEntityID();
                GraphVolumeGroup2Volume assoc = new GraphVolumeGroup2Volume(volumeGroupID3.getID() + "+" + volumeID.getID());
                assoc.setVolumeGroupID(volumeGroupID3);
                assoc.setVolumeID(volumeID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDeviceExternalDisk(Hashtable groupBySet) {
        int i;
        GraphDiskGroup.ID diskGroupID;
        Vector<GraphDiskGroup.ID> diskGroupIDV = new Vector<GraphDiskGroup.ID>();
        Vector<GraphDiskGroup2Disk.ID> diskGroup2diskIDV = new Vector<GraphDiskGroup2Disk.ID>();
        Enumeration diskGroupEnu = this.enumerate(GraphDiskGroup.TYPE);
        while (diskGroupEnu.hasMoreElements()) {
            GraphDiskGroup diskGroup = (GraphDiskGroup)diskGroupEnu.nextElement();
            if (!diskGroup.containScope("External")) continue;
            GraphDiskGroup.ID diskGroupID2 = (GraphDiskGroup.ID)diskGroup.getEntityID();
            diskGroupIDV.add(diskGroupID2);
        }
        Enumeration diskGroup2diskEnu = this.enumerate(GraphDiskGroup2Disk.TYPE);
        while (diskGroup2diskEnu.hasMoreElements()) {
            GraphDiskGroup2Disk diskGroup2disk = (GraphDiskGroup2Disk)diskGroup2diskEnu.nextElement();
            diskGroupID = diskGroup2disk.getDiskGroupID();
            if (!diskGroupIDV.contains(diskGroupID)) continue;
            GraphDiskGroup2Disk.ID diskGroup2diskID = (GraphDiskGroup2Disk.ID)diskGroup2disk.getEntityID();
            diskGroup2diskIDV.add(diskGroup2diskID);
        }
        for (i = 0; i < diskGroupIDV.size(); ++i) {
            diskGroupID = (GraphDiskGroup.ID)diskGroupIDV.elementAt(i);
            this.remove(diskGroupID);
        }
        for (i = 0; i < diskGroup2diskIDV.size(); ++i) {
            GraphDiskGroup2Disk.ID diskGroup2diskID = (GraphDiskGroup2Disk.ID)diskGroup2diskIDV.elementAt(i);
            this.remove(diskGroup2diskID);
        }
        Vector entityV = new Vector();
        Enumeration diskEnu = this.enumerate(GraphDisk.TYPE);
        while (diskEnu.hasMoreElements()) {
            GraphDisk disk = (GraphDisk)diskEnu.nextElement();
            if (!disk.containScope("External")) continue;
            entityV.add(disk);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(DISKGROUP_EXTERNAL);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration diskGroupKeyEnu = groupH.keys();
        while (diskGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)diskGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = "External" + key.getID();
            GraphDiskGroup diskGroup = new GraphDiskGroup(idStr);
            GraphDiskGroup.ID diskGroupID3 = (GraphDiskGroup.ID)diskGroup.getEntityID();
            diskGroup.addScope("External");
            diskGroup.setDisplayName(key.getLabel());
            diskGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            diskGroup.setSortingValue(key);
            diskGroup.setGroupKey(key);
            this.put(diskGroup);
            for (int i2 = 0; i2 < entityV.size(); ++i2) {
                GraphDisk disk = (GraphDisk)entityV.elementAt(i2);
                GraphDisk.ID diskID = (GraphDisk.ID)disk.getEntityID();
                GraphDiskGroup2Disk assoc = new GraphDiskGroup2Disk(diskGroupID3.getID() + "+" + diskID.getID());
                assoc.setDiskGroupID(diskGroupID3);
                assoc.setDiskID(diskID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDeviceLun(Hashtable groupBySet) {
        this.removeAll(GraphLunGroup.TYPE);
        this.removeAll(GraphLunGroup2Lun.TYPE);
        Vector entityV = new Vector();
        Enumeration lunEnu = this.enumerate(GraphLun.TYPE);
        while (lunEnu.hasMoreElements()) {
            GraphLun lun = (GraphLun)lunEnu.nextElement();
            entityV.add(lun);
        }
        Integer groupByBitmap = (Integer)groupBySet.get(LUNGROUP);
        Hashtable groupH = GraphGroupingUtilities.applyGrouping(entityV, groupByBitmap, this);
        Enumeration lunGroupKeyEnu = groupH.keys();
        while (lunGroupKeyEnu.hasMoreElements()) {
            GraphGroupKey key = (GraphGroupKey)lunGroupKeyEnu.nextElement();
            entityV = (Vector)groupH.get(key);
            String idStr = key.getID();
            GraphLunGroup lunGroup = new GraphLunGroup(idStr);
            GraphLunGroup.ID lunGroupID = (GraphLunGroup.ID)lunGroup.getEntityID();
            lunGroup.setDisplayName(key.getLabel());
            lunGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(entityV));
            lunGroup.setSortingValue(key);
            lunGroup.setGroupKey(key);
            this.put(lunGroup);
            for (int i = 0; i < entityV.size(); ++i) {
                GraphLun lun = (GraphLun)entityV.elementAt(i);
                GraphLun.ID lunID = (GraphLun.ID)lun.getEntityID();
                GraphLunGroup2Lun assoc = new GraphLunGroup2Lun(lunGroupID.getID() + "+" + lunID.getID());
                assoc.setLunGroupID(lunGroupID);
                assoc.setLunID(lunID);
                this.put(assoc);
            }
        }
    }

    private void groupSubviewDevice() {
        GraphSubviewSubsystemL2Device device = new GraphSubviewSubsystemL2Device("Device");
        GraphSubviewSubsystemL2Device.ID deviceID = (GraphSubviewSubsystemL2Device.ID)device.getEntityID();
        device.setDisplayName(GuiUtil.getString("TOPO_LABEL_TASK_DEVICE"));
        this.put(device);
        GraphSubsystem.ID focusEntityID = (GraphSubsystem.ID)this.modelID.getFocusEntityID();
        GraphSubsystem focusEntity = (GraphSubsystem)this.get(focusEntityID);
        device.setIsSVC(focusEntity.getIsSVC());
        Enumeration diskGroupEnu = this.enumerate(GraphDiskGroup.TYPE);
        while (diskGroupEnu.hasMoreElements()) {
            GraphDiskGroup diskGroup = (GraphDiskGroup)diskGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), diskGroup.getHealthStatus()));
        }
        Enumeration poolGroupEnu = this.enumerate(GraphPoolGroup.TYPE);
        while (poolGroupEnu.hasMoreElements()) {
            GraphPoolGroup poolGroup = (GraphPoolGroup)poolGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), poolGroup.getHealthStatus()));
        }
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            GraphVolumeGroup volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), volumeGroup.getHealthStatus()));
        }
        Enumeration lunGroupEnu = this.enumerate(GraphLunGroup.TYPE);
        while (lunGroupEnu.hasMoreElements()) {
            GraphLunGroup lunGroup = (GraphLunGroup)lunGroupEnu.nextElement();
            device.setHealthStatus(GraphModelUtilities.aggregateStatus(device.getHealthStatus(), lunGroup.getHealthStatus()));
        }
    }

    public void applyFiltering(int filteringLevel) {
        GraphPool2Disk pool2disk;
        Enumeration pool2diskEnu;
        GraphDisk.ID diskID;
        GraphDiskGroup.ID diskGroupID;
        GraphDiskGroup diskGroup;
        GraphLun lun;
        GraphLun.ID lunID;
        GraphVolume2Lun volume2lun;
        Enumeration volume2lunEnu;
        GraphPool pool;
        GraphPool.ID poolID;
        GraphPool2Volume pool2volume;
        Enumeration pool2volumeEnu;
        GraphVolume.ID volumeID;
        GraphVolumeGroup.ID volumeGroupID;
        GraphVolumeGroup volumeGroup;
        Boolean filterable;
        GraphFCPort2FCPort fcp2fcport;
        Enumeration subsystemGroupEnu = this.enumerate(GraphSubsystemGroup.TYPE);
        while (subsystemGroupEnu.hasMoreElements()) {
            GraphSubsystemGroup subsystemGroup = (GraphSubsystemGroup)subsystemGroupEnu.nextElement();
            GraphSubsystemGroup.ID subsystemGroupID = (GraphSubsystemGroup.ID)subsystemGroup.getEntityID();
            Enumeration subsystemEnu = this.associator(GraphSubsystemGroup2Subsystem.TYPE, subsystemGroupID);
            while (subsystemEnu.hasMoreElements()) {
                GraphSubsystem subsystem = (GraphSubsystem)subsystemEnu.nextElement();
                subsystem.setIsFilterable(Boolean.FALSE);
            }
            subsystemGroup.setIsFilterable(Boolean.FALSE);
        }
        Enumeration fcportGroupEnu = this.enumerate(GraphFCPortGroup.TYPE);
        while (fcportGroupEnu.hasMoreElements()) {
            GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu.nextElement();
            GraphFCPortGroup.ID fcportGroupID = (GraphFCPortGroup.ID)fcportGroup.getEntityID();
            int totalCountUsed = 0;
            int unfilteredCountUsed = 0;
            int totalCountEmpty = 0;
            int unfilteredCountEmpty = 0;
            Enumeration fcportEnu = this.associator(GraphFCPortGroup2FCPort.TYPE, fcportGroupID);
            while (fcportEnu.hasMoreElements()) {
                Boolean filterable2;
                GraphFCPort fcport = (GraphFCPort)fcportEnu.nextElement();
                GraphFCPort.ID fcportID = (GraphFCPort.ID)fcport.getEntityID();
                Enumeration fcport2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcportID);
                if (fcport2fcportEnu.hasMoreElements()) {
                    ++totalCountUsed;
                    if (filteringLevel == 0) {
                        filterable2 = Boolean.FALSE;
                    } else if (GraphModelUtilities.isAbnormal(fcport)) {
                        filterable2 = Boolean.FALSE;
                    } else {
                        filterable2 = Boolean.TRUE;
                        if (filteringLevel == 1) {
                            GraphSwitch sw;
                            Enumeration swEnu;
                            GraphFCPort.ID fcpID;
                            fcp2fcport = (GraphFCPort2FCPort)fcport2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable2 = Boolean.FALSE;
                            }
                            if ((fcpID = fcp2fcport.getFCPort1ID()).equals(fcportID)) {
                                fcpID = fcp2fcport.getFCPort2ID();
                            }
                            if ((swEnu = this.associator(GraphSwitch2FCPort.TYPE, fcpID)).hasMoreElements() && GraphModelUtilities.isAbnormal(sw = (GraphSwitch)swEnu.nextElement())) {
                                filterable2 = Boolean.FALSE;
                            }
                        }
                    }
                    if (!filterable2.booleanValue()) {
                        ++unfilteredCountUsed;
                    }
                } else {
                    ++totalCountEmpty;
                    filterable2 = filteringLevel == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(fcport) ? Boolean.FALSE : Boolean.TRUE);
                    if (!filterable2.booleanValue()) {
                        ++unfilteredCountEmpty;
                    }
                }
                fcport.setIsFilterable(filterable2);
            }
            fcportGroup.setNumOfFCPortsInUse(new Integer(totalCountUsed));
            fcportGroup.setNumOfAbnormalFCPortsInUse(new Integer(unfilteredCountUsed));
            fcportGroup.setNumOfFCPortsEmpty(new Integer(totalCountEmpty));
            fcportGroup.setNumOfAbnormalFCPortsEmpty(new Integer(unfilteredCountEmpty));
            fcportGroup.setIsFilterable(unfilteredCountUsed + unfilteredCountEmpty == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration swGroupEnu = this.enumerate(GraphSwitchGroup.TYPE);
        while (swGroupEnu.hasMoreElements()) {
            GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu.nextElement();
            GraphSwitchGroup.ID swGroupID = (GraphSwitchGroup.ID)swGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration swEnu = this.associator(GraphSwitchGroup2Switch.TYPE, swGroupID);
            while (swEnu.hasMoreElements()) {
                GraphSwitch sw = (GraphSwitch)swEnu.nextElement();
                GraphSwitch.ID swID = (GraphSwitch.ID)sw.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(sw)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration fcpIDEnu = this.associatorID(GraphSwitch2FCPort.TYPE, swID);
                        while (fcpIDEnu.hasMoreElements()) {
                            GraphFCPort fcport;
                            GraphFCPort.ID fcpID = (GraphFCPort.ID)fcpIDEnu.nextElement();
                            Enumeration fcp2fcportEnu = this.reference(GraphFCPort2FCPort.TYPE, fcpID);
                            if (!fcp2fcportEnu.hasMoreElements()) continue;
                            fcp2fcport = (GraphFCPort2FCPort)fcp2fcportEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(fcp2fcport)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphFCPort.ID fcportID = fcp2fcport.getFCPort1ID();
                            if (fcportID.equals(fcpID)) {
                                fcportID = fcp2fcport.getFCPort2ID();
                            }
                            if (!GraphModelUtilities.isAbnormal(fcport = (GraphFCPort)this.get(fcportID))) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                sw.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            swGroup.setNumOfSwitches(new Integer(totalCount));
            swGroup.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            swGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            volumeGroupID = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            if (!volumeGroup.containScope("External")) continue;
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration volumeEnu = this.associator(GraphVolumeGroup2Volume.TYPE, volumeGroupID);
            while (volumeEnu.hasMoreElements()) {
                GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                volumeID = (GraphVolume.ID)volume.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(volume)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        pool2volumeEnu = this.reference(GraphPool2Volume.TYPE, volumeID);
                        while (pool2volumeEnu.hasMoreElements()) {
                            pool2volume = (GraphPool2Volume)pool2volumeEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(pool2volume)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            poolID = pool2volume.getPoolID();
                            pool = (GraphPool)this.get(poolID);
                            if (!GraphModelUtilities.isAbnormal(pool)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                        volume2lunEnu = this.reference(GraphVolume2Lun.TYPE, volumeID);
                        while (volume2lunEnu.hasMoreElements()) {
                            volume2lun = (GraphVolume2Lun)volume2lunEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(volume2lun)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            lunID = volume2lun.getLunID();
                            lun = (GraphLun)this.get(lunID);
                            if (!GraphModelUtilities.isAbnormal(lun)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                volume.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            volumeGroup.setNumOfVolumes(new Integer(totalCount));
            volumeGroup.setNumOfAbnormalVolumes(new Integer(unfilteredCount));
            volumeGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration diskGroupEnu = this.enumerate(GraphDiskGroup.TYPE);
        while (diskGroupEnu.hasMoreElements()) {
            diskGroup = (GraphDiskGroup)diskGroupEnu.nextElement();
            diskGroupID = (GraphDiskGroup.ID)diskGroup.getEntityID();
            if (diskGroup.containScope("External")) continue;
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration diskEnu = this.associator(GraphDiskGroup2Disk.TYPE, diskGroupID);
            while (diskEnu.hasMoreElements()) {
                GraphDisk disk = (GraphDisk)diskEnu.nextElement();
                diskID = (GraphDisk.ID)disk.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(disk)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        pool2diskEnu = this.reference(GraphPool2Disk.TYPE, diskID);
                        while (pool2diskEnu.hasMoreElements()) {
                            pool2disk = (GraphPool2Disk)pool2diskEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(pool2disk)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            poolID = pool2disk.getPoolID();
                            pool = (GraphPool)this.get(poolID);
                            if (!GraphModelUtilities.isAbnormal(pool)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                disk.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            diskGroup.setNumOfDisks(new Integer(totalCount));
            diskGroup.setNumOfAbnormalDisks(new Integer(unfilteredCount));
            diskGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration poolGroupEnu = this.enumerate(GraphPoolGroup.TYPE);
        while (poolGroupEnu.hasMoreElements()) {
            GraphPoolGroup poolGroup = (GraphPoolGroup)poolGroupEnu.nextElement();
            GraphPoolGroup.ID poolGroupID = (GraphPoolGroup.ID)poolGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration poolEnu = this.associator(GraphPoolGroup2Pool.TYPE, poolGroupID);
            while (poolEnu.hasMoreElements()) {
                GraphPool pool2 = (GraphPool)poolEnu.nextElement();
                GraphPool.ID poolID2 = (GraphPool.ID)pool2.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(pool2)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        pool2diskEnu = this.reference(GraphPool2Disk.TYPE, poolID2);
                        while (pool2diskEnu.hasMoreElements()) {
                            pool2disk = (GraphPool2Disk)pool2diskEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(pool2disk)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphDisk.ID diskID2 = pool2disk.getDiskID();
                            GraphDisk disk = (GraphDisk)this.get(diskID2);
                            if (!GraphModelUtilities.isAbnormal(disk)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                        Enumeration pool2volumeEnu2 = this.reference(GraphPool2Volume.TYPE, poolID2);
                        while (pool2volumeEnu2.hasMoreElements()) {
                            GraphPool2Volume pool2volume2 = (GraphPool2Volume)pool2volumeEnu2.nextElement();
                            if (GraphModelUtilities.isAbnormal(pool2volume2)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphVolume.ID volumeID2 = pool2volume2.getVolumeID();
                            GraphVolume volume = (GraphVolume)this.get(volumeID2);
                            if (!GraphModelUtilities.isAbnormal(volume)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                pool2.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            poolGroup.setNumOfPools(new Integer(totalCount));
            poolGroup.setNumOfAbnormalPools(new Integer(unfilteredCount));
            poolGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        volumeGroupEnu = this.enumerate(GraphVolumeGroup.TYPE);
        while (volumeGroupEnu.hasMoreElements()) {
            volumeGroup = (GraphVolumeGroup)volumeGroupEnu.nextElement();
            volumeGroupID = (GraphVolumeGroup.ID)volumeGroup.getEntityID();
            if (volumeGroup.containScope("External")) continue;
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration volumeEnu = this.associator(GraphVolumeGroup2Volume.TYPE, volumeGroupID);
            while (volumeEnu.hasMoreElements()) {
                GraphVolume volume = (GraphVolume)volumeEnu.nextElement();
                volumeID = (GraphVolume.ID)volume.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(volume)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        pool2volumeEnu = this.reference(GraphPool2Volume.TYPE, volumeID);
                        while (pool2volumeEnu.hasMoreElements()) {
                            pool2volume = (GraphPool2Volume)pool2volumeEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(pool2volume)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            poolID = pool2volume.getPoolID();
                            pool = (GraphPool)this.get(poolID);
                            if (!GraphModelUtilities.isAbnormal(pool)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                        volume2lunEnu = this.reference(GraphVolume2Lun.TYPE, volumeID);
                        while (volume2lunEnu.hasMoreElements()) {
                            volume2lun = (GraphVolume2Lun)volume2lunEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(volume2lun)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            lunID = volume2lun.getLunID();
                            lun = (GraphLun)this.get(lunID);
                            if (!GraphModelUtilities.isAbnormal(lun)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                volume.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            volumeGroup.setNumOfVolumes(new Integer(totalCount));
            volumeGroup.setNumOfAbnormalVolumes(new Integer(unfilteredCount));
            volumeGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        diskGroupEnu = this.enumerate(GraphDiskGroup.TYPE);
        while (diskGroupEnu.hasMoreElements()) {
            diskGroup = (GraphDiskGroup)diskGroupEnu.nextElement();
            diskGroupID = (GraphDiskGroup.ID)diskGroup.getEntityID();
            if (!diskGroup.containScope("External")) continue;
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration diskEnu = this.associator(GraphDiskGroup2Disk.TYPE, diskGroupID);
            while (diskEnu.hasMoreElements()) {
                GraphDisk disk = (GraphDisk)diskEnu.nextElement();
                diskID = (GraphDisk.ID)disk.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(disk)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        pool2diskEnu = this.reference(GraphPool2Disk.TYPE, diskID);
                        while (pool2diskEnu.hasMoreElements()) {
                            pool2disk = (GraphPool2Disk)pool2diskEnu.nextElement();
                            if (GraphModelUtilities.isAbnormal(pool2disk)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            poolID = pool2disk.getPoolID();
                            pool = (GraphPool)this.get(poolID);
                            if (!GraphModelUtilities.isAbnormal(pool)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                disk.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            diskGroup.setNumOfDisks(new Integer(totalCount));
            diskGroup.setNumOfAbnormalDisks(new Integer(unfilteredCount));
            diskGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration lunGroupEnu = this.enumerate(GraphLunGroup.TYPE);
        while (lunGroupEnu.hasMoreElements()) {
            GraphLunGroup lunGroup = (GraphLunGroup)lunGroupEnu.nextElement();
            GraphLunGroup.ID lunGroupID = (GraphLunGroup.ID)lunGroup.getEntityID();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration lunEnu = this.associator(GraphLunGroup2Lun.TYPE, lunGroupID);
            while (lunEnu.hasMoreElements()) {
                GraphLun lun2 = (GraphLun)lunEnu.nextElement();
                GraphLun.ID lunID2 = (GraphLun.ID)lun2.getEntityID();
                ++totalCount;
                if (filteringLevel == 0) {
                    filterable = Boolean.FALSE;
                } else if (GraphModelUtilities.isAbnormal(lun2)) {
                    filterable = Boolean.FALSE;
                } else {
                    filterable = Boolean.TRUE;
                    if (filteringLevel == 1) {
                        Enumeration volume2lunEnu2 = this.reference(GraphVolume2Lun.TYPE, lunID2);
                        while (volume2lunEnu2.hasMoreElements()) {
                            GraphVolume2Lun volume2lun2 = (GraphVolume2Lun)volume2lunEnu2.nextElement();
                            if (GraphModelUtilities.isAbnormal(volume2lun2)) {
                                filterable = Boolean.FALSE;
                                break;
                            }
                            GraphVolume.ID volumeID3 = volume2lun2.getVolumeID();
                            GraphVolume volume = (GraphVolume)this.get(volumeID3);
                            if (!GraphModelUtilities.isAbnormal(volume)) continue;
                            filterable = Boolean.FALSE;
                            break;
                        }
                    }
                }
                lun2.setIsFilterable(filterable);
                if (filterable.booleanValue()) continue;
                ++unfilteredCount;
            }
            lunGroup.setNumOfLuns(new Integer(totalCount));
            lunGroup.setNumOfAbnormalLuns(new Integer(unfilteredCount));
            lunGroup.setIsFilterable(unfilteredCount == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        Enumeration connectivityEnu = this.enumerate(GraphSubviewSubsystemL2Connectivity.TYPE);
        while (connectivityEnu.hasMoreElements()) {
            GraphSubviewSubsystemL2Connectivity connectivity = (GraphSubviewSubsystemL2Connectivity)connectivityEnu.nextElement();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration fcportGroupEnu2 = this.enumerate(GraphFCPortGroup.TYPE);
            while (fcportGroupEnu2.hasMoreElements()) {
                GraphFCPortGroup fcportGroup = (GraphFCPortGroup)fcportGroupEnu2.nextElement();
                totalCount += fcportGroup.getNumOfFCPortsInUse() + fcportGroup.getNumOfFCPortsEmpty();
                unfilteredCount += fcportGroup.getNumOfAbnormalFCPortsInUse() + fcportGroup.getNumOfAbnormalFCPortsEmpty();
            }
            connectivity.setNumOfFCPorts(new Integer(totalCount));
            connectivity.setNumOfAbnormalFCPorts(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration swGroupEnu2 = this.enumerate(GraphSwitchGroup.TYPE);
            while (swGroupEnu2.hasMoreElements()) {
                GraphSwitchGroup swGroup = (GraphSwitchGroup)swGroupEnu2.nextElement();
                totalCount += swGroup.getNumOfSwitches().intValue();
                unfilteredCount += swGroup.getNumOfAbnormalSwitches().intValue();
            }
            connectivity.setNumOfSwitches(new Integer(totalCount));
            connectivity.setNumOfAbnormalSwitches(new Integer(unfilteredCount));
            connectivity.setIsFilterable(Boolean.FALSE);
        }
        Enumeration deviceEnu = this.enumerate(GraphSubviewSubsystemL2Device.TYPE);
        while (deviceEnu.hasMoreElements()) {
            GraphSubviewSubsystemL2Device device = (GraphSubviewSubsystemL2Device)deviceEnu.nextElement();
            int totalCount = 0;
            int unfilteredCount = 0;
            Enumeration volumeGroupEnu2 = this.enumerate(GraphVolumeGroup.TYPE);
            while (volumeGroupEnu2.hasMoreElements()) {
                GraphVolumeGroup volumeGroup2 = (GraphVolumeGroup)volumeGroupEnu2.nextElement();
                if (!volumeGroup2.containScope("External")) continue;
                totalCount += volumeGroup2.getNumOfVolumes().intValue();
                unfilteredCount += volumeGroup2.getNumOfAbnormalVolumes().intValue();
            }
            device.setNumOfExternalVolumes(new Integer(totalCount));
            device.setNumOfAbnormalExternalVolumes(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration diskGroupEnu2 = this.enumerate(GraphDiskGroup.TYPE);
            while (diskGroupEnu2.hasMoreElements()) {
                GraphDiskGroup diskGroup2 = (GraphDiskGroup)diskGroupEnu2.nextElement();
                if (diskGroup2.containScope("External")) continue;
                totalCount += diskGroup2.getNumOfDisks().intValue();
                unfilteredCount += diskGroup2.getNumOfAbnormalDisks().intValue();
            }
            device.setNumOfDisks(new Integer(totalCount));
            device.setNumOfAbnormalDisks(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration poolGroupEnu2 = this.enumerate(GraphPoolGroup.TYPE);
            while (poolGroupEnu2.hasMoreElements()) {
                GraphPoolGroup poolGroup = (GraphPoolGroup)poolGroupEnu2.nextElement();
                totalCount += poolGroup.getNumOfPools().intValue();
                unfilteredCount += poolGroup.getNumOfAbnormalPools().intValue();
            }
            device.setNumOfPools(new Integer(totalCount));
            device.setNumOfAbnormalPools(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            volumeGroupEnu2 = this.enumerate(GraphVolumeGroup.TYPE);
            while (volumeGroupEnu2.hasMoreElements()) {
                GraphVolumeGroup volumeGroup3 = (GraphVolumeGroup)volumeGroupEnu2.nextElement();
                if (volumeGroup3.containScope("External")) continue;
                totalCount += volumeGroup3.getNumOfVolumes().intValue();
                unfilteredCount += volumeGroup3.getNumOfAbnormalVolumes().intValue();
            }
            device.setNumOfVolumes(new Integer(totalCount));
            device.setNumOfAbnormalVolumes(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            diskGroupEnu2 = this.enumerate(GraphDiskGroup.TYPE);
            while (diskGroupEnu2.hasMoreElements()) {
                GraphDiskGroup diskGroup3 = (GraphDiskGroup)diskGroupEnu2.nextElement();
                if (!diskGroup3.containScope("External")) continue;
                totalCount += diskGroup3.getNumOfDisks().intValue();
                unfilteredCount += diskGroup3.getNumOfAbnormalDisks().intValue();
            }
            device.setNumOfExternalDisks(new Integer(totalCount));
            device.setNumOfAbnormalExternalDisks(new Integer(unfilteredCount));
            totalCount = 0;
            unfilteredCount = 0;
            Enumeration lunGroupEnu2 = this.enumerate(GraphLunGroup.TYPE);
            while (lunGroupEnu2.hasMoreElements()) {
                GraphLunGroup lunGroup = (GraphLunGroup)lunGroupEnu2.nextElement();
                totalCount += lunGroup.getNumOfLuns().intValue();
                unfilteredCount += lunGroup.getNumOfAbnormalLuns().intValue();
            }
            device.setNumOfLuns(new Integer(totalCount));
            device.setNumOfAbnormalLuns(new Integer(unfilteredCount));
            device.setIsFilterable(Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        public ID(GraphSubsystem focusEntity) {
            super("SubsystemL2", focusEntity.getEntityID());
        }
    }
}

